/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.workitems;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ui.operations.FileSystemUIOperation;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.core.utils.StatusUtil;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.common.ISvnRepository;
import com.ibm.team.scm.svn.common.RevisionLinks;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.AbstractWorkItemAction;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class LinkToWorkItemsAction
extends AbstractWorkItemAction {
    public void run(Shell shell, IWorkbenchPage page, final IStructuredSelection selection) {
        final IURIReference svnReference = this.getSelectedRevisionReference(selection);
        final UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(SVNRCPMessages.LinkToWorkItemsAction_0, (Operation)new FileSystemUIOperation(){

            public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemClientException, OperationFailedException {
                final ITeamRepository teamRepository = LinkToWorkItemsAction.this.getTeamRepository(context, selection, monitor);
                if (teamRepository != null) {
                    context.asyncExec(new Runnable(){

                        public void run() {
                            LinkToWorkItemsAction.linkWorkItemsToRevision(context, svnReference, teamRepository, LinkToWorkItemsAction.getProviderFactory(teamRepository), LinkToWorkItemsAction.this.getWorkItemAdapter());
                        }
                    });
                }
            }
        });
    }

    static IWorkItemHandle[] linkWorkItemsToRevision(final UIContext context, final IURIReference svnReference, final ITeamRepository server, final ProviderFactory factory, final SVNWorkItemAdapter workItemAdapter) {
        final IWorkItemHandle[] handles = LinkToWorkItemsAction.openWorkItemPicker(context.getShell(), context.getPage(), server);
        if (handles.length > 0) {
            context.getUserOperationRunner().enqueue(SVNRCPMessages.LinkToWorkItemsAction_1, (Operation)new FileSystemUIOperation(){

                public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemClientException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        URI repoUri = SvnLogEntry.getRepositoryUriFromRevisionUri((URI)svnReference.getURI());
                        if (!LinkToWorkItemsAction.isConnected(repoUri.toString(), server, workItemAdapter, (IProgressMonitor)progress.newChild(20))) {
                            LinkToWorkItemsAction.promptToConnect(context, repoUri.toString(), server, workItemAdapter, (IProgressMonitor)progress.newChild(20));
                        }
                    }
                    catch (URISyntaxException e) {
                        StatusUtil.log((Object)workItemAdapter, (Throwable)e);
                    }
                    RevisionLinks.createLink((LinkProvider)factory.getLinkProvider(), (IReference)svnReference, (IWorkItemHandle[])handles, (IProgressMonitor)progress.newChild(60));
                }
            });
        }
        return handles;
    }

    protected static void promptToConnect(final UIContext context, final String url, final ITeamRepository server, SVNWorkItemAdapter workItemAdapter, IProgressMonitor monitor) throws TeamRepositoryException {
        ISvnClientLibrary clientLibrary;
        final int[] result = new int[1];
        context.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(context.getShell(), SVNRCPMessages.LinkToWorkItemsAction_2, null, NLS.bind((String)SVNRCPMessages.LinkToWorkItemsAction_3, (Object)url, (Object)server.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, result[0]);
                result[0] = dialog.open();
            }
        });
        if (result[0] == 2) {
            throw new OperationCanceledException();
        }
        if (result[0] == 0 && (clientLibrary = (ISvnClientLibrary)server.getClientLibrary(ISvnClientLibrary.class)) != null) {
            clientLibrary.createRepository(url, monitor);
        }
    }

    protected static boolean isConnected(String url, ITeamRepository server, SVNWorkItemAdapter workItemAdapter, IProgressMonitor monitor) throws TeamRepositoryException {
        ISvnClientLibrary clientLibrary = (ISvnClientLibrary)server.getClientLibrary(ISvnClientLibrary.class);
        if (clientLibrary != null) {
            ISvnRepository connection = clientLibrary.getRepository(url, true, monitor);
            return connection != null;
        }
        return false;
    }
}

