/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.view;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ui.operations.FileSystemUIOperation;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.svn.rcp.ui.internal.ActionDelegate;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.Utils;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class NewRepositoryAction
extends ActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final ITeamRepository repository = this.getTeamRepository(selection);
        if (repository == null) {
            return;
        }
        final String url = this.promptForUrl(shell);
        if (url == null) {
            return;
        }
        UIContext context = this.getContext();
        context.getUserOperationRunner().enqueue(NLS.bind((String)SVNRCPMessages.NewRepositoryAction_0, (Object)url), (Operation)new FileSystemUIOperation(){

            public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemClientException, OperationFailedException {
                if (!repository.loggedIn()) {
                    repository.login(monitor);
                }
                NewRepositoryAction.this.createRepository(repository, url, monitor);
            }
        });
    }

    private ITeamRepository getTeamRepository(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof ITeamRepository) {
                return (ITeamRepository)o;
            }
            if (o instanceof SvnRepositoryWrapper) {
                SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)o);
                return wrapper.getRepository();
            }
            if (o instanceof DomainSubtreeRoot) {
                DomainSubtreeRoot root = (DomainSubtreeRoot)o;
                return Utils.getTeamRepository(root);
            }
        }
        return null;
    }

    private String promptForUrl(Shell shell) {
        InputDialog dialog = new InputDialog(shell, SVNRCPMessages.NewRepositoryAction_1, SVNRCPMessages.NewRepositoryAction_2, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.length() > 0) {
                    try {
                        URI uri = new URI(newText);
                        if (!this.isSupportedScheme(uri.getScheme())) {
                            return NLS.bind((String)SVNRCPMessages.NewRepositoryAction_4, (Object)uri.getScheme());
                        }
                        if (uri.isOpaque()) {
                            return SVNRCPMessages.NewRepositoryAction_5;
                        }
                        if (uri.getHost() == null || uri.getHost().length() == 0) {
                            return SVNRCPMessages.NewRepositoryAction_6;
                        }
                        if (uri.getFragment() != null && uri.getFragment().length() <= 0) {
                            return SVNRCPMessages.NewRepositoryAction_7;
                        }
                        if (uri.getQuery() != null && uri.getQuery().length() <= 0) {
                            return SVNRCPMessages.NewRepositoryAction_8;
                        }
                        if (!this.isValidPath(uri.getPath())) {
                            return NLS.bind((String)SVNRCPMessages.NewRepositoryAction_9, (Object)uri.getPath());
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        return SVNRCPMessages.NewRepositoryAction_10;
                    }
                }
                return null;
            }

            private boolean isValidPath(String path) {
                return true;
            }

            private boolean isSupportedScheme(String scheme) {
                return scheme != null && (scheme.equals("http") || scheme.equals("https") || scheme.equals("svn") || scheme.equals("svn+ssh"));
            }
        });
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return null;
    }

    public boolean isEnabled() {
        ITeamRepository repository = this.getTeamRepository(this.getSelection());
        return repository != null;
    }
}

