/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.view;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.ui.operations.FileSystemUIOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.OperationFailedException;
import com.ibm.team.scm.svn.client.ISvnClientLibrary;
import com.ibm.team.scm.svn.rcp.ui.internal.ActionDelegate;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import com.ibm.team.scm.svn.rcp.ui.internal.view.SvnRepositoryWrapper;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class DeleteRepositoryAction
extends ActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        final ArrayList<SvnRepositoryWrapper> repos = new ArrayList<SvnRepositoryWrapper>();
        for (Object o : selection) {
            if (!(o instanceof SvnRepositoryWrapper)) continue;
            SvnRepositoryWrapper wrapper = (SvnRepositoryWrapper)((Object)o);
            repos.add(wrapper);
        }
        if (repos.isEmpty()) {
            return;
        }
        String message = repos.size() == 1 ? NLS.bind((String)SVNRCPMessages.DeleteRepositoryAction_0, (Object)((SvnRepositoryWrapper)((Object)repos.get(0))).getSvnRepository().getUrl()) : NLS.bind((String)SVNRCPMessages.DeleteRepositoryAction_1, (Object)repos.size());
        if (MessageDialog.openQuestion((Shell)shell, (String)SVNRCPMessages.DeleteRepositoryAction_2, (String)message)) {
            this.getContext().getUserOperationRunner().enqueue(SVNRCPMessages.DeleteRepositoryAction_3, (Operation)new FileSystemUIOperation(){

                public void filesystemRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException, FileSystemClientException, OperationFailedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(repos.size() * 100));
                    for (SvnRepositoryWrapper svnRepositoryWrapper : repos) {
                        ITeamRepository repository = svnRepositoryWrapper.getRepository();
                        ISvnClientLibrary clientLibrary = DeleteRepositoryAction.this.getClientLibrary(repository);
                        clientLibrary.deleteRepository(svnRepositoryWrapper.getSvnRepository(), true, (IProgressMonitor)progress.newChild(100));
                    }
                }
            });
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

