/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.scm.client.importz.internal.utils.PathUtils;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.Credentials;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SVNRepositoryInfo {
    private final SVNRepository repository;
    private final Credentials credentials;

    public SVNRepositoryInfo(SVNURL repositoryRoot, Credentials credentials) throws SVNException {
        this.repository = SVNRepositoryFactory.create((SVNURL)repositoryRoot);
        this.credentials = credentials;
        this.credentials.updateAuthentication(this.repository);
    }

    public SVNRepositoryInfo(String repositoryUrl) throws SVNException {
        this(SVNURL.parseURIDecoded((String)repositoryUrl), new Credentials());
    }

    public SVNRepository getRepository() {
        return this.repository;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getRelativePath(SVNURL childUrl) {
        return PathUtils.getRelativePath((String)this.repository.getLocation().getPath(), (String)childUrl.getPath());
    }

    public SVNURL getLocation() {
        return this.repository.getLocation();
    }

    public SVNRepository getRepository(String relativePath) throws SVNException {
        if (relativePath.length() == 0) {
            return this.repository;
        }
        SVNRepository repo = SVNRepositoryFactory.create((SVNURL)this.repository.getLocation().appendPath(relativePath, false));
        this.credentials.updateAuthentication(repo);
        return repo;
    }
}

