/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal.importz;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.importz.IImportData;
import com.ibm.team.scm.client.importz.IImporter;
import com.ibm.team.scm.client.importz.internal.ISyncFileReader;
import com.ibm.team.scm.client.importz.internal.ISyncImportParticipant;
import com.ibm.team.scm.client.importz.spi.ImportData;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.PasswordDialog;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNChangeArchiveCreator;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNImportData;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNRepositoryInfo;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;
import org.tmatesoft.svn.core.SVNAuthenticationException;

public class SVNImporter
implements IImporter {
    public void createChangeSetArchive(ISyncFileReader reader, String archiveFileName, IProgressMonitor monitor) throws CoreException, IOException {
    }

    public void createChangeSetArchive(ISyncImportParticipant participant, String archiveFileName, IProgressMonitor monitor) throws CoreException, IOException {
    }

    public void createChangeSetArchive(IImportData importData, IProgressMonitor monitor) throws TeamRepositoryException {
        SVNImportData sid = (SVNImportData)importData;
        File archiveFile = ((ImportData)importData).getArchiveFile();
        final SVNRepositoryInfo repository = sid.getRepository();
        final boolean[] tryAgain = new boolean[]{true};
        while (tryAgain[0]) {
            try {
                new SVNChangeArchiveCreator(archiveFile, repository, sid.getMapping(), sid.getEarliestRevision(), sid.getLatestRevision(), sid.getDefaultUser()).createChangeSetArchive(monitor);
                return;
            }
            catch (SVNAuthenticationException e) {
                tryAgain[0] = false;
                final boolean[] canceled = new boolean[1];
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        PasswordDialog dialog = new PasswordDialog(repository.getRepository().getLocation().toString(), repository.getCredentials(), e.getMessage());
                        tryAgain[0] = dialog.open() == 0;
                        canceled[0] = !tryAgain[0];
                    }
                });
                if (canceled[0]) {
                    throw new OperationCanceledException();
                }
                if (tryAgain[0]) continue;
                throw new TeamRepositoryException((Throwable)e);
            }
        }
    }
}

