/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.rcp.ui.internal;

import com.ibm.team.process.rcp.ui.RepositoryCreationPage;
import com.ibm.team.process.rcp.ui.RepositorySelectionPage;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.scm.svn.rcp.ui.internal.SVNRCPMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class RepositorySelectionWizard
extends Wizard {
    private RepositorySelectionPage selectionPage;
    private RepositoryCreationPage creationPage;

    public RepositorySelectionWizard() {
        this.setWindowTitle(SVNRCPMessages.RepositorySelectionWizard_0);
    }

    public void addPages() {
        if (TeamPlatform.getTeamRepositoryService().getTeamRepositories().length > 0) {
            this.selectionPage = new RepositorySelectionPage(SVNRCPMessages.RepositorySelectionWizard_1);
            this.addPage((IWizardPage)this.selectionPage);
        }
        this.creationPage = new RepositoryCreationPage(SVNRCPMessages.RepositorySelectionWizard_2);
        this.addPage((IWizardPage)this.creationPage);
    }

    public boolean canFinish() {
        return this.getTeamRepository() != null;
    }

    public boolean performFinish() {
        ITeamRepository repo = null;
        if (this.selectionPage != null && this.selectionPage.getTeamRepository() != null) {
            repo = this.selectionPage.getTeamRepository();
        } else {
            try {
                repo = this.creationPage.createRepository();
            }
            catch (Throwable e) {
                MessageDialog.openError((Shell)this.getShell(), (String)SVNRCPMessages.RepositorySelectionWizard_3, (String)e.getMessage());
            }
        }
        return repo != null;
    }

    public ITeamRepository getTeamRepository() {
        if (this.selectionPage != null && this.selectionPage.getTeamRepository() != null) {
            return this.selectionPage.getTeamRepository();
        }
        return this.creationPage.getTeamRepository();
    }
}

