/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.psubversive.ui.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import com.ibm.team.scm.svn.psubversive.ui.internal.SubversiveLogEntry;
import com.ibm.team.scm.svn.rcp.ui.internal.workitems.SVNWorkItemAdapter;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.polarion.team.svn.core.client.PropertyData;
import org.polarion.team.svn.core.client.Revision;
import org.polarion.team.svn.core.operation.local.property.RemovePropertiesOperation;
import org.polarion.team.svn.core.operation.local.property.SetPropertiesOperation;
import org.polarion.team.svn.core.resource.IRepositoryFolder;
import org.polarion.team.svn.core.resource.IRepositoryLocation;
import org.polarion.team.svn.core.svnstorage.SVNRemoteStorage;
import org.polarion.team.svn.core.svnstorage.SVNRepositoryFolder;

public class SubversiveWorkItemAdapter
extends SVNWorkItemAdapter {
    private static SVNWorkItemAdapter instance;
    private final IWorkbenchPart part;

    public SubversiveWorkItemAdapter(IWorkbenchPart part) {
        this.part = part;
    }

    public static synchronized SVNWorkItemAdapter getInstance() {
        if (instance == null) {
            instance = new SubversiveWorkItemAdapter(null);
        }
        return instance;
    }

    public SvnLogEntry asLogEntry(Object revision) {
        if (this.part != null) {
            return SubversiveLogEntry.create(this.part, revision);
        }
        return null;
    }

    public SvnBugtraqProperties getBugTrackingProperties(IProject project) throws FileSystemClientException {
        return SubversiveLogEntry.getBugtraqProperties((IResource)project);
    }

    public void setBugTrackingProperties(IProject project, SvnBugtraqProperties properties) throws FileSystemClientException {
        ArrayList<PropertyData> result = new ArrayList<PropertyData>(properties.entrySet().size());
        for (Map.Entry entry : properties.entrySet()) {
            result.add(new PropertyData((String)entry.getKey(), (String)entry.getValue(), null));
        }
        SetPropertiesOperation op = new SetPropertiesOperation(new IResource[]{project}, result.toArray(new PropertyData[result.size()]), false);
        op.run((IProgressMonitor)new NullProgressMonitor());
    }

    public void removeBugTrackingProperties(IProject project) throws FileSystemClientException {
        ArrayList<PropertyData> result = new ArrayList<PropertyData>();
        result.add(new PropertyData("bugtraq:url", null, null));
        result.add(new PropertyData("bugtraq:message", null, null));
        result.add(new PropertyData("bugtraq:label", null, null));
        result.add(new PropertyData("bugtraq:append", null, null));
        result.add(new PropertyData("bugtraq:number", null, null));
        result.add(new PropertyData("bugtraq:warnifnoissue", null, null));
        result.add(new PropertyData("bugtraq:logregex", null, null));
        RemovePropertiesOperation op = new RemovePropertiesOperation(new IResource[]{project}, result.toArray(new PropertyData[result.size()]), false);
        op.run((IProgressMonitor)new NullProgressMonitor());
    }

    public IRepositoryFolder getRemoteFolder(String repoUrl, String revision) {
        IRepositoryLocation[] locations = SVNRemoteStorage.instance().getRepositoryLocations();
        IRepositoryLocation location = null;
        int i = 0;
        while (i < locations.length) {
            IRepositoryLocation l = locations[i];
            if (l.getUrl().equals(repoUrl)) {
                location = l;
                break;
            }
            ++i;
        }
        if (location == null) {
            location = SVNRemoteStorage.instance().newRepositoryLocation();
            location.setUrl(repoUrl);
        }
        SVNRepositoryFolder folder = new SVNRepositoryFolder(location, repoUrl, Revision.HEAD);
        if (revision != null) {
            folder.setRevision(Long.parseLong(revision));
        }
        return folder;
    }
}

