/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.esubversive.ui.internal;

import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.svn.common.SvnBugtraqProperties;
import com.ibm.team.scm.svn.common.SvnLogEntry;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.history.SVNHistoryPage;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.properties.bugtraq.BugtraqModel;
import org.eclipse.team.svn.ui.repository.model.RepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;

public class SubversiveLogEntry
extends SvnLogEntry {
    private final IWorkbenchPart part;
    private final SVNLogEntry logMessage;

    public static SvnLogEntry create(IWorkbenchPart part, Object revision) {
        SVNLogEntry logMessage = SubversiveLogEntry.getLogMessage(revision);
        if (logMessage != null && part instanceof IHistoryView) {
            return new SubversiveLogEntry(part, logMessage);
        }
        return null;
    }

    private static SVNLogEntry getLogMessage(Object revision) {
        IAdaptable adaptable;
        Object adapted;
        if (revision instanceof SVNLogEntry) {
            return (SVNLogEntry)revision;
        }
        if (revision instanceof IAdaptable && (adapted = (adaptable = (IAdaptable)revision).getAdapter(SVNLogEntry.class)) instanceof SVNLogEntry) {
            return (SVNLogEntry)adapted;
        }
        return null;
    }

    public SubversiveLogEntry(IWorkbenchPart part, SVNLogEntry logMessage) {
        this.part = part;
        this.logMessage = logMessage;
    }

    public IURIReference asUriReference() throws URISyntaxException {
        IRepositoryLocation location = this.getRepositoryLocationOfInput();
        if (location != null) {
            String url = location.getUrl();
            return SubversiveLogEntry.createUriReference(url, this.logMessage);
        }
        return null;
    }

    public static IURIReference createUriReference(String url, SVNLogEntry message) throws URISyntaxException {
        URI repoUri = new URI(url);
        String comment = message.message;
        String revisionString = Long.toString(message.revision);
        URI uri = SubversiveLogEntry.createURI((String)repoUri.getScheme(), null, (String)repoUri.getHost(), (int)repoUri.getPort(), (String)repoUri.getPath(), (String)revisionString);
        return SubversiveLogEntry.createReference((URI)uri, (String)comment, (String)revisionString);
    }

    public String getRepositoryUrl() {
        IRepositoryLocation location = this.getRepositoryLocationOfInput();
        if (location != null) {
            return location.getUrl();
        }
        return null;
    }

    private IRepositoryLocation getRepositoryLocationOfInput() {
        SVNHistoryPage historyPage = this.getHistoryPage();
        if (historyPage != null) {
            Object input = historyPage.getInput();
            if (input instanceof IRepositoryResource) {
                IRepositoryResource rr = (IRepositoryResource)input;
                return rr.getRepositoryLocation();
            }
            if (input instanceof RepositoryResource) {
                RepositoryResource rr = (RepositoryResource)input;
                return rr.getRepositoryResource().getRepositoryLocation();
            }
            if (input instanceof IRepositoryLocation) {
                return (IRepositoryLocation)input;
            }
            if (input instanceof RepositoryLocation) {
                return ((RepositoryLocation)input).getRepositoryLocation();
            }
            if (input instanceof IResource) {
                IResource resource = (IResource)input;
                return SVNRemoteStorage.instance().getRepositoryLocation(resource);
            }
        }
        return null;
    }

    public IResource getDisplayedResource() {
        SVNHistoryPage historyPage = this.getHistoryPage();
        if (historyPage != null) {
            return historyPage.getResource();
        }
        return null;
    }

    private SVNHistoryPage getHistoryPage() {
        IHistoryView view;
        IHistoryPage historyPage;
        if (this.part instanceof IHistoryView && (historyPage = (view = (IHistoryView)this.part).getHistoryPage()) instanceof SVNHistoryPage) {
            return (SVNHistoryPage)historyPage;
        }
        return null;
    }

    public SvnBugtraqProperties getBugtraqProperties() throws TeamRepositoryException {
        IResource resource = this.getDisplayedResource();
        SvnBugtraqProperties result = SubversiveLogEntry.getBugtraqProperties(resource);
        return result;
    }

    public static SvnBugtraqProperties getBugtraqProperties(IResource resource) {
        BugtraqModel model;
        SvnBugtraqProperties result = new SvnBugtraqProperties();
        if (resource != null && (model = SubversiveLogEntry.getProjectProperties(resource.getProject())) != null) {
            result.put("bugtraq:url", model.getUrl());
            result.put("bugtraq:label", model.getLabel());
            result.put("bugtraq:message", model.getMessage());
            result.put("bugtraq:number", Boolean.toString(model.isNumber()));
            result.put("bugtraq:append", Boolean.toString(model.isAppend()));
            result.put("bugtraq:warnifnoissue", Boolean.toString(model.isWarnIfNoIssue()));
        }
        return result;
    }

    private static BugtraqModel getProjectProperties(IProject project) {
        if (project == null) {
            return null;
        }
        CommitPanel.CollectPropertiesOperation op = new CommitPanel.CollectPropertiesOperation(new IResource[]{project});
        op.run((IProgressMonitor)new NullProgressMonitor());
        return op.getBugtraqModel();
    }

    public String getComment() {
        return this.logMessage.message;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getDisplayedResource();
        }
        return super.getAdapter(adapter);
    }

    public long getRevision() {
        return this.logMessage.revision;
    }
}

