/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.esubversive.ui.internal;

import com.ibm.team.repository.rcp.ui.utils.AbstractActionDelegate;
import com.ibm.team.repository.rcp.ui.utils.UIContext;
import com.ibm.team.scm.client.importz.internal.utils.PathUtils;
import com.ibm.team.scm.svn.rcp.ui.internal.importz.SVNImportOperation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.ui.IWorkbenchPage;

public class SubversiveImportAction
extends AbstractActionDelegate {
    public void run(Shell shell, IWorkbenchPage page, IStructuredSelection selection) {
        IRepositoryLocation repository = this.getRepository(selection);
        String repositoryUrl = repository.getRepositoryRootUrl();
        String[] folderPaths = new String[selection.size()];
        int i = 0;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            folderPaths[i++] = this.getRepositoryRelativePath(repository, (RepositoryFolder)iter.next());
        }
        SVNImportOperation.importFromSVN((UIContext)this.getContext(), (String)repositoryUrl, (String[])folderPaths);
    }

    private String getRepositoryRelativePath(IRepositoryLocation repository, RepositoryFolder folder) {
        String repoUrl = repository.getUrl();
        String folderUrl = folder.getRepositoryResource().getUrl();
        if (folderUrl.startsWith(repoUrl)) {
            return folderUrl.substring(repoUrl.length());
        }
        try {
            URI repoUri = new URI(repoUrl);
            URI folderUri = new URI(folderUrl);
            return PathUtils.getRelativePath((String)repoUri.getPath(), (String)folderUri.getPath());
        }
        catch (URISyntaxException uRISyntaxException) {
            return PathUtils.getRelativePath((String)repoUrl, (String)folderUrl);
        }
    }

    private IRepositoryLocation getRepository(IStructuredSelection selection) {
        return ((RepositoryFolder)selection.getFirstElement()).getRepositoryResource().getRepositoryLocation();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (selection instanceof IStructuredSelection) {
            Object[] elements = ((IStructuredSelection)selection).toArray();
            IRepositoryLocation repository = null;
            int i = 0;
            while (i < elements.length) {
                if (!(elements[i] instanceof RepositoryFolder)) {
                    action.setEnabled(false);
                    return;
                }
                RepositoryFolder folder = (RepositoryFolder)elements[i];
                if (repository == null) {
                    repository = folder.getRepositoryResource().getRepositoryLocation();
                } else if (!repository.equals(folder.getRepositoryResource().getRepositoryLocation())) {
                    action.setEnabled(false);
                    return;
                }
                if (this.hasOverlap(folder, i + 1, elements)) {
                    action.setEnabled(false);
                    return;
                }
                ++i;
            }
            action.setEnabled(true);
        }
    }

    private boolean hasOverlap(RepositoryFolder folder, int offset, Object[] elements) {
        int i = offset;
        while (i < elements.length) {
            RepositoryFolder other;
            Object object = elements[i];
            if (object instanceof RepositoryFolder && (PathUtils.isParentUrl((String)(other = (RepositoryFolder)object).getRepositoryResource().getUrl(), (String)folder.getRepositoryResource().getUrl()) || PathUtils.isParentUrl((String)folder.getRepositoryResource().getUrl(), (String)other.getRepositoryResource().getUrl()))) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

