/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.svn.common;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.ItemProfile;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNWorkItemExtractor {
    public static final String BUGID_PLACEHOLDER = "%BUGID%";
    private static final String REPOSITORY_WORK_ITEM_SUFFIX = "resource/itemName/com.ibm.team.workitem.WorkItem/";
    private static final String BUG_PATTERN_STRING = "s?:?\\s?((\\d+),?\\s?)+(\\s|\\z)";
    private static final int WORK_ITEM_ID_GROUP = 2;
    private static SVNWorkItemExtractor instance;
    private Pattern itemIdPattern;
    private IAuditableCommon auditableCommon;
    private IWorkItemCommon workItemCommon;
    private String typesPattern = "work item|bug|issue|enhancement|defect";

    public static SVNWorkItemExtractor getInstance() {
        if (instance == null) {
            instance = new SVNWorkItemExtractor();
        }
        return instance;
    }

    public static SVNWorkItemExtractor create(IAuditableCommon auditableCommon, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        SVNWorkItemExtractor workItemExtractor = new SVNWorkItemExtractor(auditableCommon, workItemCommon);
        workItemExtractor.initialize(monitor);
        return workItemExtractor;
    }

    public SVNWorkItemExtractor(IAuditableCommon auditableCommon, IWorkItemCommon workItemCommon) {
        this.auditableCommon = auditableCommon;
        this.workItemCommon = workItemCommon;
    }

    public SVNWorkItemExtractor() {
    }

    private void initialize(IProgressMonitor monitor) throws TeamRepositoryException {
        List<String> types = this.getWorkItemTypes(monitor);
        String typePattern = "";
        for (String typeName : types) {
            typePattern = String.valueOf(typePattern) + "|" + typeName;
        }
        if (typePattern.length() > 0) {
            typePattern = typePattern.substring(1);
        }
        this.typesPattern = typePattern;
    }

    public final Set<Location> getWorkItemLocations(String bugTraqUrl, List<Long> ids) throws TeamRepositoryException {
        HashSet<Location> result = new HashSet<Location>();
        TeamRepositoryException exception = null;
        for (Long id : ids) {
            try {
                URI uri = this.makeUri(bugTraqUrl, Long.toString(id));
                if (uri == null) continue;
                result.add(Location.location((URI)uri));
            }
            catch (TeamRepositoryException e) {
                exception = e;
            }
        }
        if (result.isEmpty() && exception != null) {
            throw exception;
        }
        return result;
    }

    public Set<Location> getWorkItemLocations(String bugTraqUrl, String bugTraqMessage, String comment, boolean useJazzPattern) throws TeamRepositoryException {
        List<Long> itemNumbers = this.extractWorkItemNumbers(bugTraqMessage, comment, useJazzPattern);
        Set<Location> itemLocations = this.getWorkItemLocations(bugTraqUrl, itemNumbers);
        return itemLocations;
    }

    public synchronized List<Long> extractWorkItemNumbers(String bugTraqMessage, String comment, boolean useJazzPattern) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (comment == null) {
            return result;
        }
        if (useJazzPattern) {
            if (this.itemIdPattern == null) {
                this.itemIdPattern = Pattern.compile("(" + this.typesPattern + ")" + BUG_PATTERN_STRING, 66);
            }
            Matcher matcher = this.itemIdPattern.matcher(comment);
            while (matcher.find()) {
                String idStrings = matcher.group(2);
                List<Long> workItemIds = this.toWorkItemIds(idStrings);
                result.addAll(workItemIds);
            }
        }
        if (bugTraqMessage != null) {
            String idStrings = this.extractSvnItemNumbers(bugTraqMessage, comment);
            List<Long> workItemIds = this.toWorkItemIds(idStrings);
            result.addAll(workItemIds);
        }
        return result;
    }

    private URI makeUri(String url, String item) throws TeamRepositoryException {
        try {
            return new URI(this.makeUrl(url, item));
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private String makeUrl(String url, String item) {
        return url.replaceAll(BUGID_PLACEHOLDER, item);
    }

    private String extractSvnItemNumbers(String bugTraqMessage, String comment) {
        String firstLine;
        String itemNumbers;
        if (bugTraqMessage == null || bugTraqMessage.length() == 0 || comment == null) {
            return null;
        }
        int index = bugTraqMessage.indexOf(BUGID_PLACEHOLDER);
        if (index == -1) {
            return null;
        }
        String prefix = bugTraqMessage.substring(0, index);
        int end = index + BUGID_PLACEHOLDER.length();
        String suffix = null;
        if (end < bugTraqMessage.length()) {
            suffix = bugTraqMessage.substring(end);
        }
        if ((itemNumbers = this.extractSvnItemNumbers(prefix, suffix, firstLine = this.getFirstLine(comment))) != null) {
            return itemNumbers;
        }
        String lastLine = this.getLastLine(comment);
        return this.extractSvnItemNumbers(prefix, suffix, lastLine);
    }

    private String getLastLine(String comment) {
        int index = comment.lastIndexOf(10);
        if (index != -1 && index == comment.length() - 1) {
            index = comment.lastIndexOf(10, index - 1);
        }
        if (index == -1) {
            return null;
        }
        return comment.substring(index + 1).trim();
    }

    private String getFirstLine(String comment) {
        int index = comment.indexOf(10);
        String firstLine = index == -1 ? comment : comment.substring(0, index).trim();
        return firstLine;
    }

    private String extractSvnItemNumbers(String prefix, String suffix, String line) {
        if (line != null && line.startsWith(prefix)) {
            String itemString = line.substring(prefix.length());
            if (suffix != null && itemString.endsWith(suffix)) {
                itemString = itemString.substring(0, itemString.length() - suffix.length());
            }
            return itemString;
        }
        return null;
    }

    private List<Long> toWorkItemIds(String idStrings) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (idStrings != null) {
            String[] items = idStrings.split(",");
            int i = 0;
            while (i < items.length) {
                String item = items[i].trim();
                if (item.length() > 0) {
                    try {
                        long id = Long.parseLong(item);
                        result.add(id);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                ++i;
            }
        }
        return result;
    }

    public String getWorkItemUrl(String repositoryURI, String workItemId) {
        if (repositoryURI == null) {
            return REPOSITORY_WORK_ITEM_SUFFIX + workItemId;
        }
        if (!repositoryURI.endsWith("/")) {
            repositoryURI = String.valueOf(repositoryURI) + "/";
        }
        return String.valueOf(repositoryURI) + REPOSITORY_WORK_ITEM_SUFFIX + workItemId;
    }

    private List<String> getWorkItemTypes(IProgressMonitor monitor) throws TeamRepositoryException {
        String nameProperty = ProcessCommon.getPropertyName(IProjectArea.class, (String)"name");
        ItemProfile profile = ItemProfile.createProfile((IItemType)IProjectArea.ITEM_TYPE, (String[])new String[]{nameProperty});
        List projectAreas = this.getAuditableCommon().findAuditables(profile, monitor);
        HashSet<String> typeNames = new HashSet<String>();
        IWorkItemCommon workItemClient = this.getWorkItemCommon();
        for (IProjectArea projectArea : projectAreas) {
            if (projectArea.isArchived()) continue;
            List workItemTypes = workItemClient.findWorkItemTypes((IProjectAreaHandle)projectArea, monitor);
            for (IWorkItemType workItemType : workItemTypes) {
                typeNames.add(workItemType.getDisplayName().toLowerCase());
                typeNames.addAll(workItemType.getAliases());
            }
        }
        return new ArrayList<String>(typeNames);
    }

    private IWorkItemCommon getWorkItemCommon() {
        return this.workItemCommon;
    }

    private IAuditableCommon getAuditableCommon() {
        return this.auditableCommon;
    }
}

