/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ItemId<T extends IItem> {
    private IItemType itemType;
    private UUID itemId;
    private static final UUID NULL_ITEM_ID = UUID.valueOf((String)"_IxCr0ISKEdubTOb61gISMg");

    public ItemId(IItemType type, UUID id) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)id);
        this.itemType = type;
        this.itemId = id;
    }

    public static <T extends IItem> ItemId<T> forItem(T item) {
        return new ItemId<T>((IItemHandle)item);
    }

    public static <T extends IItem> ItemId<T> create(IItemHandle item) {
        return new ItemId<T>(item);
    }

    public static ItemId getNullItem(IItemType type) {
        return new ItemId(type, NULL_ITEM_ID);
    }

    public static UUID getNullItemUUID() {
        return NULL_ITEM_ID;
    }

    public ItemId(IItemHandle handle) {
        this(handle.getItemType(), handle.getItemId());
    }

    public <K extends IItemHandle> K toHandle() {
        if (this.isNull()) {
            return null;
        }
        return (K)this.itemType.createItemHandle(this.itemId, null);
    }

    public <K extends IItemHandle> K toHandle(Object origin) {
        if (this.isNull()) {
            return null;
        }
        return (K)this.itemType.createItemHandle(origin, this.itemId, null);
    }

    public IItemType getItemType() {
        return this.itemType;
    }

    public UUID getItemUUID() {
        return this.itemId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemId) {
            ItemId id = (ItemId)obj;
            return id.itemId.equals((Object)this.itemId);
        }
        return false;
    }

    public int hashCode() {
        return this.itemId.hashCode();
    }

    public boolean isNull() {
        return this.itemId.equals((Object)NULL_ITEM_ID);
    }

    public String toString() {
        return "ItemId(" + this.itemType.getName() + ", " + this.itemId.getUuidValue() + ")";
    }

    public static <K extends IItem, T extends K> ItemId<K> upcast(ItemId<T> toConvert) {
        return toConvert;
    }
}

