/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.dto;

import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.SynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.UpdateReport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class SynchronizationInfo
implements ISynchronizationInfo {
    private final Map<UUID, SynchronizationTimes> workspaceTimes = new HashMap<UUID, SynchronizationTimes>();
    private final Map<UUID, Map<UUID, ComponentStateSummary>> componentTimes = new HashMap<UUID, Map<UUID, ComponentStateSummary>>();

    public SynchronizationInfo() {
    }

    public SynchronizationInfo(ISynchronizationTimes[] syncTimes) {
        if (syncTimes != null) {
            ISynchronizationTimes[] iSynchronizationTimesArray = syncTimes;
            int n = syncTimes.length;
            int n2 = 0;
            while (n2 < n) {
                ISynchronizationTimes t = iSynchronizationTimesArray[n2];
                SynchronizationTimes times = (SynchronizationTimes)t;
                if (times.getWorkspaceTime() != 0L) {
                    this.addWorkspaceTime(times.getWorkspace(), times.getWorkspaceTime());
                }
                for (ComponentStateSummary cTime : times.getComponentTimes()) {
                    if (cTime.getChangeHistoryState() != 0L) {
                        this.addChangeHistoryTime(times.getWorkspace(), cTime.getComponent(), cTime.getChangeHistoryTime());
                    }
                    if (cTime.getConfigurationState() == 0L) continue;
                    this.addConfigurationTime(times.getWorkspace(), cTime.getComponent(), cTime.getConfigurationTime());
                }
                ++n2;
            }
        }
    }

    public void updateTimes(IWorkspaceHandle workspace, IUpdateReport report) {
        IComponentHandle component;
        this.addWorkspaceTime(workspace, ((UpdateReport)report).getStateAfter());
        HashSet<UUID> afterComponents = new HashSet<UUID>();
        for (IComponentStateSummary summary : report.getComponentStatesAfter()) {
            component = summary.getComponent();
            afterComponents.add(component.getItemId());
            this.addConfigurationTime(workspace, component, summary.getConfigurationState());
            this.addChangeHistoryTime(workspace, component, summary.getChangeHistoryState());
        }
        for (IComponentStateSummary summary : report.getComponentStatesBefore()) {
            component = summary.getComponent();
            if (afterComponents.contains(component.getItemId())) continue;
            this.addConfigurationTime(workspace, component, 0L);
            this.addChangeHistoryTime(workspace, component, 0L);
        }
    }

    public void addChangeHistoryTime(IWorkspaceHandle workspace, IComponentHandle component, ISyncTime changeHistoryTime) {
        this.addChangeHistoryTime(workspace, component, ((SyncTime)changeHistoryTime).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangeHistoryTime(IWorkspaceHandle workspace, IComponentHandle component, long changeHistoryTime) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Map<UUID, SynchronizationTimes> map = this.workspaceTimes;
        synchronized (map) {
            Map<UUID, ComponentStateSummary> compTimes = this.componentTimes.get(workspace.getItemId());
            if (changeHistoryTime == 0L) {
                if (compTimes == null) {
                    return;
                }
                ComponentStateSummary syncTime = compTimes.get(component.getItemId());
                if (syncTime == null) {
                    return;
                }
                if (syncTime.getConfigurationState() != 0L) {
                    syncTime.setChangeHistoryState(0L);
                    return;
                }
                if (compTimes.size() == 1) {
                    this.componentTimes.remove(workspace.getItemId());
                } else {
                    compTimes.remove(component.getItemId());
                }
                SynchronizationTimes wsTimes = this.workspaceTimes.get(workspace.getItemId());
                if (wsTimes.getWorkspaceTime() == 0L && wsTimes.getComponentTimes().size() == 1) {
                    this.workspaceTimes.remove(workspace.getItemId());
                } else {
                    Iterator it = wsTimes.getComponentTimes().iterator();
                    while (it.hasNext()) {
                        if (it.next() != syncTime) continue;
                        it.remove();
                        break;
                    }
                }
            } else {
                ComponentStateSummary syncTime;
                if (compTimes == null) {
                    compTimes = new HashMap<UUID, ComponentStateSummary>();
                    this.componentTimes.put(workspace.getItemId(), compTimes);
                }
                if ((syncTime = compTimes.get(component.getItemId())) == null) {
                    SynchronizationTimes wsTimes = this.workspaceTimes.get(workspace.getItemId());
                    if (wsTimes == null) {
                        wsTimes = ScmDtoFactory.eINSTANCE.createSynchronizationTimes();
                        wsTimes.setWorkspace(workspace);
                        wsTimes.setWorkspaceTime(0L);
                        this.workspaceTimes.put(workspace.getItemId(), wsTimes);
                    }
                    syncTime = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
                    syncTime.setComponent(component);
                    syncTime.setConfigurationState(0L);
                    wsTimes.getComponentTimes().add(syncTime);
                    compTimes.put(component.getItemId(), syncTime);
                }
                syncTime.setChangeHistoryState(changeHistoryTime);
            }
        }
    }

    public void addConfigurationTime(IWorkspaceHandle workspace, IComponentHandle component, ISyncTime configurationTime) {
        this.addConfigurationTime(workspace, component, ((SyncTime)configurationTime).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigurationTime(IWorkspaceHandle workspace, IComponentHandle component, long configurationTime) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Map<UUID, SynchronizationTimes> map = this.workspaceTimes;
        synchronized (map) {
            Map<UUID, ComponentStateSummary> compTimes = this.componentTimes.get(workspace.getItemId());
            if (configurationTime == 0L) {
                if (compTimes == null) {
                    return;
                }
                ComponentStateSummary syncTime = compTimes.get(component.getItemId());
                if (syncTime == null) {
                    return;
                }
                if (syncTime.getChangeHistoryState() != 0L) {
                    syncTime.setConfigurationState(0L);
                    return;
                }
                if (compTimes.size() == 1) {
                    this.componentTimes.remove(workspace.getItemId());
                } else {
                    compTimes.remove(component.getItemId());
                }
                SynchronizationTimes wsTimes = this.workspaceTimes.get(workspace.getItemId());
                if (wsTimes.getWorkspaceTime() == 0L && wsTimes.getComponentTimes().size() == 1) {
                    this.workspaceTimes.remove(workspace.getItemId());
                } else {
                    Iterator it = wsTimes.getComponentTimes().iterator();
                    while (it.hasNext()) {
                        if (it.next() != syncTime) continue;
                        it.remove();
                        break;
                    }
                }
            } else {
                ComponentStateSummary syncTime;
                if (compTimes == null) {
                    compTimes = new HashMap<UUID, ComponentStateSummary>();
                    this.componentTimes.put(workspace.getItemId(), compTimes);
                }
                if ((syncTime = compTimes.get(component.getItemId())) == null) {
                    SynchronizationTimes wsTimes = this.workspaceTimes.get(workspace.getItemId());
                    if (wsTimes == null) {
                        wsTimes = ScmDtoFactory.eINSTANCE.createSynchronizationTimes();
                        wsTimes.setWorkspace(workspace);
                        wsTimes.setWorkspaceTime(0L);
                        this.workspaceTimes.put(workspace.getItemId(), wsTimes);
                    }
                    syncTime = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
                    syncTime.setComponent(component);
                    syncTime.setChangeHistoryState(0L);
                    wsTimes.getComponentTimes().add(syncTime);
                    compTimes.put(component.getItemId(), syncTime);
                }
                syncTime.setConfigurationState(configurationTime);
            }
        }
    }

    public void addWorkspaceTime(IWorkspaceHandle workspace, ISyncTime workspaceTime) {
        this.addWorkspaceTime(workspace, ((SyncTime)workspaceTime).getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWorkspaceTime(IWorkspaceHandle workspace, long workspaceTime) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        Map<UUID, SynchronizationTimes> map = this.workspaceTimes;
        synchronized (map) {
            SynchronizationTimes wsTimes = this.workspaceTimes.get(workspace.getItemId());
            if (workspaceTime == 0L) {
                if (wsTimes == null) {
                    return;
                }
                if (wsTimes.getComponentTimes().isEmpty()) {
                    this.workspaceTimes.remove(workspace.getItemId());
                } else {
                    wsTimes.setWorkspaceTime(0L);
                }
            } else if (wsTimes == null) {
                wsTimes = ScmDtoFactory.eINSTANCE.createSynchronizationTimes();
                wsTimes.setWorkspace(workspace);
                wsTimes.getComponentTimes().clear();
                this.workspaceTimes.put(workspace.getItemId(), wsTimes);
            }
            wsTimes.setWorkspaceTime(workspaceTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationTimes[] getSyncTimes() {
        Map<UUID, SynchronizationTimes> map = this.workspaceTimes;
        synchronized (map) {
            block4: {
                if (!this.workspaceTimes.isEmpty()) break block4;
                return null;
            }
            return this.workspaceTimes.values().toArray(new SynchronizationTimes[this.workspaceTimes.size()]);
        }
    }
}

