/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IDataQuery;
import com.ibm.team.repository.common.query.IDataQueryPage;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.ISelectionElement;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.service.IQueryService;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.internal.BaselineConnection;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.IScmImportService;
import com.ibm.team.scm.common.internal.IScmQueryService;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.query.BaseBaselineQueryModel;
import com.ibm.team.scm.common.internal.query.BaseWorkspaceQueryModel;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceManager
extends EventSource
implements IWorkspaceManager {
    public static final String PLUGIN_ID = "com.ibm.team.scm.common";
    private final IClientLibraryContext context;
    protected final Object lock = new Object();
    protected final Object insertionLock = new Object();
    private final VersionableManager versionableManager;
    protected final Map<UUID, WeakReference<WorkspaceConnection>> knownWorkspaceConnections = new WeakHashMap<UUID, WeakReference<WorkspaceConnection>>();
    protected final Map<UUID, WeakReference<BaselineConnection>> knownBaselineConnections = new WeakHashMap<UUID, WeakReference<BaselineConnection>>();
    protected final Map<UUID, WeakReference<IComponentHandle>> knownComponents = new WeakHashMap<UUID, WeakReference<IComponentHandle>>();

    public WorkspaceManager(IClientLibraryContext context) {
        this.context = new ScmClientLibraryContext(context);
        this.versionableManager = new VersionableManager(this);
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.context.teamRepository();
    }

    public IClientLibraryContext getContext() {
        return this.context;
    }

    @Override
    public IVersionableManager versionableManager() {
        return this.versionableManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownWorkspaceConnections() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<WorkspaceConnection> connections = new ArrayList<WorkspaceConnection>(this.knownWorkspaceConnections.keySet().size());
            for (WeakReference<WorkspaceConnection> ref : this.knownWorkspaceConnections.values()) {
                WorkspaceConnection connection = null;
                if (ref != null) {
                    connection = (WorkspaceConnection)ref.get();
                }
                if (connection == null) continue;
                connections.add(connection);
            }
            return Collections.unmodifiableList(connections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkspaceConnection getConnectionIfKnown(IWorkspaceHandle ws) {
        WeakReference<WorkspaceConnection> ref;
        Object object = this.lock;
        synchronized (object) {
            ref = this.knownWorkspaceConnections.get(ws.getItemId());
        }
        if (ref != null) {
            return (WorkspaceConnection)ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownComponents() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IComponentHandle> components = new ArrayList<IComponentHandle>(this.knownComponents.keySet().size());
            ArrayList<UUID> staleKeysToBeRemoved = new ArrayList<UUID>();
            for (UUID key : this.knownComponents.keySet()) {
                WeakReference<IComponentHandle> ref = this.knownComponents.get(key);
                if (ref == null) continue;
                IComponentHandle component = (IComponentHandle)ref.get();
                if (component != null) {
                    components.add(component);
                    continue;
                }
                staleKeysToBeRemoved.add(key);
            }
            for (UUID key : staleKeysToBeRemoved) {
                this.knownComponents.remove(key);
            }
            return Collections.unmodifiableList(components);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List knownBaselineConnections() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<BaselineConnection> connections = new ArrayList<BaselineConnection>(this.knownBaselineConnections.values().size());
            for (WeakReference<BaselineConnection> ref : this.knownBaselineConnections.values()) {
                BaselineConnection connection = null;
                if (ref != null) {
                    connection = (BaselineConnection)ref.get();
                }
                if (connection == null) continue;
                connections.add(connection);
            }
            return Collections.unmodifiableList(connections);
        }
    }

    public IFolder createFolder() {
        IFolder f = (IFolder)IFolder.ITEM_TYPE.createItem();
        return f;
    }

    IScmService getServerConfigurationService() throws TeamRepositoryException {
        IScmService service = (IScmService)this.context.getServiceInterface(IScmService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IScmImportService getScmImportService() throws TeamRepositoryException {
        IScmImportService service = (IScmImportService)this.context.getServiceInterface(IScmImportService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IScmQueryService getScmQueryService() throws TeamRepositoryException {
        IScmQueryService service = (IScmQueryService)this.context.getServiceInterface(IScmQueryService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    IQueryService getQueryService() throws TeamRepositoryException {
        IQueryService service = (IQueryService)this.context.getServiceInterface(IQueryService.class);
        if (service == null) {
            throw new NotLoggedInException();
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends IWorkspaceConnection> getWorkspaceConnections(List<? extends IWorkspaceHandle> workspaces, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (workspaces == null) {
                throw new IllegalArgumentException();
            }
            ArrayList<IWorkspaceHandle> toFetch = new ArrayList<IWorkspaceHandle>(workspaces.size());
            HashMap<UUID, Object> connections = new HashMap<UUID, Object>((int)((double)workspaces.size() / 0.75));
            Object object = this.lock;
            synchronized (object) {
                for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
                    if (iWorkspaceHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    if (connections.containsKey(iWorkspaceHandle.getItemId())) continue;
                    WeakReference<WorkspaceConnection> cr = this.knownWorkspaceConnections.get(iWorkspaceHandle.getItemId());
                    if (cr != null) {
                        WorkspaceConnection conn = (WorkspaceConnection)cr.get();
                        connections.put(iWorkspaceHandle.getItemId(), conn);
                        if (conn != null) continue;
                        toFetch.add(iWorkspaceHandle);
                        continue;
                    }
                    connections.put(iWorkspaceHandle.getItemId(), null);
                    toFetch.add(iWorkspaceHandle);
                }
            }
            if (!toFetch.isEmpty()) {
                int totalSize = toFetch.size();
                WorkspaceRefreshParameter[] workspaceRefreshParameterArray = new WorkspaceRefreshParameter[totalSize];
                int i = 0;
                for (IWorkspaceHandle w : toFetch) {
                    WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
                    parm.setWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(w.getItemId(), null));
                    workspaceRefreshParameterArray[i++] = parm;
                }
                int left = totalSize;
                ArrayList<WorkspaceRefreshResult> existing = new ArrayList<WorkspaceRefreshResult>(totalSize);
                int j = 0;
                while (left > 0) {
                    WorkspaceRefreshResult[] result;
                    int from = j * 1024;
                    int size = Math.min(1024, left);
                    WorkspaceRefreshParameter[] subArray = new WorkspaceRefreshParameter[size];
                    System.arraycopy(workspaceRefreshParameterArray, from, subArray, 0, size);
                    WorkspaceRefreshResult[] workspaceRefreshResultArray = result = this.getServerConfigurationService().refreshWorkspaces(subArray, IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WorkspaceRefreshResult w = workspaceRefreshResultArray[n2];
                        if (w != null) {
                            existing.add(w);
                        }
                        ++n2;
                    }
                    left -= size;
                    ++j;
                }
                List<IWorkspaceConnection> connectionList = this.getWorkspaceConnections(existing.toArray(new WorkspaceRefreshResult[existing.size()]));
                for (IWorkspaceConnection w : connectionList) {
                    connections.put(w.getResolvedWorkspace().getItemId(), w);
                }
            }
            ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>(workspaces.size());
            for (IWorkspaceHandle iWorkspaceHandle : workspaces) {
                result.add((IWorkspaceConnection)connections.get(iWorkspaceHandle.getItemId()));
            }
            ArrayList<IWorkspaceConnection> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle workspace, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        try {
            WorkspaceConnection conn = null;
            Object object = this.lock;
            synchronized (object) {
                WeakReference<WorkspaceConnection> ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                if (ref != null && (conn = (WorkspaceConnection)ref.get()) == null) {
                    this.knownWorkspaceConnections.remove(workspace.getItemId());
                }
            }
            if (conn == null) {
                WorkspaceRefreshResult refreshed = this.getServerConfigurationService().refreshWorkspaces(new WorkspaceRefreshParameter[]{this.createEmptyWorkspaceRefreshParameter(workspace)}, SCMClientUtil.monitorFor(monitor))[0];
                monitor.worked(90);
                if (refreshed == null) {
                    throw new ItemNotFoundException((IItemHandle)workspace);
                }
                Object object2 = this.insertionLock;
                synchronized (object2) {
                    WeakReference<WorkspaceConnection> ref;
                    Object object3 = this.lock;
                    synchronized (object3) {
                        ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                        if (ref != null) {
                            conn = (WorkspaceConnection)ref.get();
                            if (conn != null) {
                                WorkspaceConnection workspaceConnection = conn;
                                return workspaceConnection;
                            }
                            this.knownWorkspaceConnections.remove(workspace.getItemId());
                        }
                    }
                    conn = new WorkspaceConnection(this, refreshed);
                    object3 = this.lock;
                    synchronized (object3) {
                        ref = this.knownWorkspaceConnections.get(workspace.getItemId());
                        if (ref != null) {
                            Assert.isTrue((boolean)false, (String)"WorkspaceConnection obtained concurrently.  This should not happen.");
                        }
                        this.knownWorkspaceConnections.put(this.getWorkspaceId(conn), new WeakReference<WorkspaceConnection>(conn));
                    }
                }
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "workspaces", null, workspace);
            }
            WorkspaceConnection workspaceConnection = conn;
            return workspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    private WorkspaceRefreshParameter createEmptyWorkspaceRefreshParameter(IWorkspaceHandle workspace) {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        parm.setWorkspace((IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspace.getItemId(), workspace.getStateId()));
        return parm;
    }

    @Override
    public IBaselineConnection getBaselineConnection(IBaselineHandle baselineHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baselineHandle == null) {
                throw new IllegalArgumentException();
            }
            IBaseline baseline = (IBaseline)this.context.teamRepository().itemManager().fetchCompleteItem((IItemHandle)baselineHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            SCMClientUtil.checkMonitor(monitor);
            IBaselineConnection iBaselineConnection = this.getBaselineConnection(baseline, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            return iBaselineConnection;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBaselineConnection getBaselineConnection(IBaseline baseline, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baseline == null) {
                throw new IllegalArgumentException();
            }
            if (!baseline.isComplete()) {
                throw new IllegalArgumentException();
            }
            IBaseline b = (IBaseline)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(baseline)).get(0);
            boolean added = false;
            BaselineConnection conn = null;
            Object object = this.lock;
            synchronized (object) {
                WeakReference<BaselineConnection> ref = this.knownBaselineConnections.get(b.getItemId());
                if (ref != null && (conn = (BaselineConnection)ref.get()) == null) {
                    this.knownBaselineConnections.remove(b.getItemId());
                }
                if (conn == null) {
                    conn = new BaselineConnection(this, b);
                    this.knownBaselineConnections.put(this.getBaselineId(conn), new WeakReference<BaselineConnection>(conn));
                    added = true;
                }
            }
            if (added) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baselines", null, b);
            }
            BaselineConnection baselineConnection = conn;
            return baselineConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection copyWorkspace(IAuditableHandle scopeHandle, IWorkspaceConnection peerWorkspaceConnection, String workspaceName, String description, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.copyWorkspace(scopeHandle, peerWorkspaceConnection, workspaceName, description, null, monitor);
    }

    public IWorkspaceConnection copyWorkspace(IAuditableHandle scopeHandle, IWorkspaceConnection peerWorkspaceConnection, String workspaceName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IWorkspaceConnection conn;
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceName == null || workspaceName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (peerWorkspaceConnection.isStream() && !(scopeHandle instanceof ITeamAreaHandle)) {
                throw new IllegalArgumentException();
            }
            if (!peerWorkspaceConnection.isStream() && !(scopeHandle instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            WorkspaceRefreshResult refreshResult = service.copyWorkspace(scopeHandle, (IWorkspaceHandle)peerWorkspaceConnection.getResolvedWorkspace(), workspaceName, description, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(90);
            IWorkspaceConnection iWorkspaceConnection = conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{refreshResult}).get(0);
            return iWorkspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComment(IChangeSetHandle changeSet, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComment(changeSet, comment, null, monitor);
    }

    public void setComment(IChangeSetHandle changeSet, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSet == null) {
                throw new IllegalArgumentException();
            }
            if (comment == null) {
                throw new IllegalArgumentException();
            }
            IStatus check = IItemValidator.INSTANCE.validateAttribute((IType)IChangeSet.ITEM_TYPE, IChangeSet.COMMENT_PROPERTY, (Object)comment);
            if (!check.isOK()) {
                throw new IllegalArgumentException("Comment is not appropriate");
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IChangeSet newChangeSet = service.setComment(changeSet, comment, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            FlowNodeConnection.log("Workspace Manager setComment about to applyItemUpdates - refreshing change set " + newChangeSet.getItemId().getUuidValue() + " to stateId " + newChangeSet.getStateId().getUuidValue());
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newChangeSet));
            FlowNodeConnection.log("Workspace Manager setComment finished applyItemUpdates");
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setName(IBaselineSetHandle baselineSet, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setName(baselineSet, name, null, monitor);
    }

    public void setName(IBaselineSetHandle baselineSet, String name, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IBaselineSet newBaselineSet = service.setBaselineSetName(baselineSet, name, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaselineSet));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComment(IBaselineSetHandle baselineSet, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComment(baselineSet, comment, null, monitor);
    }

    public void setComment(IBaselineSetHandle baselineSet, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (comment == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IBaselineSet newBaselineSet = service.setBaselineSetComment(baselineSet, comment, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(75);
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(newBaselineSet));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findWorkspaceAcceptRelationships(IWorkspaceHandle workspaceHandle, IAuditableHandle ownerFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmQueryService service = this.getScmQueryService();
            IWorkspaceHandle[] wsHandles = service.findWorkspaceAcceptFlows(workspaceHandle, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List workspaces = this.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(wsHandles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ArrayList<IWorkspace> matching = new ArrayList<IWorkspace>();
            for (IWorkspace workspace : workspaces) {
                if (workspace == null || ownerFilter != null && !ownerFilter.sameItemId((IItemHandle)workspace.getOwner())) continue;
                matching.add(workspace);
            }
            List list = Collections.unmodifiableList(matching);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void deleteWorkspace(IWorkspaceHandle workspaceHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.deleteWorkspace(workspaceHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkspace(IWorkspaceHandle workspaceHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            service.deleteWorkspace(workspaceHandle, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(25);
            Object object = this.lock;
            synchronized (object) {
                this.knownWorkspaceConnections.remove(workspaceHandle.getItemId());
            }
            this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(workspaceHandle));
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyRemove", "workspaces", workspaceHandle, null);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List findComponents(String namePattern, IAuditableHandle owner, boolean exact, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            List previouslyExistingComponents;
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            IScmQueryService service = this.getScmQueryService();
            SCMClientUtil.checkMonitor(monitor);
            IComponentHandle[] components = service.findComponents(namePattern, exact, owner, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(40);
            ArrayList<IComponentHandle> newComponents = new ArrayList<IComponentHandle>(components.length);
            Object object = this.lock;
            synchronized (object) {
                previouslyExistingComponents = this.knownComponents();
                Set knownComponentIds = ConfigUtil.getItemIds((Collection)previouslyExistingComponents);
                IComponentHandle[] iComponentHandleArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IComponentHandle component = iComponentHandleArray[n2];
                    if (!knownComponentIds.contains(component.getItemId())) {
                        newComponents.add(component);
                    }
                    ++n2;
                }
                for (IComponentHandle c : newComponents) {
                    this.knownComponents.put(c.getItemId(), new WeakReference<IComponentHandle>(c));
                }
            }
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAddMany", "components", previouslyExistingComponents, this.knownComponents());
            List<IComponentHandle> list = Arrays.asList(components);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findBaselineSets(String namePattern, IProcessAreaHandle teamScope, boolean exact, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            IScmQueryService service = this.getScmQueryService();
            SCMClientUtil.checkMonitor(monitor);
            IBaselineSet[] baselineSets = service.findBaselineSets(namePattern, teamScope, exact, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(40);
            List<IBaselineSet> baselineSetsList = Arrays.asList(baselineSets);
            List list = this.teamRepository().itemManager().applyItemUpdates(baselineSetsList);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IComponent createComponent(String componentName, IAuditableHandle ownerHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createComponent(componentName, ownerHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IComponent createComponent(String componentName, IAuditableHandle ownerHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (componentName == null || componentName.equals("")) {
                throw new IllegalArgumentException();
            }
            if (ownerHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            IComponent component = service.createComponent(componentName, ownerHandle, Connection.getSyncTimes(syncInfo), this.getRepoMonitor(monitor));
            IComponent result = (IComponent)this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(component)).iterator().next();
            Object object = this.lock;
            synchronized (object) {
                this.knownComponents.put(result.getItemId(), new WeakReference<IItemHandle>(result.getItemType().createItemHandle(result.getItemId(), result.getStateId())));
            }
            this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, result);
            IComponent iComponent = result;
            return iComponent;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, null, null, null, progressMonitor);
    }

    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, null, null, syncInfo, monitor);
    }

    @Override
    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IWorkspaceHandle defaultFlow, IWorkspaceHandle sourceChangeHistory, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createWorkspace(scopeHandle, workspaceName, description, defaultFlow, sourceChangeHistory, null, monitor);
    }

    public IWorkspaceConnection createWorkspace(IContributorHandle scopeHandle, String workspaceName, String description, IWorkspaceHandle defaultFlow, IWorkspaceHandle sourceChangeHistory, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (workspaceName == null || workspaceName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            WorkspaceRefreshResult result = service.createWorkspace(scopeHandle, workspaceName, description, defaultFlow, sourceChangeHistory, Connection.getSyncTimes(syncInfo), this.getRepoMonitor(monitor));
            monitor.worked(50);
            List<IWorkspaceConnection> conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result});
            IWorkspaceConnection iWorkspaceConnection = conn.get(0);
            return iWorkspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IWorkspaceConnection createStream(ITeamAreaHandle scopeHandle, String streamName, String description, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createStream(scopeHandle, streamName, description, null, monitor);
    }

    public IWorkspaceConnection createStream(ITeamAreaHandle scopeHandle, String streamName, String description, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IWorkspaceConnection conn;
            if (scopeHandle == null) {
                throw new IllegalArgumentException();
            }
            if (streamName == null || streamName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            WorkspaceRefreshResult result = service.createStream(scopeHandle, streamName, description, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            monitor.worked(90);
            IWorkspaceConnection iWorkspaceConnection = conn = this.getWorkspaceConnections(new WorkspaceRefreshResult[]{result}).get(0);
            return iWorkspaceConnection;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findWorkspaceDeliverRelationships(IWorkspaceHandle workspaceHandle, IAuditableHandle ownerFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (workspaceHandle == null) {
                throw new IllegalArgumentException();
            }
            IScmQueryService service = this.getScmQueryService();
            IWorkspaceHandle[] wsHandles = service.findWorkspaceDeliverFlows(workspaceHandle, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List workspaces = this.teamRepository().itemManager().fetchCompleteItems(Arrays.asList(wsHandles), 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ArrayList<IWorkspace> matching = new ArrayList<IWorkspace>();
            for (IWorkspace workspace : workspaces) {
                if (workspace == null || ownerFilter != null && !ownerFilter.sameItemId((IItemHandle)workspace.getOwner())) continue;
                matching.add(workspace);
            }
            List list = Collections.unmodifiableList(matching);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IItemQueryPage findWorkspacesByName(String namePattern, boolean matchWorkspaces, boolean matchStreams, boolean matchOwners, int pageSize, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (namePattern == null) {
                throw new IllegalArgumentException("namePattern must not be null");
            }
            if (!matchWorkspaces && !matchStreams) {
                throw new IllegalArgumentException("either matchWorkspaces or matchStreams must be true (or both)");
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("pageSize must be positive");
            }
            IScmQueryService service = this.getScmQueryService();
            IItemQueryPage page = service.findWorkspacesByName(namePattern, matchWorkspaces, matchStreams, matchOwners, pageSize, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(100);
            IItemQueryPage iItemQueryPage = page;
            return iItemQueryPage;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IItemQueryPage fetchNextPage(final IItemQueryPage page, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!page.hasNext()) {
            return null;
        }
        return (IItemQueryPage)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IItemQueryPage>(){

            public IItemQueryPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                monitor = SCMClientUtil.getMonitor(monitor, 100);
                try {
                    IItemQueryPage result = (IItemQueryPage)WorkspaceManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), page.getSize());
                    SCMClientUtil.checkMonitor(monitor);
                    monitor.worked(100);
                    IItemQueryPage iItemQueryPage = result;
                    return iItemQueryPage;
                }
                finally {
                    monitor.done();
                }
            }
        }, monitor);
    }

    @Override
    public List findAllWorkspaces(IAuditableHandle scope, String namePattern, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (scope == null) {
                throw new IllegalArgumentException();
            }
            if (!(scope instanceof ITeamAreaHandle) && !(scope instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            if (namePattern == null) {
                throw new IllegalArgumentException();
            }
            IScmQueryService service = this.getScmQueryService();
            WorkspaceRefreshResult[] results = service.findAllWorkspaces(scope, namePattern, SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(33);
            List<IWorkspaceConnection> wsConnections = this.getWorkspaceConnections(results);
            List<IWorkspaceConnection> list = Collections.unmodifiableList(wsConnections);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IWorkspaceConnection> getWorkspaceConnections(WorkspaceRefreshResult[] results) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> response = new ArrayList<IWorkspaceConnection>(results.length);
        ArrayList<IWorkspace> added = new ArrayList<IWorkspace>(results.length);
        Object object = this.insertionLock;
        synchronized (object) {
            int i = 0;
            while (i < results.length) {
                WeakReference<WorkspaceConnection> ref;
                WorkspaceRefreshResult refreshed = results[i];
                UUID workspaceId = refreshed.getWorkspaceItemId();
                WorkspaceConnection conn = null;
                Object object2 = this.lock;
                synchronized (object2) {
                    ref = this.knownWorkspaceConnections.get(workspaceId);
                    if (ref != null && (conn = (WorkspaceConnection)ref.get()) == null) {
                        this.knownWorkspaceConnections.remove(workspaceId);
                    }
                }
                if (conn == null) {
                    conn = new WorkspaceConnection(this, refreshed);
                    object2 = this.lock;
                    synchronized (object2) {
                        ref = this.knownWorkspaceConnections.get(workspaceId);
                        if (ref != null) {
                            Assert.isTrue((boolean)false, (String)"WorkspaceConnection obtained concurrently.  This should not happen.");
                        }
                        this.knownWorkspaceConnections.put(this.getWorkspaceId(conn), new WeakReference<WorkspaceConnection>(conn));
                    }
                    added.add(conn.getResolvedWorkspace());
                }
                response.add(conn);
                ++i;
            }
        }
        this.acquire();
        try {
            for (IWorkspace w : added) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "workspaces", null, w);
            }
        }
        finally {
            this.release();
        }
        return response;
    }

    @Override
    public List findAllBaselines(IComponentHandle component, String commentPattern, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (commentPattern == null) {
                throw new IllegalArgumentException();
            }
            BaseBaselineQueryModel.BaselineQueryModel bqm = BaseBaselineQueryModel.BaselineQueryModel.ROOT;
            IItemQuery query = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)bqm);
            IPredicate pred = bqm.component()._eq(query.newItemHandleArg())._and(bqm.comment()._like((IString)query.newStringArg(), '\\'));
            Object[] params = new Object[]{component.getItemId(), String.valueOf(commentPattern) + "%"};
            query.filter(pred);
            List baselines = this.findItems(query, params, monitor);
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(33);
            List list = Collections.unmodifiableList(baselines);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getChangeSetLinkSummary(changeSets, null, monitor);
    }

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (changeSets == null || changeSets.isEmpty()) {
                throw new IllegalArgumentException();
            }
            IChangeSetHandle[] handles = changeSets.toArray(new IChangeSetHandle[changeSets.size()]);
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IChangeSetLinkSummary[] summaries = service.getChangeSetLinkSummaries(handles, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(90);
            List<IChangeSetLinkSummary> list = Arrays.asList(summaries);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void renameComponent(IComponentHandle component, String newName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.renameComponent(component, newName, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameComponent(IComponentHandle component, String newName, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (newName == null || newName.equals("")) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IComponent c = service.renameComponent(component, newName, Connection.getSyncTimes(syncInfo), this.getRepoMonitor(monitor));
            monitor.worked(80);
            boolean sendEvent = false;
            Object object = this.lock;
            synchronized (object) {
                sendEvent = this.knownComponents.remove(c.getItemId()) != null;
                this.knownComponents.put(c.getItemId(), new WeakReference<IItemHandle>(c.getItemType().createItemHandle(c.getItemId(), c.getStateId())));
            }
            if (sendEvent) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, c);
            }
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(c));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setComponentOwner(IComponentHandle component, IAuditableHandle newOwnerHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setComponentOwner(component, newOwnerHandle, null, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentOwner(IComponentHandle component, IAuditableHandle newOwnerHandle, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (component == null) {
                throw new IllegalArgumentException();
            }
            if (newOwnerHandle == null) {
                throw new IllegalArgumentException();
            }
            if (!(newOwnerHandle instanceof IContributorHandle) && !(newOwnerHandle instanceof ITeamAreaHandle)) {
                throw new IllegalArgumentException();
            }
            IScmService service = this.getServerConfigurationService();
            monitor.worked(5);
            IComponent c = service.setComponentOwner(component, newOwnerHandle, Connection.getSyncTimes(syncInfo), this.getRepoMonitor(monitor));
            monitor.worked(80);
            boolean sendEvent = false;
            Object object = this.lock;
            synchronized (object) {
                sendEvent = this.knownComponents.remove(c.getItemId()) != null;
                this.knownComponents.put(c.getItemId(), new WeakReference<IItemHandle>(c.getItemType().createItemHandle(c.getItemId(), c.getStateId())));
            }
            if (sendEvent) {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "components", null, c);
            }
            this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(c));
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List findItems(IItemQuery query, Object[] params) throws TeamRepositoryException {
        int PAGE_SIZE = 75;
        IItemQueryPage page = this.getQueryService().queryItems(query, params, PAGE_SIZE);
        ArrayList items = new ArrayList(page.getResultSize());
        items.addAll(page.getItemHandles());
        while (page.hasNext()) {
            page = (IItemQueryPage)this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), PAGE_SIZE);
            items.addAll(page.getItemHandles());
        }
        return this.teamRepository().itemManager().fetchCompleteItems(items, 0, null);
    }

    @Override
    public List findItems(final IItemQuery query, final Object[] params, IProgressMonitor monitor) throws TeamRepositoryException {
        return (List)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<List>(){

            public List run(IProgressMonitor monitor) throws TeamRepositoryException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                int PAGE_SIZE = 75;
                IItemQueryPage page = WorkspaceManager.this.getQueryService().queryItems(query, params, PAGE_SIZE);
                ArrayList items = new ArrayList(page.getResultSize());
                items.addAll(page.getItemHandles());
                while (page.hasNext()) {
                    if (progress.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    page = (IItemQueryPage)WorkspaceManager.this.getQueryService().fetchPage(page.getToken(), page.getNextStartPosition(), PAGE_SIZE);
                    items.addAll(page.getItemHandles());
                }
                return WorkspaceManager.this.teamRepository().itemManager().fetchCompleteItems(items, 0, (IProgressMonitor)progress.newChild(1));
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() throws TeamRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            this.knownBaselineConnections.clear();
            this.knownComponents.clear();
            this.knownWorkspaceConnections.clear();
        }
    }

    private UUID getWorkspaceId(WorkspaceConnection conn) {
        return conn.getWorkspaceHandle().getItemId();
    }

    private UUID getBaselineId(BaselineConnection conn) {
        return conn.getBaseline().getItemId();
    }

    private void sendPropertyChangeEvent(String eventType, String property, Object oldValue, Object newValue) {
        this.queueEvent(new PropertyChangeEvent((IEventSource)this, eventType, (Object)this, (Object)property, oldValue, newValue));
    }

    private IRepositoryProgressMonitor getRepoMonitor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public Set findAllWorkspaceNames(final IAuditableHandle scope, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (scope == null) {
                throw new IllegalArgumentException();
            }
            if (!(scope instanceof ITeamAreaHandle) && !(scope instanceof IContributorHandle)) {
                throw new IllegalArgumentException();
            }
            IDataQueryPage page = (IDataQueryPage)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IDataQueryPage>(){

                public IDataQueryPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                    BaseWorkspaceQueryModel.WorkspaceQueryModel model = BaseWorkspaceQueryModel.WorkspaceQueryModel.ROOT;
                    IDataQuery query = (IDataQuery)IDataQuery.FACTORY.newInstance((IQueryModel)model);
                    query.select((ISelectionElement)model.name());
                    query.filter(model.owner()._eq((IItemHandle)scope));
                    return WorkspaceManager.this.getQueryService().queryData(query, new Object[0], 512);
                }
            }, monitor);
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(page.getResultSize() == 0 ? 100 : page.getSize() * 100 / page.getResultSize());
            HashSet<String> names = new HashSet<String>(page.getResultSize());
            while (true) {
                int pos;
                int i = 0;
                int n = page.getSize();
                while (i < n) {
                    names.add(page.getRow(i).getString(0));
                    ++i;
                }
                if (!page.hasNext()) break;
                final UUID token = page.getToken();
                monitor.worked((page = (IDataQueryPage)this.context.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<IDataQueryPage>(pos = page.getNextStartPosition()){
                    private final /* synthetic */ int val$pos;
                    {
                        this.val$pos = n;
                    }

                    public IDataQueryPage run(IProgressMonitor monitor) throws TeamRepositoryException {
                        return (IDataQueryPage)WorkspaceManager.this.getQueryService().fetchPage(token, this.val$pos, 512);
                    }
                }, monitor)).getResultSize() == 0 ? 100 : page.getSize() * 100 / page.getResultSize());
            }
            Set set = Collections.unmodifiableSet(names);
            return set;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria criteria, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.findChangeSets(criteria, maxResults, null, monitor);
    }

    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria criteria, int maxResults, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (criteria == null) {
                throw new IllegalArgumentException();
            }
            if (maxResults < 1) {
                throw new IllegalArgumentException();
            }
            if (syncInfo == null) {
                if (criteria.getChangeType() == 0) {
                    List<IChangeSetHandle> list = Collections.emptyList();
                    return list;
                }
                if (criteria.getModifiedAfter() != null && criteria.getModifiedBefore() != null && criteria.getModifiedAfter().compareTo(criteria.getModifiedBefore()) >= 0) {
                    List<IChangeSetHandle> list = Collections.emptyList();
                    return list;
                }
            }
            List<IChangeSetHandle> list = Arrays.asList(this.getScmQueryService().findChangeSets(criteria, maxResults, Connection.getSyncTimes(syncInfo), SCMClientUtil.monitorFor(monitor)));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshWorkspaceConnections(Collection<IWorkspaceConnection> connections, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (connections == null) {
                throw new IllegalArgumentException();
            }
            HashMap<UUID, IWorkspaceConnection> mapping = new HashMap<UUID, IWorkspaceConnection>((int)((double)connections.size() * 0.75));
            ArrayList<WorkspaceRefreshParameter> parms = new ArrayList<WorkspaceRefreshParameter>(connections.size());
            ArrayList<UUID> workspaceIds = new ArrayList<UUID>(connections.size());
            for (IWorkspaceConnection connection : connections) {
                if (connection == null) {
                    throw new IllegalArgumentException();
                }
                mapping.put(connection.getResolvedWorkspace().getItemId(), connection);
                workspaceIds.add(connection.getResolvedWorkspace().getItemId());
                parms.add(((WorkspaceConnection)connection).createRefreshParameter());
            }
            WorkspaceRefreshParameter[] param = parms.toArray(new WorkspaceRefreshParameter[parms.size()]);
            int left = parms.size();
            int j = 0;
            while (left > 0) {
                int from = j * 1024;
                int size = Math.min(1024, left);
                WorkspaceRefreshParameter[] subArray = new WorkspaceRefreshParameter[size];
                System.arraycopy(param, from, subArray, 0, size);
                WorkspaceRefreshResult[] refreshResults = this.getServerConfigurationService().refreshWorkspaces(subArray, IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
                int i = 0;
                while (i < refreshResults.length) {
                    UUID wsId = (UUID)workspaceIds.get(i);
                    WorkspaceRefreshResult result = refreshResults[i];
                    if (result == null) {
                        Object object = this.lock;
                        synchronized (object) {
                            this.knownWorkspaceConnections.remove(wsId);
                        }
                        this.teamRepository().itemManager().applyItemDeletes(Collections.singletonList(IWorkspace.ITEM_TYPE.createItemHandle(wsId, null)));
                    } else {
                        WorkspaceConnection conn = (WorkspaceConnection)mapping.get(result.getWorkspaceItemId());
                        ContextLock lock = new ContextLock();
                        lock.addExclusive((IContextHandle)conn.getResolvedWorkspace());
                        lock.acquire();
                        try {
                            conn.refresh(result);
                        }
                        finally {
                            lock.release();
                        }
                    }
                    ++i;
                }
                left -= size;
                ++j;
            }
        }
        finally {
            monitor.done();
        }
    }
}

