/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.common.advice.IObjectsResponse;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IWorkspaceConfiguration;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.ChangeHistoryEvent;
import com.ibm.team.scm.client.internal.ChangeSetClientCache;
import com.ibm.team.scm.client.internal.ClientCurrentComponentInfo;
import com.ibm.team.scm.client.internal.CommitEvent;
import com.ibm.team.scm.client.internal.Connection;
import com.ibm.team.scm.client.internal.CurrentChangeSetEvent;
import com.ibm.team.scm.client.internal.FlowNodeConnection;
import com.ibm.team.scm.client.internal.FlowTable;
import com.ibm.team.scm.client.internal.ImportChangeSetResult;
import com.ibm.team.scm.client.internal.Messages;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.VersionableManager;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.client.internal.isv.IWorkspaceDeliverRunnable;
import com.ibm.team.scm.client.internal.isv.IWorkspaceOperationRunner;
import com.ibm.team.scm.client.internal.process.ClientAdvisableOperation;
import com.ibm.team.scm.client.internal.process.ProcessUtils;
import com.ibm.team.scm.client.interop.IImportChangeSetResult;
import com.ibm.team.scm.client.interop.IWorkspaceConnectionInteropAdapter;
import com.ibm.team.scm.common.AcceptFlags;
import com.ibm.team.scm.common.ChangeSetsNotOutgoingException;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IScmService;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidStreamOperationException;
import com.ibm.team.scm.common.SyncReportInappropriateException;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IComponentizedAncestorList;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.BaselineHandle;
import com.ibm.team.scm.common.internal.ChangeSetHandle;
import com.ibm.team.scm.common.internal.ComponentFlow;
import com.ibm.team.scm.common.internal.ComponentHandle;
import com.ibm.team.scm.common.internal.ConfigUtil;
import com.ibm.team.scm.common.internal.CurrentFlows;
import com.ibm.team.scm.common.internal.FlowEntry;
import com.ibm.team.scm.common.internal.IScmImportService;
import com.ibm.team.scm.common.internal.Workspace;
import com.ibm.team.scm.common.internal.WorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.BasisMapping;
import com.ibm.team.scm.common.internal.dto.ChangeHistorySyncReport;
import com.ibm.team.scm.common.internal.dto.CommitParameter;
import com.ibm.team.scm.common.internal.dto.ComponentBaselineEntry;
import com.ibm.team.scm.common.internal.dto.ComponentChangeSetEntry;
import com.ibm.team.scm.common.internal.dto.ComponentInfo;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchParameter;
import com.ibm.team.scm.common.internal.dto.ComponentizedFetchResult;
import com.ibm.team.scm.common.internal.dto.ComponentizedFolderEntryReport;
import com.ibm.team.scm.common.internal.dto.ICommitParameter;
import com.ibm.team.scm.common.internal.dto.ItemConflictReport;
import com.ibm.team.scm.common.internal.dto.PredecessorInfo;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.ServiceConfigurationProvider;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import com.ibm.team.scm.common.internal.dto.UpdateReport;
import com.ibm.team.scm.common.internal.dto.WorkspaceDeliveryResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceImportResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemListResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceItemResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshParameter;
import com.ibm.team.scm.common.internal.dto.WorkspaceRefreshResult;
import com.ibm.team.scm.common.internal.dto.WorkspaceUpdateReportResult;
import com.ibm.team.scm.common.internal.util.SCMItemUtil;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.process.ProcessProxy;
import com.ibm.team.scm.common.process.RepositoryRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceConnection
extends FlowNodeConnection
implements IWorkspaceConnection,
IWorkspaceOperationRunner {
    private final IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory = new ConfigurationOpFactory();
    private final ChangeSetClientCache changeSetCache = new ChangeSetClientCache();
    private final IWorkspaceConfiguration workspaceConfiguration;

    WorkspaceConnection(WorkspaceManager workspaceManager, WorkspaceRefreshResult refreshResult) throws TeamRepositoryException {
        super(workspaceManager, refreshResult);
        this.refresh(refreshResult, false);
        this.workspaceConfiguration = new WorkspaceConfigurationProxy();
    }

    @Override
    public IUpdateReport conflictReport(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.conflictReport(null, monitor);
    }

    IUpdateReport conflictReport(ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IUpdateReport result = service.conflictReport(this.getWorkspaceHandle(), WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            SCMClientUtil.checkMonitor(monitor);
            IUpdateReport iUpdateReport = result;
            return iUpdateReport;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, "", false, syncInfo, monitor);
    }

    @Override
    public IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createChangeSet(component, comment, setCurrent, null, monitor);
    }

    IChangeSetHandle createChangeSet(IComponentHandle component, String comment, boolean setCurrent, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_0);
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            WorkspaceItemResult serviceResult = service.createChangeSet(this.getWorkspaceHandle(), component, comment, setCurrent, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            serviceResult.unsetItem();
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " createChangeSet() ends");
            IChangeSet iChangeSet = changeSet;
            return iChangeSet;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    private ItemNotFoundException expandItemNotFoundDetails(ItemNotFoundException e) {
        if (e.getData() instanceof IItemHandle && ((IItemHandle)e.getData()).sameItemId((IItemHandle)this.getWorkspaceHandle())) {
            ItemNotFoundException newException = new ItemNotFoundException(NLS.bind((String)Messages.WorkspaceConnection_19, (Object[])new Object[]{this.getResolvedWorkspace().getName()}), (IItemHandle)e.getData());
            if (e.getStackTrace() != null) {
                newException.setStackTrace(e.getStackTrace());
            }
            e = newException;
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IChangeSetHandle> suspendedChangeSets() {
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getSuspendedChangeSets();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getSuspendedChangeSetsByComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List activeChangeSets(IComponentHandle component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.lock;
        synchronized (object) {
            return this.changeSetCache.getActiveChangeSetsByComponent(component);
        }
    }

    @Override
    public IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.moveFoldersBetweenComponents(sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, null, monitor);
    }

    IUpdateReport moveFoldersBetweenComponents(IComponentHandle sourceComponent, IComponentHandle targetComponent, IFolderHandle[] folderHandles, IFolderHandle[] parentsToMoveInto, String sourceComment, String targetComment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (sourceComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (targetComponent == null) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (folderHandles == null || folderHandles.length == 0) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        if (parentsToMoveInto == null || parentsToMoveInto.length != folderHandles.length) {
            throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), sourceComponent);
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), targetComponent);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            WorkspaceUpdateReportResult result = service.moveFoldersWithHistory(this.getWorkspaceHandle(), sourceComponent, targetComponent, folderHandles, parentsToMoveInto, sourceComment, targetComment, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), false);
                this.sendEvent(result.getReport());
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " moveFolders() ends");
            IUpdateReport iUpdateReport = result.getReport();
            return iUpdateReport;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public void closeChangeSets(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, null, monitor);
    }

    void closeChangeSets(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, true, syncInfo, monitor);
    }

    @Override
    public void ensureClosed(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, null, monitor);
    }

    void ensureClosed(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        this.closeChangeSets(changeSets, false, null, monitor);
    }

    private static void addBaselineEntries(List<ComponentBaselineEntry> cbe, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentBaselineEntry be : cbe) {
            IComponentHandle c = be.getComponent();
            for (IBaselineHandle bh : be.getBaselines()) {
                componentMap.put(bh.getItemId(), c);
            }
        }
    }

    private static void addChangeSetEntries(List<ComponentChangeSetEntry> cce, Map<UUID, IComponentHandle> componentMap) {
        for (ComponentChangeSetEntry ce : cce) {
            IComponentHandle c = ce.getComponent();
            for (IChangeSetHandle ch : ce.getChangeSets()) {
                componentMap.put(ch.getItemId(), c);
            }
        }
    }

    private static void addBasisMappings(List<BasisMapping> bm, Map<UUID, IComponentHandle> componentMap) {
        for (BasisMapping b : bm) {
            componentMap.put(b.getBaseline().getItemId(), b.getComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, ChangeHistorySyncReport report, Collection<IBaselineHandle> baselines, Collection<IChangeSetHandle> changeSets, boolean lockRemote, IProgressMonitor monitor) throws TeamRepositoryException {
        IComponentHandle cmp;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<UUID, IComponentHandle> componentMap = new HashMap<UUID, IComponentHandle>();
        WorkspaceConnection.addBaselineEntries(report.getIncomingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addBaselineEntries(report.getOutgoingComponentBaselineEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getIncomingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntries(), componentMap);
        WorkspaceConnection.addChangeSetEntries(report.getOutgoingComponentChangeSetEntriesAfterBasis(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getCommonComponentBaselines(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getLocalBases(), componentMap);
        WorkspaceConnection.addBasisMappings(report.getRemoteBases(), componentMap);
        IWorkspaceHandle remoteWorkspace = report.getRemote();
        WorkspaceConnection other = this.workspaceManager.getConnectionIfKnown(report.getRemote());
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IBaselineHandle h : baselines) {
            cmp = (IComponentHandle)componentMap.get(h.getItemId());
            if (cmp == null && (cmp = this.getComponent(h)) == null && (cmp = this.getComponentFromBasis(h)) == null) {
                if (other != null) {
                    cmp = other.getComponentFromBasis(h);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add((IChangeSetHandle)h);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        for (IChangeSetHandle cs : changeSets) {
            cmp = (IComponentHandle)componentMap.get(cs.getItemId());
            if (cmp == null && (cmp = this.getComponent(cs)) == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (other != null) {
                        object = other.lock;
                        synchronized (object) {
                            cmp = other.changeSetCache.getComponent(cs);
                        }
                    }
                    if (cmp == null) {
                        if (toFetch == null) {
                            toFetch = new ArrayList();
                        }
                        toFetch.add(cs);
                        continue;
                    }
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
            if (!lockRemote) continue;
            lock.addExclusive((IContextHandle)remoteWorkspace, cmp);
        }
        if (toFetch != null) {
            List fetched = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                IComponentHandle cmp2;
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                if (i instanceof IBaseline) {
                    cmp2 = ((IBaseline)i).getComponent();
                } else if (i instanceof IChangeSet) {
                    cmp2 = ((IChangeSet)i).getComponent();
                } else {
                    throw new IllegalStateException();
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp2);
                if (lockRemote) {
                    lock.addExclusive((IContextHandle)remoteWorkspace, cmp2);
                }
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IComponentHandle getComponentFromBasis(IBaselineHandle h) {
        Object object = this.lock;
        synchronized (object) {
            for (ClientCurrentComponentInfo info : this.cachedComponents.values()) {
                if (!h.sameItemId((IItemHandle)info.basis())) continue;
                return info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, List<? extends IChangeSetHandle> list1, List<? extends IChangeSetHandle> list2, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        Iterator<? extends IChangeSetHandle> i2 = list2.iterator();
        for (IChangeSetHandle iChangeSetHandle : list1) {
            IComponentHandle cmp = this.getComponent(iChangeSetHandle);
            if (cmp == null) {
                Object object = this.lock;
                synchronized (object) {
                    cmp = this.changeSetCache.getComponent(iChangeSetHandle);
                }
                if (cmp == null) {
                    IChangeSetHandle iChangeSetHandle2 = i2.next();
                    cmp = this.getComponent(iChangeSetHandle2);
                    if (cmp == null) {
                        object = this.lock;
                        synchronized (object) {
                            cmp = this.changeSetCache.getComponent(iChangeSetHandle2);
                        }
                        if (cmp == null) {
                            if (toFetch == null) {
                                toFetch = new ArrayList<IChangeSetHandle>();
                            }
                            toFetch.add(iChangeSetHandle2);
                            continue;
                        }
                    }
                } else {
                    i2.next();
                }
            } else {
                i2.next();
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        i2 = null;
        if (toFetch != null) {
            List list = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : list) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLock(ContextLock lock, Collection<IChangeSetHandle> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IChangeSetHandle> toFetch = null;
        for (IChangeSetHandle cs : changeSets) {
            IComponentHandle cmp = this.getComponent(cs);
            if (cmp == null) {
                Iterator iterator = this.lock;
                synchronized (iterator) {
                    cmp = this.changeSetCache.getComponent(cs);
                }
                if (cmp == null) {
                    if (toFetch == null) {
                        toFetch = new ArrayList<IChangeSetHandle>();
                    }
                    toFetch.add(cs);
                    continue;
                }
            }
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), cmp);
        }
        if (toFetch != null) {
            List fetched = this.teamRepository().itemManager().fetchCompleteItems(toFetch, 0, (IProgressMonitor)progress.newChild(100));
            int idx = 0;
            for (IItem i : fetched) {
                if (i == null) {
                    throw new ItemNotFoundException((IItemHandle)toFetch.get(idx));
                }
                lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), ((IChangeSet)i).getComponent());
                ++idx;
            }
        }
        progress.done();
    }

    private IComponentHandle getComponent(IChangeSetHandle csh) {
        IChangeSet cs;
        if (csh instanceof IChangeSet && (cs = (IChangeSet)csh).getComponent() != null) {
            return cs.getComponent();
        }
        cs = (IChangeSet)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)csh);
        if (cs != null && cs.getComponent() != null) {
            return cs.getComponent();
        }
        return null;
    }

    private IComponentHandle getComponent(IBaselineHandle bh) {
        IBaseline b;
        if (bh instanceof IBaseline && (b = (IBaseline)bh).getComponent() != null) {
            return b.getComponent();
        }
        b = (IBaseline)this.teamRepository().itemManager().getSharedItemIfKnown((IItemHandle)bh);
        if (b != null && b.getComponent() != null) {
            return b.getComponent();
        }
        return null;
    }

    private void closeChangeSets(Collection changeSets, boolean checkActive, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(changeSets);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceItemListResult result = service.closeChangeSets(this.getWorkspaceHandle(), (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), checkActive, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            this.acquire();
            try {
                this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CloseChangeSets", SCMClientUtil.asList(changeSets));
                WorkspaceRefreshResult refreshResult = result.getRefreshResult();
                this.refresh(refreshResult, false);
                this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                result.unsetItems();
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " closeChangeSets() ends");
            }
            finally {
                this.release();
            }
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.discardChangeSets(preflight, changeSets, null, monitor);
    }

    public List getMostRecentBaselinesAffecting(IComponentHandle component, List folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            for (Object element : folderHandles) {
                if (element == null) {
                    throw new IllegalArgumentException();
                }
                if (element instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            IBaseline[] baselines = service.getMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, folderHandles.toArray(new IFolderHandle[folderHandles.size()]), this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
            List<IBaseline> list = Arrays.asList(baselines);
            return list;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void initializeMostRecentBaselinesAffecting(IComponentHandle component, List<? extends IBaselineHandle> baselines, List<? extends IFolderHandle> folderHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            if (baselines.size() != folderHandles.size()) {
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : folderHandles) {
                if (iFolderHandle == null) {
                    throw new IllegalArgumentException();
                }
                if (iFolderHandle instanceof IVersionableHandle) continue;
                throw new IllegalArgumentException();
            }
            for (IFolderHandle iFolderHandle : baselines) {
                if (iFolderHandle != null) continue;
                throw new IllegalArgumentException();
            }
            SCMClientUtil.checkMonitor(monitor);
            this.validate();
            IScmService service = this.workspaceManager().getServerConfigurationService();
            service.initializeMostRecentBaselinesAffecting((IWorkspaceHandle)this.getResolvedWorkspace(), component, baselines.toArray(new IBaselineHandle[baselines.size()]), folderHandles.toArray(new IFolderHandle[folderHandles.size()]), this.monitorFor(monitor));
            SCMClientUtil.checkMonitor(monitor);
            monitor.worked(50);
        }
        finally {
            monitor.done();
        }
    }

    IUpdateReport discardChangeSets(boolean preflight, Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(changeSets);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, changeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            lock.acquire();
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() begins");
            }
        } else {
            monitor.worked(10);
            lock = null;
        }
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.discardChangeSets(this.getWorkspaceHandle(), preflight, (IChangeSetHandle[])changeSets.toArray(new ChangeSetHandle[changeSets.size()]), IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            IUpdateReport report = result.getReport();
            monitor.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), false);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", SCMClientUtil.asList(changeSets));
                    this.sendEvent(report);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " discardChangeSets() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            monitor.done();
        }
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        this.refresh(false, monitor);
    }

    @Override
    public void refresh(boolean replaceComponent, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID txnId = UUID.generate();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) begins - tag " + txnId.getUuidValue());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            WorkspaceRefreshResult refreshResult = this.refreshInternal((IProgressMonitor)progress.newChild(95), txnId);
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
            ContextLock lock = new ContextLock();
            lock.addExclusive((IContextHandle)this.getWorkspaceHandle());
            lock.acquire();
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) acquires lock - tag " + txnId.getUuidValue());
            try {
                this.refresh(refreshResult, false, " - tag " + txnId.getUuidValue());
            }
            finally {
                lock.release();
            }
        }
        finally {
            progress.done();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(bool,monitor) ends - tag " + txnId.getUuidValue());
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.refreshInternal(monitor, null);
    }

    private WorkspaceRefreshResult refreshInternal(IProgressMonitor monitor, UUID txnId) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshParameter parm = this.createRefreshParameter();
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshParameter created" + txnId.getUuidValue());
            }
            WorkspaceRefreshParameter[] workspaceRefreshParameters = new WorkspaceRefreshParameter[]{parm};
            WorkspaceRefreshResult refreshResult = service.refreshWorkspaces(workspaceRefreshParameters, IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor))[0];
            if (txnId != null) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refreshResult returned" + txnId.getUuidValue());
            }
            if (refreshResult == null) {
                throw new ItemNotFoundException(this.getResolvedWorkspace().getItemHandle());
            }
            WorkspaceRefreshResult workspaceRefreshResult = refreshResult;
            return workspaceRefreshResult;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkspaceRefreshParameter createRefreshParameter() {
        WorkspaceRefreshParameter parm = ScmDtoFactory.eINSTANCE.createWorkspaceRefreshParameter();
        Object object = this.lock;
        synchronized (object) {
            IWorkspace resolvedWorkspace = this.getResolvedWorkspace();
            parm.setWorkspace((IWorkspaceHandle)resolvedWorkspace.getStateHandle());
            parm.getActiveChangeSets().addAll(this.activeChangeSets());
            parm.getSuspendedChangedSets().addAll(this.suspendedChangeSets());
            for (ICurrentComponentInfo iCurrentComponentInfo : this.getComponentsInfo()) {
                ComponentStateSummary state = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
                state.setChangeHistoryState(((SyncTime)iCurrentComponentInfo.changeHistoryTime()).getValue());
                state.setComponent(iCurrentComponentInfo.getComponent());
                state.setConfigurationState(((SyncTime)iCurrentComponentInfo.configurationTime()).getValue());
                parm.getCurrentComponents().add(state);
            }
        }
        return parm;
    }

    public void refresh(WorkspaceRefreshResult data) throws TeamRepositoryException {
        if (data == null) {
            throw new IllegalArgumentException();
        }
        this.refresh(data, false);
    }

    @Override
    protected void refresh(WorkspaceRefreshResult refreshResult, boolean replaceComponent) throws TeamRepositoryException {
        this.refresh(refreshResult, replaceComponent, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(WorkspaceRefreshResult refreshResult, boolean replaceComponent, String tag) throws TeamRepositoryException {
        if (!refreshResult.getWorkspace().sameItemId((IItemHandle)this.workspaceHandle)) {
            throw new IllegalArgumentException();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) begins " + tag);
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                HashMap added;
                Workspace workspaceFromServer = (Workspace)refreshResult.getWorkspace();
                List componentList = refreshResult.getComponents();
                Map previousBases = this.getBases();
                HashMap<UUID, IComponentHandle> previousComponents = new HashMap<UUID, IComponentHandle>();
                for (ClientCurrentComponentInfo i : this.cachedComponents.values()) {
                    previousComponents.put(i.getComponent().getItemId(), i.getComponent());
                }
                Map beforeSuspended = ConfigUtil.tableForItems(this.changeSetCache.getSuspendedChangeSets());
                Map beforeActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets());
                TreeMap<IComponentHandle, IBaselineHandle> newBases = new TreeMap<IComponentHandle, IBaselineHandle>(ItemUtil.itemIdComparator);
                newBases.putAll(previousBases);
                HashMap<UUID, ClientCurrentComponentInfo> componentMap = new HashMap<UUID, ClientCurrentComponentInfo>(this.cachedComponents);
                Iterator iter = componentList.iterator();
                HashMap<UUID, IComponentHandle> newComponents = new HashMap<UUID, IComponentHandle>();
                TreeMap<IComponentHandle, IChangeSetHandle> currentChangeSets = new TreeMap<IComponentHandle, IChangeSetHandle>(ItemUtil.itemIdComparator);
                HashSet<UUID> staleComponents = new HashSet<UUID>();
                while (iter.hasNext()) {
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> previousConflicts;
                    ComponentInfo entry = (ComponentInfo)iter.next();
                    ClientCurrentComponentInfo ci = (ClientCurrentComponentInfo)this.cachedComponents.get(entry.getComponent().getItemId());
                    if (ci != null) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has local chTime=" + ((SynchronizationTime)ci.changeHistoryTime().toSynchronizationTime()).getTime() + " and supplied chTime=" + entry.getChangeHistoryState() + tag);
                    } else {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + entry.getComponent().getItemId().getUuidValue() + " has supplied chTime=" + entry.getChangeHistoryState() + tag);
                    }
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> map = previousConflicts = ci == null ? Collections.EMPTY_MAP : ci.getConflicts();
                    if (ci != null && WorkspaceConnection.compareTimes(((SyncTime)ci.changeHistoryTime()).getValue(), entry.getChangeHistoryState()) > 0) {
                        staleComponents.add(entry.getComponent().getItemId());
                        continue;
                    }
                    ClientCurrentComponentInfo newInfo = new ClientCurrentComponentInfo(entry.getDeliveredBy(), entry.getDeliveryDate(), entry.getBasis(), entry.getIndex() + 1L, (ISyncTime)new SyncTime(entry.getConfigurationState()), (ISyncTime)new SyncTime(entry.getChangeHistoryState()), entry.getComponent(), entry.getChangehistory(), entry.getConflicts());
                    componentMap.put(entry.getComponent().getItemId(), newInfo);
                    Map<UUID, ClientCurrentComponentInfo.ConflictInfo> currentConflicts = newInfo.getConflicts();
                    if (!previousConflicts.equals(currentConflicts)) {
                        this.sendEvent("com.ibm.team.scm.ConflictUpdate", Collections.EMPTY_LIST, entry.getComponent());
                    }
                    newComponents.put(entry.getComponent().getItemId(), entry.getComponent());
                    if (entry.getBasis() != null) {
                        newBases.put(entry.getComponent(), entry.getBasis());
                    }
                    IChangeSetHandle current = entry.getCurrentChangeSet();
                    IChangeSetHandle oldCurrent = this.changeSetCache.getCurrentChangeSet(entry.getComponent());
                    if (current == null && oldCurrent != null || current != null && !current.sameItemId((IItemHandle)oldCurrent)) {
                        this.sendCurrentChangeSetEvent(current, oldCurrent, entry.getComponent());
                    }
                    currentChangeSets.put(entry.getComponent(), current == null ? ChangeSetClientCache.CURRENT_UNSET : current);
                }
                if (workspaceFromServer != null && WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    for (IComponentHandle deleted : refreshResult.getRemovedComponents()) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component " + deleted.getItemId().getUuidValue() + " is removed." + tag);
                        UUID componentId = deleted.getItemId();
                        componentMap.remove(componentId);
                        IChangeSetHandle oldCurrent = this.changeSetCache.getCurrentChangeSet(deleted);
                        if (oldCurrent != null) {
                            this.sendCurrentChangeSetEvent(null, oldCurrent, deleted);
                        }
                        currentChangeSets.put(deleted, ChangeSetClientCache.CURRENT_UNSET);
                        newBases.remove(deleted);
                    }
                }
                Set newBasesIds = ConfigUtil.getItemIds(newBases.values());
                Set prevBasesIds = ConfigUtil.getItemIds(previousBases.values());
                if (replaceComponent || !newBasesIds.equals(prevBasesIds)) {
                    this.sendPropertyChangeEvent("com.ibm.team.repository.PropertySet", "bases", previousBases, newBases);
                }
                if (!previousComponents.keySet().equals(componentMap.keySet())) {
                    Collection value;
                    String eventType;
                    newComponents.keySet().removeAll(previousComponents.keySet());
                    previousComponents.keySet().removeAll(componentMap.keySet());
                    if (!newComponents.isEmpty()) {
                        eventType = "com.ibm.team.repository.PropertyAddMany";
                        value = newComponents.values();
                        if (newComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyAdd";
                            value = newComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyAdd") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponent added " + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - newComponents added " + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", null, value);
                    }
                    if (!previousComponents.isEmpty()) {
                        eventType = "com.ibm.team.repository.PropertyRemoveMany";
                        value = previousComponents.values();
                        if (previousComponents.size() == 1) {
                            eventType = "com.ibm.team.repository.PropertyRemove";
                            value = previousComponents.values().iterator().next();
                        }
                        if (eventType == "com.ibm.team.repository.PropertyRemove") {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - component removed" + tag);
                        } else {
                            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - components removed" + tag);
                        }
                        this.sendPropertyChangeEvent(eventType, "components", value, null);
                    }
                }
                this.changeSetCache.updateCaches(refreshResult, currentChangeSets, staleComponents);
                this.cachedComponents = Collections.unmodifiableMap(componentMap);
                if (workspaceFromServer != null && WorkspaceConnection.compareTimes(this.vTime.getValue(), workspaceFromServer.getTime()) < 0) {
                    List flows = workspaceFromServer.getFlows();
                    CurrentFlows currentFlows = workspaceFromServer.getCurrentFlows();
                    TreeMap<IComponentHandle, CurrentFlows> currentComponentFlows = new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator);
                    for (ComponentFlow e : workspaceFromServer.getCurrentComponentFlows()) {
                        currentComponentFlows.put(e.getComponent(), e.getCurrentFlows());
                    }
                    this.flowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
                    this.vTime = new SyncTime(workspaceFromServer.getTime());
                    this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(workspaceFromServer));
                }
                Map afterSuspended = ConfigUtil.tableForItems(this.changeSetCache.getSuspendedChangeSets());
                Map afterActive = ConfigUtil.tableForItems(this.changeSetCache.getActiveChangeSets());
                if (!afterActive.keySet().equals(beforeActive.keySet())) {
                    added = new HashMap(afterActive);
                    added.keySet().removeAll(beforeActive.keySet());
                    if (!added.isEmpty()) {
                        for (IChangeSet cs : added.values()) {
                            this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", Collections.singletonList(cs), this.changeSetCache.getComponent((IChangeSetHandle)cs));
                        }
                    }
                }
                if (!afterSuspended.keySet().equals(beforeSuspended.keySet())) {
                    added = new HashMap(afterSuspended);
                    added.keySet().removeAll(beforeSuspended.keySet());
                    if (!added.isEmpty()) {
                        this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.SuspendChangeSet", new ArrayList(added.values()));
                    }
                    HashMap removed = new HashMap(beforeSuspended);
                    removed.keySet().removeAll(afterSuspended.keySet());
                    if (!removed.isEmpty()) {
                        this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.RemoveSuspendedChangeSet", new ArrayList(removed.values()));
                    }
                }
                ArrayList<IChangeSet> valid = new ArrayList<IChangeSet>(refreshResult.getActiveChangeSets().size());
                for (IChangeSet cs : refreshResult.getActiveChangeSets()) {
                    if (staleComponents.contains(cs.getComponent().getItemId())) continue;
                    valid.add(cs);
                }
                if (!valid.isEmpty()) {
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                    for (IChangeSet cs : valid) {
                        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing change set " + cs.getItemId().getUuidValue() + " to stateId " + cs.getStateId().getUuidValue() + " " + tag);
                    }
                    this.teamRepository().itemManager().applyItemUpdates(valid);
                    WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) - refreshing " + valid.size() + " active change sets " + tag);
                }
                if (!refreshResult.getSuspendedChangeSets().isEmpty()) {
                    this.teamRepository().itemManager().applyItemUpdates(refreshResult.getSuspendedChangeSets());
                }
                this.clearRefreshResult(refreshResult);
            }
        }
        finally {
            this.release();
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " refresh(WRR,bool) ends " + tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refreshWorkspace(Workspace w) {
        this.acquire();
        try {
            Object object = this.lock;
            synchronized (object) {
                block9: {
                    if (WorkspaceConnection.compareTimes(this.vTime.getValue(), w.getTime()) < 0) break block9;
                    return;
                }
                List flows = w.getFlows();
                CurrentFlows currentFlows = w.getCurrentFlows();
                TreeMap<IComponentHandle, CurrentFlows> currentComponentFlows = new TreeMap<IComponentHandle, CurrentFlows>(ItemUtil.itemIdComparator);
                for (ComponentFlow e : w.getCurrentComponentFlows()) {
                    currentComponentFlows.put(e.getComponent(), e.getCurrentFlows());
                }
                this.teamRepository().itemManager().applyItemUpdates(Collections.singletonList(w));
                this.vTime = new SyncTime(w.getTime());
                this.flowTable = new FlowTable(flows.toArray(new FlowEntry[flows.size()]), currentFlows, currentComponentFlows);
            }
        }
        finally {
            this.release();
        }
    }

    protected void clearRefreshResult(WorkspaceRefreshResult refreshResult) {
        refreshResult.unsetActiveChangeSets();
        refreshResult.unsetSuspendedChangeSets();
        refreshResult.unsetActiveRemoved();
        refreshResult.unsetSuspendedRemoved();
        refreshResult.unsetWorkspaceItemId();
        refreshResult.unsetWorkspace();
        refreshResult.unsetComponents();
    }

    @Override
    public IUpdateReport accept(int flags, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, syncReport, baselines, incomingChangeSets, null, monitor);
    }

    IUpdateReport accept(int flags, IChangeHistorySyncReport syncReport, List baselines, List incomingChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (incomingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        for (Object o : baselines) {
            if (o != null && o instanceof BaselineHandle) continue;
            throw new IllegalArgumentException();
        }
        for (Object o : incomingChangeSets) {
            if (o != null && o instanceof ChangeSetHandle) continue;
            throw new IllegalArgumentException();
        }
        IWorkspaceHandle remoteWorkspaceHandle = this.checkedGetRemote(syncReport);
        IWorkspaceHandle handle = this.getWorkspaceHandle();
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        this.checkLocal(syncReport, handle, monitor);
        List sortedIncomingCsHandleList = this.checkAgainstReport((ChangeHistorySyncReport)syncReport, true, incomingChangeSets);
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        if ((2 & flags) != 0) {
            throw new IllegalArgumentException();
        }
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselines, sortedIncomingCsHandleList, false, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            lock.acquire();
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() begins");
            }
        } else {
            monitor.worked(10);
            lock = null;
        }
        try {
            this.validate();
            ChangeSetHandle[] sortedIncomingCsHandles = sortedIncomingCsHandleList.toArray(new ChangeSetHandle[sortedIncomingCsHandleList.size()]);
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.acceptCombined(handle, flags, remoteWorkspaceHandle, (IBaselineHandle[])baselines.toArray(new BaselineHandle[baselines.size()]), (IChangeSetHandle[])sortedIncomingCsHandles, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            IUpdateReport updateReport = result.getReport();
            monitor.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), false);
                    this.sendEvent(updateReport);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", baselines, incomingChangeSets);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " acceptCombined() ends");
            }
            IUpdateReport iUpdateReport = updateReport;
            return iUpdateReport;
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            monitor.done();
        }
    }

    @Override
    public IUpdateReport accept(int flags, List incoming, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.accept(flags, incoming, null, monitor);
    }

    IUpdateReport accept(int flags, List incoming, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        if ((2 & flags) != 0) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(incoming);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            lock.acquire();
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() begins");
            }
        } else {
            lock = null;
            monitor.worked(10);
        }
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.accept(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            IUpdateReport report = result.getReport();
            monitor.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), false);
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", incoming);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " accept() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            monitor.done();
        }
    }

    @Override
    public IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.resume(flags, incoming, null, monitor);
    }

    IUpdateReport resume(int flags, List<IChangeSetHandle> incoming, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ContextLock lock;
        boolean preflight;
        boolean bl = preflight = (flags & 1) != 0;
        if (incoming == null) {
            throw new IllegalArgumentException();
        }
        if (!AcceptFlags.isValid((int)flags)) {
            throw new IllegalArgumentException();
        }
        this.checkForDuplicates(incoming);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        if (!preflight) {
            lock = new ContextLock();
            this.addToLock(lock, incoming, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            lock.acquire();
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() begins");
            }
        } else {
            lock = null;
            monitor.worked(10);
        }
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.resume(this.getWorkspaceHandle(), flags, (IChangeSetHandle[])incoming.toArray(new ChangeSetHandle[incoming.size()]), IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            IUpdateReport report = result.getReport();
            monitor.worked(80);
            if (!preflight) {
                this.acquire();
                try {
                    this.refresh(result.getRefreshResult(), false);
                    this.sendEvent(report);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", incoming);
                    this.sendEvent("com.ibm.team.scm.ChangeHistoryEvent.RemoveSuspendedChangeSet", incoming);
                }
                finally {
                    this.release();
                }
            }
            if (!preflight) {
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " resume() ends");
            }
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        finally {
            if (!preflight) {
                lock.release();
            }
            monitor.done();
        }
    }

    @Override
    public void deliver(IChangeHistorySyncReport syncReport, List baselines, List outgoingChangeSets, IProgressMonitor m) throws TeamRepositoryException {
        this.deliver(syncReport, baselines, outgoingChangeSets, null, null, m);
    }

    void deliver(final IChangeHistorySyncReport syncReport, final List baselines, final List outgoingChangeSets, final ISynchronizationInfo syncInfo, final IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionRunnable, IProgressMonitor m) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)m, (int)100);
        if (syncReport == null) {
            throw new IllegalArgumentException();
        }
        if (baselines == null) {
            throw new IllegalArgumentException();
        }
        if (outgoingChangeSets == null) {
            throw new IllegalArgumentException();
        }
        this.checkLocal(syncReport, this.getWorkspaceHandle(), (IProgressMonitor)progress.newChild(10));
        IWorkspaceHandle remoteWorkspaceHandle = this.checkedGetRemote(syncReport);
        final WorkspaceConnection remoteConnection = (WorkspaceConnection)SCMPlatform.getWorkspaceManager(this.teamRepository()).getWorkspaceConnection(remoteWorkspaceHandle, (IProgressMonitor)progress.newChild(20));
        final IScmService service = this.workspaceManager.getServerConfigurationService();
        DeliverOperationData deliverData = new DeliverOperationData((ProcessProxy)new ProcessUtils.ClientProcessProxy(this.teamRepository()), this.getResolvedWorkspace(), remoteConnection.getResolvedWorkspace(), baselines, outgoingChangeSets);
        final ClientAdvisableOperation operation = new ClientAdvisableOperation(this.teamRepository(), "com.ibm.team.scm.client.deliver", deliverData, (IItem)remoteConnection.getResolvedWorkspace());
        operation.setIgnoredExceptions(false);
        operation.setBlock(new RepositoryRunnable(){

            public Object run(final IProgressMonitor topMonitor) throws TeamRepositoryException {
                return WorkspaceConnection.this.runDeliver(new IWorkspaceDeliverRunnable(){

                    public IObjectsResponse deliver(IWorkspaceHandle workspaceHandle, IWorkspaceHandle targetWorkspaceHandle, IBaselineHandle[] baselines, IChangeSetHandle[] outgoingChangeSets, IRepositoryProgressMonitor monitor) throws TeamRepositoryException {
                        if (preConditionRunnable != null && operation.isBeingRerun()) {
                            preConditionRunnable.run(topMonitor);
                        }
                        return service.deliverCombined(workspaceHandle, targetWorkspaceHandle, baselines, outgoingChangeSets, IScmService.DELTA_PER_INVOCATION, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), monitor);
                    }
                }, remoteConnection, syncReport, baselines, outgoingChangeSets, topMonitor);
            }
        });
        operation.processExec((IProgressMonitor)progress.newChild(70));
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() ends");
    }

    @Override
    public IOperationReport runDeliver(IWorkspaceDeliverRunnable runnable, IWorkspaceConnection remoteConnection, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselineHandles, List<IChangeSetHandle> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        List sortedChangeSetHandles = this.checkAgainstReport((ChangeHistorySyncReport)syncReport, false, outgoingChangeSets);
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, (ChangeHistorySyncReport)syncReport, baselineHandles, sortedChangeSetHandles, true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " deliver() begins");
        try {
            ((WorkspaceConnection)remoteConnection).validate();
            this.validate();
            WorkspaceHandle remoteWorkspaceHandle = (WorkspaceHandle)remoteConnection.getResolvedWorkspace();
            IObjectsResponse response = runnable.deliver(this.getWorkspaceHandle(), (IWorkspaceHandle)remoteWorkspaceHandle, (IBaselineHandle[])baselineHandles.toArray(new BaselineHandle[baselineHandles.size()]), (IChangeSetHandle[])sortedChangeSetHandles.toArray(new ChangeSetHandle[sortedChangeSetHandles.size()]), this.monitorFor(monitor));
            WorkspaceDeliveryResult result = (WorkspaceDeliveryResult)response.getClientObjects()[0];
            monitor.worked(80);
            this.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            try {
                this.refresh(result.getRefreshResult());
                this.sendDeliverEvent("com.ibm.team.scm.ChangeHistoryEvent.Deliver", baselineHandles, sortedChangeSetHandles, (IFlowNodeHandle)remoteWorkspaceHandle);
            }
            finally {
                this.release();
            }
            ((WorkspaceConnection)remoteConnection).refresh(result.getTargetRefreshResult());
            IOperationReport iOperationReport = response.getOperationReport();
            return iOperationReport;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    private Set<UUID> checkForDuplicates(Collection changeSets) {
        HashSet<UUID> result = new HashSet<UUID>();
        for (Object element : changeSets) {
            if (element == null || !(element instanceof IChangeSetHandle)) {
                throw new IllegalArgumentException();
            }
            if (result.add(((IChangeSetHandle)element).getItemId())) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    private List checkAgainstReport(ChangeHistorySyncReport report, boolean incoming, List changeSets) throws TeamRepositoryException {
        Set<UUID> uniqueCsIds = this.checkForDuplicates(changeSets);
        HashSet<UUID> reportCsIds = new HashSet<UUID>();
        ArrayList<IChangeSetHandle> sortedCsHandles = new ArrayList<IChangeSetHandle>(changeSets.size());
        List reportList = incoming ? report.incomingChangeSets() : report.outgoingChangeSets();
        for (IChangeSetHandle csh : reportList) {
            reportCsIds.add(csh.getItemId());
            if (!uniqueCsIds.contains(csh.getItemId())) continue;
            sortedCsHandles.add(csh);
        }
        if (!reportCsIds.containsAll(uniqueCsIds)) {
            HashSet<UUID> notContainedIds = new HashSet<UUID>(uniqueCsIds);
            notContainedIds.removeAll(reportCsIds);
            String msg = incoming ? Messages.WorkspaceConnection_1 : Messages.WorkspaceConnection_2;
            if (!incoming) {
                throw new ChangeSetsNotOutgoingException((Object)this.teamRepository(), msg);
            }
            throw new TeamRepositoryException((Object)this.teamRepository(), msg);
        }
        return sortedCsHandles;
    }

    private void checkLocal(IChangeHistorySyncReport syncReport, IWorkspaceHandle localHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkspaceHandle reportLocalHandle = ((ChangeHistorySyncReport)syncReport).getLocal();
        if (reportLocalHandle == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_3);
        }
        if (!reportLocalHandle.sameItemId((IItemHandle)localHandle)) {
            IWorkspace reportWorkspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)reportLocalHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            IWorkspace workspace = (IWorkspace)this.teamRepository().itemManager().fetchCompleteItem((IItemHandle)localHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            String message = NLS.bind((String)Messages.WorkspaceConnection_4, (Object[])new Object[]{reportWorkspace.getName(), workspace.getName()});
            throw new SyncReportInappropriateException((Object)this.teamRepository(), message);
        }
    }

    private IWorkspaceHandle checkedGetRemote(IChangeHistorySyncReport syncReport) throws TeamRepositoryException {
        IWorkspaceHandle remote = ((ChangeHistorySyncReport)syncReport).getRemote();
        if (remote == null) {
            throw new SyncReportInappropriateException((Object)this.teamRepository(), Messages.WorkspaceConnection_5);
        }
        return remote;
    }

    @Override
    public IWorkspaceConnection.IConfigurationOpFactory configurationOpFactory() {
        return this.configurationOpFactory;
    }

    @Override
    public IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSet, configOps, null, monitor);
    }

    IUpdateReport commit(IChangeSetHandle activeChangeSet, Collection configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSet == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_6);
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, (Collection<IChangeSetHandle>)Collections.singletonList(activeChangeSet), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            HashSet itemIds = new HashSet();
            ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSet);
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, instruction);
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), new ICommitParameter[]{instruction}, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            monitor.worked(80);
            IUpdateReport report = result.getReport();
            this.acquire();
            try {
                this.sendCommitEvent(activeChangeSet);
                this.sendEvent(report);
                this.refresh(result.getRefreshResult(), false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(e);
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.commit(activeChangeSets, configOps, null, monitor);
    }

    IUpdateReport commit(List<IChangeSetHandle> activeChangeSets, List<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configOps, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (activeChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.size() != configOps.size()) {
            throw new IllegalArgumentException();
        }
        if (activeChangeSets.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_9);
        }
        if (ConfigUtil.getItemIds(activeChangeSets).size() != activeChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, activeChangeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() begins");
        try {
            this.validate();
            HashSet itemIds = new HashSet();
            CommitParameter[] instructions = new CommitParameter[configOps.size()];
            int i = 0;
            while (i < instructions.length) {
                ICommitParameter instruction = ICommitParameter.FACTORY.create(activeChangeSets.get(i));
                for (IWorkspaceConnection.IConfigurationOp iConfigurationOp : configOps.get(i)) {
                    this.processConfigOp(iConfigurationOp, itemIds, instruction);
                }
                instructions[i] = instruction;
                ++i;
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceUpdateReportResult result = service.batchCommit((IWorkspaceHandle)this.getResolvedWorkspace(), (ICommitParameter[])instructions, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            monitor.worked(80);
            IUpdateReport iUpdateReport = result.getReport();
            this.acquire();
            try {
                for (IChangeSetHandle ch : activeChangeSets) {
                    this.sendCommitEvent(ch);
                }
                this.sendEvent(iUpdateReport);
                this.refresh(result.getRefreshResult(), false);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspace.getItemId().getUuidValue() + " commit() ends");
            IUpdateReport iUpdateReport2 = iUpdateReport;
            return iUpdateReport2;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    private void processConfigOp(IWorkspaceConnection.IConfigurationOp element, Set itemIds, ICommitParameter instruction) throws TeamRepositoryException {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (element instanceof SaveOp) {
            SaveOp op = (SaveOp)element;
            IVersionable item = op.item;
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            if (!item.isWorkingCopy()) {
                throw new TeamRepositoryException((Throwable)new IllegalArgumentException());
            }
            IStatus status = IItemValidator.INSTANCE.validateConstraints((IItem)item);
            if (!status.isOK()) {
                PropertyConstraintException e = SCMItemUtil.buildConstraintException((IVersionable)item, (IStatus)status);
                throw e;
            }
            instruction.addItemToSave(op.item);
            return;
        }
        if (element instanceof RevertOp) {
            RevertOp op = (RevertOp)element;
            if (!itemIds.add(op.itemStateHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToRevert(op.itemStateHandle);
            return;
        }
        if (element instanceof DeleteOp) {
            DeleteOp op = (DeleteOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToDelete(op.itemHandle);
            return;
        }
        if (element instanceof DeleteSubtreeOp) {
            DeleteSubtreeOp op = (DeleteSubtreeOp)element;
            if (!itemIds.add(op.folderHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addFolderToDeleteSubtree(op.folderHandle);
            return;
        }
        if (element instanceof UndoOp) {
            UndoOp op = (UndoOp)element;
            if (!itemIds.add(op.itemHandle.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            instruction.addItemToUndo(op.itemHandle);
            return;
        }
        if (element instanceof MergeOp) {
            MergeOp op = (MergeOp)element;
            IWorkspaceConnection.IMergeResultOp innerOp = op.getInnerOp();
            if (itemIds.contains(innerOp.getItemHandle().getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            this.processConfigOp(innerOp, itemIds, instruction);
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(innerOp.getItemHandle().getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            instruction.addPredecessorInformation(info);
            return;
        }
        if (element instanceof MarkAsMergedOp) {
            MarkAsMergedOp op = (MarkAsMergedOp)element;
            if (!itemIds.add(op.item.getItemId())) {
                throw new IllegalArgumentException("Duplicate configuration operation");
            }
            PredecessorInfo info = ScmDtoFactory.eINSTANCE.createPredecessorInfo();
            info.setItemId(op.item.getItemId());
            info.setPredecessor(op.getSelectedState());
            info.setMergePredecessor(op.getProposedState());
            if (!info.isValid()) {
                throw new IllegalArgumentException("MarkAsMerge operation malformed.");
            }
            instruction.addPredecessorInformation(info);
            instruction.addItemToMarkAsMerged(op.item);
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public IUpdateReport suspend(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.suspend(changeSets, null, monitor);
    }

    IUpdateReport suspend(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            ChangeSetHandle[] array = changeSets.toArray(new ChangeSetHandle[changeSets.size()]);
            WorkspaceUpdateReportResult result = service.suspend(this.getWorkspaceHandle(), (IChangeSetHandle[])array, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            IUpdateReport report = result.getReport();
            monitor.worked(80);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), false);
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " suspend() ends");
            IUpdateReport iUpdateReport = report;
            return iUpdateReport;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public void removeSuspended(Collection changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.removeSuspended(changeSets, null, monitor);
    }

    void removeSuspended(Collection changeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, changeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        try {
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " removeSuspended() begins");
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            ChangeSetHandle[] array = changeSets.toArray(new ChangeSetHandle[changeSets.size()]);
            WorkspaceRefreshResult result = service.removeSuspended(this.getWorkspaceHandle(), (IChangeSetHandle[])array, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            this.refresh(result, false);
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " removeSuspended() ends");
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public void setCurrentChangeSet(IChangeSetHandle current, IProgressMonitor monitor) throws TeamRepositoryException {
        this.setCurrentChangeSet(current, null, monitor);
    }

    void setCurrentChangeSet(IChangeSetHandle current, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (current == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_12);
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, (Collection<IChangeSetHandle>)Collections.singleton(current), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() begins");
        try {
            this.validate();
            if (!this.isActive(current)) {
                throw new CompletedChangeSetException(Messages.WorkspaceConnection_13);
            }
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceRefreshResult result = service.setCurrentChangeSet(this.getWorkspaceHandle(), current, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() beforeRefresh");
            this.refresh(result, false);
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " setCurrentChangeSet() ends");
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public void unsetCurrentChangeSet(IComponentHandle component, IProgressMonitor monitor) throws TeamRepositoryException {
        this.unsetCurrentChangeSet(component, null, monitor);
    }

    void unsetCurrentChangeSet(IComponentHandle component, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_14);
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            WorkspaceRefreshResult result = service.unsetCurrentChangeSet(this.getWorkspaceHandle(), component, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(80);
            this.refresh(result, false);
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " unsetCurrentChangeSet() ends");
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(IChangeSetHandle changeSet) {
        Set ids = null;
        Object object = this.lock;
        synchronized (object) {
            ids = ConfigUtil.getItemIds(this.changeSetCache.getActiveChangeSets());
        }
        return ids.contains(changeSet.getItemId());
    }

    private void sendCurrentChangeSetEvent(IChangeSetHandle current, IChangeSetHandle oldCurrent, IComponentHandle component) {
        this.queue(new CurrentChangeSetEvent(this, current, oldCurrent, component));
    }

    private void sendCommitEvent(IChangeSetHandle changeSet) {
        this.queue(new CommitEvent(this, "com.ibm.team.scm.Commit", changeSet));
    }

    private void sendDeliverEvent(String type, List baselineHandles, List changeSetHandles, IFlowNodeHandle deliverTarget) {
        this.queue(new ChangeHistoryEvent(this, type, baselineHandles, changeSetHandles, null, deliverTarget));
    }

    public void committedWork(IChangeSetHandle changeSet, IUpdateReport updateReport, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) begins");
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            this.acquire();
            try {
                this.sendCommitEvent(changeSet);
                this.sendEvent(updateReport);
            }
            finally {
                this.release();
            }
            ContextLock lock = new ContextLock();
            HashSet<UUID> before = new HashSet<UUID>();
            IWorkspaceHandle ws = this.getWorkspaceHandle();
            for (IComponentStateSummary s : updateReport.getComponentStatesBefore()) {
                before.add(s.getComponent().getItemId());
                lock.addExclusive((IContextHandle)ws, s.getComponent());
            }
            for (IComponentStateSummary s : updateReport.getComponentStatesAfter()) {
                if (before.remove(s.getComponent().getItemId())) continue;
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
                break;
            }
            if (!before.isEmpty()) {
                lock.clear();
                lock.addExclusive((IContextHandle)ws);
            }
            before = null;
            lock.acquire();
            try {
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                this.refresh(r);
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset,ur,monitor) ends");
        }
        finally {
            monitor.done();
        }
    }

    public void committedWork(List changeSets, IUpdateReport[] reports, IProgressMonitor monitor) throws TeamRepositoryException {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) begins");
        monitor = SCMClientUtil.getMonitor(monitor);
        try {
            ContextLock lock = new ContextLock();
            this.acquire();
            try {
                int i = 0;
                while (i < reports.length) {
                    HashSet<UUID> before = new HashSet<UUID>();
                    IWorkspaceHandle ws = this.getWorkspaceHandle();
                    for (IComponentStateSummary s : reports[i].getComponentStatesBefore()) {
                        before.add(s.getComponent().getItemId());
                        lock.addExclusive((IContextHandle)ws, s.getComponent());
                    }
                    for (IComponentStateSummary s : reports[i].getComponentStatesAfter()) {
                        if (before.remove(s.getComponent().getItemId())) continue;
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                        break;
                    }
                    if (!before.isEmpty()) {
                        lock.clear();
                        lock.addExclusive((IContextHandle)ws);
                    }
                    this.sendEvent(reports[i]);
                    ++i;
                }
                i = 0;
                while (i < changeSets.size()) {
                    this.sendCommitEvent((IChangeSetHandle)changeSets.get(i));
                    ++i;
                }
            }
            finally {
                this.release();
            }
            lock.acquire();
            try {
                WorkspaceRefreshResult r = this.refreshInternal((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                this.refresh(r);
            }
            finally {
                lock.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " committedWork(cset[],ur[],monitor) ends");
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IChangeSetHandle getCurrentChangeSet(IComponentHandle componentHandle) {
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) begins");
        if (componentHandle == null) {
            throw new IllegalArgumentException("component cannot be null");
        }
        IChangeSetHandle changeSet = null;
        Object object = this.lock;
        synchronized (object) {
            changeSet = this.changeSetCache.getCurrentChangeSet(componentHandle);
        }
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " getCurrentChangeSet(Comp) ends");
        return changeSet;
    }

    @Override
    public List retrieveComponentStateSummaries(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            monitor.worked(10);
            IComponentStateSummary[] summaries = service.getWorkspaceComponentStateSummaries(this.getWorkspaceHandle(), this.monitorFor(monitor));
            monitor.worked(80);
            ArrayList<IComponentStateSummary> result = new ArrayList<IComponentStateSummary>(summaries.length);
            int i = 0;
            while (i < summaries.length) {
                IComponentStateSummary summary = summaries[i];
                result.add(summary);
                ++i;
            }
            SCMClientUtil.checkMonitor(monitor);
            ArrayList<IComponentStateSummary> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.relocateChanges(targetChangeSets, itemsToMove, sourceChangeSets, null, monitor);
    }

    void relocateChanges(List<? extends IChangeSetHandle> targetChangeSets, List<? extends IVersionableHandle> itemsToMove, List<? extends IChangeSetHandle> sourceChangeSets, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (targetChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (itemsToMove == null) {
            throw new IllegalArgumentException();
        }
        if (sourceChangeSets == null) {
            throw new IllegalArgumentException();
        }
        if (targetChangeSets.size() != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        int size = itemsToMove.size();
        if (size != sourceChangeSets.size()) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> itemIds = new HashSet<UUID>();
        int i = 0;
        while (i < size) {
            IChangeSetHandle source = sourceChangeSets.get(i);
            IChangeSetHandle target = targetChangeSets.get(i);
            IVersionableHandle item = itemsToMove.get(i);
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!itemIds.add(item.getItemId())) {
                throw new IllegalArgumentException();
            }
            if (source == null) {
                throw new IllegalArgumentException();
            }
            if (target == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        this.addToLock(lock, sourceChangeSets, targetChangeSets, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            WorkspaceItemListResult result = service.relocateChanges(this.getWorkspaceHandle(), targetChangeSets.toArray(new IChangeSetHandle[size]), itemsToMove.toArray(new IVersionableHandle[size]), sourceChangeSets.toArray(new IChangeSetHandle[size]), IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            this.acquire();
            try {
                HashSet<UUID> sendAlready = new HashSet<UUID>();
                for (IChangeSetHandle iChangeSetHandle : targetChangeSets) {
                    if (sendAlready.contains(iChangeSetHandle.getItemId())) continue;
                    this.sendCommitEvent(iChangeSetHandle);
                    sendAlready.add(iChangeSetHandle.getItemId());
                }
                WorkspaceRefreshResult workspaceRefreshResult = result.getRefreshResult();
                this.refresh(workspaceRefreshResult, false);
                this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                result.unsetItems();
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " relocateChanges ends");
            }
            finally {
                this.release();
            }
        }
        finally {
            lock.release();
        }
    }

    @Override
    public IContextHandle getContextHandle() {
        return this.getWorkspaceHandle();
    }

    private IRepositoryProgressMonitor monitorFor(IProgressMonitor monitor) {
        return IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
    }

    @Override
    public Object getAdapter(Class clazz) {
        if (clazz == IWorkspaceConnectionInteropAdapter.class) {
            return new IWorkspaceConnectionInteropAdapter(){

                public IImportChangeSetResult importChangeSet(IComponentHandle componentHandle, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.importChangeSet(componentHandle, comment, configOps, creationTime, contributor, monitor);
                }

                public IBaseline createPostImportBaseline(IComponentHandle componentHandle, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
                    return WorkspaceConnection.this.createPostImportBaseline(componentHandle, name, comment, null, monitor);
                }
            };
        }
        return null;
    }

    IBaseline createPostImportBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline begins");
        try {
            IBaseline iBaseline;
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            monitor.worked(10);
            WorkspaceItemListResult serviceResult = service.createPostImportBaseline(this.getWorkspaceHandle(), component, name, comment, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(90);
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), false);
                IBaseline baseline = (IBaseline)serviceResult.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(serviceResult.getItems());
                serviceResult.unsetItems();
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createPostImportBaseline ends");
                iBaseline = baseline;
            }
            catch (Throwable throwable) {
                this.release();
                throw throwable;
            }
            this.release();
            return iBaseline;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    IImportChangeSetResult importChangeSet(IComponentHandle component, String comment, Collection configOps, long creationTime, IContributorHandle contributor, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(component instanceof ComponentHandle)) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            throw new IllegalArgumentException();
        }
        if (configOps == null) {
            throw new IllegalArgumentException();
        }
        if (this.getResolvedWorkspace().isStream()) {
            throw new InvalidStreamOperationException(Messages.WorkspaceConnection_18);
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.getWorkspaceHandle(), component);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet begins");
        try {
            this.validate();
            IScmImportService service = this.workspaceManager.getScmImportService();
            monitor.worked(10);
            HashSet itemIds = new HashSet();
            ICommitParameter instruction = ICommitParameter.FACTORY.create();
            for (IWorkspaceConnection.IConfigurationOp element : configOps) {
                this.processConfigOp(element, itemIds, instruction);
            }
            WorkspaceImportResult serviceResult = service.importChangeSet(this.getWorkspaceHandle(), component, comment, instruction, creationTime, contributor, IScmService.DELTA_PER_INVOCATION, this.monitorFor(monitor));
            monitor.worked(80);
            IChangeSet changeSet = (IChangeSet)serviceResult.getItem();
            IUpdateReport report = serviceResult.getReport();
            serviceResult.unsetItem();
            this.acquire();
            try {
                this.refresh(serviceResult.getRefreshResult(), false);
                this.sendEvent(report);
            }
            finally {
                this.release();
            }
            WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " importChangeSet ends");
            ImportChangeSetResult importChangeSetResult = new ImportChangeSetResult(changeSet, report);
            return importChangeSetResult;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createBaseline(component, name, comment, null, monitor);
    }

    IBaselineConnection createBaseline(IComponentHandle component, String name, String comment, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        if (name == null) {
            name = "";
        }
        if (comment == null) {
            comment = "";
        }
        if (component == null) {
            throw new IllegalArgumentException("component must not be null");
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle, component);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline begins");
        try {
            IBaselineConnection iBaselineConnection;
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            WorkspaceItemListResult result = service.createBaseline(handle, component, name, comment, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(50);
            this.acquire();
            try {
                this.refresh(result.getRefreshResult(), false);
                IBaseline baseline = (IBaseline)result.getItems().get(0);
                this.teamRepository().itemManager().applyItemUpdates(result.getItems());
                result.unsetItems();
                IBaselineConnection b = this.workspaceManager.getBaselineConnection(baseline, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaseline ends");
                iBaselineConnection = b;
            }
            catch (Throwable throwable) {
                this.release();
                throw throwable;
            }
            this.release();
            return iBaselineConnection;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, boolean createNewBaselines, IProgressMonitor monitor) throws TeamRepositoryException {
        ISynchronizationInfo syncInfo = ISynchronizationInfo.FACTORY.newInstance();
        if (this.isStream()) {
            ArrayList<UUID> excludedComUUIDs = new ArrayList<UUID>();
            for (IComponentHandle exludedComponentHandle : excludedComponents) {
                excludedComUUIDs.add(exludedComponentHandle.getItemId());
            }
            for (IComponentHandle component : this.getComponents()) {
                if (excludedComUUIDs.contains(component.getItemId())) continue;
                ICurrentComponentInfo componentInfo = this.getComponentInfo(component);
                syncInfo.addChangeHistoryTime((IWorkspaceHandle)this.workspace, component, componentInfo.changeHistoryTime());
                syncInfo.addConfigurationTime((IWorkspaceHandle)this.workspace, component, componentInfo.configurationTime());
            }
        } else {
            syncInfo = null;
        }
        return this.createBaselineSet(excludedComponents, name, comment, createNewBaselines, syncInfo, monitor);
    }

    IBaselineSetHandle createBaselineSet(Collection excludedComponents, String name, String comment, boolean createNewBaselines, ISynchronizationInfo syncInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ComponentHandle[] excludedComponentsArray = null;
        if (excludedComponents != null && excludedComponents.size() > 0) {
            for (Object element : excludedComponents) {
                if (element == null || !(element instanceof IComponentHandle)) {
                    throw new IllegalArgumentException();
                }
                this.checkKnownComponent((IComponentHandle)element, monitor);
            }
            excludedComponentsArray = excludedComponents.toArray(new ComponentHandle[excludedComponents.size()]);
        }
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (comment == null) {
            comment = "";
        }
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        ContextLock lock = new ContextLock();
        lock.addExclusive((IContextHandle)this.workspaceHandle);
        lock.acquire();
        WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet begins");
        try {
            this.validate();
            IScmService service = this.workspaceManager.getServerConfigurationService();
            IWorkspaceHandle handle = this.workspaceHandle;
            monitor.worked(5);
            WorkspaceItemListResult result = service.createBaselineSet(handle, (IComponentHandle[])excludedComponentsArray, name, comment, createNewBaselines, IScmService.DELTA_PER_INVOCATION, WorkspaceConnection.getSyncTimes(syncInfo), this.monitorFor(monitor));
            monitor.worked(90);
            IBaselineSet b = (IBaselineSet)result.getItems().get(0);
            this.teamRepository().itemManager().applyItemUpdates(result.getItems());
            result.unsetItems();
            this.acquire();
            try {
                this.sendPropertyChangeEvent("com.ibm.team.repository.PropertyAdd", "baseline sets", null, b);
                this.refresh(result.getRefreshResult(), false);
                WorkspaceConnection.log("Workspace " + this.workspaceHandle.getItemId().getUuidValue() + " createBaselineSet ends");
            }
            finally {
                this.release();
            }
            IBaselineSet iBaselineSet = b;
            return iBaselineSet;
        }
        finally {
            lock.release();
            monitor.done();
        }
    }

    @Override
    public IUpdateReport conflictReport() {
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        Collection<? extends ICurrentComponentInfo> infos = this.getComponentsInfo();
        for (ClientCurrentComponentInfo clientCurrentComponentInfo : infos) {
            Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = clientCurrentComponentInfo.getConflicts();
            for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
                ItemConflictReport icr = conflict.toItemConflictReport();
                result.getConflicts().add(icr);
            }
        }
        return result;
    }

    @Override
    public IUpdateReport conflictReport(IComponentHandle component) throws TeamRepositoryException {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this.checkKnownComponent(component, null);
        UpdateReport result = ScmDtoFactory.eINSTANCE.createUpdateReport();
        result.setStateAfter(this.workspace.getTime());
        result.setStateBefore(this.workspace.getTime());
        ClientCurrentComponentInfo info = (ClientCurrentComponentInfo)this.getComponentInfo(component);
        Map<UUID, ClientCurrentComponentInfo.ConflictInfo> conflicts = info.getConflicts();
        for (ClientCurrentComponentInfo.ConflictInfo conflict : conflicts.values()) {
            ItemConflictReport icr = conflict.toItemConflictReport();
            result.getConflicts().add(icr);
        }
        return result;
    }

    @Override
    public void runDeliverWithPrecondition(IWorkspaceOperationRunner.IWorkspaceOperationRunnable preConditionCheck, IChangeHistorySyncReport syncReport, List<IBaselineHandle> baselines, List<IChangeSetHandle> outgoingChangeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        this.deliver(syncReport, baselines, outgoingChangeSets, null, preConditionCheck, monitor);
    }

    @Override
    public IWorkspaceConfiguration configuration() {
        return this.workspaceConfiguration;
    }

    static class ConfigurationOpFactory
    implements IWorkspaceConnection.IConfigurationOpFactory {
        ConfigurationOpFactory() {
        }

        public IWorkspaceConnection.ISaveOp save(IVersionable item) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            if (!item.isWorkingCopy()) {
                throw new IllegalArgumentException();
            }
            return new SaveOp(item, null, null);
        }

        public IWorkspaceConnection.IDeleteOp delete(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteOp(itemHandle);
        }

        public IWorkspaceConnection.IRevertOp revert(IVersionableHandle itemStateHandle) {
            if (itemStateHandle == null || !itemStateHandle.hasStateId()) {
                throw new IllegalArgumentException();
            }
            return new RevertOp(itemStateHandle);
        }

        public IWorkspaceConnection.IDeleteSubtreeOp deleteSubtree(IFolderHandle folderHandle) {
            if (folderHandle == null) {
                throw new IllegalArgumentException();
            }
            return new DeleteSubtreeOp(folderHandle);
        }

        public IWorkspaceConnection.IUndoOp undo(IVersionableHandle itemHandle) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            return new UndoOp(itemHandle);
        }

        public IWorkspaceConnection.IMarkAsMergedOp markAsMerged(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (item == null) {
                throw new IllegalArgumentException();
            }
            return new MarkAsMergedOp(item, predecessor, mergePredecessor);
        }

        public IWorkspaceConnection.IMergeOp merge(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            if (nestedOp == null) {
                throw new IllegalArgumentException();
            }
            return new MergeOp(nestedOp, predecessor, mergePredecessor);
        }
    }

    private static class DeleteOp
    implements IWorkspaceConnection.IDeleteOp {
        final IVersionableHandle itemHandle;

        DeleteOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    private static class DeleteSubtreeOp
    implements IWorkspaceConnection.IDeleteSubtreeOp {
        final IFolderHandle folderHandle;

        DeleteSubtreeOp(IFolderHandle folderHandle) {
            this.folderHandle = folderHandle;
        }

        public IFolderHandle getFolderHandle() {
            return this.folderHandle;
        }
    }

    private static class MarkAsMergedOp
    implements IWorkspaceConnection.IMarkAsMergedOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IVersionableHandle item;

        public MarkAsMergedOp(IVersionableHandle item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IVersionableHandle getItemHandle() {
            return this.item;
        }

        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class MergeOp
    implements IWorkspaceConnection.IMergeOp {
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;
        final IWorkspaceConnection.IMergeResultOp nestedOp;

        public MergeOp(IWorkspaceConnection.IMergeResultOp nestedOp, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.nestedOp = nestedOp;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IWorkspaceConnection.IMergeResultOp getInnerOp() {
            return this.nestedOp;
        }

        public IVersionableHandle getProposedState() {
            return this.mergePred;
        }

        public IVersionableHandle getSelectedState() {
            return this.pred;
        }
    }

    private static class RevertOp
    implements IWorkspaceConnection.IRevertOp {
        final IVersionableHandle itemStateHandle;

        RevertOp(IVersionableHandle itemStateHandle) {
            this.itemStateHandle = itemStateHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemStateHandle;
        }
    }

    private static class SaveOp
    implements IWorkspaceConnection.ISaveOp {
        final IVersionable item;
        final IVersionableHandle pred;
        final IVersionableHandle mergePred;

        SaveOp(IVersionable item, IVersionableHandle predecessor, IVersionableHandle mergePredecessor) {
            this.item = item;
            this.pred = predecessor;
            this.mergePred = mergePredecessor;
        }

        public IVersionable getItem() {
            return this.item;
        }

        public IVersionableHandle getMergePredecessor() {
            return this.mergePred;
        }

        public IVersionableHandle getPredecessor() {
            return this.pred;
        }

        public IVersionableHandle getItemHandle() {
            return this.item;
        }
    }

    private static class UndoOp
    implements IWorkspaceConnection.IUndoOp {
        final IVersionableHandle itemHandle;

        UndoOp(IVersionableHandle itemHandle) {
            this.itemHandle = itemHandle;
        }

        public IVersionableHandle getItemHandle() {
            return this.itemHandle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WorkspaceConfigurationProxy
    implements IWorkspaceConfiguration {
        @Override
        public List<IComponentizedAncestorList> fetchAncestorsByName(String exactVersionableName, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (exactVersionableName == null || exactVersionableName.equals("")) {
                    throw new IllegalArgumentException();
                }
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                IComponentizedAncestorList[] reports = service.workspaceFindVersionablesByName(WorkspaceConnection.this.workspaceHandle, exactVersionableName, Connection.getSyncTimes(null), WorkspaceConnection.this.monitorFor(monitor));
                List<IComponentizedAncestorList> list = Arrays.asList(reports);
                return list;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<UUID, ? extends IVersionable>> fetchCompleteItems(List<? extends IComponentHandle> components, List<List<? extends IVersionableHandle>> versionableItemsByComponent, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                if (components == null) {
                    throw new IllegalArgumentException();
                }
                HashSet<UUID> componentIds = new HashSet<UUID>();
                HashMap<UUID, ServiceConfigurationProvider> configProviders = new HashMap<UUID, ServiceConfigurationProvider>((int)((double)components.size() * 0.75));
                for (IComponentHandle iComponentHandle : components) {
                    if (iComponentHandle == null) {
                        throw new IllegalArgumentException();
                    }
                    if (!componentIds.add(iComponentHandle.getItemId())) {
                        throw new IllegalArgumentException();
                    }
                    WorkspaceConnection.this.checkKnownComponent(iComponentHandle, monitor);
                    configProviders.put(iComponentHandle.getItemId(), ServiceConfigurationProvider.FACTORY.create(WorkspaceConnection.this.workspaceHandle, iComponentHandle));
                }
                if (versionableItemsByComponent == null) {
                    throw new IllegalArgumentException();
                }
                if (versionableItemsByComponent.size() != components.size()) {
                    throw new IllegalArgumentException();
                }
                boolean bl = false;
                int i = 0;
                ArrayList batches = new ArrayList();
                HashMap<UUID, ComponentizedFetchParameter> current = new HashMap<UUID, ComponentizedFetchParameter>();
                for (List<? extends IVersionableHandle> items : versionableItemsByComponent) {
                    ComponentizedFetchParameter param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                    IComponentHandle ch = components.get(i++);
                    current.put(ch.getItemId(), param);
                    if (items == null) {
                        throw new IllegalArgumentException();
                    }
                    for (IVersionableHandle iVersionableHandle : items) {
                        int n;
                        if (iVersionableHandle == null) {
                            throw new IllegalArgumentException();
                        }
                        if (n < 2048) {
                            param.getHandles().add(iVersionableHandle);
                            n += 1;
                            continue;
                        }
                        batches.add(current);
                        current = new HashMap();
                        param = ScmDtoFactory.eINSTANCE.createComponentizedFetchParameter();
                        n = 1;
                        current.put(ch.getItemId(), param);
                        param.getHandles().add(iVersionableHandle);
                    }
                }
                batches.add(current);
                SCMClientUtil.checkMonitor(monitor);
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                monitor.worked(20);
                HashMap<UUID, Map<UUID, ? extends IVersionable>> result = new HashMap<UUID, Map<UUID, ? extends IVersionable>>();
                for (UUID compId : componentIds) {
                    result.put(compId, new HashMap());
                }
                VersionableManager vman = (VersionableManager)WorkspaceConnection.this.workspaceManager().versionableManager();
                int ticks = 75 / batches.size();
                for (Map map : batches) {
                    int size = map.size();
                    ServiceConfigurationProvider[] cfgs = new ServiceConfigurationProvider[size];
                    ComponentizedFetchParameter[] parm = new ComponentizedFetchParameter[size];
                    UUID[] compId = new UUID[size];
                    int j = 0;
                    for (UUID componentId : map.keySet()) {
                        cfgs[j] = (ServiceConfigurationProvider)configProviders.get(componentId);
                        compId[j] = componentId;
                        parm[j++] = (ComponentizedFetchParameter)map.get(componentId);
                    }
                    ComponentizedFetchResult[] fromServer = service.configurationBatchFetch(cfgs, parm, null, null, WorkspaceConnection.this.monitorFor(monitor));
                    SCMClientUtil.checkMonitor(monitor);
                    monitor.worked(ticks);
                    j = 0;
                    while (j < size) {
                        UUID componentId = compId[j];
                        Map perComponent = (Map)result.get(componentId);
                        ComponentizedFetchResult r = fromServer[j];
                        i = 0;
                        while (i < r.getItemIds().size()) {
                            Object v = (IVersionable)r.getStates().get(i);
                            v = v.getStateId().equals((Object)ItemUtil.DELETED_UUID) ? null : (IVersionable)vman.applyItemStates(Collections.singletonList(v)).get(0);
                            UUID itemId = (UUID)r.getItemIds().get(i);
                            perComponent.put(itemId, v);
                            ++i;
                        }
                        ++j;
                    }
                }
                HashMap<UUID, Map<UUID, ? extends IVersionable>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }

        @Override
        public Map<UUID, Map<String, IVersionableHandle>> childEntriesForRoots(IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                WorkspaceConnection.this.validate();
                IScmService service = WorkspaceConnection.this.workspaceManager().getServerConfigurationService();
                SCMClientUtil.checkMonitor(monitor);
                ComponentizedFolderEntryReport[] fromServer = service.configurationBatchChildEntriesForRoot(WorkspaceConnection.this.workspaceHandle, Connection.getSyncTimes(null), WorkspaceConnection.this.monitorFor(monitor));
                HashMap<UUID, Map<String, IVersionableHandle>> result = new HashMap<UUID, Map<String, IVersionableHandle>>((int)((double)fromServer.length * 0.75));
                ComponentizedFolderEntryReport[] componentizedFolderEntryReportArray = fromServer;
                int n = fromServer.length;
                int n2 = 0;
                while (n2 < n) {
                    ComponentizedFolderEntryReport report = componentizedFolderEntryReportArray[n2];
                    result.put(report.getComponent().getItemId(), report.getReport().getEntries());
                    ++n2;
                }
                HashMap<UUID, Map<String, IVersionableHandle>> hashMap = result;
                return hashMap;
            }
            finally {
                monitor.done();
            }
        }
    }
}

