/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.providers.LinkProvider;
import org.eclipse.core.runtime.IProgressMonitor;

public class RepositoryLinkProvider
implements LinkProvider {
    private ILinkManager linkService;

    public RepositoryLinkProvider(ITeamRepository repo) {
        this.linkService = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
    }

    public ILinkQueryPage findLinksBySource(IReference source, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.linkService.findLinksBySource(source, monitor);
    }

    public IReferenceFactory referenceFactory() {
        return this.linkService.referenceFactory();
    }

    public ILinkQueryPage findLinks(String linkTypeId, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.linkService.findLinks(new String[]{linkTypeId}, monitor);
    }

    public ILink createLink(String linkTypeId, IReference source, IReference target) throws TeamRepositoryException {
        return this.linkService.createLink(linkTypeId, source, target);
    }

    public void saveLink(ILink link, IProgressMonitor monitor) throws TeamRepositoryException {
        this.linkService.saveLink(link, monitor);
    }
}

