/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui.teamnavigator;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.process.common.TeamAreaHierarchyException;
import com.ibm.team.process.internal.rcp.ui.ConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryListener;
import com.ibm.team.process.rcp.ui.teamnavigator.Messages;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ConnectedProjectAreaRegistry
implements IConnectedProjectAreaRegistry {
    public static final String CONNECTED_PROJECT_AREAS_MEMENTO = "connectedProjectAreasMemento";
    private static final String CONNECTED_PROJECT_AREAS = "connectedProjectAreas";
    private static final String CONNECTED_PROJECT_AREA = "connectedProjectArea";
    private static final String SELECTED_TEAM_AREA = "selectedTeamArea";
    private static final String TEAM_AREA = "teamArea";
    private static final String KEY_REPOSITORY_URI = "repositoryURI";
    private static final String KEY_AREA_UUID = "projectAreaUUID";
    private static final String KEY_PROJECT_AREA_NAME = "projectAreaName";
    private static final IProjectAreaHandle[] EMPTY = new IProjectAreaHandle[0];
    private static final int NOT_ARCHIVED_PROJECT_AREAS = 0;
    private static final int ARCHIVED_PROJECT_AREAS = 1;
    private static final int ALL_PROJECT_AREAS = 2;
    private IListener fStateListener = new IListener(){

        public void handleEvents(List events) {
            for (IEvent event : events) {
                ITeamRepository repository;
                if (!(event instanceof com.ibm.team.repository.client.util.PropertyChangeEvent)) continue;
                com.ibm.team.repository.client.util.PropertyChangeEvent propertyChangeEvent = (com.ibm.team.repository.client.util.PropertyChangeEvent)event;
                if (!(event.getEventSource() instanceof ITeamRepository)) continue;
                int state = (Integer)propertyChangeEvent.getNewValue();
                if (propertyChangeEvent.getProperty() == "state") {
                    if (state == 0 || state == 2) continue;
                    ITeamRepository repository2 = (ITeamRepository)event.getEventSource();
                    if (repository2.loggedIn() && repository2.getErrorState() == 0) {
                        ConnectedProjectAreaRegistry.this.restoreStateForRepository(repository2);
                        continue;
                    }
                    ConnectedProjectAreaRegistry.this.notifyListeners(repository2, null);
                    continue;
                }
                if (propertyChangeEvent.getProperty() != "error_state") continue;
                int oldState = (Integer)propertyChangeEvent.getOldValue();
                if (oldState != 0 && state == 0) {
                    repository = (ITeamRepository)event.getEventSource();
                    if (!repository.loggedIn()) continue;
                    ConnectedProjectAreaRegistry.this.restoreStateForRepository(repository);
                    continue;
                }
                if (oldState != 0 || state == 0 || !(repository = (ITeamRepository)event.getEventSource()).loggedIn()) continue;
                ConnectedProjectAreaRegistry.this.notifyListeners(repository, null);
            }
        }
    };
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryListener = new ITeamRepositoryService.IRepositoryServiceListener(){

        public void addedRepository(ITeamRepository repository) {
            repository.addGenericListener((Object)"state", ConnectedProjectAreaRegistry.this.fStateListener);
            repository.addGenericListener((Object)"error_state", ConnectedProjectAreaRegistry.this.fStateListener);
            repository.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, ConnectedProjectAreaRegistry.this.fItemChangeListener);
            repository.itemManager().addItemChangeListener(ITeamArea.ITEM_TYPE, ConnectedProjectAreaRegistry.this.fItemChangeListener);
            ConnectedProjectAreaRegistry.this.notifyListeners(repository, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedRepository(ITeamRepository repository) {
            repository.removeGenericListener((Object)"state", ConnectedProjectAreaRegistry.this.fStateListener);
            repository.removeGenericListener((Object)"error_state", ConnectedProjectAreaRegistry.this.fStateListener);
            repository.itemManager().removeItemChangeListener(IProjectArea.ITEM_TYPE, ConnectedProjectAreaRegistry.this.fItemChangeListener);
            repository.itemManager().removeItemChangeListener(ITeamArea.ITEM_TYPE, ConnectedProjectAreaRegistry.this.fItemChangeListener);
            ConnectedProjectAreaRegistry connectedProjectAreaRegistry = ConnectedProjectAreaRegistry.this;
            synchronized (connectedProjectAreaRegistry) {
                if (ConnectedProjectAreaRegistry.this.fRepositoriesToProjectAreas.remove(repository.getRepositoryURI()) != null) {
                    ConnectedProjectAreaRegistry.this.notifyListeners(repository, null);
                }
            }
        }
    };
    private IPropertyChangeListener fPropertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("teamArtifactsNavigator.showArchived".equals(event.getProperty())) {
                List connected = ConnectedProjectAreaRegistry.this.getConnectedProjectAreas(null, 2);
                for (IProjectAreaHandle handle : connected) {
                    ConnectedProjectAreaRegistry.this.notifyListenersForHierarchyChange(handle, Collections.singletonList(handle));
                }
                boolean archiveIncluded = ProcessRCPUIPlugin.getDefault().getPreferenceStore().getBoolean("teamArtifactsNavigator.showArchived");
                List archived = ConnectedProjectAreaRegistry.this.getConnectedProjectAreas(null, 1);
                for (IProjectAreaHandle handle : archived) {
                    ConnectedProjectAreaRegistry.this.notifyListenersForArchiveStateChange(handle, archiveIncluded);
                }
            }
        }
    };
    private ISharedItemChangeListener fItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            ArrayList<IProjectArea> projectAreasToRemove = new ArrayList<IProjectArea>();
            for (ISharedItemChangeEvent event : events) {
                if (event.getSharedItem() instanceof IProjectArea) {
                    IProjectArea beforeState = (IProjectArea)event.getBeforeState();
                    IProjectArea afterState = (IProjectArea)event.getAfterState();
                    if (beforeState == null || !ProcessCommon.requiredPropertiesSet((IProcessItem)beforeState, (int)0)) continue;
                    if (afterState == null) {
                        projectAreasToRemove.add(beforeState);
                        continue;
                    }
                    if (!ProcessCommon.requiredPropertiesSet((IProcessItem)afterState, (int)0)) continue;
                    boolean nameChange = !beforeState.getName().equals(afterState.getName());
                    boolean initializedChange = beforeState.isInitialized() ^ afterState.isInitialized();
                    if (nameChange || initializedChange || beforeState.isArchived() != afterState.isArchived()) {
                        if (nameChange) {
                            ConnectedProjectAreaRegistry.this.updateProjectAreaName(afterState);
                            ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
                            changeEvent.setProjectArea((IProjectAreaHandle)afterState);
                            changeEvent.setResortRequired(true);
                            ConnectedProjectAreaRegistry.this.notifyListeners(changeEvent);
                            continue;
                        }
                        if (!initializedChange) continue;
                        String uniqueKey = ConnectedProjectAreaRegistry.this.getUniqueKey(afterState);
                        ArrayList teamAreas = new ArrayList(afterState.getTeamAreas());
                        ConnectedProjectAreaRegistry.this.fProjectAreasToTeamAreas.put(uniqueKey, teamAreas);
                        ConnectedProjectAreaRegistry.this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, teamAreas);
                        ConnectedProjectAreaRegistry.this.notifyListeners((IProjectAreaHandle)afterState);
                        continue;
                    }
                    List hierarchyChanges = this.determineTeamAreaHierarchyChanges(beforeState, afterState);
                    if (hierarchyChanges == null) continue;
                    ConnectedProjectAreaRegistry.this.notifyListenersForHierarchyChange((IProjectAreaHandle)afterState, hierarchyChanges);
                    continue;
                }
                if (!(event.getSharedItem() instanceof ITeamArea) || !ProcessCommon.requiredPropertiesSet((IProcessItem)((ITeamArea)event.getSharedItem()), (int)0)) continue;
                this.teamAreaChanged(event);
            }
            ConnectedProjectAreaRegistry.this.removeConnectedProjectAreas(projectAreasToRemove);
        }

        private void teamAreaChanged(ISharedItemChangeEvent event) {
            ITeamArea afterState = (ITeamArea)event.getAfterState();
            ITeamArea beforeState = (ITeamArea)event.getBeforeState();
            if (afterState == null) {
                IProjectAreaHandle projectArea = beforeState.getProjectArea();
                if (!ConnectedProjectAreaRegistry.this.isConnectedProjectArea(projectArea)) {
                    return;
                }
                ConnectedProjectAreaRegistry.this.removeTeamArea(projectArea, (ITeamAreaHandle)beforeState, true);
            } else if (beforeState == null) {
                IProjectAreaHandle projectArea = afterState.getProjectArea();
                if (!ConnectedProjectAreaRegistry.this.isConnectedProjectArea(projectArea)) {
                    return;
                }
                String uniqueKey = ConnectedProjectAreaRegistry.this.getUniqueKey(projectArea);
                ArrayList<ITeamArea> knownTeamAreas = (ArrayList<ITeamArea>)ConnectedProjectAreaRegistry.this.fProjectAreasToTeamAreas.get(uniqueKey);
                if (knownTeamAreas != null) {
                    for (ITeamAreaHandle iTeamAreaHandle : knownTeamAreas) {
                        if (!iTeamAreaHandle.sameItemId((IItemHandle)afterState)) continue;
                        return;
                    }
                } else {
                    knownTeamAreas = new ArrayList<ITeamArea>();
                    ConnectedProjectAreaRegistry.this.fProjectAreasToTeamAreas.put(uniqueKey, knownTeamAreas);
                }
                knownTeamAreas.add(afterState);
                ConnectedProjectAreaRegistry.this.addSelectedTeamArea(afterState.getProjectArea(), afterState, true);
            } else if (beforeState.isArchived() != afterState.isArchived()) {
                IProjectAreaHandle handle = afterState.getProjectArea();
                IItemManager manager = ((ITeamRepository)handle.getOrigin()).itemManager();
                IProjectArea projectArea = (IProjectArea)manager.getSharedItemIfKnown((IItemHandle)handle);
                if (projectArea != null && projectArea.isArchived()) {
                    return;
                }
                ConnectedProjectAreaRegistry.this.notifyListeners(handle);
            }
        }

        private List determineTeamAreaHierarchyChanges(IProjectArea before, IProjectArea after) {
            try {
                ITeamAreaHierarchy beforeHierarchy = before.getTeamAreaHierarchy();
                ITeamAreaHierarchy hierarchy = after.getTeamAreaHierarchy();
                Set beforeRoots = beforeHierarchy.getRoots();
                Set afterRoots = hierarchy.getRoots();
                if (beforeRoots.size() != afterRoots.size()) {
                    return Collections.singletonList(after);
                }
                for (ITeamAreaHandle teamAreaHandle : afterRoots) {
                    ITeamAreaHandle parent = hierarchy.getParent(teamAreaHandle);
                    ITeamAreaHandle beforeParent = beforeHierarchy.getParent(teamAreaHandle);
                    if ((parent != null || beforeParent == null) && (parent == null || beforeParent != null)) continue;
                    return Collections.singletonList(after);
                }
                ArrayList toRefresh = new ArrayList();
                this.determineTeamAreaHierarchyChanges(beforeHierarchy, hierarchy, afterRoots, toRefresh);
                if (toRefresh.isEmpty()) {
                    toRefresh = null;
                }
                return toRefresh;
            }
            catch (TeamAreaHierarchyException teamAreaHierarchyException) {
                return null;
            }
        }

        private void determineTeamAreaHierarchyChanges(ITeamAreaHierarchy beforeHierarchy, ITeamAreaHierarchy hierarchy, Set teamAreaHandles, List toRefresh) {
            for (ITeamAreaHandle teamAreaHandle : teamAreaHandles) {
                try {
                    ITeamAreaHandle parent = hierarchy.getParent(teamAreaHandle);
                    ITeamAreaHandle beforeParent = beforeHierarchy.getParent(teamAreaHandle);
                    if (parent != null && beforeParent != null && !parent.sameItemId((IItemHandle)beforeParent)) {
                        toRefresh.add(parent);
                        toRefresh.add(beforeParent);
                    }
                    Set children = hierarchy.getChildren(teamAreaHandle);
                    Set beforeChildren = beforeHierarchy.getChildren(teamAreaHandle);
                    if (children.size() != beforeChildren.size() && beforeHierarchy.getParent(teamAreaHandle) != null) {
                        toRefresh.add(teamAreaHandle);
                    }
                    this.determineTeamAreaHierarchyChanges(beforeHierarchy, hierarchy, children, toRefresh);
                }
                catch (TeamAreaHierarchyException teamAreaHierarchyException) {}
            }
        }
    };
    private static ConnectedProjectAreaRegistry fgDefault = null;
    private ListenerList fListeners = new ListenerList();
    private Map fRepositoriesToProjectAreas = new HashMap();
    private Map fProjectAreasToSelectedTeamAreas = new HashMap();
    private Map fProjectAreasToTeamAreas = new HashMap();
    private Map fNames = new HashMap();

    private ConnectedProjectAreaRegistry() {
        this.init();
    }

    public static ConnectedProjectAreaRegistry getDefault() {
        if (ProcessRCPUIPlugin.getDefault() == null) {
            return null;
        }
        if (fgDefault == null) {
            fgDefault = new ConnectedProjectAreaRegistry();
        }
        return fgDefault;
    }

    public List getConnectedProjectAreas(ITeamRepository teamRepository) {
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        return this.getConnectedProjectAreas(teamRepository, preferences.getBoolean("teamArtifactsNavigator.showArchived"));
    }

    public List getConnectedProjectAreas(ITeamRepository teamRepository, boolean includeArchived) {
        return this.getConnectedProjectAreas(teamRepository, includeArchived ? 2 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConnectedProjectAreas(ITeamRepository teamRepository, int includeArchived) {
        if (teamRepository == null) {
            ArrayList listsOfProjectAreas = null;
            ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
            synchronized (connectedProjectAreaRegistry) {
                listsOfProjectAreas = new ArrayList(this.fRepositoriesToProjectAreas.values());
            }
            ArrayList all = new ArrayList();
            Iterator iterator = listsOfProjectAreas.iterator();
            while (iterator.hasNext()) {
                Iterator projectAreas = ((List)iterator.next()).iterator();
                this.getConnectedProjectAreas(all, projectAreas, includeArchived);
            }
            return all;
        }
        ArrayList projectAreas = (ArrayList)this.fRepositoriesToProjectAreas.get(teamRepository.getRepositoryURI());
        if (projectAreas == null) {
            return new ArrayList();
        }
        ConnectedProjectAreaRegistry all = this;
        synchronized (all) {
            projectAreas = new ArrayList(projectAreas);
        }
        ArrayList connected = new ArrayList(projectAreas.size());
        this.getConnectedProjectAreas(connected, projectAreas.iterator(), includeArchived);
        return connected;
    }

    private void getConnectedProjectAreas(List connectedAreas, Iterator projectAreas, int includeArchived) {
        block5: while (projectAreas.hasNext()) {
            IProjectAreaHandle handle = (IProjectAreaHandle)projectAreas.next();
            ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
            if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                IItemManager itemManager = teamRepository.itemManager();
                IItem fullState = itemManager.getSharedItemIfKnown((IItemHandle)handle);
                if (fullState != null) {
                    switch (includeArchived) {
                        case 2: {
                            connectedAreas.add(fullState);
                            break;
                        }
                        case 0: {
                            if (((IProcessArea)fullState).isArchived()) continue block5;
                            connectedAreas.add(fullState);
                            break;
                        }
                        case 1: {
                            if (!((IProcessArea)fullState).isArchived()) continue block5;
                            connectedAreas.add(fullState);
                        }
                    }
                    continue;
                }
                connectedAreas.add(handle);
                continue;
            }
            if (handle.hasFullState()) {
                connectedAreas.add(handle.getFullState().getItemHandle());
                continue;
            }
            connectedAreas.add(handle);
        }
    }

    public IProjectAreaHandle[] fetchConnectedProjectAreas(ITeamRepository teamRepository, boolean handleNotLoggedIn, boolean includeArchived, IProgressMonitor monitor) throws TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProjectAreaHandle[] projectAreas = EMPTY;
        List projectAreaHandles = this.getConnectedProjectAreas(teamRepository, includeArchived);
        if (!projectAreaHandles.isEmpty()) {
            if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                try {
                    List connectedProjectAreas = teamRepository.itemManager().fetchCompleteItems(projectAreaHandles, 1, monitor);
                    int i = 0;
                    ArrayList deletedProjectAreas = new ArrayList();
                    Iterator connected = connectedProjectAreas.iterator();
                    while (connected.hasNext()) {
                        IProjectArea area = (IProjectArea)connected.next();
                        if (area == null) {
                            connected.remove();
                            deletedProjectAreas.add(projectAreaHandles.get(i));
                        } else if (!includeArchived && area.isArchived()) {
                            connected.remove();
                        }
                        ++i;
                        projectAreas = connectedProjectAreas.toArray(new IProjectArea[connectedProjectAreas.size()]);
                    }
                    this.removeConnectedProjectAreas(deletedProjectAreas);
                }
                catch (TeamRepositoryException e) {
                    if (handleNotLoggedIn) {
                        projectAreaHandles = this.getConnectedProjectAreas(teamRepository, includeArchived);
                        projectAreas = projectAreaHandles.toArray(new IProjectAreaHandle[projectAreaHandles.size()]);
                    }
                    throw e;
                }
            } else if (handleNotLoggedIn) {
                projectAreas = projectAreaHandles.toArray(new IProjectAreaHandle[projectAreaHandles.size()]);
            }
        }
        return projectAreas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectedProjectAreas(ITeamRepository teamRepository, List projectAreas) {
        List oldConnected;
        ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
        synchronized (connectedProjectAreaRegistry) {
            String uniqueKey;
            oldConnected = (List)this.fRepositoriesToProjectAreas.get(teamRepository.getRepositoryURI());
            this.fRepositoriesToProjectAreas.put(teamRepository.getRepositoryURI(), new ArrayList(projectAreas));
            if (oldConnected != null) {
                for (IProjectAreaHandle oldProjectAreaHandle : oldConnected) {
                    uniqueKey = this.getUniqueKey(oldProjectAreaHandle);
                    this.fProjectAreasToTeamAreas.remove(uniqueKey);
                    this.fProjectAreasToSelectedTeamAreas.remove(uniqueKey);
                    this.fNames.remove(uniqueKey);
                }
            }
            for (IProjectArea projectArea : projectAreas) {
                uniqueKey = this.getUniqueKey(projectArea);
                this.fNames.put(uniqueKey, projectArea.getName());
                this.fProjectAreasToTeamAreas.put(uniqueKey, new ArrayList(projectArea.getTeamAreas()));
                this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, new ArrayList(projectArea.getTeamAreas()));
            }
        }
        this.saveState();
        this.notifyListeners(teamRepository, oldConnected);
    }

    public void addListener(IConnectedProjectAreaRegistryListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IConnectedProjectAreaRegistryListener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void notifyListeners(ITeamRepository teamRepository, List previouslyConnected) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setTeamRepository(teamRepository);
        this.notifyListeners(changeEvent);
    }

    private void notifyListeners(ConnectedProjectAreaRegistryChangeEvent changeEvent) {
        Object[] listeners = this.fListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IConnectedProjectAreaRegistryListener)listeners[i]).connectedProjectAreaRegistryChanged(changeEvent);
            ++i;
        }
    }

    private void notifyListeners(IProjectAreaHandle projectArea, List previouslySelected) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea);
        changeEvent.setPreviouslySelected(previouslySelected);
        this.notifyListeners(changeEvent);
    }

    private void notifyListeners(IProjectAreaHandle projectArea, boolean connected) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea, connected);
        this.notifyListeners(changeEvent);
    }

    private void notifyListeners(IProjectAreaHandle projectArea, ITeamAreaHandle teamArea, boolean selected, boolean sharedItemChange) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea);
        changeEvent.setTeamArea(teamArea, selected, sharedItemChange);
        this.notifyListeners(changeEvent);
    }

    private void notifyListeners(IProjectAreaHandle projectArea) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea);
        this.notifyListeners(changeEvent);
    }

    private void notifyListenersForHierarchyChange(IProjectAreaHandle projectArea, List hierarchyChanges) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea);
        changeEvent.setType(4);
        changeEvent.setHierarchyChanges(hierarchyChanges);
        this.notifyListeners(changeEvent);
    }

    private void notifyListenersForArchiveStateChange(IProjectAreaHandle projectArea, boolean archived) {
        ConnectedProjectAreaRegistryChangeEvent changeEvent = new ConnectedProjectAreaRegistryChangeEvent();
        changeEvent.setProjectArea(projectArea);
        if (archived) {
            changeEvent.setType(8);
        } else {
            changeEvent.setType(9);
        }
        this.notifyListeners(changeEvent);
    }

    public void addConnectedProjectArea(IProjectArea projectArea) {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        List teamAreas = projectArea.getTeamAreas();
        if (this.addConnectedProjectArea((IProjectAreaHandle)projectArea, teamRepository, projectArea.getName(), teamAreas, teamAreas)) {
            this.saveState();
            this.notifyListeners((IProjectAreaHandle)projectArea, true);
        }
    }

    private synchronized boolean addConnectedProjectArea(IProjectAreaHandle projectAreaHandle, ITeamRepository teamRepository, String projectAreaName, List teamAreas, List selectedTeamAreas) {
        List connected = this.getConnectedProjectAreas(teamRepository);
        for (IProjectAreaHandle handle : connected) {
            if (!handle.sameItemId((IItemHandle)projectAreaHandle)) continue;
            return false;
        }
        connected.add(projectAreaHandle);
        this.fRepositoriesToProjectAreas.put(teamRepository.getRepositoryURI(), connected);
        String uniqueKey = this.getUniqueKey(projectAreaHandle);
        this.fNames.put(uniqueKey, projectAreaName);
        this.fProjectAreasToTeamAreas.put(uniqueKey, new ArrayList(teamAreas));
        this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, new ArrayList(selectedTeamAreas));
        return true;
    }

    public void addSelectedTeamArea(IProjectAreaHandle projectArea, ITeamArea teamArea) {
        if (!this.isConnectedProjectArea(projectArea)) {
            throw new AssertionFailedException(Messages.ConnectedProjectAreaRegistry_8);
        }
        this.addSelectedTeamArea(projectArea, teamArea, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSelectedTeamArea(IProjectAreaHandle projectArea, ITeamArea teamArea, boolean sharedItemChange) {
        ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
        synchronized (connectedProjectAreaRegistry) {
            List selected = this.getSelectedTeamAreas(projectArea);
            for (ITeamAreaHandle handle : selected) {
                if (!handle.sameItemId((IItemHandle)teamArea)) continue;
                return;
            }
            selected.add(teamArea);
            this.fProjectAreasToSelectedTeamAreas.put(this.getUniqueKey(projectArea), selected);
        }
        this.saveState();
        this.notifyListeners(projectArea, (ITeamAreaHandle)teamArea, true, sharedItemChange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTeamArea(IProjectAreaHandle projectArea, ITeamAreaHandle teamArea, boolean sharedItemChange) {
        ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
        synchronized (connectedProjectAreaRegistry) {
            ITeamAreaHandle handle;
            Iterator iter;
            ArrayList teamAreas;
            String uniqueKey = this.getUniqueKey(projectArea);
            if (sharedItemChange && (teamAreas = (ArrayList)this.fProjectAreasToTeamAreas.get(uniqueKey)) != null) {
                teamAreas = new ArrayList(teamAreas);
                iter = teamAreas.iterator();
                while (iter.hasNext()) {
                    handle = (ITeamAreaHandle)iter.next();
                    if (!handle.sameItemId((IItemHandle)teamArea)) continue;
                    iter.remove();
                    this.fProjectAreasToTeamAreas.put(uniqueKey, teamAreas);
                    break;
                }
            }
            if ((teamAreas = (List)this.fProjectAreasToSelectedTeamAreas.get(uniqueKey)) != null) {
                teamAreas = new ArrayList(teamAreas);
                iter = teamAreas.iterator();
                while (iter.hasNext()) {
                    handle = (ITeamAreaHandle)iter.next();
                    if (!handle.sameItemId((IItemHandle)teamArea)) continue;
                    iter.remove();
                    this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, teamAreas);
                    break;
                }
            }
        }
        this.notifyListeners(projectArea, teamArea, false, sharedItemChange);
    }

    public void setSelectedTeamAreas(IProjectAreaHandle projectArea, List teamAreas) {
        if (!this.isConnectedProjectArea(projectArea)) {
            throw new AssertionFailedException(Messages.ConnectedProjectAreaRegistry_9);
        }
        String uniqueKey = this.getUniqueKey(projectArea);
        List previouslySelected = (List)this.fProjectAreasToSelectedTeamAreas.get(uniqueKey);
        this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, new ArrayList(teamAreas));
        this.saveState();
        this.notifyListeners(projectArea, previouslySelected);
    }

    public List getSelectedTeamAreas(IProjectAreaHandle projectAreaHandle) {
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        return this.getSelectedTeamAreas(projectAreaHandle, preferences.getBoolean("teamArtifactsNavigator.showArchived"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSelectedTeamAreas(IProjectAreaHandle projectAreaHandle, boolean includeArchived) {
        ArrayList teamAreas = (ArrayList)this.fProjectAreasToSelectedTeamAreas.get(this.getUniqueKey(projectAreaHandle));
        if (teamAreas == null) {
            return new ArrayList();
        }
        if (includeArchived) {
            ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
            synchronized (connectedProjectAreaRegistry) {
                return new ArrayList(teamAreas);
            }
        }
        IItemManager manager = ((ITeamRepository)projectAreaHandle.getOrigin()).itemManager();
        ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
        synchronized (connectedProjectAreaRegistry) {
            teamAreas = new ArrayList(teamAreas);
        }
        ArrayList<Object> selectedTeamAreas = new ArrayList<Object>(teamAreas.size());
        for (ITeamAreaHandle teamAreaHandle : teamAreas) {
            ITeamArea teamArea = null;
            teamArea = teamAreaHandle.hasFullState() ? (ITeamArea)teamAreaHandle.getFullState() : (ITeamArea)manager.getSharedItemIfKnown((IItemHandle)teamAreaHandle);
            if (teamArea != null) {
                if (teamArea.isArchived()) continue;
                selectedTeamAreas.add(teamArea);
                continue;
            }
            selectedTeamAreas.add(teamAreaHandle);
        }
        return selectedTeamAreas;
    }

    public static void disposeDefault() {
        if (fgDefault == null) {
            return;
        }
        fgDefault.dispose();
    }

    private synchronized void dispose() {
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            teamRepositories[i].itemManager().removeItemChangeListener(IProjectArea.ITEM_TYPE, this.fItemChangeListener);
            teamRepositories[i].itemManager().removeItemChangeListener(ITeamArea.ITEM_TYPE, this.fItemChangeListener);
            teamRepositories[i].removeGenericListener((Object)"state", this.fStateListener);
            teamRepositories[i].removeGenericListener((Object)"error_state", this.fStateListener);
            ++i;
        }
        this.saveState();
        this.fListeners.clear();
        this.fProjectAreasToSelectedTeamAreas.clear();
        this.fProjectAreasToTeamAreas.clear();
        this.fRepositoriesToProjectAreas.clear();
        this.fNames.clear();
        fgDefault = null;
    }

    private synchronized void saveState() {
        XMLMemento memento = XMLMemento.createWriteRoot((String)CONNECTED_PROJECT_AREAS);
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            IPreferenceStore preferences = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
            preferences.setValue(CONNECTED_PROJECT_AREAS_MEMENTO, writer.toString());
        }
        catch (IOException e) {
            ProcessRCPUIPlugin.getDefault().log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(IMemento memento) {
        HashSet keySet = null;
        ConnectedProjectAreaRegistry connectedProjectAreaRegistry = this;
        synchronized (connectedProjectAreaRegistry) {
            keySet = new HashSet(this.fRepositoriesToProjectAreas.keySet());
        }
        for (String uri : keySet) {
            List areas = (List)this.fRepositoriesToProjectAreas.get(uri);
            if (areas.isEmpty()) continue;
            Iterator projectAreas = areas.iterator();
            while (projectAreas.hasNext()) {
                List allTeamAreas;
                IMemento connectedProjectArea = memento.createChild(CONNECTED_PROJECT_AREA);
                IProjectAreaHandle connected = (IProjectAreaHandle)projectAreas.next();
                connectedProjectArea.putString(KEY_REPOSITORY_URI, uri);
                String uniqueKey = this.getUniqueKey(connected);
                connectedProjectArea.putString(KEY_AREA_UUID, connected.getItemId().getUuidValue());
                connectedProjectArea.putString(KEY_PROJECT_AREA_NAME, (String)this.fNames.get(uniqueKey));
                List teamAreas = (List)this.fProjectAreasToSelectedTeamAreas.get(uniqueKey);
                if (teamAreas != null) {
                    Iterator tAreas = teamAreas.iterator();
                    while (tAreas.hasNext()) {
                        IMemento selectedTeamArea = connectedProjectArea.createChild(SELECTED_TEAM_AREA);
                        ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)tAreas.next();
                        String teamAreaUuidValue = teamAreaHandle.getItemId().getUuidValue();
                        selectedTeamArea.putString(KEY_AREA_UUID, teamAreaUuidValue);
                    }
                }
                if ((allTeamAreas = (List)this.fProjectAreasToTeamAreas.get(uniqueKey)) == null) continue;
                Iterator tAreas = allTeamAreas.iterator();
                while (tAreas.hasNext()) {
                    IMemento teamArea = connectedProjectArea.createChild(TEAM_AREA);
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)tAreas.next();
                    String teamAreaUuidValue = teamAreaHandle.getItemId().getUuidValue();
                    teamArea.putString(KEY_AREA_UUID, teamAreaUuidValue);
                }
            }
        }
    }

    private void init() {
        this.restoreStateFromMemento();
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryListener);
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            ITeamRepository teamRepository = teamRepositories[i];
            if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                this.restoreStateForRepository(teamRepository);
            }
            teamRepository.addGenericListener((Object)"state", this.fStateListener);
            teamRepository.addGenericListener((Object)"error_state", this.fStateListener);
            teamRepository.itemManager().addItemChangeListener(IProjectArea.ITEM_TYPE, this.fItemChangeListener);
            teamRepository.itemManager().addItemChangeListener(ITeamArea.ITEM_TYPE, this.fItemChangeListener);
            ++i;
        }
        IPreferenceStore store = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    private synchronized void restoreStateForRepository(final ITeamRepository teamRepository) {
        final String teamRepositoryURI = teamRepository.getRepositoryURI();
        final List projectAreaHandles = (List)this.fRepositoriesToProjectAreas.get(teamRepositoryURI);
        if (projectAreaHandles == null || projectAreaHandles.isEmpty()) {
            this.notifyListeners(teamRepository, projectAreaHandles);
            return;
        }
        Job initJob = new Job(Messages.ConnectedProjectAreaRegistry_10){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List projectAreas = teamRepository.itemManager().fetchCompleteItems(projectAreaHandles, 0, monitor);
                    Iterator iterator = projectAreas.iterator();
                    while (iterator.hasNext()) {
                        IProjectArea projectArea = (IProjectArea)iterator.next();
                        if (projectArea == null) {
                            iterator.remove();
                            continue;
                        }
                        String uniqueKey = ConnectedProjectAreaRegistry.this.getUniqueKey(projectArea);
                        List teamAreaHandles = (List)ConnectedProjectAreaRegistry.this.fProjectAreasToSelectedTeamAreas.get(uniqueKey);
                        if (teamAreaHandles != null) {
                            List teamAreas = teamRepository.itemManager().fetchCompleteItems(teamAreaHandles, 0, monitor);
                            Iterator tAreas = teamAreas.iterator();
                            while (tAreas.hasNext()) {
                                ITeamArea area = (ITeamArea)tAreas.next();
                                if (area != null) continue;
                                tAreas.remove();
                            }
                            ConnectedProjectAreaRegistry.this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, teamAreas);
                            continue;
                        }
                        ConnectedProjectAreaRegistry.this.fProjectAreasToSelectedTeamAreas.put(uniqueKey, new ArrayList());
                    }
                    ConnectedProjectAreaRegistry connectedProjectAreaRegistry = ConnectedProjectAreaRegistry.this;
                    synchronized (connectedProjectAreaRegistry) {
                        ConnectedProjectAreaRegistry.this.fRepositoriesToProjectAreas.put(teamRepositoryURI, projectAreas);
                    }
                    ConnectedProjectAreaRegistry.this.notifyListeners(teamRepository, projectAreaHandles);
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", 0, Messages.ConnectedProjectAreaRegistry_11, (Throwable)e);
                }
            }

            public boolean belongsTo(Object family) {
                return family == ConnectedProjectAreaRegistry.class;
            }
        };
        initJob.schedule();
    }

    public synchronized void setStateFromMemento(String stringMemento, boolean notify, boolean maintainProjectAreas) {
        ArrayList previousProjectAreas = null;
        HashMap previousNames = null;
        HashMap previousProjectAreasToSelectedTeamAreas = null;
        HashMap previousProjectAreasToTeamAreas = null;
        if (maintainProjectAreas) {
            previousProjectAreas = new ArrayList();
            ArrayList listOfLists = new ArrayList(this.fRepositoriesToProjectAreas.values());
            for (List list : listOfLists) {
                previousProjectAreas.addAll(list);
            }
            previousNames = new HashMap(this.fNames);
            previousProjectAreasToSelectedTeamAreas = new HashMap(this.fProjectAreasToSelectedTeamAreas);
            previousProjectAreasToTeamAreas = new HashMap(this.fProjectAreasToTeamAreas);
        }
        this.fRepositoriesToProjectAreas.clear();
        this.fProjectAreasToSelectedTeamAreas.clear();
        this.fProjectAreasToTeamAreas.clear();
        this.fNames.clear();
        XMLMemento memento = null;
        if (stringMemento != null && stringMemento.length() > 0) {
            try {
                memento = XMLMemento.createReadRoot((Reader)new StringReader(stringMemento));
            }
            catch (WorkbenchException e) {
                ProcessRCPUIPlugin.getDefault().log(e);
            }
        }
        if (memento == null) {
            return;
        }
        IMemento[] connectedMementos = memento.getChildren(CONNECTED_PROJECT_AREA);
        if (connectedMementos == null) {
            return;
        }
        int i = 0;
        while (i < connectedMementos.length) {
            IMemento[] teamAreaMementos;
            IMemento connectedMemento = connectedMementos[i];
            String repoURL = connectedMemento.getString(KEY_REPOSITORY_URI);
            ITeamRepository teamRepository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repoURL);
            String projectAreaID = connectedMemento.getString(KEY_AREA_UUID);
            UUID uuid = UUID.valueOf((String)projectAreaID);
            IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle((Object)teamRepository, uuid, null);
            String projectAreaName = connectedMemento.getString(KEY_PROJECT_AREA_NAME);
            String projectAreaUniqueKey = this.getUniqueKey(projectAreaHandle);
            this.fNames.put(projectAreaUniqueKey, projectAreaName);
            String repositoryURI = teamRepository.getRepositoryURI();
            ArrayList<Object> connectedAreas = (ArrayList<IProjectAreaHandle>)this.fRepositoriesToProjectAreas.get(repositoryURI);
            connectedAreas = connectedAreas == null ? new ArrayList<IProjectAreaHandle>() : new ArrayList(connectedAreas);
            connectedAreas.add(projectAreaHandle);
            this.fRepositoriesToProjectAreas.put(repositoryURI, connectedAreas);
            IMemento[] selectedMementos = connectedMemento.getChildren(SELECTED_TEAM_AREA);
            if (selectedMementos != null) {
                ArrayList<Object> selectedTeamAreas = (ArrayList<ITeamAreaHandle>)this.fProjectAreasToSelectedTeamAreas.get(projectAreaUniqueKey);
                selectedTeamAreas = selectedTeamAreas == null ? new ArrayList<ITeamAreaHandle>() : new ArrayList(selectedTeamAreas);
                int j = 0;
                while (j < selectedMementos.length) {
                    IMemento selectedTeamAreaMemento = selectedMementos[j];
                    String teamAreaID = selectedTeamAreaMemento.getString(KEY_AREA_UUID);
                    uuid = UUID.valueOf((String)teamAreaID);
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle((Object)teamRepository, uuid, null);
                    selectedTeamAreas.add(teamAreaHandle);
                    ++j;
                }
                this.fProjectAreasToSelectedTeamAreas.put(projectAreaUniqueKey, selectedTeamAreas);
            }
            if ((teamAreaMementos = connectedMemento.getChildren(TEAM_AREA)) != null) {
                ArrayList<Object> teamAreas = (ArrayList<ITeamAreaHandle>)this.fProjectAreasToTeamAreas.get(projectAreaUniqueKey);
                teamAreas = teamAreas == null ? new ArrayList<ITeamAreaHandle>() : new ArrayList(teamAreas);
                int j = 0;
                while (j < teamAreaMementos.length) {
                    IMemento teamAreaMemento = teamAreaMementos[j];
                    String teamAreaID = teamAreaMemento.getString(KEY_AREA_UUID);
                    uuid = UUID.valueOf((String)teamAreaID);
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)ITeamArea.ITEM_TYPE.createItemHandle((Object)teamRepository, uuid, null);
                    teamAreas.add(teamAreaHandle);
                    ++j;
                }
                this.fProjectAreasToTeamAreas.put(projectAreaUniqueKey, teamAreas);
            }
            ++i;
        }
        if (maintainProjectAreas) {
            this.maintainProjectAreasAfterSettingStateFromMemento(previousProjectAreas, previousNames, previousProjectAreasToTeamAreas, previousProjectAreasToSelectedTeamAreas);
        }
        this.saveState();
        if (notify) {
            this.notifyAfterSettingStateFromMemento();
        }
    }

    private void notifyAfterSettingStateFromMemento() {
        ITeamRepository[] teamRepositories = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < teamRepositories.length) {
            ITeamRepository teamRepository = teamRepositories[i];
            if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
                List projectAreaHandles = (List)this.fRepositoriesToProjectAreas.get(teamRepository.getRepositoryURI());
                this.notifyListeners(teamRepository, projectAreaHandles);
            }
            ++i;
        }
    }

    private void maintainProjectAreasAfterSettingStateFromMemento(List previousProjectAreas, Map previousNames, Map previousProjectAreasToTeamAreas, Map previousProjectAreasToSelectedTeamAreas) {
        List currentConnected = this.getConnectedProjectAreas(null);
        ArrayList<IProjectAreaHandle> projectAreasToRemove = new ArrayList<IProjectAreaHandle>();
        Iterator currentConnectedIterator = currentConnected.iterator();
        while (currentConnectedIterator.hasNext()) {
            IProjectAreaHandle connected = (IProjectAreaHandle)currentConnectedIterator.next();
            if (this.findInPrevious(previousProjectAreas, currentConnectedIterator, connected)) continue;
            projectAreasToRemove.add(connected);
        }
        this.removeConnectedProjectAreas(projectAreasToRemove, false);
        for (IProjectAreaHandle previous : previousProjectAreas) {
            String projectAreaKey = this.getUniqueKey(previous);
            this.addConnectedProjectArea(previous, (ITeamRepository)previous.getOrigin(), (String)previousNames.get(projectAreaKey), (List)previousProjectAreasToTeamAreas.get(projectAreaKey), (List)previousProjectAreasToSelectedTeamAreas.get(projectAreaKey));
        }
    }

    private boolean findInPrevious(List previousProjectAreas, Iterator currentConnectedIterator, IProjectAreaHandle connected) {
        Iterator previousProjectAreasIterator = previousProjectAreas.iterator();
        while (previousProjectAreasIterator.hasNext()) {
            IProjectAreaHandle previous = (IProjectAreaHandle)previousProjectAreasIterator.next();
            if (!connected.sameItemId((IItemHandle)previous)) continue;
            previousProjectAreasIterator.remove();
            currentConnectedIterator.remove();
            return true;
        }
        return false;
    }

    private void restoreStateFromMemento() {
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        String stringMemento = preferences.getString(CONNECTED_PROJECT_AREAS_MEMENTO);
        this.setStateFromMemento(stringMemento, false, false);
    }

    public void removeConnectedProjectAreas(List projectAreas) {
        this.removeConnectedProjectAreas(projectAreas, true);
        this.saveState();
    }

    private synchronized void removeConnectedProjectAreas(List projectAreasToRemove, boolean notify) {
        block0: for (IProjectAreaHandle projectArea : projectAreasToRemove) {
            ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
            ArrayList connectedAreas = (ArrayList)this.fRepositoriesToProjectAreas.get(teamRepository.getRepositoryURI());
            if (connectedAreas == null) continue;
            connectedAreas = new ArrayList(connectedAreas);
            Iterator connectedIter = connectedAreas.iterator();
            while (connectedIter.hasNext()) {
                IProjectAreaHandle handle = (IProjectAreaHandle)connectedIter.next();
                if (!handle.sameItemId((IItemHandle)projectArea)) continue;
                String uniqueKey = this.getUniqueKey(projectArea);
                this.fNames.remove(uniqueKey);
                this.fProjectAreasToSelectedTeamAreas.remove(uniqueKey);
                this.fProjectAreasToTeamAreas.remove(uniqueKey);
                connectedIter.remove();
                this.fRepositoriesToProjectAreas.put(teamRepository.getRepositoryURI(), connectedAreas);
                if (!notify) continue block0;
                this.notifyListeners(projectArea, false);
                continue block0;
            }
        }
    }

    public String getProjectAreaName(IProjectAreaHandle handle) {
        return (String)this.fNames.get(this.getUniqueKey(handle));
    }

    private void updateProjectAreaName(IProjectArea projectArea) {
        this.fNames.put(this.getUniqueKey(projectArea), projectArea.getName());
    }

    public boolean isConnectedProjectArea(IProjectAreaHandle projectArea) {
        List projectAreas = (List)this.fRepositoriesToProjectAreas.get(((ITeamRepository)projectArea.getOrigin()).getRepositoryURI());
        if (projectAreas != null) {
            for (IProjectAreaHandle handle : projectAreas) {
                if (!handle.sameItemId((IItemHandle)projectArea)) continue;
                return true;
            }
        }
        return false;
    }

    public IProjectArea getConnectedProjectArea(ITeamAreaHandle teamArea) {
        ITeamRepository teamRepository = (ITeamRepository)teamArea.getOrigin();
        List projectAreas = (List)this.fRepositoriesToProjectAreas.get(teamRepository.getRepositoryURI());
        if (projectAreas == null) {
            return null;
        }
        for (IProjectAreaHandle projectAreaHandle : projectAreas) {
            if (!projectAreaHandle.hasFullState()) {
                projectAreaHandle = (IProjectAreaHandle)teamRepository.itemManager().getSharedItemIfKnown((IItemHandle)projectAreaHandle);
            }
            if (projectAreaHandle == null || !projectAreaHandle.hasFullState()) continue;
            IProjectArea projectArea = (IProjectArea)projectAreaHandle.getFullState();
            Iterator teamAreas = projectArea.getTeamAreas().iterator();
            while (teamAreas.hasNext()) {
                if (!teamArea.sameItemId((IItemHandle)teamAreas.next())) continue;
                return projectArea;
            }
        }
        return null;
    }

    private String getUniqueKey(Object element) {
        String uniqueKey = null;
        if (element instanceof IProcessAreaHandle) {
            IProcessAreaHandle handle = (IProcessAreaHandle)element;
            UUID repositoryId = this.getRepositoryId((IItemHandle)handle);
            uniqueKey = repositoryId != null ? repositoryId + handle.getItemId().getUuidValue() : handle.getItemId().getUuidValue();
        }
        return uniqueKey;
    }

    private UUID getRepositoryId(IItemHandle handle) {
        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
        if (repository != null) {
            return repository.getId();
        }
        return null;
    }
}

