/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.rcp.ui.ProcessAreaContentProvider;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class TeamAreaSelectionDialog
extends ElementTreeSelectionDialog {
    private boolean fAllowArchived = false;

    public TeamAreaSelectionDialog(Shell parent) {
        super(parent, (ILabelProvider)new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl()), (ITreeContentProvider)new ProcessAreaContentProvider());
        this.setTitle(Messages.TeamAreaSelectionDialog_0);
        this.setMessage(Messages.TeamAreaSelectionDialog_1);
        this.setAllowMultiple(false);
        this.setComparator(new ViewerComparator());
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof ITeamArea) {
                        return new Status(0, "com.ibm.team.process.rcp.ui", "");
                    }
                    if (selection[0] instanceof PendingUpdateAdapter) {
                        return new Status(4, "com.ibm.team.process.rcp.ui", "");
                    }
                } else if (selection.length == 0) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", "");
                }
                return new Status(4, "com.ibm.team.process.rcp.ui", Messages.TeamAreaSelectionDialog_5);
            }
        });
    }

    public ITeamArea getSelectedTeamArea() {
        return (ITeamArea)this.getFirstResult();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.fAllowArchived) {
            final Button showArchivedButton = new Button(composite, 32);
            showArchivedButton.setText(Messages.TeamAreaSelectionDialog_6);
            showArchivedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TeamAreaSelectionDialog.this.setShowArchived(showArchivedButton.getSelection());
                }
            });
            showArchivedButton.setFont(parent.getFont());
        }
        this.setShowArchived(this.fAllowArchived);
        this.getTreeViewer().setComparer((IElementComparer)new ItemHandleComparer());
        return composite;
    }

    protected void setShowArchived(boolean show) {
        ProcessAreaContentProvider provider = (ProcessAreaContentProvider)this.getTreeViewer().getContentProvider();
        provider.setIncludeArchived(show);
    }

    public void setAllowArchivedAreas(boolean allowArchived) {
        this.fAllowArchived = allowArchived;
    }
}

