/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.process.rcp.ui.IStatusHandler;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.RepositoryCreationPart;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.PasswordUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RepositoryCreationPage
extends WizardPage
implements IStatusHandler {
    private RepositoryCreationPart fPart;
    private RepositoryInfo fRepositoryInformation;

    public RepositoryCreationPage(String title, String description) {
        super(title);
        this.setTitle(title);
        this.setDescription(description);
        this.fRepositoryInformation = new RepositoryInfo(null);
    }

    public RepositoryCreationPage(String description) {
        this(Messages.RepositoryCreationPage_0, description);
    }

    public boolean canFlipToNextPage() {
        return this.fRepositoryInformation.isValid();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
        this.fPart = new RepositoryCreationPart(this, this.fRepositoryInformation);
    }

    public ITeamRepository createRepository() {
        return this.createRepository(true);
    }

    public ITeamRepository createRepository(final boolean login) {
        boolean success;
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        RepositoryCreationPage.this.create();
                        ITeamRepository repo = ((RepositoryCreationPage)RepositoryCreationPage.this).fRepositoryInformation.fTeamRepository;
                        if (repo != null) {
                            if (repo.loggedIn()) {
                                repo.logout();
                            }
                            if (login) {
                                repo.login(monitor);
                            }
                        }
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            this.reportCreationError(e);
        }
        catch (InterruptedException interruptedException) {}
        boolean bl = success = this.fRepositoryInformation.fTeamRepository != null && (!login || this.fRepositoryInformation.fTeamRepository.loggedIn());
        if (!success) {
            if (this.fRepositoryInformation.fTeamRepository != null) {
                TeamPlatform.getTeamRepositoryService().removeTeamRepository(this.fRepositoryInformation.fTeamRepository);
            }
            this.fRepositoryInformation.fTeamRepository = null;
        }
        this.setPageComplete(this.fRepositoryInformation.fTeamRepository != null);
        return this.fRepositoryInformation.fTeamRepository;
    }

    private void reportCreationError(InvocationTargetException invocationException) {
        TeamRepositoryException repoException;
        ITeamRepository repo;
        Throwable exception = invocationException.getTargetException();
        if (exception == null) {
            exception = invocationException;
        }
        String message = exception.getMessage();
        if (exception instanceof TeamRepositoryException && (repo = (ITeamRepository)(repoException = (TeamRepositoryException)exception).getOrigin()) != null) {
            message = RepositoryLabelProvider.toConnectionErrorString(repoException, repo);
        }
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RepositoryCreationPage_1, null, (IStatus)new Status(4, "com.ibm.team.process.rcp.ui", message, exception));
    }

    public ITeamRepository getTeamRepository() {
        return this.fRepositoryInformation.fTeamRepository;
    }

    public void dispose() {
        this.fPart.dispose();
    }

    public void create() {
        this.fRepositoryInformation.fTeamRepository = this.createNewRepository(this.fRepositoryInformation.fURI);
        this.fRepositoryInformation.fTeamRepository.setAutoLogin(this.fRepositoryInformation.fAutoLogin);
        this.fRepositoryInformation.fTeamRepository.setSavePassword(this.fRepositoryInformation.fSavePassword);
        this.fRepositoryInformation.fTeamRepository.setName(this.fRepositoryInformation.fName);
        this.fRepositoryInformation.fTeamRepository.setUserId(this.fRepositoryInformation.fUserID);
        if (this.fRepositoryInformation.fTeamRepository.getSavePassword()) {
            PasswordUtil.savePassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository, (String)this.fRepositoryInformation.fUserID, (String)this.fRepositoryInformation.fPassword);
        } else {
            PasswordUtil.clearSavedPassword((ITeamRepository)this.fRepositoryInformation.fTeamRepository);
        }
        this.fRepositoryInformation.fTeamRepository.setConnectionTimeout(this.fRepositoryInformation.fTimeout);
    }

    private ITeamRepository createNewRepository(String uri) {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(uri);
        TeamPlatform.getTeamRepositoryService().addTeamRepository(repo);
        return repo;
    }

    public RepositoryInfo getRepositoryInformation() {
        return this.fRepositoryInformation;
    }

    public Composite getComposite() {
        return (Composite)this.getControl();
    }

    public void setStatus(IStatus status) {
        String statusMessage = null;
        if (status != null && !status.isOK()) {
            statusMessage = status.getMessage();
        }
        if (statusMessage == null) {
            this.setMessage(null);
        } else {
            this.setMessage(statusMessage, 3);
        }
        this.setPageComplete(statusMessage == null);
    }

    public GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }
}

