/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.AdapterAction;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.rcp.ui.IOpener;
import com.ibm.team.process.rcp.ui.IRefreshable;
import com.ibm.team.process.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;

public class ContextMenuHelper2 {
    private static Map fgViewPartToStandardActionMappings = new HashMap();

    public static List createStandardActions(IViewPart viewPart, String[] actionTypes) {
        Assert.isTrue((!fgViewPartToStandardActionMappings.containsKey(viewPart) ? 1 : 0) != 0);
        IViewSite site = viewPart.getViewSite();
        IActionBars actionBars = site.getActionBars();
        ArrayList<AdapterAction> actions = new ArrayList<AdapterAction>(actionTypes.length);
        AdapterAction action = null;
        int i = 0;
        while (i < actionTypes.length) {
            String actionType = actionTypes[i];
            if (actionType.equals(IMenuOperationTarget.DELETE)) {
                action = new AdapterAction(Messages.ContextMenuHelper2_0, IMenuOperationTarget.DELETE, (IWorkbenchSite)site);
                actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)action);
            } else if (actionType.equals("jazz.open")) {
                action = new AdapterAction(Messages.ContextMenuHelper2_1, "jazz.open", (IWorkbenchSite)site);
            } else if (actionType.equals(IMenuOperationTarget.PROPERTIES)) {
                action = new AdapterAction(Messages.ContextMenuHelper2_2, IMenuOperationTarget.PROPERTIES, (IWorkbenchSite)site);
                actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)action);
            } else if (actionType.equals(IMenuOperationTarget.REFRESH)) {
                action = new AdapterAction(Messages.ContextMenuHelper2_3, IMenuOperationTarget.REFRESH, (IWorkbenchSite)site);
                actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)action);
            }
            if (action != null) {
                actions.add(action);
            }
            ++i;
        }
        fgViewPartToStandardActionMappings.put(viewPart, actions);
        actionBars.updateActionBars();
        return new ArrayList(actions);
    }

    public static void addStandardActions(IMenuManager manager, IViewPart viewPart, String[] actionTypes) {
        ISelectionProvider selectionProvider = viewPart.getViewSite().getSelectionProvider();
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        if (selection instanceof DomainSelection) {
            selection = ((DomainSelection)selection).getOriginal();
        }
        if (selection.isEmpty()) {
            return;
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        IMenuOperationTarget target = (IMenuOperationTarget)adapterManager.getAdapter(selection.getFirstElement(), IMenuOperationTarget.class);
        List actions = (List)fgViewPartToStandardActionMappings.get(viewPart);
        if (actions == null) {
            return;
        }
        for (AdapterAction action : actions) {
            String type = action.getType();
            if (target != null) {
                if (type.equals(IMenuOperationTarget.DELETE) && target.canDoOperation(IMenuOperationTarget.DELETE, selection)) {
                    manager.appendToGroup("jazz.refactoring.group", (IAction)action);
                } else if (type.equals("jazz.open")) {
                    if (target.canDoOperation("jazz.open", selection)) {
                        manager.appendToGroup("jazz.open.group", (IAction)action);
                    } else if (viewPart instanceof IOpener && ((IOpener)viewPart).canOpenSelection(selection)) {
                        manager.appendToGroup("jazz.open.group", (IAction)action);
                    }
                }
            } else if (type.equals("jazz.open") && viewPart instanceof IOpener && ((IOpener)viewPart).canOpenSelection(selection)) {
                manager.appendToGroup("jazz.open.group", (IAction)action);
            }
            if (type.equals(IMenuOperationTarget.PROPERTIES)) {
                manager.appendToGroup("jazz.properties.group", (IAction)action);
                continue;
            }
            if (!type.equals(IMenuOperationTarget.REFRESH) || !(viewPart instanceof IRefreshable)) continue;
            manager.appendToGroup("jazz.refactoring.group", (IAction)action);
        }
    }

    public static void removeStandardActions(IViewPart viewPart) {
        List actions = (List)fgViewPartToStandardActionMappings.remove(viewPart);
        if (actions == null) {
            return;
        }
        for (AdapterAction action : actions) {
            action.dispose();
        }
    }

    public static void addStandardActions(IMenuManager manager, ISelectionProvider selectionProvider, IWorkbenchSite workbenchSite, String[] actionTypes) {
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        if (selection instanceof DomainSelection) {
            selection = ((DomainSelection)selection).getOriginal();
        }
        if (selection.isEmpty()) {
            return;
        }
        IAdapterManager adapterManager = Platform.getAdapterManager();
        IMenuOperationTarget target = (IMenuOperationTarget)adapterManager.getAdapter(selection.getFirstElement(), IMenuOperationTarget.class);
        int i = 0;
        while (i < actionTypes.length) {
            String type = actionTypes[i];
            if (target != null) {
                if (type.equals(IMenuOperationTarget.DELETE) && target.canDoOperation(IMenuOperationTarget.DELETE, selection)) {
                    manager.appendToGroup("jazz.refactoring.group", (IAction)new AdapterAction(Messages.ContextMenuHelper2_4, IMenuOperationTarget.DELETE, workbenchSite, selectionProvider));
                } else if (type.equals("jazz.open") && target.canDoOperation("jazz.open", selection)) {
                    manager.appendToGroup("jazz.open.group", (IAction)new AdapterAction(Messages.ContextMenuHelper2_5, "jazz.open", workbenchSite, selectionProvider));
                }
            }
            if (type.equals(IMenuOperationTarget.PROPERTIES)) {
                manager.appendToGroup("jazz.properties.group", (IAction)new AdapterAction(Messages.ContextMenuHelper2_6, IMenuOperationTarget.PROPERTIES, workbenchSite, selectionProvider));
            } else if (type.equals(IMenuOperationTarget.REFRESH)) {
                manager.appendToGroup("jazz.refactoring.group", (IAction)new AdapterAction(Messages.ContextMenuHelper2_7, IMenuOperationTarget.REFRESH, workbenchSite, selectionProvider));
            }
            ++i;
        }
    }
}

