/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.DomainNavigator;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.internal.rcp.ui.HelpContextIds;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.OpenTeamAreaFiltersDialogAction;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.IRefreshable;
import com.ibm.team.process.rcp.ui.ProcessRCPUI;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.ProjectAreaCategory;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import java.util.List;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ShowInContext;

public class TeamArtifactsNavigator
extends DomainNavigator
implements IRefreshable,
Preferences.IPropertyChangeListener {
    private ProjectAreaCategory fProjectAreaCategory = new ProjectAreaCategory();

    public TeamArtifactsNavigator() {
        this.fProjectAreaCategory.setTeamArtifactsNavigator(this);
        this.setCategory(this.fProjectAreaCategory);
    }

    private IConnectedProjectAreaRegistry getConnectedProjectAreaRegistry() {
        return ConnectedProjectAreaRegistry.getDefault();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fProjectAreaCategory.init();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.process.rcp.ui.csh_team_artifacts");
        this.fProjectAreaCategory.setViewer(this.getTreeViewer());
        this.updateDescription();
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    protected void addToolBar() {
        super.addToolBar();
        IToolBarManager viewToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        viewToolBarManager.prependToGroup("viewActions", (IAction)new OpenTeamAreaFiltersDialogAction(this.getSite().getShell()));
    }

    public boolean show(ShowInContext context) {
        TreePath path;
        Object first;
        TreeSelection treeSelection;
        TreePath[] paths;
        if (super.show(context)) {
            return true;
        }
        if (!(context.getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)context.getSelection();
        if (selection instanceof TreeSelection && (paths = (treeSelection = (TreeSelection)selection).getPaths()).length == 1 && (first = (path = paths[0]).getFirstSegment()) instanceof IProjectArea) {
            IProjectArea projectArea = (IProjectArea)first;
            this.getTreeViewer().getControl().setFocus();
            this.setSelection((ISelection)new StructuredSelection((Object)projectArea));
            return true;
        }
        return false;
    }

    public ISelection getOriginalSelection() {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof DomainSelection) {
            return ((DomainSelection)selection).getOriginal();
        }
        return selection;
    }

    public void refresh() {
        ISelection originalSelection;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer == null || treeViewer.getControl().isDisposed()) {
            return;
        }
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem instanceof IProjectAreaHandle) {
                this.fProjectAreaCategory.refreshCategoryElement(elem);
                return;
            }
            Domain[] domains = this.getDomains();
            int i = 0;
            while (i < domains.length) {
                if (domains[i].contains(elem)) {
                    if (!domains[i].refresh(elem)) break;
                    return;
                }
                ++i;
            }
        }
        if ((originalSelection = this.getOriginalSelection()) instanceof IStructuredSelection && !originalSelection.isEmpty()) {
            treeViewer.refresh(((IStructuredSelection)originalSelection).getFirstElement());
        } else {
            treeViewer.refresh();
        }
    }

    public void updateDescription() {
        IConnectedProjectAreaRegistry registry = this.getConnectedProjectAreaRegistry();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        IPreferenceStore preferences = ProcessRCPUI.getPreferenceStore();
        int filterType = preferences.getInt("teamArtifactsNavigator.activeFilter");
        String filterName = Messages.TeamArtifactsNavigator_0;
        switch (filterType) {
            case 1: {
                filterName = Messages.TeamArtifactsNavigator_1;
                break;
            }
            case 2: {
                filterName = Messages.TeamArtifactsNavigator_2;
            }
        }
        if (connectedProjectAreas.isEmpty()) {
            String description = NLS.bind((String)Messages.TeamArtifactsNavigator_3, (Object)filterName);
            this.setContentDescription(description);
            return;
        }
        int totalCount = 0;
        int selectedCount = 0;
        for (IProjectAreaHandle connectedProjectAreaHandle : connectedProjectAreas) {
            IItemManager itemManager = ((ITeamRepository)connectedProjectAreaHandle.getOrigin()).itemManager();
            IProjectArea projectArea = (IProjectArea)itemManager.getSharedItemIfKnown((IItemHandle)connectedProjectAreaHandle);
            if (projectArea == null) continue;
            List teamAreas = registry.getSelectedTeamAreas(connectedProjectAreaHandle);
            totalCount += projectArea.getTeamAreas().size();
            selectedCount += teamAreas.size();
        }
        String description = NLS.bind((String)Messages.TeamArtifactsNavigator_4, (Object[])new Object[]{filterName, Integer.toString(selectedCount), Integer.toString(totalCount)});
        this.setContentDescription(description);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        IConnectedProjectAreaRegistry registry;
        List connectedProjectAreas;
        if (event.getProperty().equals("teamArtifactsNavigator.activeFilter") && (connectedProjectAreas = (registry = this.getConnectedProjectAreaRegistry()).getConnectedProjectAreas(null)).isEmpty()) {
            this.updateDescription();
        }
    }

    public void dispose() {
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        super.dispose();
    }
}

