/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;

public class SelectTeamAreasAction
extends Action {
    private int fType;

    public SelectTeamAreasAction(int type) {
        super("", 8);
        this.fType = type;
        switch (this.fType) {
            case 0: {
                this.setText(Messages.SelectTeamAreasAction_1);
                break;
            }
            case 1: {
                this.setText(Messages.SelectTeamAreasAction_2);
                break;
            }
            case 2: {
                this.setText(Messages.SelectTeamAreasAction_3);
            }
        }
    }

    public void run() {
        IPreferenceStore preferences = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
        if (this.fType == preferences.getInt("teamArtifactsNavigator.activeFilter")) {
            return;
        }
        switch (this.fType) {
            case 0: {
                this.selectCustom();
                break;
            }
            case 1: {
                this.selectMyTeamAreas();
                break;
            }
            case 2: {
                this.selectAllTeamAreas(false);
            }
        }
        preferences.setValue("teamArtifactsNavigator.activeFilter", this.fType);
    }

    private void selectCustom() {
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        String stringMemento = preferences.getString("customTeamAreaFilterMemento");
        if (stringMemento.length() != 0) {
            ConnectedProjectAreaRegistry.getDefault().setStateFromMemento(stringMemento, true, true);
        } else {
            this.selectAllTeamAreas(true);
        }
    }

    private void selectAllTeamAreas(final boolean alwaysIncludeArchived) {
        final ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        if (connectedProjectAreas.isEmpty()) {
            return;
        }
        IProjectAreaHandle projectAreaHandle = (IProjectAreaHandle)connectedProjectAreas.get(0);
        final ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
        Job job = new Job(Messages.SelectTeamAreasAction_4){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
                    boolean includeArchived = alwaysIncludeArchived || preferences.getBoolean("teamArtifactsNavigator.showArchived");
                    IProjectAreaHandle[] projectAreas = registry.fetchConnectedProjectAreas(teamRepository, false, includeArchived, monitor);
                    int i = 0;
                    while (i < projectAreas.length) {
                        IProjectArea projectArea = (IProjectArea)projectAreas[i];
                        registry.setSelectedTeamAreas((IProjectAreaHandle)projectArea, projectArea.getTeamAreas());
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SelectTeamAreasAction_5, (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void selectMyTeamAreas() {
        final ConnectedProjectAreaRegistry registry = ConnectedProjectAreaRegistry.getDefault();
        final List connectedProjectAreas = registry.getConnectedProjectAreas(null);
        if (connectedProjectAreas.isEmpty()) {
            return;
        }
        Job job = new Job(Messages.SelectTeamAreasAction_6){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    for (IProjectAreaHandle projectAreaHandle : connectedProjectAreas) {
                        ITeamRepository teamRepository = (ITeamRepository)projectAreaHandle.getOrigin();
                        IContributor user = teamRepository.loggedInContributor();
                        if (user == null) continue;
                        IProcessItemService service = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
                        List teamAreas = service.findTeamAreas(user, projectAreaHandle, SelectTeamAreasAction.this.computeRequiredProperties(), monitor);
                        registry.setSelectedTeamAreas(projectAreaHandle, teamAreas);
                    }
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException e) {
                    return new Status(4, "com.ibm.team.process.rcp.ui", Messages.SelectTeamAreasAction_7, (Throwable)e);
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private Collection computeRequiredProperties() {
        return IProcessClientService.ALL_PROPERTIES;
    }
}

