/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.RepositoryInfo;
import com.ibm.team.process.internal.rcp.ui.RepositoryLabelProvider;
import com.ibm.team.process.internal.rcp.ui.RepositoryLoginDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.utils.PasswordUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class RepositoryLoginHandler
implements ITeamRepository.ILoginHandler {
    private ITeamRepository.ILoginHandler.ILoginInfo getCurrentInfo(ITeamRepository repository) {
        return new RepositoryInfo(repository);
    }

    private ITeamRepository.ILoginHandler.ILoginInfo challengeUI(ITeamRepository server) {
        RepositoryLoginDialog dialog;
        int dialogResult;
        if (server.getSavePassword()) {
            switch (server.getErrorState()) {
                case 0: {
                    return this.getCurrentInfo(server);
                }
                case 1: {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    String message = Messages.RepositoryLoginHandler_0;
                    Throwable lastError = server.getLastError();
                    if (lastError instanceof TeamRepositoryException) {
                        message = RepositoryLabelProvider.toConnectionErrorString((TeamRepositoryException)lastError, server);
                    }
                    if (MessageDialog.openQuestion((Shell)shell, (String)Messages.RepositoryLoginHandler_1, (String)NLS.bind((String)Messages.RepositoryLoginHandler_2, (Object)message))) {
                        return this.getCurrentInfo(server);
                    }
                    return null;
                }
            }
        }
        if ((dialogResult = (dialog = this.createLoginDialog(server)).open()) == 0) {
            server.setSavePassword(dialog.isSavePassword());
            server.setAutoLogin(dialog.isAutologin());
            if (server.getSavePassword()) {
                PasswordUtil.savePassword((ITeamRepository)server, (String)server.getUserId(), (String)dialog.getPassword());
            }
            return new ITeamRepository.ILoginHandler.ILoginInfo(){

                public String getUserId() {
                    return dialog.getUsername();
                }

                public String getPassword() {
                    return dialog.getPassword();
                }
            };
        }
        return null;
    }

    private RepositoryLoginDialog createLoginDialog(ITeamRepository repository) {
        String uri = repository.getRepositoryURI();
        String userId = repository.getUserId();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String message = null;
        String tooltip = "";
        if (repository.getErrorState() != 0) {
            message = RepositoryLabelProvider.toConnectionErrorString(repository);
            Throwable lastError = repository.getLastError();
            if (lastError != null) {
                StringWriter sw = new StringWriter();
                lastError.printStackTrace(new PrintWriter(sw));
                sw.flush();
                tooltip = sw.getBuffer().toString();
            }
        }
        RepositoryLoginDialog dialog = new RepositoryLoginDialog(shell, uri, userId != null ? userId : "", this.getPassword(repository, userId), message, tooltip);
        dialog.setUsernameMutable(true);
        dialog.setSavePassword(repository.getSavePassword());
        dialog.setAutoLogin(repository.getAutoLogin());
        return dialog;
    }

    private String getPassword(ITeamRepository repository, String userId) {
        return PasswordUtil.getSavedPassword((ITeamRepository)repository, (String)userId);
    }

    public ITeamRepository.ILoginHandler.ILoginInfo challenge(final ITeamRepository repository) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return null;
        }
        final ITeamRepository.ILoginHandler.ILoginInfo[] result = new ITeamRepository.ILoginHandler.ILoginInfo[1];
        if (Display.getCurrent() == null) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    result[0] = RepositoryLoginHandler.this.challengeUI(repository);
                }
            });
            return result[0];
        }
        return this.challengeUI(repository);
    }
}

