/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryLoginDialog
extends Dialog {
    protected Text usernameField;
    protected Text passwordField;
    protected Button rememberPasswordButton;
    protected Button autoLoginButton;
    protected String domain;
    protected String username;
    protected String password;
    protected boolean fSavePassword = false;
    protected boolean autoLogin = false;
    protected Image keyLockImage;
    protected boolean isUsernameMutable = true;
    protected String message = null;
    private LocalResourceManager resourceMgr;
    private final String messageTooltip;

    public RepositoryLoginDialog(Shell parentShell, String location, String defaultName, String defaultPassword, String message, String messageTooltip) {
        super(null);
        this.messageTooltip = messageTooltip;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.username = defaultName;
        this.password = defaultPassword;
        this.domain = location;
        this.message = message;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepositoryLoginDialog_0);
    }

    public void create() {
        super.create();
        this.usernameField.setText(this.username);
        this.passwordField.setText(this.password);
        this.rememberPasswordButton.setSelection(this.fSavePassword);
        this.autoLoginButton.setSelection(this.autoLogin);
        if (this.isUsernameMutable) {
            this.usernameField.selectAll();
            this.usernameField.setFocus();
        } else {
            this.usernameField.setEditable(false);
            this.passwordField.setFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.resourceMgr = new LocalResourceManager(JFaceResources.getResources(), (Control)top);
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        Label imageLabel = new Label(imageComposite, 0);
        this.keyLockImage = this.resourceMgr.createImageWithDefault(ImagePool.KEYLOCK_IMAGE);
        imageLabel.setImage(this.keyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        if (this.message != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setForeground(Display.getDefault().getSystemColor(3));
            messageLabel.setBackground(Display.getDefault().getSystemColor(22));
            messageLabel.setText(this.message);
            messageLabel.setToolTipText(this.messageTooltip);
            data = new GridData(768);
            data.horizontalSpan = 3;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.domain != null) {
            Label d = new Label(main, 64);
            d.setText(Messages.RepositoryLoginDialog_1);
            data = new GridData();
            d.setLayoutData((Object)data);
            Text label = new Text(main, 76);
            label.setBackground(Display.getDefault().getSystemColor(22));
            label.setText(this.domain);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 300;
            label.setLayoutData((Object)data);
        }
        this.createUsernameFields(main);
        this.createPasswordFields(main);
        if (this.domain != null) {
            this.rememberPasswordButton = new Button(main, 32);
            this.rememberPasswordButton.setText(Messages.RepositoryLoginDialog_2);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.rememberPasswordButton.setLayoutData((Object)data);
            this.rememberPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryLoginDialog.this.fSavePassword = RepositoryLoginDialog.this.rememberPasswordButton.getSelection();
                }
            });
            this.autoLoginButton = new Button(main, 32);
            this.autoLoginButton.setText(Messages.RepositoryLoginDialog_3);
            data = new GridData(768);
            data.horizontalSpan = 3;
            this.autoLoginButton.setLayoutData((Object)data);
            this.autoLoginButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RepositoryLoginDialog.this.autoLogin = RepositoryLoginDialog.this.autoLoginButton.getSelection();
                }
            });
            Composite warningComposite = new Composite(main, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginHeight = 0;
            warningComposite.setLayout((Layout)layout);
            data = new GridData(768);
            data.horizontalSpan = 3;
            warningComposite.setLayoutData((Object)data);
            Label warningLabel = new Label(warningComposite, 0);
            warningLabel.setImage(RepositoryLoginDialog.getImage((String)"dialog_messasge_warning_image"));
            warningLabel.setLayoutData((Object)new GridData(34));
            Label warningText = new Label(warningComposite, 64);
            warningText.setText(Messages.RepositoryLoginDialog_4);
            data = new GridData(768);
            data.widthHint = 300;
            warningText.setLayoutData((Object)data);
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void createPasswordFields(Composite parent) {
        new Label(parent, 0).setText(Messages.RepositoryLoginDialog_5);
        this.passwordField = new Text(parent, 0x400800);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.passwordField.setLayoutData((Object)data);
    }

    protected void createUsernameFields(Composite parent) {
        new Label(parent, 0).setText(Messages.RepositoryLoginDialog_6);
        this.usernameField = new Text(parent, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        this.usernameField.setLayoutData((Object)data);
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isSavePassword() {
        return this.fSavePassword;
    }

    public boolean isAutologin() {
        return this.autoLogin;
    }

    protected void okPressed() {
        this.password = this.passwordField.getText();
        this.username = this.usernameField.getText();
        super.okPressed();
    }

    public void setUsernameMutable(boolean value) {
        this.isUsernameMutable = value;
    }

    public void setSavePassword(boolean value) {
        this.fSavePassword = value;
    }

    public void setAutoLogin(boolean value) {
        this.autoLogin = value;
    }
}

