/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import com.ibm.team.repository.common.transport.VersionMismatchException;
import com.ibm.team.repository.rcp.ui.labelproviders.ListeningLabelProvider;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.NoResponseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class RepositoryLabelProvider
extends ListeningLabelProvider {
    private Image fRepositoryImage;
    private Image fLoggedInRepositoryImage;
    private Image fErrorLoggedInRepositoryImage;
    private Font fItalicFont;
    private Font fNormalFont;
    private IListener fEventListener = new IListener(){

        public void handleEvents(List events) {
            ArrayList<Object> affectedRepos = new ArrayList<Object>();
            for (IPropertyChangeEvent event : events) {
                affectedRepos.add(event.getObject());
            }
            RepositoryLabelProvider.this.fireChangeEvent(affectedRepos);
        }
    };

    public static String getRepositoryText(ITeamRepository repo) {
        String name = repo.getName();
        if (name == null || "".equals(name)) {
            name = repo.getRepositoryURI();
        }
        return name;
    }

    public RepositoryLabelProvider() {
        this.fRepositoryImage = this.getImage(ImagePool.LOGGEDOUT_REPOSITORY);
        this.fLoggedInRepositoryImage = this.getImage(ImagePool.LOGGEDIN_REPOSITORY);
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
        imageDescriptorArray[1] = ImagePool.ERROR_TICK;
        this.fErrorLoggedInRepositoryImage = this.getImage((ImageDescriptor)new OverlayIcon(ImagePool.LOGGEDIN_REPOSITORY, this.fLoggedInRepositoryImage, imageDescriptorArray, new Point(16, 16), 17408));
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        FontRegistry fontRegistry = theme.getFontRegistry();
        FontDescriptor defaultFont = fontRegistry.getDescriptor("org.eclipse.jface.defaultfont");
        this.fItalicFont = this.getFont(defaultFont.withStyle(2));
        this.fNormalFont = this.getFont(defaultFont);
    }

    protected void doUpdateLabel(ViewerLabel label, Object element) {
        ITeamRepository obj = (ITeamRepository)element;
        String userId = obj.getUserId();
        if (userId == null || "".equals(userId)) {
            userId = Messages.RepositoryLabelProvider_0;
        }
        String name = RepositoryLabelProvider.getRepositoryText(obj);
        StringBuffer result = new StringBuffer(userId);
        result.append('@');
        result.append(name);
        int state = obj.getState();
        int errorState = obj.getErrorState();
        if (state == 0 || state == 2) {
            label.setFont(this.fItalicFont);
        } else {
            label.setFont(this.fNormalFont);
        }
        if (errorState == 1 || errorState == 2) {
            result.append(NLS.bind((String)" ({0})", (Object)RepositoryLabelProvider.toConnectionErrorString(obj)));
            if (state == 1) {
                label.setImage(this.fErrorLoggedInRepositoryImage);
            } else {
                label.setImage(this.fErrorLoggedInRepositoryImage);
            }
        } else if (state == 1) {
            label.setImage(this.fLoggedInRepositoryImage);
        } else {
            label.setImage(this.fRepositoryImage);
        }
        label.setText(result.toString());
    }

    protected void elementAdded(Object element) {
        super.elementAdded(element);
        ((ITeamRepository)element).addGenericListener((Object)"state", this.fEventListener);
        ((ITeamRepository)element).addGenericListener((Object)"error_state", this.fEventListener);
    }

    protected void elementRemoved(Object element) {
        super.elementRemoved(element);
        ((ITeamRepository)element).removeGenericListener((Object)"state", this.fEventListener);
        ((ITeamRepository)element).removeGenericListener((Object)"error_state", this.fEventListener);
    }

    public static String toConnectionErrorString(ITeamRepository repo) {
        Throwable e;
        String errorString = "";
        int errorState = repo.getErrorState();
        if (errorState != 0 && (e = repo.getLastError()) != null) {
            if (e instanceof TeamRepositoryException) {
                errorString = RepositoryLabelProvider.toConnectionErrorString((TeamRepositoryException)e, repo);
            } else {
                errorString = errorState == 1 ? Messages.RepositoryLabelProvider_1 : Messages.RepositoryLabelProvider_2;
                String message = e.getMessage();
                if (message != null) {
                    errorString = NLS.bind((String)"{0}: {1}", (Object)errorString, (Object)message);
                }
            }
        }
        return errorString;
    }

    public static String toConnectionErrorString(TeamRepositoryException exception, ITeamRepository repo) {
        String message = NLS.bind((String)Messages.RepositoryLabelProvider_3, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        if (exception instanceof AuthenticationException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_4, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof ConnectionException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_5, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof HostUnknownException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_6, (Object)repo.getRepositoryURI());
        } else if (exception instanceof NoResponseException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_7, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        } else if (exception instanceof VersionMismatchException) {
            message = NLS.bind((String)Messages.RepositoryLabelProvider_8, (Object)RepositoryLabelProvider.getRepositoryText(repo));
        }
        return message;
    }
}

