/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.rcp.ui.utils.PasswordUtil;

public class RepositoryInfo
implements ITeamRepository.ILoginHandler.ILoginInfo {
    public static final int MIN_TIMOUT = 0;
    public static final int MAX_TIMOUT = 9999;
    public ITeamRepository fTeamRepository;
    public String fName = "";
    public String fURI = "";
    public String fUserID = "";
    public String fPassword = "";
    public boolean fAutoLogin = true;
    public boolean fSavePassword = true;
    public int fTimeout;

    public RepositoryInfo(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
        if (teamRepository != null) {
            this.fURI = teamRepository.getRepositoryURI();
            this.fName = teamRepository.getName();
            if (this.fName == null) {
                this.fName = "";
            }
            this.fUserID = teamRepository.getUserId();
            this.fPassword = PasswordUtil.getSavedPassword((ITeamRepository)teamRepository, (String)this.fUserID);
            this.fAutoLogin = teamRepository.getAutoLogin();
            this.fSavePassword = teamRepository.getSavePassword();
            this.fTimeout = teamRepository.getConnectionTimeout();
        } else {
            ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
            this.fTimeout = service.getDefaultConnectionTimeout() / 1000;
        }
    }

    public String getPassword() {
        return this.fPassword;
    }

    public String getUserId() {
        return this.fUserID;
    }

    public boolean isValid() {
        return this.fUserID != null && this.fUserID.trim().length() > 0 && this.fURI != null && this.fURI.trim().length() > 0 && this.fTimeout >= 0 && this.fTimeout <= 9999;
    }
}

