/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryCertificateDialog
extends Dialog {
    public static final int SEL_REJECTED = 1;
    public static final int SEL_ACCEPTED_SESSION = 2;
    public static final int SEL_ACCEPTED_PERMANENT = 4;
    private int fButtonMask;
    private int fSelectionState;
    protected Button fRejectButton;
    protected Button fSessionButton;
    protected Button fPermanentButton;
    private final String fDomain;
    private final String fMessage;
    private final String fMessageTooltip;
    private Image fKeyLockImage;
    private LocalResourceManager fResourceMgr;

    public RepositoryCertificateDialog(String location, String message, String messageTooltip, int buttonMask, int defaultSelection) {
        super(null);
        this.fMessageTooltip = messageTooltip;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDomain = location;
        this.fMessage = message;
        this.fButtonMask = buttonMask;
        if (defaultSelection != 1 && defaultSelection != 2 && defaultSelection != 4) {
            throw new IllegalArgumentException();
        }
        this.fSelectionState = defaultSelection;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.RepositoryCertificateDialog_0);
    }

    public void create() {
        super.create();
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        this.fResourceMgr = new LocalResourceManager(JFaceResources.getResources(), (Control)top);
        Composite imageComposite = new Composite(top, 0);
        layout = new GridLayout();
        imageComposite.setLayout((Layout)layout);
        imageComposite.setLayoutData((Object)new GridData(1040));
        Label imageLabel = new Label(imageComposite, 0);
        this.fKeyLockImage = this.fResourceMgr.createImageWithDefault(ImagePool.KEYLOCK_IMAGE);
        imageLabel.setImage(this.fKeyLockImage);
        GridData data = new GridData(768);
        imageLabel.setLayoutData((Object)data);
        Composite main = new Composite(top, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(768));
        if (this.fMessage != null) {
            Label messageLabel = new Label(main, 64);
            messageLabel.setBackground(Display.getDefault().getSystemColor(22));
            messageLabel.setText(this.fMessage);
            messageLabel.setToolTipText(this.fMessageTooltip);
            data = new GridData(768);
            data.horizontalSpan = 2;
            data.widthHint = 300;
            messageLabel.setLayoutData((Object)data);
        }
        if (this.fDomain != null) {
            Label d = new Label(main, 64);
            d.setText(Messages.RepositoryCertificateDialog_4);
            data = new GridData();
            d.setLayoutData((Object)data);
            Text label = new Text(main, 76);
            label.setBackground(Display.getDefault().getSystemColor(22));
            label.setText(this.fDomain);
            data = new GridData(768);
            data.widthHint = 300;
            label.setLayoutData((Object)data);
        }
        Label m = new Label(main, 64);
        m.setText(Messages.RepositoryCertificateDialog_5);
        data = new GridData();
        data.horizontalSpan = 2;
        m.setLayoutData((Object)data);
        Composite choices = new Composite(main, 8);
        data = new GridData();
        data.horizontalSpan = 2;
        choices.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        choices.setLayout((Layout)gridLayout);
        if ((this.fButtonMask & 1) == 1) {
            this.fRejectButton = new Button(choices, 16);
            this.fRejectButton.setText(Messages.RepositoryCertificateDialog_1);
            this.fRejectButton.setSelection(this.fSelectionState == 1);
        }
        if ((this.fButtonMask & 2) == 2) {
            this.fSessionButton = new Button(choices, 16);
            this.fSessionButton.setText(Messages.RepositoryCertificateDialog_2);
            this.fSessionButton.setSelection(this.fSelectionState == 2);
        }
        if ((this.fButtonMask & 4) == 4) {
            this.fPermanentButton = new Button(choices, 16);
            this.fPermanentButton.setText(Messages.RepositoryCertificateDialog_3);
            this.fPermanentButton.setSelection(this.fSelectionState == 4);
        }
        Dialog.applyDialogFont((Control)parent);
        return main;
    }

    protected void okPressed() {
        if (this.fRejectButton != null && this.fRejectButton.getSelection()) {
            this.fSelectionState = 1;
        } else if (this.fSessionButton != null && this.fSessionButton.getSelection()) {
            this.fSelectionState = 2;
        } else if (this.fPermanentButton != null && this.fPermanentButton.getSelection()) {
            this.fSelectionState = 4;
        } else {
            throw new IllegalStateException();
        }
        super.okPressed();
    }

    public int getSelection() {
        return this.fSelectionState;
    }
}

