/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointManager;
import com.ibm.team.process.internal.rcp.ui.IElementCollector;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessUIPreferenceStore;
import com.ibm.team.process.internal.rcp.ui.RepositoryProxyListener;
import com.ibm.team.process.internal.rcp.ui.TeamRepositoryPersistanceManager;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IExternalUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.query.BaseContributorQueryModel;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.service.IQueryService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ProcessRCPUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.team.process.rcp.ui";
    public static final String PREF_TEAM_ARTIFACTS_NAVIGATOR_ACTIVE_FILTER = "teamArtifactsNavigator.activeFilter";
    public static final int CUSTOM = 0;
    public static final int MY_TEAM_AREAS = 1;
    public static final int ALL_TEAM_AREAS = 2;
    private static int MAX_SIZE = 2000;
    private ExtensionPointManager fExtensionPointManager;
    private ProcessUIPreferenceStore fProcessPreferenceStore;
    private TeamRepositoryPersistanceManager fTeamRepositoryPersistanceManager;
    private static ProcessRCPUIPlugin fgDefault;

    public static ProcessRCPUIPlugin getDefault() {
        return fgDefault;
    }

    public ProcessRCPUIPlugin() {
        fgDefault = this;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.fProcessPreferenceStore == null) {
            this.fProcessPreferenceStore = new ProcessUIPreferenceStore(this.getPluginPreferenceStore());
        }
        return this.fProcessPreferenceStore;
    }

    public IPersistentPreferenceStore getPluginPreferenceStore() {
        return (IPersistentPreferenceStore)super.getPreferenceStore();
    }

    public void log(Throwable exception) {
        this.log(Messages.ProcessRCPUIPlugin_2, exception);
    }

    public void log(String message, Throwable exception) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void stop(BundleContext context) throws Exception {
        ConnectedProjectAreaRegistry.disposeDefault();
        if (this.fExtensionPointManager != null) {
            this.fExtensionPointManager.dispose();
        }
        if (this.fTeamRepositoryPersistanceManager != null) {
            this.fTeamRepositoryPersistanceManager.dispose();
        }
        fgDefault = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fExtensionPointManager = new ExtensionPointManager(this.getBundle());
        this.fTeamRepositoryPersistanceManager = new TeamRepositoryPersistanceManager();
        new RepositoryProxyListener(context);
    }

    public ExtensionPointManager getExtensionPointManager() {
        return this.fExtensionPointManager;
    }

    private List fetchAndResolveContributors(String pattern, Collection properties, IPredicate archiveFilter, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000);
        try {
            ArrayList contributors = new ArrayList();
            final int pageSize = collector == null ? MAX_SIZE : 20;
            IClientLibraryContext context = (IClientLibraryContext)teamRepository;
            final IItemQuery allContributorsQuery = (IItemQuery)IItemQuery.FACTORY.newInstance((IQueryModel)BaseContributorQueryModel.ContributorQueryModel.ROOT);
            allContributorsQuery.orderByAsc((IField)BaseContributorQueryModel.ContributorQueryModel.ROOT.name());
            allContributorsQuery.setResultLimit(MAX_SIZE + 1);
            Object[] params = IQueryService.EMPTY_PARAMETERS;
            if (pattern != null) {
                IPredicate wildCard = BaseContributorQueryModel.ContributorQueryModel.ROOT.name()._ignoreCaseLike((IString)allContributorsQuery.newStringArg(), '\\');
                if (archiveFilter != null) {
                    allContributorsQuery.filter(archiveFilter._and(wildCard));
                } else {
                    allContributorsQuery.filter(wildCard);
                }
                pattern = this.escape(pattern);
                String wildCardPattern = null;
                wildCardPattern = pattern.length() > 1 && pattern.charAt(0) == ' ' ? "%" + pattern + '%' : String.valueOf(pattern) + '%';
                params = new Object[]{wildCardPattern};
            } else if (archiveFilter != null) {
                allContributorsQuery.filter(archiveFilter);
            }
            final Object[] queryParameters = params;
            final IQueryService queryService = (IQueryService)context.getServiceInterface(IQueryService.class);
            IItemQueryPage page = (IItemQueryPage)context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return queryService.queryItems(allContributorsQuery, queryParameters, pageSize);
                }
            }, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (page.getResultSize() > 0) {
                SubProgressMonitor pageMonitor = new SubProgressMonitor(monitor, 950);
                pageMonitor.beginTask("", 1000 * (int)Math.ceil((double)page.getResultSize() / 100.0));
                List items = teamRepository.itemManager().fetchPartialItems(page.getItemHandles(), 0, properties, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 1000));
                contributors.addAll(items);
                if (collector != null) {
                    collector.add(items.toArray());
                }
                while (page.hasNext()) {
                    final UUID token = page.getToken();
                    final int nextStartPosition = page.getNextStartPosition();
                    page = (IItemQueryPage)context.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                        public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                            return queryService.fetchPage(token, nextStartPosition, 100);
                        }
                    }, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 500));
                    items = teamRepository.itemManager().fetchPartialItems(page.getItemHandles(), 0, properties, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)pageMonitor, 500));
                    contributors.addAll(items);
                    if (contributors.size() > MAX_SIZE) {
                        contributors.remove(contributors.size() - 1);
                        if (collector == null) continue;
                        collector.add(items.subList(0, items.size() - 1).toArray());
                        continue;
                    }
                    if (collector == null) continue;
                    collector.add(items.toArray());
                }
                if (collector != null) {
                    if (page.getResultSize() > MAX_SIZE) {
                        collector.setMaximumSearchLimitReached(MAX_SIZE);
                    } else {
                        collector.setMaximumSearchLimitReached(-1);
                    }
                }
            } else if (collector != null) {
                collector.setMaximumSearchLimitReached(-1);
            }
            ArrayList arrayList = contributors;
            return arrayList;
        }
        finally {
            if (collector != null) {
                collector.done();
            }
            monitor.done();
        }
    }

    private String escape(String pattern) {
        pattern = pattern.replaceAll("\\_", "\\\\_");
        return pattern.replaceAll("\\%", "\\\\%");
    }

    public List resolveContributors(List handles, Collection properties, boolean includeArchived, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)teamRepository);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (handles.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List result = teamRepository.itemManager().fetchPartialItems(handles, 0, properties, monitor);
        return result;
    }

    public List fetchAllContributors(String pattern, Collection properties, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchAllContributors(pattern, properties, false, null, teamRepository, monitor);
    }

    public List fetchExternalUsers(String pattern, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!(teamRepository instanceof IClientLibraryContext) || pattern.trim().length() == 0) {
            if (collector != null) {
                collector.done();
            }
            return Collections.EMPTY_LIST;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("", 1000);
        IExternalUserRegistryManager manager = teamRepository.externalUserRegistryManager();
        int queryMax = manager.getMaxLimitForUserSearchQuery((IProgressMonitor)new SubProgressMonitor(monitor, 50));
        IExternalUser[] externalUsers = pattern.startsWith(" ") ? manager.findUsersByAnyName(pattern.substring(1), (IProgressMonitor)new SubProgressMonitor(monitor, 550)) : manager.findUsersByName(pattern, (IProgressMonitor)new SubProgressMonitor(monitor, 550));
        if (queryMax != -1 && externalUsers.length == queryMax + 1) {
            collector.setMaximumSearchLimitReached(queryMax);
        } else {
            collector.setMaximumSearchLimitReached(-1);
        }
        List<String> properties = Arrays.asList(IContributor.USERID_PROPERTY);
        List existing = this.fetchAllContributors(pattern, properties, true, null, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
        HashMap<String, IContributor> mapOfExisting = new HashMap<String, IContributor>(existing.size());
        for (IContributor existingContributor : existing) {
            mapOfExisting.put(existingContributor.getUserId(), existingContributor);
        }
        int updateSize = 5;
        ArrayList<IExternalUser> potential = new ArrayList<IExternalUser>(externalUsers.length);
        int pointer = 0;
        int i = 0;
        while (i < externalUsers.length) {
            IExternalUser externalUser = externalUsers[i];
            if (mapOfExisting.get(externalUser.getUserId()) == null) {
                potential.add(externalUser);
                int size = potential.size();
                if (size % updateSize == 0) {
                    collector.add(potential.subList(pointer, size).toArray());
                    pointer += updateSize;
                }
            }
            ++i;
        }
        int size = potential.size();
        if (size % updateSize != 0) {
            if (size > updateSize) {
                collector.add(potential.subList(pointer, size).toArray());
            } else {
                collector.add(potential.toArray());
            }
        }
        collector.done();
        return potential;
    }

    public List fetchAllContributors(String pattern, Collection properties, boolean includeArchived, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        Assert.isNotNull((Object)teamRepository);
        if (pattern != null && pattern.trim().length() == 0) {
            if (collector != null) {
                collector.done();
            }
            return Collections.EMPTY_LIST;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.resolveContributors(pattern, properties, includeArchived, collector, teamRepository, monitor);
    }

    private List resolveContributors(String pattern, Collection properties, boolean includeArchived, IElementCollector collector, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID repoID = teamRepository.getId();
        if (repoID == null || !teamRepository.loggedIn() || teamRepository.getErrorState() != 0) {
            if (collector != null) {
                collector.done();
            }
            return Collections.EMPTY_LIST;
        }
        if (pattern != null) {
            pattern = pattern.toLowerCase();
        }
        IPredicate archiveFilter = null;
        if (!includeArchived) {
            archiveFilter = BaseContributorQueryModel.ContributorQueryModel.ROOT.archived()._isFalse();
        }
        return this.fetchAndResolveContributors(pattern, properties, archiveFilter, collector, teamRepository, monitor);
    }

    public void setMaximumFetchSize(int maxSize) {
        MAX_SIZE = maxSize;
    }
}

