/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.internal.rcp.ui.SelectTeamAreasAction;
import com.ibm.team.process.internal.rcp.ui.ShowArchivedAction;
import com.ibm.team.process.internal.rcp.ui.ShowDeletedIterationsAction;
import com.ibm.team.process.internal.rcp.ui.TeamAreaFiltersDialog;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class OpenTeamAreaFiltersDialogAction
extends Action
implements IMenuCreator {
    public static final String CUSTOM_TEAM_AREA_FILTER_MEMENTO = "customTeamAreaFilterMemento";
    private Shell fShell;
    private Menu fMenu;
    private SelectTeamAreasAction fSelectMyTeamAreasAction;
    private SelectTeamAreasAction fSelectAllTeamAreasAction;
    private SelectTeamAreasAction fSelectCustomTeamAreasAction;
    private ShowArchivedAction fShowArchivedAction;
    private ShowDeletedIterationsAction fShowDeletedAction;

    public OpenTeamAreaFiltersDialogAction(Shell shell) {
        this.fShell = shell;
        this.setMenuCreator(this);
        this.fSelectMyTeamAreasAction = new SelectTeamAreasAction(1);
        this.fSelectAllTeamAreasAction = new SelectTeamAreasAction(2);
        this.fSelectCustomTeamAreasAction = new SelectTeamAreasAction(0);
        this.fShowArchivedAction = new ShowArchivedAction();
        this.fShowDeletedAction = new ShowDeletedIterationsAction();
        Preferences preferences = ProcessRCPUIPlugin.getDefault().getPluginPreferences();
        int filterType = preferences.getInt("teamArtifactsNavigator.activeFilter");
        switch (filterType) {
            case 0: {
                this.fSelectCustomTeamAreasAction.setChecked(true);
                this.fSelectCustomTeamAreasAction.run();
                break;
            }
            case 1: {
                this.fSelectMyTeamAreasAction.setChecked(true);
                this.fSelectMyTeamAreasAction.run();
                break;
            }
            case 2: {
                this.fSelectAllTeamAreasAction.setChecked(true);
                this.fSelectAllTeamAreasAction.run();
            }
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/copied/elcl16/filter_ps.gif");
    }

    public String getToolTipText() {
        return Messages.OpenTeamAreaFiltersDialogAction_2;
    }

    public String getText() {
        return Messages.OpenTeamAreaFiltersDialogAction_3;
    }

    public void run() {
        IPreferenceStore preferences = ProcessRCPUIPlugin.getDefault().getPreferenceStore();
        if (preferences.getInt("teamArtifactsNavigator.activeFilter") != 0) {
            this.fSelectCustomTeamAreasAction.run();
        }
        TeamAreaFiltersDialog filter = new TeamAreaFiltersDialog(this.fShell);
        filter.open();
        String stringMemento = preferences.getString("connectedProjectAreasMemento");
        preferences.setValue(CUSTOM_TEAM_AREA_FILTER_MEMENTO, stringMemento);
        this.fSelectCustomTeamAreasAction.setChecked(true);
        this.fSelectAllTeamAreasAction.setChecked(false);
        this.fSelectMyTeamAreasAction.setChecked(false);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ActionContributionItem item = new ActionContributionItem((IAction)this.fSelectAllTeamAreasAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fSelectMyTeamAreasAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fSelectCustomTeamAreasAction);
        item.fill(this.fMenu, -1);
        new MenuItem(this.fMenu, 2);
        item = new ActionContributionItem((IAction)this);
        item.fill(this.fMenu, -1);
        new MenuItem(this.fMenu, 2);
        item = new ActionContributionItem((IAction)this.fShowArchivedAction);
        item.fill(this.fMenu, -1);
        item = new ActionContributionItem((IAction)this.fShowDeletedAction);
        item.fill(this.fMenu, -1);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }
}

