/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.internal.ImagePool;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.viewerutilities.ContextMenuHelper;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.internal.rcp.ui.DelegatingComparer;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathContentProvider;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathLabelProvider;
import com.ibm.team.process.internal.rcp.ui.DelegatingTreePathSorter;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.internal.rcp.ui.IDomainNavigator;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.ContextMenuHelper2;
import com.ibm.team.process.rcp.ui.RepositoryCreationWizard;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;

public abstract class DomainNavigator
extends ViewPart
implements IDomainNavigator,
IShowInTarget {
    private Map fValidationJobs = new HashMap();
    private TreeViewer fTreeViewer;
    private Category fCategory;
    private DomainManager fDomainManager;
    private SashForm fSashForm;
    private Composite fLinkComposite;
    private ITeamRepositoryService.IRepositoryServiceListener fRepositoryServiceListener;
    private Action fShowLinksAction;
    private Label fLinksDescription;
    protected static final String fgViewActionsGroupMarker = "viewActions";

    public ISelection getOriginalSelection() {
        return ((DomainSelection)this.getSite().getSelectionProvider().getSelection()).getOriginal();
    }

    public void createPartControl(Composite parent) {
        this.fDomainManager = new DomainManager(this, this.fCategory, ConnectedProjectAreaRegistry.getDefault());
        this.fSashForm = new SashForm(parent, 66048);
        this.fSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        DelegatingTreePathContentProvider delegatingContentProvider = new DelegatingTreePathContentProvider(this.fDomainManager, this.fCategory);
        DelegatingTreePathLabelProvider delegatingLabelProvider = new DelegatingTreePathLabelProvider(this.fDomainManager, this.fCategory, (IElementRemovedNotifier)delegatingContentProvider);
        this.fTreeViewer = new TreeViewer((Composite)this.fSashForm, 514){

            protected void associate(Object newData, Item item) {
                Object currentData = item.getData();
                if (currentData instanceof IItem && newData instanceof IItemHandle && !((IItemHandle)newData).hasFullState() && ((ITeamRepository)((IItem)currentData).getOrigin()).loggedIn()) {
                    return;
                }
                super.associate(newData, item);
            }
        };
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)delegatingContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)delegatingLabelProvider);
        this.fTreeViewer.setSorter((ViewerSorter)new DelegatingTreePathSorter(this.fDomainManager));
        this.fTreeViewer.setComparer((IElementComparer)new DelegatingComparer(this.fDomainManager));
        this.fTreeViewer.setInput((Object)this.fDomainManager);
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DomainNavigator.this.openSelection(DomainNavigator.this.getSite().getSelectionProvider().getSelection(), false);
            }
        });
        this.fTreeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                DomainNavigator.this.validateCategoryElement(event.getElement());
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)new ConvertingSelectionProvider((ISelectionProvider)this.fTreeViewer){

            protected ISelection convertFrom(ISelection viewerSelection) {
                return DomainNavigator.this.convertSelection2Model(viewerSelection);
            }
        });
        this.fLinkComposite = new Composite((Composite)this.fSashForm, 0);
        this.fLinkComposite.setLayout((Layout)new GridLayout());
        this.fLinkComposite.setLayoutData((Object)new GridData(1808));
        this.fLinkComposite.setBackground(this.fLinkComposite.getDisplay().getSystemColor(25));
        this.fSashForm.setWeights(new int[]{75, 25});
        this.createSetupLinks(this.fLinkComposite);
        this.createStandardActions();
        this.hookContextMenu(this.fTreeViewer);
        this.addDragSupport(this.fTreeViewer);
        this.addDropSupport(this.fTreeViewer);
        this.addToolBar();
        this.updateTopComposite();
        new TooltipSupport(this.fTreeViewer.getControl(), true, true){
            private Domain fCurrentDomain;
            private TreePath fPath;

            protected Object mapElement(int x, int y) {
                Object element = super.mapElement(x, y);
                this.fCurrentDomain = null;
                this.fPath = null;
                if (element != null) {
                    LinkedList<Object> pathelems = new LinkedList<Object>();
                    pathelems.add(element);
                    TreeItem item = DomainNavigator.this.fTreeViewer.getTree().getItem(new Point(x, y));
                    while (item.getParentItem() != null) {
                        item = item.getParentItem();
                        Object data = item.getData();
                        pathelems.addFirst(data);
                        if (!(data instanceof DomainSubtreeRoot)) continue;
                        this.fCurrentDomain = ((DomainSubtreeRoot)data).getDomain();
                    }
                    this.fPath = new TreePath(pathelems.toArray());
                    if (this.fCurrentDomain == null) {
                        this.fCurrentDomain = DomainNavigator.this.fDomainManager.getDomain(element);
                    }
                    if (this.fCurrentDomain != null) {
                        try {
                            element = this.fCurrentDomain.convertToModel(element);
                        }
                        catch (RuntimeException e) {
                            DomainNavigator.this.discardDomain(this.fCurrentDomain, e, true);
                        }
                    }
                }
                return element;
            }

            protected String getMarkup(Object element, boolean isFocus) {
                String markup = super.getMarkup(element, isFocus);
                if (markup != null) {
                    return markup;
                }
                if (element != null && this.fCurrentDomain != null) {
                    try {
                        return this.fCurrentDomain.getHoverMarkupForObject(element);
                    }
                    catch (RuntimeException e) {
                        DomainNavigator.this.discardDomain(this.fCurrentDomain, e, true);
                    }
                }
                return null;
            }

            protected void openRequested(Object element) {
                TreeSelection treesel = new TreeSelection(this.fPath);
                ArrayList<Object> elts = new ArrayList<Object>();
                elts.add(element);
                DomainSelection ds = new DomainSelection((IStructuredSelection)treesel, elts);
                DomainNavigator.this.openSelection((ISelection)ds, true);
            }
        };
        this.fRepositoryServiceListener = new ITeamRepositoryService.IRepositoryServiceListener(){

            public void addedRepository(ITeamRepository repository) {
                this.update();
            }

            public void removedRepository(ITeamRepository repository) {
                this.update();
            }

            private void update() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (!DomainNavigator.this.fSashForm.isDisposed()) {
                            DomainNavigator.this.updateTopComposite();
                        }
                    }
                });
            }
        };
        TeamPlatform.getTeamRepositoryService().addRepositoryServiceListener(this.fRepositoryServiceListener);
    }

    private void createSetupLinks(final Composite parent) {
        this.fLinksDescription = new Label(parent, 64);
        this.fLinksDescription.setLayoutData((Object)new GridData());
        this.fLinksDescription.setBackground(parent.getBackground());
        this.fLinksDescription.setText(Messages.DomainNavigator_0);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                GridData data = new GridData();
                data.widthHint = parent.getSize().x;
                DomainNavigator.this.fLinksDescription.setLayoutData((Object)data);
            }
        });
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.team.process.rcp.ui", "internalTANLinks");
        int i = 0;
        while (i < configurationElements.length) {
            final IConfigurationElement element = configurationElements[i];
            final String label = element.getAttribute("label");
            if (label != null && label.trim().length() > 0) {
                final Link link = this.createLink(parent, label);
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            Runnable runnable = (Runnable)element.createExecutableExtension("runnableClass");
                            runnable.run();
                        }
                        catch (CoreException exception) {
                            ErrorDialog.openError((Shell)link.getShell(), (String)Messages.DomainNavigator_5, (String)NLS.bind((String)Messages.DomainNavigator_6, (Object)label), (IStatus)exception.getStatus());
                            ProcessRCPUIPlugin.getDefault().log(exception);
                        }
                    }
                });
            }
            ++i;
        }
        Link link = this.createLink(parent, Messages.DomainNavigator_18);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardDialog wd = new WizardDialog(((Control)event.getSource()).getShell(), (IWizard)new RepositoryCreationWizard());
                wd.open();
            }
        });
        new Label(parent, 0);
        link = this.createLink(parent, Messages.DomainNavigator_17);
        final Display display = link.getDisplay();
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        DomainNavigator.this.openFirstStepsWelcomePage();
                    }
                });
            }
        });
    }

    private Link createLink(Composite parent, String linkText) {
        Link link = new Link(parent, 0);
        link.setBackground(parent.getBackground());
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 1;
        gridData.widthHint = 500;
        link.setLayoutData((Object)gridData);
        link.setText(NLS.bind((String)"<a href=\"\">{0}</a>", (Object)linkText));
        return link;
    }

    private void updateTopComposite() {
        if (TeamPlatform.getTeamRepositoryService().getTeamRepositories().length == 0) {
            this.fTreeViewer.getControl().setVisible(false);
            this.fLinkComposite.setVisible(true);
            this.fSashForm.setMaximizedControl((Control)this.fLinkComposite);
            this.fShowLinksAction.setEnabled(false);
            this.fShowLinksAction.setChecked(false);
            this.fLinksDescription.setText(Messages.DomainNavigator_0);
        } else {
            this.fLinksDescription.setText(Messages.DomainNavigator_19);
            this.showLinks(false);
        }
    }

    public void validateCategoryElement(final Object element) {
        if (this.fCategory.isCategoryElement(element) && !this.fCategory.isValid(element) && !this.fValidationJobs.containsKey(element)) {
            Job job = new Job(this.fCategory.getValidationJobName(element)){

                protected IStatus run(IProgressMonitor monitor) {
                    DomainNavigator.this.fCategory.makeValid(element, monitor);
                    new UIJob(Messages.DomainNavigator_8){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (DomainNavigator.this.fTreeViewer.getTree().isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            if (DomainNavigator.this.fCategory.isValid(element)) {
                                DomainNavigator.this.fTreeViewer.expandToLevel(element, 1);
                            } else {
                                DomainNavigator.this.fTreeViewer.collapseToLevel(element, -1);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    DomainNavigator.this.fValidationJobs.remove(element);
                    return Status.OK_STATUS;
                }
            };
            this.fValidationJobs.put(element, job);
            job.schedule();
        }
    }

    private void createStandardActions() {
        ContextMenuHelper2.createStandardActions((IViewPart)this, IMenuOperationTarget.ALL_TYPES);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider = this.getSite().getSelectionProvider();
        if (selectionProvider != null) {
            selectionProvider.setSelection(selection);
        }
    }

    public boolean show(ShowInContext context) {
        if (!(context.getSelection() instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)context.getSelection();
        IStructuredSelection internalSelection = (IStructuredSelection)this.convertModel2Selection((ISelection)selection);
        if (selection.size() != internalSelection.size()) {
            return false;
        }
        this.setSelection((ISelection)internalSelection);
        return true;
    }

    protected void setCategory(Category category) {
        if (category == this.fCategory) {
            return;
        }
        this.fCategory = category;
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public Domain[] getDomains() {
        return this.fDomainManager.getDomains();
    }

    DomainManager getDomainManager() {
        return this.fDomainManager;
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public Control getTopControl() {
        return this.fSashForm.getMaximizedControl();
    }

    public IWorkbenchPart getWorkbenchPart() {
        return this;
    }

    protected void addToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager viewToolBarManager = bars.getToolBarManager();
        Action collapseAll = new Action(){

            public void run() {
                DomainNavigator.this.fTreeViewer.collapseAll();
            }
        };
        collapseAll.setToolTipText(Messages.DomainNavigator_9);
        collapseAll.setImageDescriptor(ImagePool.COLLAPSE_ALL);
        viewToolBarManager.add((IAction)collapseAll);
        viewToolBarManager.add((IContributionItem)new GroupMarker(fgViewActionsGroupMarker));
        viewToolBarManager.appendToGroup(fgViewActionsGroupMarker, (IContributionItem)new Separator());
        viewToolBarManager.add((IContributionItem)new GroupMarker("additions"));
        viewToolBarManager.appendToGroup("additions", (IContributionItem)new Separator());
        this.fShowLinksAction = new Action(){

            public void run() {
                DomainNavigator.this.showLinks(this.isChecked());
            }
        };
        this.fShowLinksAction.setToolTipText(Messages.DomainNavigator_20);
        this.fShowLinksAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/elcl16/get_start.gif"));
        this.fShowLinksAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/dlcl16/get_start.gif"));
        this.fShowLinksAction.setChecked(false);
        viewToolBarManager.appendToGroup("additions", (IAction)this.fShowLinksAction);
    }

    protected void showLinks(boolean showLinks) {
        if (showLinks) {
            this.fTreeViewer.getControl().setVisible(true);
            this.fLinkComposite.setVisible(true);
            this.fSashForm.setMaximizedControl(null);
        } else {
            this.fTreeViewer.getControl().setVisible(true);
            this.fLinkComposite.setVisible(false);
            this.fSashForm.setMaximizedControl(this.fTreeViewer.getControl());
        }
        this.fShowLinksAction.setEnabled(true);
    }

    ISelection convertSelection2Model(ISelection selection) {
        return this.convertSelection(selection, false);
    }

    ISelection convertModel2Selection(ISelection selection) {
        return this.convertSelection(selection, true);
    }

    private ISelection convertSelection(ISelection selection, boolean isModelSelection) {
        if (selection instanceof ITreeSelection) {
            ITreeSelection ss = (ITreeSelection)selection;
            TreePath[] paths = ss.getPaths();
            ArrayList<Object> result = new ArrayList<Object>(paths.length);
            int i = 0;
            while (i < paths.length) {
                Object object = paths[i].getLastSegment();
                if (paths[i].getSegmentCount() == 1 && this.fCategory.isCategoryElement(object)) {
                    result.add(this.fCategory.convertModel(object));
                } else {
                    Domain domain = null;
                    domain = paths[i].getSegmentCount() > 1 && paths[i].getSegment(1) instanceof DomainSubtreeRoot ? ((DomainSubtreeRoot)paths[i].getSegment(1)).getDomain() : (paths[i].getSegmentCount() > 1 && paths[i].getSegment(0) instanceof Domain ? (Domain)paths[i].getSegment(0) : this.fDomainManager.getDomain(object));
                    if (domain != null) {
                        Object r = null;
                        try {
                            if (isModelSelection) {
                                r = domain.convertToSelection(object);
                            } else {
                                DomainSubtreeRoot doro = null;
                                if (object instanceof DomainSubtreeRoot) {
                                    doro = (DomainSubtreeRoot)object;
                                }
                                r = domain.convertToModel(object);
                                if (doro != null && r == object) {
                                    r = doro;
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            this.discardDomain(domain, e, true);
                        }
                        if (r != null) {
                            result.add(r);
                        }
                    }
                }
                ++i;
            }
            return new DomainSelection((IStructuredSelection)ss, result);
        }
        return selection;
    }

    private void hookContextMenu(TreeViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ContextMenuHelper.buildStandardContextMenuGroups((IMenuManager)manager);
                ContextMenuHelper2.addStandardActions(manager, (IViewPart)DomainNavigator.this, IMenuOperationTarget.ALL_TYPES);
                DomainNavigator.this.addDomainActions(manager);
            }
        });
        final Menu menu = menuMgr.createContextMenu(viewer.getControl());
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DomainNavigator.this.getSite().getSelectionProvider().getSelection();
                if (selection.getFirstElement() instanceof IProjectAreaHandle) {
                    menu.setDefaultItem(null);
                } else {
                    menu.setDefaultItem(DomainNavigator.this.findItemForAction(menu, "jazz.open"));
                }
            }
        });
        this.getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        viewer.getControl().setMenu(menu);
    }

    private MenuItem findItemForAction(Menu menu, String id) {
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            ActionContributionItem ci;
            MenuItem item = items[i];
            if (item.getData() instanceof ActionContributionItem && id.equals((ci = (ActionContributionItem)item.getData()).getId())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    private void addDomainActions(final IMenuManager manager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof DomainSelection) {
            DomainSelection domsel = (DomainSelection)selection;
            TreeSelection origtreesel = (TreeSelection)domsel.getOriginal();
            Domain domain = null;
            TreePath[] paths = origtreesel.getPaths();
            int i = 0;
            while (i < paths.length) {
                Domain actdomain = null;
                if (paths[i].getSegmentCount() == 1 && this.fCategory.isCategoryElement(paths[i].getFirstSegment())) {
                    this.fCategory.contributeContextMenuActions((IWorkbenchSite)this.getSite(), manager, (IStructuredSelection)selection);
                    ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
                    return;
                }
                actdomain = this.determineDomain(paths[i]);
                if (actdomain == null) {
                    ProcessRCPUIPlugin.getDefault().log(Messages.DomainNavigator_14, new NullPointerException());
                    return;
                }
                if (domain == null) {
                    domain = actdomain;
                }
                if (domain != actdomain) {
                    return;
                }
                ++i;
            }
            if (domain == null) {
                return;
            }
            final Domain finalDomain = domain;
            final IStructuredSelection origsel = domsel.getOriginal();
            ContextMenuHelper.addNewSubmenu((IMenuManager)manager, (boolean)false);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    finalDomain.contributeContextMenuActions(manager, origsel);
                }
            });
        }
    }

    private void addDropSupport(TreeViewer treeViewer) {
        ViewerDropAdapter dropAdapter = new ViewerDropAdapter((Viewer)this.fTreeViewer){
            private Domain fDropDomain;

            public boolean performDrop(Object data) {
                if (!(data instanceof ISelection)) {
                    return false;
                }
                if (this.fDropDomain == null) {
                    return false;
                }
                Object target = this.getCurrentTarget();
                if (target != null) {
                    try {
                        return this.fDropDomain.performDrop(target, (ISelection)data, this.getCurrentOperation());
                    }
                    catch (RuntimeException e) {
                        DomainNavigator.this.discardDomain(this.fDropDomain, e, true);
                        this.fDropDomain = null;
                    }
                }
                return false;
            }

            private Domain getDropDomain(Object dropTarget) {
                if (dropTarget == null || DomainNavigator.this.fCategory.isCategoryElement(dropTarget)) {
                    return null;
                }
                TreePath dropTargetPath = this.createTreePath((TreeItem)DomainNavigator.this.fTreeViewer.testFindItem(dropTarget));
                return DomainNavigator.this.determineDomain(dropTargetPath);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (!LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                if (this.fDropDomain == null) {
                    return false;
                }
                if (target != null) {
                    try {
                        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                        return this.fDropDomain.validateDrop(target, selection, operation);
                    }
                    catch (RuntimeException e) {
                        DomainNavigator.this.discardDomain(this.fDropDomain, e, true);
                        this.fDropDomain = null;
                    }
                }
                return false;
            }

            public void dragEnter(DropTargetEvent event) {
                if (event.item instanceof TreeItem) {
                    this.fDropDomain = this.getDropDomain(this.getCurrentTarget());
                }
                this.updateEventDetail(event);
            }

            private void updateEventDetail(DropTargetEvent event) {
                int operations = 0;
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                if (this.fDropDomain != null) {
                    operations |= this.fDropDomain.getSupportedOperationsForSelection(selection);
                }
                this.updateEventDetail(event, operations);
            }

            public void dragOver(DropTargetEvent event) {
                Object oldTarget = this.getCurrentTarget();
                int oldLocation = this.getCurrentLocation();
                super.dragOver(event);
                if (event.item instanceof TreeItem && (oldTarget != this.getCurrentTarget() || this.getCurrentLocation() != oldLocation)) {
                    Domain oldDomain = this.fDropDomain;
                    this.fDropDomain = this.getDropDomain(this.getCurrentTarget());
                    if (oldDomain != this.fDropDomain) {
                        this.updateEventDetail(event);
                    }
                }
            }

            private TreePath createTreePath(TreeItem item) {
                ArrayList<Object> path = new ArrayList<Object>();
                TreeItem current = item;
                while (current != null) {
                    path.add(0, current.getData());
                    current = current.getParentItem();
                }
                return new TreePath(path.toArray());
            }

            private void updateEventDetail(DropTargetEvent event, int operations) {
                event.detail = (event.operations & 4) != 0 && (operations & 4) != 0 ? 4 : ((event.operations & 1) != 0 && (operations & 1) != 0 ? 1 : ((event.operations & 2) != 0 && (operations & 2) != 0 ? 2 : ((event.operations & 0x10) != 0 && (operations & 0x10) != 0 ? 16 : 0)));
            }
        };
        dropAdapter.setFeedbackEnabled(false);
        treeViewer.addDropSupport(23, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)dropAdapter);
    }

    private void addDragSupport(TreeViewer treeViewer) {
        new ViewerDragSupport((Viewer)treeViewer, 7){

            public ISelection getSelection() {
                ISelectionProvider provider = DomainNavigator.this.getSite().getSelectionProvider();
                if (provider != null) {
                    return provider.getSelection();
                }
                return super.getSelection();
            }
        };
    }

    public void openSelection(ISelection selection, boolean openContainers) {
        HashMap<Domain, ArrayList<Object>> selections = new HashMap<Domain, ArrayList<Object>>();
        if (selection instanceof DomainSelection) {
            DomainSelection domsel = (DomainSelection)selection;
            TreeSelection treeSelection = (TreeSelection)domsel.getOriginal();
            TreePath[] paths = treeSelection.getPaths();
            Object firstElement = domsel.getFirstElement();
            if (domsel.size() == 1 && this.fCategory.isCategoryElement(firstElement)) {
                TreePath path;
                TreePath treePath = path = paths != null && paths.length == 1 ? paths[0] : null;
                if (path == null || path.getSegmentCount() == 1) {
                    if (!openContainers || !this.fCategory.open((IWorkbenchSite)this.getSite(), firstElement)) {
                        this.fTreeViewer.setExpandedState(firstElement, !this.fTreeViewer.getExpandedState(firstElement));
                    }
                } else {
                    this.fCategory.open((IWorkbenchSite)this.getSite(), firstElement);
                }
                return;
            }
            int i = 0;
            while (i < paths.length) {
                Domain domain;
                if (!this.fCategory.isCategoryElement(paths[i].getLastSegment()) && (domain = this.determineDomain(paths[i])) != null) {
                    Object elem = domain.convertToModel(paths[i].getLastSegment());
                    ArrayList<Object> list = (ArrayList<Object>)selections.get(domain);
                    if (list == null) {
                        list = new ArrayList<Object>();
                    }
                    list.add(elem);
                    selections.put(domain, list);
                }
                ++i;
            }
            if (selections.isEmpty() && firstElement != null) {
                this.fTreeViewer.setExpandedState(firstElement, !this.fTreeViewer.getExpandedState(firstElement));
            }
            Iterator iterator = selections.entrySet().iterator();
            boolean opened = false;
            while (iterator.hasNext()) {
                Map.Entry domainEntry = iterator.next();
                StructuredSelection s = new StructuredSelection((List)domainEntry.getValue());
                try {
                    if (!((Domain)domainEntry.getKey()).open(this.getSite(), (IStructuredSelection)s)) continue;
                    opened = true;
                }
                catch (RuntimeException e) {
                    ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainNavigator_15, (Object)((Domain)domainEntry.getKey()).getName()), e);
                    return;
                }
            }
            if (domsel.size() == 1 && !opened) {
                this.fTreeViewer.setExpandedState(treeSelection.getFirstElement(), !this.fTreeViewer.getExpandedState(treeSelection.getFirstElement()));
            }
        }
    }

    protected void discardDomain(Domain domain, RuntimeException e, boolean refresh) {
        ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainNavigator_16, (Object)domain.getName()), e);
        this.fDomainManager.unloadDomain(domain, refresh);
    }

    public void dispose() {
        IElementComparer comparer = this.fTreeViewer.getComparer();
        if (comparer instanceof DelegatingComparer) {
            ((DelegatingComparer)comparer).dispose();
        }
        this.setSelection(null);
        if (this.fDomainManager != null) {
            this.fDomainManager.dispose();
        }
        ContextMenuHelper2.removeStandardActions((IViewPart)this);
        TeamPlatform.getTeamRepositoryService().removeRepositoryServiceListener(this.fRepositoryServiceListener);
        super.dispose();
    }

    private boolean openFirstStepsWelcomePage() {
        IIntroManager introManager = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart intro = introManager.showIntro(null, false);
        if (intro == null) {
            return false;
        }
        IIntroURL url = IntroURLFactory.createIntroURL((String)"http://org.eclipse.ui.intro/showPage?id=firststeps");
        return url.execute();
    }

    private Domain determineDomain(TreePath treePath) {
        if (treePath.getSegmentCount() > 1 && treePath.getSegment(1) instanceof DomainSubtreeRoot) {
            return ((DomainSubtreeRoot)treePath.getSegment(1)).getDomain();
        }
        if (!this.fCategory.isCategoryElement(treePath.getFirstSegment())) {
            return this.fDomainManager.getDomain(treePath.getFirstSegment());
        }
        return null;
    }
}

