/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.rcp.core.extensionpoint.ExtensionPointHandler;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.internal.rcp.ui.IDomainNavigator;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistry;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DomainManager
extends ExtensionPointHandler {
    private static final String ATTR_ICON = "icon";
    protected static final String ATTR_NAME = "name";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_ID = "id";
    private IDomainNavigator fNavigator;
    private Category fCategory;
    private IConnectedProjectAreaRegistry fConnectedProjectAreaRegistry;
    private final List fDomains;
    private ResourceManager fResourceManager;

    public DomainManager(IDomainNavigator owner, Category category, IConnectedProjectAreaRegistry connectedProjectAreaRegistry) {
        super(ProcessRCPUIPlugin.getDefault().getExtensionPointManager(), "teamArtifactsNavigatorDomain", "teamArtifactsNavigatorDomain");
        this.fNavigator = owner;
        this.fCategory = category;
        this.fConnectedProjectAreaRegistry = connectedProjectAreaRegistry;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fDomains = new ArrayList();
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        Domain[] domains = this.getDomains();
        List list = this.fDomains;
        synchronized (list) {
            this.fDomains.clear();
        }
        int i = 0;
        while (i < domains.length) {
            block9: {
                try {
                    try {
                        domains[i].dispose();
                    }
                    catch (RuntimeException e) {
                        ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainManager_5, (Object)domains[i].getName()), e);
                        domains[i].setDisposed();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    domains[i].setDisposed();
                    throw throwable;
                }
                domains[i].setDisposed();
            }
            ++i;
        }
        this.fResourceManager.dispose();
        this.fNavigator = null;
        this.fCategory = null;
        this.fConnectedProjectAreaRegistry = null;
    }

    public Domain getDomain(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof Domain) {
            return (Domain)element;
        }
        Domain ret = null;
        ArrayList<Domain> toDisable = new ArrayList<Domain>();
        Domain[] domains = this.getDomains();
        int i = 0;
        while (i < domains.length) {
            Domain domain = domains[i];
            try {
                if (domain.contains(element)) {
                    ret = domain;
                    break;
                }
            }
            catch (Exception e) {
                ProcessRCPUIPlugin.getDefault().log(NLS.bind((String)Messages.DomainManager_6, (Object)domain.getName()), e);
                toDisable.add(domain);
            }
            ++i;
        }
        this.removeDomains(toDisable);
        return ret;
    }

    Domain[] getSupportingDomains(final Category category) {
        Domain[] domains = this.getDomains();
        final ArrayList supportingDomains = new ArrayList();
        final ArrayList toDisable = new ArrayList();
        int i = 0;
        while (i < domains.length) {
            final Domain domain = domains[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)Messages.DomainManager_7, (Object)domain.getName())){

                public void run() throws Exception {
                    if (domain.supportsCategory(category)) {
                        supportingDomains.add(domain);
                    }
                }

                public void handleException(Throwable e) {
                    toDisable.add(domain);
                    super.handleException(e);
                }
            });
            ++i;
        }
        this.removeDomains(toDisable);
        return supportingDomains.toArray(new Domain[supportingDomains.size()]);
    }

    private void removeDomains(List toDisable) {
        for (Domain domain : toDisable) {
            this.unloadDomain(domain, false);
        }
        if (toDisable.size() > 0) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DomainManager.this.fNavigator.refresh();
                }
            });
        }
    }

    Domain[] getNonSupportingDomains(final Category category) {
        Domain[] domains = this.getDomains();
        final ArrayList toDisable = new ArrayList();
        final ArrayList nonSupportingDomains = new ArrayList();
        int i = 0;
        while (i < domains.length) {
            final Domain domain = domains[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(NLS.bind((String)Messages.DomainManager_8, (Object)domain.getName())){

                public void run() throws Exception {
                    if (!domain.supportsCategory(category) && !domain.confineToSupportedCategories()) {
                        nonSupportingDomains.add(domain);
                    }
                }

                public void handleException(Throwable e) {
                    toDisable.add(domain);
                    super.handleException(e);
                }
            });
            ++i;
        }
        this.removeDomains(toDisable);
        return nonSupportingDomains.toArray(new Domain[nonSupportingDomains.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Domain[] getDomains() {
        List list = this.fDomains;
        synchronized (list) {
            return this.fDomains.toArray(new Domain[this.fDomains.size()]);
        }
    }

    public Category getCategory() {
        return this.fCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object elementAdded(IConfigurationElement domain) {
        try {
            Domain d = (Domain)domain.createExecutableExtension(ATTR_CLASS);
            String id = domain.getAttribute(ATTR_ID);
            d.setId(id);
            String name = domain.getAttribute(ATTR_NAME);
            d.setName(name);
            String iconPath = domain.getAttribute(ATTR_ICON);
            if (iconPath != null) {
                ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)domain.getNamespaceIdentifier(), (String)iconPath);
                if (descriptor == null) {
                    descriptor = ImageDescriptor.getMissingImageDescriptor();
                }
                d.setImage(JazzResources.getImageWithDefault((ResourceManager)this.fResourceManager, (ImageDescriptor)descriptor));
            }
            d.configure(this.fNavigator.getWorkbenchPart(), this.fCategory, this.fConnectedProjectAreaRegistry);
            List list = this.fDomains;
            synchronized (list) {
                this.fDomains.add(d);
            }
            this.fNavigator.refresh();
        }
        catch (CoreException e) {
            ProcessRCPUIPlugin.getDefault().log(Messages.DomainManager_9, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void elementsRemoved(List removed) {
        boolean needsRefresh = false;
        for (IConfigurationElement element : removed) {
            String name = element.getAttribute(ATTR_NAME);
            Domain[] domains = this.getDomains();
            int i = 0;
            while (i < domains.length) {
                Domain domain = domains[i];
                if (domain.getName().equals(name)) {
                    List list = this.fDomains;
                    synchronized (list) {
                        this.fDomains.remove(domain);
                        needsRefresh = true;
                    }
                }
                ++i;
            }
        }
        if (needsRefresh) {
            this.fNavigator.refresh();
        }
    }

    public void unloadDomain(Domain domain) {
        this.unloadDomain(domain, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDomain(Domain domain, boolean refresh) {
        block12: {
            if (domain == null) {
                return;
            }
            List list = this.fDomains;
            synchronized (list) {
                this.fDomains.remove(domain);
            }
            try {
                try {
                    domain.dispose();
                }
                catch (Exception exception) {
                    domain.setDisposed();
                    if (refresh) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                DomainManager.this.fNavigator.refresh();
                            }
                        });
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                domain.setDisposed();
                if (refresh) {
                    Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
                }
                throw throwable;
            }
            domain.setDisposed();
            if (refresh) {
                Display.getDefault().asyncExec(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }
}

