/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.AbstractDelegatingTreePathContentProvider;
import com.ibm.team.process.internal.rcp.ui.DomainManager;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.process.rcp.ui.teamnavigator.Category;
import com.ibm.team.process.rcp.ui.teamnavigator.Domain;
import com.ibm.team.process.rcp.ui.teamnavigator.DomainSubtreeRoot;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class DelegatingTreePathContentProvider2
extends AbstractDelegatingTreePathContentProvider {
    public DelegatingTreePathContentProvider2(DomainManager domainManager, Category category) {
        super(domainManager, category);
        this.fInputChangedForDomain = new HashMap();
    }

    public Object[] getChildren(TreePath parentPath) {
        block3: {
            Object parentElement = parentPath.getFirstSegment();
            Domain domain = null;
            try {
                if (parentElement instanceof DomainSubtreeRoot) {
                    domain = ((DomainSubtreeRoot)parentElement).getDomain();
                    this.callInputChanged(domain);
                    return domain.getContentProvider().getChildren(parentPath);
                }
            }
            catch (Throwable e) {
                if (domain == null) break block3;
                this.discardDomain(domain, e, true, true);
            }
        }
        return EMPTY;
    }

    public TreePath[] getParents(Object element) {
        if (element instanceof DomainSubtreeRoot) {
            return new TreePath[]{new TreePath(EMPTY)};
        }
        Domain[] domains = this.fDomainManager.getDomains();
        ArrayList paths = new ArrayList();
        int i = 0;
        while (i < domains.length) {
            if (domains[i].contains(element)) {
                try {
                    ITreePathContentProvider cp = domains[i].getContentProvider();
                    TreePath[] parents = cp.getParents(element);
                    if (parents != null) {
                        paths.addAll(Arrays.asList(parents));
                    }
                }
                catch (RuntimeException e) {
                    this.discardDomain(domains[i], e, true, true);
                }
            }
            ++i;
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    public boolean hasChildren(TreePath path) {
        Object element = path.getLastSegment();
        if (element instanceof PendingUpdateAdapter) {
            return false;
        }
        if (element instanceof DomainSubtreeRoot) {
            Domain domain = ((DomainSubtreeRoot)element).getDomain();
            try {
                return domain.getContentProvider().hasChildren(path);
            }
            catch (RuntimeException e) {
                this.discardDomain(domain, e, true, true);
                return false;
            }
        }
        Domain domain = null;
        domain = path.getSegmentCount() > 0 && path.getFirstSegment() instanceof DomainSubtreeRoot ? ((DomainSubtreeRoot)path.getFirstSegment()).getDomain() : this.fDomainManager.getDomain(element);
        if (domain != null) {
            try {
                return domain.getContentProvider().hasChildren(path);
            }
            catch (RuntimeException e) {
                this.discardDomain(domain, e, true, true);
                return false;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] computeChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        Object[] categoryElements;
        DomainManager domainManager;
        Category category;
        DelegatingTreePathContentProvider2 delegatingTreePathContentProvider2 = this;
        synchronized (delegatingTreePathContentProvider2) {
            category = this.fCategory;
            domainManager = this.fDomainManager;
            if (category == null || domainManager == null) {
                return EMPTY;
            }
            categoryElements = category.getCategoryElements();
        }
        if (categoryElements != null && categoryElements.length > 1) {
            return categoryElements;
        }
        Object categoryElement = categoryElements[0];
        Domain[] nonSupportingDomains = domainManager.getNonSupportingDomains(category);
        int i = 0;
        while (i < nonSupportingDomains.length) {
            try {
                this.discardDomain(nonSupportingDomains[i], null, false, false);
            }
            catch (Throwable e) {
                this.discardDomain(nonSupportingDomains[i], e, false, false);
            }
            ++i;
        }
        ArrayList<DomainSubtreeRoot> roots = new ArrayList<DomainSubtreeRoot>();
        Domain[] supportingDomains = domainManager.getSupportingDomains(category);
        String[] domainIds = this.getDomainIds(supportingDomains);
        try {
            String[] licenseAsserts = this.assertLicenses(domainIds, category.getTeamRepository(), monitor);
            int i2 = 0;
            while (i2 < licenseAsserts.length) {
                if (licenseAsserts[i2] == null) {
                    DomainSubtreeRoot domainSubtreeRoot = new DomainSubtreeRoot(supportingDomains[i2], categoryElement);
                    roots.add(domainSubtreeRoot);
                }
                ++i2;
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            return EMPTY;
        }
        catch (TeamRepositoryException e) {
            ProcessRCPUIPlugin.getDefault().log(Messages.DelegatingTreePathContentProvider2_1, e);
            return EMPTY;
        }
        return roots.toArray();
    }
}

