/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.ContributorDialogItem;
import com.ibm.team.repository.common.UUID;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ContributorSelectionHistory {
    private static final String DEFAULT_ROOT_NODE_NAME = "historyRootNode";
    private static final String DEFAULT_INFO_NODE_NAME = "infoNode";
    private static final int MAX_HISTORY_SIZE = 60;
    private final String CONTRIBUTOR_UUID = "CONTRIB_UUID";
    private final String CONTRIBUTOR_LABEL = "CONTRIB_LABEL";
    private final String CONTRIBUTOR_DETAILLABEL = "CONTRIB_DETAILLABEL";
    private final String REPOSITORY_URL = "REPOSITORY_URL";
    private final List historyList = Collections.synchronizedList(new LinkedList(){
        private static final long serialVersionUID = 0L;

        public boolean add(Object arg0) {
            if (this.size() > 60) {
                this.removeFirst();
            }
            if (!this.contains(arg0)) {
                return super.add(arg0);
            }
            return false;
        }
    });
    private final String rootNodeName;
    private final String infoNodeName;

    private ContributorSelectionHistory(String rootNodeName, String infoNodeName) {
        this.rootNodeName = rootNodeName;
        this.infoNodeName = infoNodeName;
    }

    public ContributorSelectionHistory() {
        this(DEFAULT_ROOT_NODE_NAME, DEFAULT_INFO_NODE_NAME);
    }

    public synchronized void accessed(List items) {
        this.historyList.addAll(items);
    }

    public synchronized boolean contains(Object object) {
        return this.historyList.contains(object);
    }

    public synchronized boolean isEmpty() {
        return this.historyList.isEmpty();
    }

    public synchronized boolean remove(Object element) {
        return this.historyList.remove(element);
    }

    public void load(IMemento memento) {
        XMLMemento historyMemento = (XMLMemento)memento.getChild(this.rootNodeName);
        if (historyMemento == null) {
            return;
        }
        IMemento[] mementoElements = historyMemento.getChildren(this.infoNodeName);
        int i = 0;
        while (i < mementoElements.length) {
            IMemento mementoElement = mementoElements[i];
            Object object = this.restoreItemFromMemento(mementoElement);
            if (object != null) {
                this.historyList.add(object);
            }
            ++i;
        }
    }

    public void save(IMemento memento) {
        IMemento historyMemento = memento.createChild(this.rootNodeName);
        Object[] items = this.getHistoryItems();
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            IMemento elementMemento = historyMemento.createChild(this.infoNodeName);
            this.storeItemToMemento(item, elementMemento);
            ++i;
        }
    }

    public synchronized Object[] getHistoryItems() {
        return this.historyList.toArray();
    }

    protected Object restoreItemFromMemento(IMemento memento) {
        String repoURL = memento.getString("REPOSITORY_URL");
        if (repoURL == null) {
            return null;
        }
        String contribUuid = memento.getString("CONTRIB_UUID");
        if (contribUuid == null) {
            return null;
        }
        String label = memento.getString("CONTRIB_LABEL");
        if (label == null) {
            return null;
        }
        String detailLabel = memento.getString("CONTRIB_DETAILLABEL");
        if (detailLabel == null) {
            return null;
        }
        ContributorDialogItem contributorDialogItem = new ContributorDialogItem(UUID.valueOf((String)contribUuid), repoURL, label, detailLabel);
        contributorDialogItem.setIsHistoryItem(true);
        return contributorDialogItem;
    }

    protected void storeItemToMemento(Object item, IMemento memento) {
        ContributorDialogItem cdi = (ContributorDialogItem)item;
        memento.putString("REPOSITORY_URL", cdi.getRepositoryURL());
        memento.putString("CONTRIB_UUID", cdi.getContributorId());
        memento.putString("CONTRIB_LABEL", cdi.getLabel());
        memento.putString("CONTRIB_DETAILLABEL", cdi.getDetailLabel());
    }
}

