/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.foundation.common.util.WildcardMatcher;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.rcp.ui.ContributorDialogItem;
import com.ibm.team.process.internal.rcp.ui.ContributorLabelProvider;
import com.ibm.team.process.internal.rcp.ui.ContributorSelectionHistory;
import com.ibm.team.process.internal.rcp.ui.DetailsContentViewer;
import com.ibm.team.process.internal.rcp.ui.IBlockContainer;
import com.ibm.team.process.internal.rcp.ui.IElementCollector;
import com.ibm.team.process.internal.rcp.ui.ImagePool;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.internal.rcp.ui.ProcessRCPUIPlugin;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IExternalUser;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.RepositoryPackage;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class ContributorSelectionBlock {
    private static final String TEAM_CONTRIBUTOR_SELECTION_DIALOG_INCLUDE_ARCHIVED = "teamContributorSelectionDialog.includeArchived";
    private static final String TEAM_CONTRIBUTOR_SELECTION_DIALOG_OPEN_EDITORS = "teamContributorSelectionDialog.openEditors";
    public static final int MAXIMUM_REACHED_STATUS = 55;
    private static final String HISTORY_SETTINGS = "History";
    private static final Collection fgContributorProperties = Arrays.asList(IContributor.NAME_PROPERTY, IContributor.EMAIL_ADDRESS_PROPERTY, IContributor.USERID_PROPERTY, RepositoryPackage.eINSTANCE.getContributor_Archived().getName());
    private Text pattern;
    private TableViewer list;
    private ItemsListLabelProvider itemsListLabelProvider;
    private boolean multi;
    private Label progressLabel;
    private RemoveHistoryItemAction removeHistoryItemAction;
    private ActionContributionItem removeHistoryActionContributionItem;
    private IStatus status;
    private RefreshCacheJob refreshCacheJob;
    private RefreshProgressMessageJob refreshProgressMessageJob;
    private ContentProvider contentProvider;
    private FilterHistoryJob filterHistoryJob;
    private FilterJob filterJob;
    private ItemsFilter filter;
    private List lastCompletedResult;
    private ItemsFilter lastCompletedFilter;
    private ItemsListSeparator itemsListSeparator;
    private static final String EMPTY_STRING = "";
    private boolean refreshWithLastSelection = false;
    private IBlockContainer fSite;
    private Label fHeaderLabel;
    private Object[] fResult;
    private Button fAddButton;
    private Button fRemoveButton;
    private DetailsContentViewer fDetails;
    private List fAdded = new ArrayList();
    private boolean fIsFilterBeingUpdated = false;
    private List fTeamAreas = null;
    private TableViewer fAddedViewer;
    private ContributorLabelProvider fContributorLabelProvider;
    private ITeamRepository fTeamRepository;
    public ItemsFilter fLastFilter;
    public boolean fRefreshRequired;
    private boolean fFetching;
    private Map fContributors = new HashMap();
    private Job fUpdateHistoryJob;
    public boolean fIncludeArchived;
    private List fFilteredContributors;
    private Shell fShell;
    private LocalResourceManager fResourceManager;
    private Label fListLabel;
    private List fFilteredHistoryItems = new ArrayList();
    private Action fToggleArchivedAction;
    private final boolean fImporting;
    private Button fSearchButton;
    private boolean fSearched = false;
    protected int fMaximumReached = -1;
    protected boolean fReset = false;
    private Button fOpenEditors;

    public ContributorSelectionBlock(boolean multi, boolean importing, IBlockContainer site, ITeamRepository teamRepository, List filteredContributors) {
        this.multi = multi;
        this.fImporting = importing;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fSite = site;
        this.fShell = site.getShell();
        this.fTeamRepository = teamRepository;
        this.refreshProgressMessageJob = new RefreshProgressMessageJob();
        this.filterHistoryJob = new FilterHistoryJob();
        this.filterJob = new FilterJob();
        this.refreshCacheJob = new RefreshCacheJob();
        this.contentProvider = new ContentProvider();
        this.itemsListSeparator = new ItemsListSeparator(Messages.ContributorSelectionBlock_0);
        this.fContributorLabelProvider = new ContributorLabelProvider();
        if (!this.fImporting) {
            this.setSelectionHistory(new ContributorSelectionHistory());
        }
        this.setListLabelProvider((ILabelProvider)this.fContributorLabelProvider);
        this.fFilteredContributors = new ArrayList(filteredContributors.size());
        for (IContributorHandle handle : filteredContributors) {
            this.fFilteredContributors.add(handle.getItemId().getUuidValue());
        }
    }

    public void addListFilter(ViewerFilter filter) {
        this.contentProvider.addFilter(filter);
    }

    public void setListLabelProvider(ILabelProvider listLabelProvider) {
        this.getItemsListLabelProvider().setProvider(listLabelProvider);
    }

    private ItemsListLabelProvider getItemsListLabelProvider() {
        if (this.itemsListLabelProvider == null) {
            this.itemsListLabelProvider = new ItemsListLabelProvider((ILabelProvider)new LabelProvider(), null);
        }
        return this.itemsListLabelProvider;
    }

    public void restoreBlockSettings(IDialogSettings settings) {
        if (this.fImporting) {
            if (this.fOpenEditors != null) {
                this.fOpenEditors.setSelection(settings.getBoolean(TEAM_CONTRIBUTOR_SELECTION_DIALOG_OPEN_EDITORS));
            }
            return;
        }
        this.fIncludeArchived = settings.getBoolean(TEAM_CONTRIBUTOR_SELECTION_DIALOG_INCLUDE_ARCHIVED);
        this.fToggleArchivedAction.setChecked(this.fIncludeArchived);
        String setting = settings.get(HISTORY_SETTINGS);
        if (setting != null) {
            try {
                XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(setting));
                this.contentProvider.loadHistory((IMemento)memento);
            }
            catch (WorkbenchException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", 4, Messages.ContributorSelectionBlock_1, (Throwable)e));
            }
        }
        this.fUpdateHistoryJob = new Job(Messages.ContributorSelectionBlock_2){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(ContributorSelectionBlock.EMPTY_STRING, 1000);
                    List teamAreas = ContributorSelectionBlock.this.getTeamAreas((IProgressMonitor)new SubProgressMonitor(monitor, 700));
                    HashMap contributorToTeamAreaNames = new HashMap();
                    ContributorSelectionBlock.this.determineContributorTeamAreas(teamAreas, contributorToTeamAreaNames);
                    ContributorSelectionBlock.this.updateHistory(contributorToTeamAreaNames, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException x) {
                    ProcessRCPUIPlugin.getDefault().log(Messages.ContributorSelectionBlock_4, x);
                    Status status = new Status(4, "com.ibm.team.process.rcp.ui", 4, Messages.ContributorSelectionBlock_5, (Throwable)x);
                    return status;
                }
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        this.fUpdateHistoryJob.schedule();
    }

    private void updateHistory(Map contributorToTeams, IProgressMonitor monitor) throws TeamRepositoryException {
        Object[] history = this.getSelectionHistory().getHistoryItems();
        if (history.length == 0) {
            monitor.beginTask(EMPTY_STRING, 1000);
            monitor.done();
            return;
        }
        boolean updateHistory = false;
        ITeamRepositoryService teamRepositoryService = TeamPlatform.getTeamRepositoryService();
        ArrayList<IItemHandle> handles = new ArrayList<IItemHandle>(history.length);
        int i = 0;
        while (i < history.length) {
            ContributorDialogItem contributorDialogItem = (ContributorDialogItem)history[i];
            String url = contributorDialogItem.getRepositoryURL();
            ITeamRepository repository = teamRepositoryService.getTeamRepository(url, 4);
            if (repository == null) {
                this.getSelectionHistory().remove(contributorDialogItem);
                updateHistory = true;
            } else if (this.fTeamRepository.getId().equals((Object)repository.getId())) {
                this.getSelectionHistory().remove(contributorDialogItem);
                updateHistory = true;
                String contributorItemId = contributorDialogItem.getContributorId();
                IItemHandle handle = IContributor.ITEM_TYPE.createItemHandle((Object)this.fTeamRepository, UUID.valueOf((String)contributorItemId), null);
                handles.add(handle);
            }
            ++i;
        }
        if (this.fIncludeArchived) {
            this.getSelectionHistory().accessed(this.fFilteredHistoryItems);
            this.fFilteredHistoryItems = new ArrayList();
        }
        List contributorsInHistory = null;
        contributorsInHistory = this.fImporting ? new ArrayList() : ProcessRCPUIPlugin.getDefault().resolveContributors(handles, fgContributorProperties, this.fIncludeArchived, this.fTeamRepository, monitor);
        ArrayList<ContributorDialogItem> accessed = new ArrayList<ContributorDialogItem>();
        for (IContributor contributor : contributorsInHistory) {
            if (contributor == null) continue;
            ContributorDialogItem dialogItem = this.convertToDialogItem(contributorToTeams, contributor);
            dialogItem.setIsHistoryItem(true);
            if (!this.fIncludeArchived && contributor.isArchived()) {
                this.fFilteredHistoryItems.add(dialogItem);
                continue;
            }
            accessed.add(dialogItem);
        }
        this.getSelectionHistory().accessed(accessed);
        if (!updateHistory) {
            return;
        }
        this.reapplyFilter();
    }

    public void dispose() {
        this.fResourceManager.dispose();
        this.filterJob.cancel();
        this.refreshCacheJob.cancel();
        this.refreshProgressMessageJob.cancel();
    }

    protected Label createHeader(Composite parent) {
        Composite header = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        header.setLayout((Layout)layout);
        this.fHeaderLabel = new Label(header, 0);
        this.fHeaderLabel.setText(Messages.ContributorSelectionBlock_7);
        this.fHeaderLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ContributorSelectionBlock.this.pattern.setFocus();
                }
            }
        });
        GridData gd = new GridData(768);
        this.fHeaderLabel.setLayoutData((Object)gd);
        header.setLayoutData((Object)gd);
        return this.fHeaderLabel;
    }

    public Label getHeaderLabel() {
        return this.fHeaderLabel;
    }

    protected Label createLabels(Composite parent) {
        Composite labels = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        labels.setLayout((Layout)layout);
        this.fListLabel = new Label(labels, 0);
        this.fListLabel.setText(Messages.ContributorSelectionBlock_8);
        this.fListLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ContributorSelectionBlock.this.list.getTable().setFocus();
                }
            }
        });
        GridData grabExcessData = new GridData(4, 4, true, false);
        this.fListLabel.setLayoutData((Object)grabExcessData);
        GridData gd = new GridData(768);
        this.progressLabel = new Label(labels, 131072);
        this.progressLabel.setLayoutData((Object)gd);
        labels.setLayoutData((Object)gd);
        return this.fListLabel;
    }

    private void reapplyFilter() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ContributorSelectionBlock.this.fShell.isDisposed()) {
                        return;
                    }
                    ContributorSelectionBlock.this.fIsFilterBeingUpdated = true;
                    ContributorSelectionBlock.this.applyFilter();
                }
            });
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
    }

    protected void createPopupMenu() {
        this.removeHistoryItemAction = new RemoveHistoryItemAction();
        this.removeHistoryActionContributionItem = new ActionContributionItem((IAction)this.removeHistoryItemAction);
        MenuManager manager = new MenuManager();
        manager.add((IContributionItem)this.removeHistoryActionContributionItem);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                List selectedElements = ((StructuredSelection)ContributorSelectionBlock.this.list.getSelection()).toList();
                Object item2 = null;
                manager.remove((IContributionItem)ContributorSelectionBlock.this.removeHistoryActionContributionItem);
                for (Object item2 : selectedElements) {
                    if (!(item2 instanceof ItemsListSeparator) && ContributorSelectionBlock.this.isHistoryElement(item2)) continue;
                    return;
                }
                if (selectedElements.size() > 0) {
                    ContributorSelectionBlock.this.removeHistoryItemAction.setText(Messages.ContributorSelectionBlock_9);
                    manager.add((IContributionItem)ContributorSelectionBlock.this.removeHistoryActionContributionItem);
                }
            }
        });
        Menu menu = manager.createContextMenu(this.list.getControl());
        this.list.getTable().setMenu(menu);
    }

    protected Control createExtendedContentArea(Composite parent) {
        if (this.multi) {
            this.list.getTable().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    Shell shell = ContributorSelectionBlock.this.fSite.getShell();
                    if (shell != null) {
                        shell.setDefaultButton(ContributorSelectionBlock.this.fAddButton);
                    }
                }

                public void focusLost(FocusEvent e) {
                    Shell shell = ContributorSelectionBlock.this.fSite.getShell();
                    if (shell != null) {
                        shell.setDefaultButton(ContributorSelectionBlock.this.fSite.getDefaultButton());
                    }
                }
            });
            Composite extra = new Composite(parent, 0);
            GridData gd = new GridData(4, 4, true, true);
            extra.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            extra.setLayout((Layout)layout);
            Composite buttonGroup = new Composite(extra, 0);
            gd = new GridData(4, 4, true, false);
            buttonGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            layout.numColumns = 3;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            buttonGroup.setLayout((Layout)layout);
            Label tableTitle = new Label(buttonGroup, 0);
            tableTitle.setText(Messages.ContributorSelectionBlock_10);
            tableTitle.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 128 && e.doit) {
                        e.detail = 0;
                        ContributorSelectionBlock.this.fAddedViewer.getTable().setFocus();
                    }
                }
            });
            gd = new GridData(4, 1024, true, false);
            tableTitle.setLayoutData((Object)gd);
            this.fAddButton = new Button(buttonGroup, 8);
            this.fAddButton.setText(Messages.ContributorSelectionBlock_11);
            this.fAddButton.setEnabled(false);
            this.fSite.setLayoutData(this.fAddButton);
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ContributorSelectionBlock.this.addPressed();
                }
            });
            this.fRemoveButton = new Button(buttonGroup, 8);
            this.fRemoveButton.setText(Messages.ContributorSelectionBlock_12);
            this.fSite.setLayoutData(this.fRemoveButton);
            this.fRemoveButton.setEnabled(false);
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ContributorSelectionBlock.this.removePressed();
                }
            });
            this.fAddedViewer = new TableViewer(extra, 2562);
            this.fAddedViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return ContributorSelectionBlock.this.fAdded.toArray();
                }
            });
            this.fAddedViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ContributorSelectionBlock.this.fRemoveButton.setEnabled(!event.getSelection().isEmpty());
                }
            });
            this.fAddedViewer.setLabelProvider((IBaseLabelProvider)this.fContributorLabelProvider);
            this.fAddedViewer.setComparator(new ViewerComparator());
            this.fAddedViewer.setInput((Object)this.fAdded);
            gd = new GridData(4, 4, true, true);
            gd.heightHint = this.fAddedViewer.getTable().getItemHeight() * 5;
            this.fAddedViewer.getControl().setLayoutData((Object)gd);
            if (this.fSite.allowOpenEditorsOnFinish()) {
                this.fOpenEditors = new Button(extra, 32);
                this.fOpenEditors.setText(Messages.ContributorSelectionBlock_53);
            }
            return extra;
        }
        return this.fDetails.getControl();
    }

    public Control create(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridData gd = new GridData(1808);
        content.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        final Label headerLabel = this.createHeader(content);
        Composite patternComposite = new Composite(content, 0);
        gd = new GridData(768);
        patternComposite.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        patternComposite.setLayout((Layout)layout);
        this.pattern = new Text(patternComposite, 2052);
        this.pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ItemsFilter newFilter = ContributorSelectionBlock.this.createFilter();
                if (ContributorSelectionBlock.this.fMaximumReached == -1 && ContributorSelectionBlock.this.lastCompletedFilter != null && (ContributorSelectionBlock.this.lastCompletedFilter.getPattern().equals(newFilter.getPattern()) || ContributorSelectionBlock.this.lastCompletedFilter.isSubFilter(newFilter))) {
                    ContributorSelectionBlock.this.lastCompletedFilter = newFilter;
                    return;
                }
                ContributorSelectionBlock.this.fReset = true;
                if (ContributorSelectionBlock.this.contentProvider.hasItems()) {
                    ContributorSelectionBlock.this.contentProvider.reset();
                    ContributorSelectionBlock.this.contentProvider.refresh();
                    ContributorSelectionBlock.this.fMaximumReached = -1;
                }
                ContributorSelectionBlock.this.lastCompletedFilter = null;
                ContributorSelectionBlock.this.lastCompletedResult = null;
                if (!ContributorSelectionBlock.this.fFetching) {
                    ContributorSelectionBlock.this.fSearchButton.setEnabled(ContributorSelectionBlock.this.pattern.getText().trim().length() > 0);
                    if (ContributorSelectionBlock.this.fSearchButton.isEnabled()) {
                        ContributorSelectionBlock.this.fSearchButton.getShell().setDefaultButton(ContributorSelectionBlock.this.fSearchButton);
                    }
                    ContributorSelectionBlock.this.fSearched = false;
                }
            }
        });
        this.fSearchButton = new Button(patternComposite, 8);
        this.fSearchButton.setText(Messages.ContributorSelectionBlock_13);
        this.fSearchButton.setToolTipText(Messages.ContributorSelectionBlock_14);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContributorSelectionBlock.this.doSearch();
            }
        });
        this.fSearched = true;
        this.fSearchButton.setEnabled(false);
        this.pattern.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LegacyActionTools.removeMnemonics((String)headerLabel.getText());
            }
        });
        gd = new GridData(768);
        this.pattern.setLayoutData((Object)gd);
        final Label listLabel = this.createLabels(content);
        Composite tableGroup = new Composite(content, 0);
        gd = new GridData(1808);
        tableGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = this.fImporting ? 1 : 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableGroup.setLayout((Layout)layout);
        this.list = new TableViewer(tableGroup, (this.multi ? 2 : 4) | 0x800 | 0x200 | 0x10000000);
        this.list.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = LegacyActionTools.removeMnemonics((String)listLabel.getText());
            }
        });
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)this.getItemsListLabelProvider());
        this.list.setInput((Object)new Object[0]);
        this.list.setItemCount(this.contentProvider.getElements(null).length);
        gd = new GridData(1808);
        gd.heightHint = this.list.getTable().getItemHeight() * 8;
        this.list.getTable().setLayoutData((Object)gd);
        if (!this.fImporting) {
            this.createFilterArchiveAction(tableGroup);
            this.pattern.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.updateCurrentItems();
                }

                private void updateCurrentItems() {
                    ItemsFilter newFilter = ContributorSelectionBlock.this.createFilter();
                    ContributorSelectionBlock.this.contentProvider.resetItems(newFilter);
                    ContributorSelectionBlock.this.refreshWithLastSelection = false;
                    ContributorSelectionBlock.this.contentProvider.reloadCache((IProgressMonitor)new NullProgressMonitor());
                    ContributorSelectionBlock.this.refresh();
                }
            });
        }
        this.createPopupMenu();
        this.pattern.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    if (ContributorSelectionBlock.this.list.getTable().getItemCount() > 0) {
                        ContributorSelectionBlock.this.list.getTable().setFocus();
                    }
                } else if (ContributorSelectionBlock.this.fImporting && e.keyCode == 13) {
                    ContributorSelectionBlock.this.doSearch();
                }
            }
        });
        this.list.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                ContributorSelectionBlock.this.handleSelected(selection);
            }
        });
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ContributorSelectionBlock.this.handleDoubleClick();
            }
        });
        this.list.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                StructuredSelection selection;
                if (e.keyCode == 127) {
                    List selectedElements = ((StructuredSelection)ContributorSelectionBlock.this.list.getSelection()).toList();
                    Object item2 = null;
                    boolean isSelectedHistory = true;
                    for (Object item2 : selectedElements) {
                        if (!(item2 instanceof ItemsListSeparator) && ContributorSelectionBlock.this.isHistoryElement(item2)) continue;
                        isSelectedHistory = false;
                        break;
                    }
                    if (isSelectedHistory) {
                        ContributorSelectionBlock.this.removeSelectedItems(selectedElements);
                    }
                }
                if (e.keyCode == 0x1000001 && (e.stateMask & 0x20000) != 0 && (e.stateMask & 0x40000) != 0 && (selection = (StructuredSelection)ContributorSelectionBlock.this.list.getSelection()).size() == 1) {
                    Object element = selection.getFirstElement();
                    if (element.equals(ContributorSelectionBlock.this.list.getElementAt(0))) {
                        ContributorSelectionBlock.this.pattern.setFocus();
                    }
                    if (ContributorSelectionBlock.this.list.getElementAt(ContributorSelectionBlock.this.list.getTable().getSelectionIndex() - 1) instanceof ItemsListSeparator) {
                        ContributorSelectionBlock.this.list.getTable().setSelection(ContributorSelectionBlock.this.list.getTable().getSelectionIndex() - 1);
                    }
                    ContributorSelectionBlock.this.list.getTable().notifyListeners(13, new Event());
                }
                if (e.keyCode == 0x1000002 && (e.stateMask & 0x20000) != 0 && (e.stateMask & 0x40000) != 0) {
                    if (ContributorSelectionBlock.this.list.getElementAt(ContributorSelectionBlock.this.list.getTable().getSelectionIndex() + 1) instanceof ItemsListSeparator) {
                        ContributorSelectionBlock.this.list.getTable().setSelection(ContributorSelectionBlock.this.list.getTable().getSelectionIndex() + 1);
                    }
                    ContributorSelectionBlock.this.list.getTable().notifyListeners(13, new Event());
                }
            }
        });
        this.fDetails = new DetailsContentViewer(tableGroup, 0x800800);
        this.fDetails.setLabelProvider((IBaseLabelProvider)new ContributorDetailsLabelProvider());
        gd = new GridData(4, 4, true, false);
        this.fDetails.getControl().setLayoutData((Object)gd);
        this.fDetails.setVisible(true);
        this.createExtendedContentArea(content);
        Dialog.applyDialogFont((Control)content);
        return parent;
    }

    private void createFilterArchiveAction(Composite tableGroup) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(tableGroup);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 128, false, true));
        this.fToggleArchivedAction = new Action(){

            public ImageDescriptor getImageDescriptor() {
                return ImagePool.ARCHIVED_USER;
            }

            public void run() {
                ContributorSelectionBlock.this.fIncludeArchived = !ContributorSelectionBlock.this.fIncludeArchived;
                ContributorSelectionBlock.this.fIsFilterBeingUpdated = true;
                ContributorSelectionBlock.this.lastCompletedFilter = null;
                ContributorSelectionBlock.this.applyFilter();
                ContributorSelectionBlock.this.fUpdateHistoryJob.schedule();
            }
        };
        this.fToggleArchivedAction.setChecked(this.fIncludeArchived);
        this.fToggleArchivedAction.setToolTipText(Messages.ContributorSelectionBlock_15);
        toolBarManager.add((IAction)this.fToggleArchivedAction);
        toolBarManager.update(true);
    }

    private void refreshDetails() {
        ArrayList selection = new ArrayList();
        this.getSelectedItems(false, selection);
        switch (selection.size()) {
            case 0: {
                this.fDetails.setInput(null);
                break;
            }
            case 1: {
                this.fDetails.setInput(selection.get(0));
                break;
            }
            default: {
                this.fDetails.setInput(NLS.bind((String)Messages.ContributorSelectionBlock_16, (Object)new Integer(selection.size())));
            }
        }
    }

    protected void handleSelected(StructuredSelection selection) {
        boolean searchIsDefault = this.fSite.getShell().getDefaultButton() == this.fSearchButton;
        this.status = new Status(0, "com.ibm.team.process.rcp.ui", 0, EMPTY_STRING, null);
        this.updateStatus(this.status);
        Status status = null;
        if (this.fMaximumReached != -1) {
            status = new Status(0, "com.ibm.team.process.rcp.ui", 55, EMPTY_STRING, null);
        }
        if (selection.size() == 0) {
            if (this.fAdded.isEmpty()) {
                status = new Status(4, "com.ibm.team.process.rcp.ui", 4, EMPTY_STRING, null);
            }
            if (this.multi) {
                this.fAddButton.setEnabled(false);
            }
        } else {
            if (this.multi) {
                this.fAddButton.setEnabled(true);
            }
            if (selection.size() == 1) {
                Object firstElement = selection.getFirstElement();
                if (firstElement instanceof ItemsListSeparator) {
                    if (this.multi) {
                        this.fAddButton.setEnabled(false);
                    }
                    if (this.fAdded.isEmpty()) {
                        status = new Status(4, "com.ibm.team.process.rcp.ui", 4, EMPTY_STRING, null);
                    }
                } else if (firstElement instanceof ContributorDialogItem) {
                    boolean isValid = ((ContributorDialogItem)firstElement).isValid();
                    if (this.multi) {
                        this.fAddButton.setEnabled(isValid);
                    }
                    if (!isValid) {
                        status = new Status(4, "com.ibm.team.process.rcp.ui", 4, Messages.ContributorSelectionBlock_52, null);
                    }
                }
            } else if (this.getSelectedItems(true, new ArrayList())) {
                status = new Status(4, "com.ibm.team.process.rcp.ui", 4, Messages.ContributorSelectionBlock_52, null);
                if (this.multi) {
                    this.fAddButton.setEnabled(false);
                }
            }
        }
        this.refreshDetails();
        boolean wasFocus = this.list.getControl().isFocusControl();
        this.updateStatus((IStatus)status);
        Shell shell = this.fSite.getShell();
        if ((this.fMaximumReached != -1 || searchIsDefault) && this.fSearchButton.isEnabled()) {
            shell.setDefaultButton(this.fSearchButton);
        } else if (wasFocus) {
            shell.setDefaultButton(this.fAddButton);
        }
    }

    public void refresh() {
        if (this.list != null && !this.list.getTable().isDisposed()) {
            List lastRefreshSelection = ((StructuredSelection)this.list.getSelection()).toList();
            Object[] elements = this.contentProvider.getElements(null);
            this.list.setItemCount(elements.length);
            this.list.refresh();
            int itemCount = this.list.getTable().getItemCount();
            if (itemCount > 0) {
                if (this.refreshWithLastSelection && lastRefreshSelection != null && lastRefreshSelection.size() > 0) {
                    this.list.setSelection((ISelection)new StructuredSelection(lastRefreshSelection));
                } else {
                    this.refreshWithLastSelection = true;
                    this.list.getTable().setSelection(0);
                    this.list.getTable().notifyListeners(13, new Event());
                }
            } else {
                this.list.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            if (this.pattern.getText().trim().length() > 0) {
                int found = elements.length;
                int i = 0;
                while (i < elements.length) {
                    Object element = elements[i];
                    if (element instanceof ItemsListSeparator) {
                        --found;
                        break;
                    }
                    ++i;
                }
                if (!this.fFetching && !this.fReset) {
                    if (found == 1) {
                        if (this.fSearched) {
                            this.fListLabel.setText(Messages.ContributorSelectionBlock_17);
                        } else {
                            this.fListLabel.setText(Messages.ContributorSelectionBlock_3);
                        }
                    } else if (this.fMaximumReached != -1) {
                        this.fListLabel.setText(NLS.bind((String)Messages.ContributorSelectionBlock_6, (Object)Integer.toString(this.fMaximumReached)));
                        this.fSite.setStatus((IStatus)new Status(2, "com.ibm.team.process.rcp.ui", Messages.ContributorSelectionBlock_19));
                    } else if (this.fSearched) {
                        this.fListLabel.setText(NLS.bind((String)Messages.ContributorSelectionBlock_20, (Object)Integer.toString(found)));
                    } else {
                        this.fListLabel.setText(NLS.bind((String)Messages.ContributorSelectionBlock_21, (Object)Integer.toString(found)));
                    }
                } else {
                    this.fReset = false;
                    if (this.fSearched) {
                        this.fListLabel.setText(Messages.ContributorSelectionBlock_8);
                    } else {
                        this.fListLabel.setText(Messages.ContributorSelectionBlock_22);
                    }
                }
            } else {
                this.fListLabel.setText(Messages.ContributorSelectionBlock_22);
            }
            this.pattern.setEnabled(!this.fFetching);
            if (!this.fFetching) {
                this.pattern.setFocus();
            }
        }
        this.scheduleProgressMessageRefresh();
    }

    public void reloadCache(IProgressMonitor monitor) {
        if (this.list != null && !this.list.getTable().isDisposed() && this.contentProvider != null) {
            this.contentProvider.reloadCache(monitor);
        }
    }

    public void scheduleRefresh() {
        this.refreshCacheJob.cancelAll();
        this.refreshCacheJob.schedule();
    }

    public void scheduleProgressMessageRefresh() {
        if (this.filterJob.getState() != 4 && this.refreshProgressMessageJob.getState() != 4) {
            this.refreshProgressMessageJob.scheduleProgressRefresh(null);
        }
    }

    public void computeResult(boolean updateHistory) {
        List oldResult = new ArrayList();
        boolean addToHistory = false;
        if (this.fAdded.isEmpty()) {
            addToHistory = true;
            boolean invalidRemoved = this.getSelectedItems(true, oldResult);
            if (invalidRemoved) {
                oldResult = Collections.EMPTY_LIST;
            }
        } else {
            oldResult = this.fAdded;
            addToHistory = true;
        }
        ArrayList<Object> newResult = new ArrayList<Object>(oldResult.size());
        for (ContributorDialogItem item : oldResult) {
            Object selected = this.fContributors.get(item.getContributorId());
            if (selected instanceof IContributor) {
                newResult.add(((IContributor)selected).getItemHandle());
                continue;
            }
            if (selected instanceof IExternalUser) {
                newResult.add(selected);
                continue;
            }
            IContributorHandle handle = (IContributorHandle)IContributor.ITEM_TYPE.createItemHandle((Object)this.fTeamRepository, UUID.valueOf((String)item.getContributorId()), null);
            newResult.add(handle);
        }
        if (addToHistory && !this.fImporting && updateHistory) {
            this.accessedHistoryItems(oldResult);
        }
        this.setResult(newResult);
    }

    protected void setResult(List newResult) {
        if (newResult == null) {
            this.fResult = null;
        } else {
            this.fResult = new Object[newResult.size()];
            newResult.toArray(this.fResult);
        }
    }

    public Object[] getResult() {
        return this.fResult;
    }

    protected void updateStatus(IStatus status) {
        this.status = status;
        this.fSite.setStatus(status);
    }

    protected boolean valid() {
        return this.status != null && (this.status.isOK() || this.status.getCode() == 1);
    }

    private boolean getSelectedItems(boolean removeInvalid, List selectedItems) {
        StructuredSelection selection = (StructuredSelection)this.list.getSelection();
        selectedItems.addAll(selection.toList());
        boolean invalidRemoved = false;
        Iterator it = selectedItems.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof ItemsListSeparator) {
                it.remove();
                continue;
            }
            if (!removeInvalid || !(item instanceof ContributorDialogItem) || ((ContributorDialogItem)item).isValid()) continue;
            it.remove();
            invalidRemoved = true;
        }
        return invalidRemoved;
    }

    protected ItemsFilter createFilter() {
        return new ItemsFilter();
    }

    private void asyncRefresh() {
        this.reloadCache((IProgressMonitor)new NullProgressMonitor());
        final Shell shell = this.fSite.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (shell.isDisposed()) {
                    return;
                }
                ContributorSelectionBlock.this.refresh();
            }
        });
    }

    public void applyFilter() {
        ItemsFilter newFilter = this.createFilter();
        this.fRefreshRequired = false;
        this.fLastFilter = newFilter;
        this.fIsFilterBeingUpdated = false;
        this.filterHistoryJob.cancel();
        this.filterJob.cancel();
        this.filter = newFilter;
        if (this.filter != null) {
            this.filterHistoryJob.schedule();
        }
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ContributorDialogItem && o2 instanceof ContributorDialogItem) {
                    return ((ContributorDialogItem)o1).compareTo(o2);
                }
                return 0;
            }
        };
    }

    protected void fillContentProvider(ContentProvider contentProvider, ItemsFilter itemsFilter, IProgressMonitor monitor) {
        monitor.beginTask(Messages.ContributorSelectionBlock_23, 1000);
        HashMap contributorToTeamAreaNames = new HashMap();
        IElementCollector elementCollector = this.getElementCollector(contributorToTeamAreaNames, contentProvider, itemsFilter, monitor);
        try {
            try {
                List teamAreas = this.getTeamAreas((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                this.determineContributorTeamAreas(teamAreas, contributorToTeamAreaNames);
                this.fFetching = true;
                if (this.fImporting) {
                    ProcessRCPUIPlugin.getDefault().fetchExternalUsers(this.getPattern(itemsFilter), elementCollector, this.fTeamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 950));
                } else {
                    ProcessRCPUIPlugin.getDefault().fetchAllContributors(this.getPattern(itemsFilter), fgContributorProperties, this.fIncludeArchived, elementCollector, this.fTeamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 950));
                }
                this.fIsFilterBeingUpdated = false;
                if (this.fRefreshRequired) {
                    this.reapplyFilter();
                    this.fRefreshRequired = false;
                }
            }
            catch (TeamRepositoryException e) {
                elementCollector.done();
                ProcessRCPUIPlugin.getDefault().log(e);
                final Shell shell = this.fSite.getShell();
                if (shell == null || shell.isDisposed()) {
                    monitor.done();
                    return;
                }
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (shell.isDisposed()) {
                            return;
                        }
                        ContributorSelectionBlock.this.updateStatus((IStatus)new Status(4, "com.ibm.team.process.rcp.ui", Messages.ContributorSelectionBlock_24));
                    }
                });
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private String getPattern(ItemsFilter itemsFilter) {
        String pattern = itemsFilter.getPattern();
        if (pattern.charAt(pattern.length() - 1) == '*') {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    private IElementCollector getElementCollector(final Map contributorToTeamAreaNames, final ContentProvider contentProvider, final ItemsFilter itemsFilter, IProgressMonitor monitor) {
        IElementCollector elementCollector = new IElementCollector(){

            public void done() {
                ContributorSelectionBlock.this.fFetching = false;
                ContributorSelectionBlock.this.asyncRefresh();
            }

            public void setMaximumSearchLimitReached(int maximumReached) {
                ContributorSelectionBlock.this.fMaximumReached = maximumReached;
            }

            public void add(Object[] elements) {
                if (ContributorSelectionBlock.this.fLastFilter != null) {
                    ContributorSelectionBlock.this.filter = ContributorSelectionBlock.this.fLastFilter;
                }
                boolean refreshNeeded = elements.length > 0;
                int i = 0;
                while (i < elements.length) {
                    if (elements[i] instanceof IExternalUser) {
                        ItemsFilter currentFilter = itemsFilter;
                        if (ContributorSelectionBlock.this.fLastFilter != null) {
                            currentFilter = ContributorSelectionBlock.this.fLastFilter;
                        }
                        ContributorDialogItem dialogItem = new ContributorDialogItem((IExternalUser)elements[i]);
                        ContributorSelectionBlock.this.fContributors.put(dialogItem.getContributorId(), elements[i]);
                        contentProvider.add(dialogItem, currentFilter);
                    } else {
                        IContributor contributor = (IContributor)elements[i];
                        this.addContributor(contributor);
                    }
                    ++i;
                }
                if (refreshNeeded) {
                    ContributorSelectionBlock.this.asyncRefresh();
                }
            }

            public void add(Object element) {
                if (ContributorSelectionBlock.this.fLastFilter != null) {
                    ContributorSelectionBlock.this.filter = ContributorSelectionBlock.this.fLastFilter;
                }
                if (element instanceof IExternalUser) {
                    ItemsFilter currentFilter = itemsFilter;
                    if (ContributorSelectionBlock.this.fLastFilter != null) {
                        currentFilter = ContributorSelectionBlock.this.fLastFilter;
                    }
                    ContributorDialogItem dialogItem = new ContributorDialogItem((IExternalUser)element);
                    ContributorSelectionBlock.this.fContributors.put(dialogItem.getContributorId(), element);
                    contentProvider.add(dialogItem, currentFilter);
                    ContributorSelectionBlock.this.asyncRefresh();
                } else {
                    IContributor contributor = (IContributor)element;
                    this.addContributor(contributor);
                    ContributorSelectionBlock.this.asyncRefresh();
                }
            }

            private void addContributor(IContributor contributor) {
                ItemsFilter currentFilter = itemsFilter;
                if (ContributorSelectionBlock.this.fLastFilter != null) {
                    currentFilter = ContributorSelectionBlock.this.fLastFilter;
                }
                ContributorSelectionBlock.this.fContributors.put(contributor.getItemId().getUuidValue(), contributor);
                ContributorDialogItem dialogItem = ContributorSelectionBlock.this.convertToDialogItem(contributorToTeamAreaNames, contributor);
                contentProvider.add(dialogItem, currentFilter);
            }
        };
        return elementCollector;
    }

    private ContributorDialogItem convertToDialogItem(Map teamAreas, IContributor contributor) {
        StringBuffer label = new StringBuffer(contributor.getName());
        if (contributor.isArchived()) {
            label.append(Messages.ContributorSelectionBlock_25);
        }
        List teams = (List)teamAreas.get(contributor.getItemId());
        StringBuffer teamList = new StringBuffer();
        if (teams != null) {
            Collections.sort(teams);
            for (String teamName : teams) {
                teamList.append(", ");
                teamList.append(teamName);
            }
        }
        if (teamList.length() > 0) {
            label.append(" - ");
            label.append(teamList.substring(2));
        }
        StringBuffer detailLabel = new StringBuffer();
        if (contributor.isArchived()) {
            detailLabel.append(Messages.ContributorSelectionBlock_28);
        }
        if (contributor.getEmailAddress().length() > 0) {
            detailLabel.append(Messages.ContributorSelectionBlock_29);
            detailLabel.append(contributor.getEmailAddress());
            detailLabel.append(" - ");
        }
        detailLabel.append(Messages.ContributorSelectionBlock_31);
        detailLabel.append(contributor.getUserId());
        ContributorDialogItem entry = new ContributorDialogItem(contributor.getItemId(), this.fTeamRepository.getRepositoryURI(), label.toString(), detailLabel.toString());
        return entry;
    }

    private List getTeamAreas(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(EMPTY_STRING, 1000);
        try {
            if (this.fTeamAreas == null) {
                IProcessItemService processService = (IProcessItemService)this.fTeamRepository.getClientLibrary(IProcessItemService.class);
                List allProjectAreas = processService.findAllProjectAreas(IProcessClientService.ALL_PROPERTIES, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                ArrayList teamAreaHandles = new ArrayList();
                for (IProjectArea projectArea : allProjectAreas) {
                    teamAreaHandles.addAll(projectArea.getTeamAreas());
                }
                IItemManager itemManager = this.fTeamRepository.itemManager();
                this.fTeamAreas = itemManager.fetchCompleteItems(teamAreaHandles, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            List list = this.fTeamAreas;
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private void addTeam(Map teamAreas, IContributorHandle c, String teamAreaName) {
        ArrayList<String> teams = (ArrayList<String>)teamAreas.get(c.getItemId());
        if (teams == null) {
            teams = new ArrayList<String>();
            teamAreas.put(c.getItemId(), teams);
        }
        if (!teams.contains(teamAreaName)) {
            teams.add(teamAreaName);
        }
    }

    private void determineContributorTeamAreas(List teamAreas, Map contributorToTeamAreaNames) {
        for (ITeamArea ta : teamAreas) {
            IContributorHandle[] members = ta.getMembers();
            int i = 0;
            while (i < members.length) {
                IContributorHandle contributor = members[i];
                this.addTeam(contributorToTeamAreaNames, contributor, ta.getName());
                ++i;
            }
        }
    }

    private void removeSelectedItems(List items) {
        this.removeHistoryItems(items);
        this.refreshWithLastSelection = false;
        this.contentProvider.refresh();
    }

    protected void removeHistoryItems(List items) {
        this.contentProvider.removeHistoryElements(items);
    }

    public void accessedHistoryItems(List items) {
        this.contentProvider.addHistoryElements(items);
    }

    private Comparator getHistoryComparator() {
        return new HistoryComparator();
    }

    public ContributorSelectionHistory getSelectionHistory() {
        return this.contentProvider.getSelectionHistory();
    }

    public void setSelectionHistory(ContributorSelectionHistory selectionHistory) {
        if (this.contentProvider != null) {
            this.contentProvider.setSelectionHistory(selectionHistory);
        }
    }

    public boolean isHistoryElement(Object item) {
        return this.contentProvider.isHistoryElement(item);
    }

    public void setSeparatorLabel(String separatorLabel) {
        this.itemsListSeparator = new ItemsListSeparator(separatorLabel);
    }

    public String getElementName(Object item) {
        if (this.getItemsListLabelProvider() != null) {
            return this.getItemsListLabelProvider().getText(item);
        }
        return item.toString();
    }

    public Control getPatternControl() {
        return this.pattern;
    }

    private void removePressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fAddedViewer.getSelection();
        List selected = selection.toList();
        this.fAdded.removeAll(selected);
        for (ContributorDialogItem item : selected) {
            this.fFilteredContributors.remove(item.getContributorId());
        }
        this.lastCompletedFilter = null;
        this.lastCompletedResult = null;
        this.refreshForAddedViewerChanges();
    }

    private void refreshForAddedViewerChanges() {
        this.fAddedViewer.refresh();
        this.reapplyFilter();
        Text patternControl = (Text)this.getPatternControl();
        patternControl.forceFocus();
        patternControl.selectAll();
    }

    private void addPressed() {
        ArrayList selected = new ArrayList();
        boolean invalidRemoved = this.getSelectedItems(true, selected);
        if (selected.isEmpty() || invalidRemoved) {
            return;
        }
        this.fAdded.addAll(selected);
        for (ContributorDialogItem item : selected) {
            this.fFilteredContributors.add(item.getContributorId());
        }
        this.refreshForAddedViewerChanges();
    }

    protected void handleDoubleClick() {
        if (this.fAdded.isEmpty()) {
            ArrayList selected = new ArrayList();
            boolean invalidRemoved = this.getSelectedItems(true, selected);
            if (selected.isEmpty() || invalidRemoved) {
                return;
            }
            this.fSite.finish();
        } else {
            this.addPressed();
        }
    }

    public boolean isShowingArchived() {
        return this.fIncludeArchived;
    }

    public void setFilter(ItemsFilter filter) {
        this.filter = filter;
    }

    public ItemsFilter getFilter() {
        return this.filter;
    }

    public void storeBlockSettings(IDialogSettings settings) {
        settings.put(TEAM_CONTRIBUTOR_SELECTION_DIALOG_OPEN_EDITORS, this.openEditorsOnFinish());
        settings.put(TEAM_CONTRIBUTOR_SELECTION_DIALOG_INCLUDE_ARCHIVED, this.isShowingArchived());
        if (this.fImporting) {
            return;
        }
        XMLMemento memento = XMLMemento.createWriteRoot((String)HISTORY_SETTINGS);
        this.getSelectionHistory().accessed(this.fFilteredHistoryItems);
        this.contentProvider.saveHistory((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            settings.put(HISTORY_SETTINGS, writer.getBuffer().toString());
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui", 4, Messages.ContributorSelectionBlock_51, (Throwable)e));
        }
    }

    private void doSearch() {
        this.fSearchButton.setEnabled(false);
        this.fSearched = true;
        this.pattern.setEnabled(false);
        if (!this.fFetching) {
            this.applyFilter();
        }
        this.fSearchButton.getShell().setDefaultButton(this.fSite.getDefaultButton());
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public boolean openEditorsOnFinish() {
        boolean openEditors = false;
        if (this.fOpenEditors != null) {
            openEditors = this.fOpenEditors.getSelection();
        }
        return openEditors;
    }

    public boolean isSearching() {
        return this.fFetching;
    }

    public void cancelSearch() {
        this.filterJob.cancel();
        this.refreshCacheJob.cancel();
        this.refreshProgressMessageJob.cancel();
    }

    private class CamelCaseComparator
    implements Comparator {
        private CamelCaseComparator() {
        }

        public int compare(Object o1, Object o2) {
            int rightCategory;
            int leftCategory = this.getCamelCaseCategory(o1);
            if (leftCategory < (rightCategory = this.getCamelCaseCategory(o2))) {
                return -1;
            }
            if (leftCategory > rightCategory) {
                return 1;
            }
            return ContributorSelectionBlock.this.getItemsComparator().compare(o1, o2);
        }

        private int getCamelCaseCategory(Object item) {
            if (ContributorSelectionBlock.this.getFilter() == null) {
                return 0;
            }
            if (!ContributorSelectionBlock.this.getFilter().isCamelCasePattern()) {
                return 0;
            }
            return ContributorSelectionBlock.this.getFilter().matchesRawNamePattern(item) ? 0 : 1;
        }
    }

    private static class CollationAwareSearchPattern
    extends SearchPattern {
        private WildcardMatcher fWildcardMatcher;

        private CollationAwareSearchPattern() {
        }

        public void setPattern(String stringPattern) {
            if (stringPattern.length() == 0) {
                super.setPattern(stringPattern);
            } else {
                super.setPattern(String.valueOf(stringPattern) + "*");
            }
            if (this.getMatchRule() == 2) {
                this.fWildcardMatcher = new WildcardMatcher(this.getPattern());
            }
        }

        public boolean matches(String text) {
            if (this.getMatchRule() == 2) {
                return this.fWildcardMatcher.match(text);
            }
            return super.matches(text);
        }
    }

    private class ContentProvider
    implements IStructuredContentProvider,
    ILazyContentProvider {
        private ContributorSelectionHistory selectionHistory;
        private Set items = Collections.synchronizedSet(new HashSet(2048));
        private List filters;
        private List lastFilteredItems = new ArrayList();
        private List lastSortedItems = Collections.synchronizedList(new ArrayList(2048));
        private boolean reset;

        public boolean hasItems() {
            return !this.items.isEmpty();
        }

        public void setSelectionHistory(ContributorSelectionHistory selectionHistory) {
            this.selectionHistory = selectionHistory;
        }

        public ContributorSelectionHistory getSelectionHistory() {
            return this.selectionHistory;
        }

        public void reset() {
            this.reset = true;
            this.items.clear();
            this.lastSortedItems.clear();
        }

        public void resetItems(ItemsFilter itemsFilter) {
            ArrayList oldItems = new ArrayList(this.items);
            this.items.clear();
            for (Object item : oldItems) {
                if (itemsFilter == null || this.isHistoryElement(item) || !itemsFilter.matchItem(item)) continue;
                this.items.add(item);
            }
            if (this.selectionHistory != null) {
                Object[] historyItems = this.selectionHistory.getHistoryItems();
                int i = 0;
                while (i < historyItems.length) {
                    Object item = historyItems[i];
                    if (itemsFilter == null || itemsFilter.matchItem(item)) {
                        this.items.add(item);
                    }
                    ++i;
                }
            }
        }

        public void stopReloadingCache() {
            this.reset = true;
        }

        public void add(Object item, ItemsFilter itemsFilter) {
            if (itemsFilter == ContributorSelectionBlock.this.getFilter()) {
                if (itemsFilter != null) {
                    if (itemsFilter.matchItem(item)) {
                        this.items.add(item);
                    }
                } else {
                    this.items.add(item);
                }
            }
        }

        public void addHistoryItems(ItemsFilter itemsFilter) {
            if (this.selectionHistory != null) {
                Object[] items = this.selectionHistory.getHistoryItems();
                int i = 0;
                while (i < items.length) {
                    Object item = items[i];
                    if (itemsFilter == ContributorSelectionBlock.this.getFilter() && itemsFilter != null && itemsFilter.matchItem(item)) {
                        this.items.add(item);
                    }
                    ++i;
                }
            }
        }

        public void refresh() {
            ContributorSelectionBlock.this.scheduleRefresh();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeHistoryElements(List itemsToRemove) {
            for (Object item : itemsToRemove) {
                if (this.selectionHistory != null) {
                    this.selectionHistory.remove(item);
                }
                if (ContributorSelectionBlock.this.getFilter() != null && ContributorSelectionBlock.this.getFilter().getPattern().length() != 0) continue;
                this.items.remove(item);
                this.lastSortedItems.remove(item);
            }
            List list = this.lastSortedItems;
            synchronized (list) {
                Collections.sort(this.lastSortedItems, ContributorSelectionBlock.this.getHistoryComparator());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addHistoryElements(List itemsToAdd) {
            if (this.selectionHistory != null) {
                this.selectionHistory.accessed(itemsToAdd);
            }
            for (Object item : itemsToAdd) {
                if (ContributorSelectionBlock.this.getFilter() != null && ContributorSelectionBlock.this.getFilter().matchItem(item)) continue;
                this.items.remove(item);
                this.lastSortedItems.remove(item);
            }
            List list = this.lastSortedItems;
            synchronized (list) {
                Collections.sort(this.lastSortedItems, ContributorSelectionBlock.this.getHistoryComparator());
            }
            this.refresh();
        }

        public boolean isHistoryElement(Object item) {
            if (item instanceof ContributorDialogItem) {
                return ((ContributorDialogItem)item).isHistoryItem();
            }
            if (this.selectionHistory != null) {
                return this.selectionHistory.contains(item);
            }
            return false;
        }

        public void loadHistory(IMemento memento) {
            if (this.selectionHistory != null) {
                this.selectionHistory.load(memento);
            }
        }

        public void saveHistory(IMemento memento) {
            if (this.selectionHistory != null) {
                this.selectionHistory.save(memento);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getSortedItems() {
            if (this.lastSortedItems.size() != this.items.size()) {
                List list = this.lastSortedItems;
                synchronized (list) {
                    this.lastSortedItems.clear();
                    this.lastSortedItems.addAll(this.items);
                    Collections.sort(this.lastSortedItems, ContributorSelectionBlock.this.getHistoryComparator());
                }
            }
            return this.lastSortedItems.toArray();
        }

        public void rememberResult(ItemsFilter itemsFilter) {
            List<Object> itemsList = Collections.synchronizedList(Arrays.asList(this.getSortedItems()));
            if (itemsFilter == ContributorSelectionBlock.this.getFilter()) {
                ContributorSelectionBlock.this.lastCompletedFilter = itemsFilter;
                ContributorSelectionBlock.this.lastCompletedResult = itemsList;
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.lastFilteredItems.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void updateElement(int index) {
            ContributorSelectionBlock.this.list.replace(this.lastFilteredItems.size() > index ? this.lastFilteredItems.get(index) : null, index);
        }

        public void reloadCache(IProgressMonitor monitor) {
            this.reset = false;
            if (monitor != null) {
                monitor.beginTask(Messages.ContributorSelectionBlock_49, 100);
            }
            this.lastFilteredItems = Arrays.asList(this.getFilteredItems(ContributorSelectionBlock.this.list.getInput(), (IProgressMonitor)(monitor != null ? new SubProgressMonitor(monitor, 100) : null)));
            if (this.reset || monitor != null && monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.done();
                }
                return;
            }
            if (monitor != null) {
                monitor.done();
            }
        }

        protected Object[] getFilteredItems(Object parent, IProgressMonitor monitor) {
            int ticks = 100;
            if (monitor != null) {
                monitor.beginTask(Messages.ContributorSelectionBlock_50, ticks);
                ticks = this.filters != null ? (ticks /= this.filters.size() + 2) : (ticks /= 2);
            }
            Object[] filteredElements = this.getSortedItems();
            if (monitor != null) {
                monitor.worked(ticks);
            }
            if (this.filters != null && filteredElements != null) {
                for (ViewerFilter f : this.filters) {
                    filteredElements = f.filter((Viewer)ContributorSelectionBlock.this.list, parent, filteredElements);
                    if (monitor == null) continue;
                    monitor.worked(ticks);
                }
            }
            if (filteredElements == null || monitor != null && monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.done();
                }
                return new Object[0];
            }
            ArrayList<Object> preparedElements = new ArrayList<Object>();
            boolean hasHistory = false;
            ContributorSelectionBlock.this.itemsListSeparator.setName(Messages.ContributorSelectionBlock_0);
            if (filteredElements.length > 0 && this.isHistoryElement(filteredElements[0])) {
                hasHistory = true;
            }
            int reportEvery = filteredElements.length / ticks;
            int i = 0;
            while (i < filteredElements.length) {
                Object item = filteredElements[i];
                if (hasHistory && !this.isHistoryElement(item)) {
                    if (ContributorSelectionBlock.this.fMaximumReached != -1) {
                        ContributorSelectionBlock.this.itemsListSeparator.setName(NLS.bind((String)Messages.ContributorSelectionBlock_26, (Object)Integer.toString(ContributorSelectionBlock.this.fMaximumReached)));
                    }
                    preparedElements.add(ContributorSelectionBlock.this.itemsListSeparator);
                    hasHistory = false;
                }
                preparedElements.add(item);
                if (monitor != null && reportEvery != 0 && (i + 1) % reportEvery == 0) {
                    monitor.worked(1);
                }
                ++i;
            }
            if (!ContributorSelectionBlock.this.fSearched) {
                if (hasHistory) {
                    ContributorSelectionBlock.this.itemsListSeparator.setName(Messages.ContributorSelectionBlock_27);
                    preparedElements.add(ContributorSelectionBlock.this.itemsListSeparator);
                } else if (filteredElements.length == 0) {
                    ContributorSelectionBlock.this.itemsListSeparator.setName(Messages.ContributorSelectionBlock_30);
                    preparedElements.add(ContributorSelectionBlock.this.itemsListSeparator);
                }
            } else if (hasHistory) {
                ContributorSelectionBlock.this.itemsListSeparator.setName(Messages.ContributorSelectionBlock_27);
                preparedElements.add(ContributorSelectionBlock.this.itemsListSeparator);
            }
            if (monitor != null) {
                monitor.done();
            }
            return preparedElements.toArray();
        }

        public void addFilter(ViewerFilter filter) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.add(filter);
        }
    }

    private static class ContributorDetailsLabelProvider
    extends LabelProvider {
        private ContributorDetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ContributorDialogItem) {
                return ((ContributorDialogItem)element).getDetailLabel();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return null;
        }
    }

    private class FilterHistoryJob
    extends Job {
        private ItemsFilter itemsFilter;

        public FilterHistoryJob() {
            super(Messages.ContributorSelectionBlock_39);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.itemsFilter = ContributorSelectionBlock.this.getFilter();
            ContributorSelectionBlock.this.contentProvider.reset();
            ContributorSelectionBlock.this.refreshWithLastSelection = false;
            ContributorSelectionBlock.this.contentProvider.addHistoryItems(this.itemsFilter);
            ContributorSelectionBlock.this.filterJob.schedule();
            return Status.OK_STATUS;
        }
    }

    private class FilterJob
    extends Job {
        protected ItemsFilter itemsFilter;

        public FilterJob() {
            super(Messages.ContributorSelectionBlock_40);
            this.setSystem(true);
        }

        protected final IStatus run(IProgressMonitor parent) {
            GranualProgressMonitor monitor = new GranualProgressMonitor(parent);
            return this.doRun(monitor);
        }

        protected IStatus doRun(GranualProgressMonitor monitor) {
            this.internalRun(monitor);
            return Status.OK_STATUS;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void internalRun(GranualProgressMonitor monitor) {
            try {
                if (monitor.isCanceled()) {
                    return;
                }
                this.itemsFilter = ContributorSelectionBlock.this.getFilter();
                if (ContributorSelectionBlock.this.fSearched && ContributorSelectionBlock.this.getFilter().getPattern().length() != 0) {
                    this.filterContent(monitor);
                }
                if (monitor.isCanceled()) {
                    return;
                }
                ContributorSelectionBlock.this.contentProvider.refresh();
                return;
            }
            finally {
                monitor.done();
            }
        }

        protected void filterContent(GranualProgressMonitor monitor) {
            if (ContributorSelectionBlock.this.lastCompletedFilter != null && ContributorSelectionBlock.this.fMaximumReached == -1 && (ContributorSelectionBlock.this.fImporting && ContributorSelectionBlock.this.lastCompletedFilter.getPattern().equals(this.itemsFilter.getPattern()) || ContributorSelectionBlock.this.lastCompletedFilter.isSubFilter(this.itemsFilter))) {
                int length = ContributorSelectionBlock.this.lastCompletedResult.size() / 500;
                monitor.beginTask(Messages.ContributorSelectionBlock_41, length);
                int pos = 0;
                while (pos < ContributorSelectionBlock.this.lastCompletedResult.size()) {
                    Object item = ContributorSelectionBlock.this.lastCompletedResult.get(pos);
                    if (monitor.isCanceled()) break;
                    ContributorSelectionBlock.this.contentProvider.add(item, this.itemsFilter);
                    if (pos != 0 && pos % 500 == 0) {
                        monitor.worked(1);
                    }
                    ++pos;
                }
                ContributorSelectionBlock.this.contentProvider.rememberResult(this.itemsFilter);
                return;
            }
            ContributorSelectionBlock.this.lastCompletedFilter = null;
            ContributorSelectionBlock.this.lastCompletedResult = null;
            ContributorSelectionBlock.this.fillContentProvider(ContributorSelectionBlock.this.contentProvider, this.itemsFilter, (IProgressMonitor)monitor);
            ContributorSelectionBlock.this.contentProvider.rememberResult(this.itemsFilter);
        }
    }

    private class GranualProgressMonitor
    extends ProgressMonitorWrapper {
        private String name;
        private String subName;
        private int totalWork;
        private double worked;
        private boolean done;

        public GranualProgressMonitor(IProgressMonitor monitor) {
            super(monitor);
        }

        public boolean isDone() {
            return this.done;
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.name = name;
            this.subName = null;
        }

        public void subTask(String name) {
            super.subTask(name);
            this.subName = name;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            if (this.name == null) {
                this.name = name;
            }
            this.totalWork = totalWork;
            ContributorSelectionBlock.this.refreshProgressMessageJob.scheduleProgressRefresh(this);
        }

        public void worked(int work) {
            super.worked(work);
            this.internalWorked(work);
        }

        public void done() {
            this.done = true;
            super.done();
        }

        public void setCanceled(boolean b) {
            this.done = b;
            super.setCanceled(b);
        }

        public void internalWorked(double work) {
            this.worked += work;
        }

        private String getMessage() {
            String message;
            if (this.done) {
                return ContributorSelectionBlock.EMPTY_STRING;
            }
            if (this.name == null) {
                message = this.subName == null ? ContributorSelectionBlock.EMPTY_STRING : this.subName;
            } else {
                String string = message = this.subName == null ? this.name : NLS.bind((String)"{0}: {1}", (Object)this.name, (Object)this.subName);
            }
            if (this.totalWork == 0) {
                return message;
            }
            return NLS.bind((String)"{0} ({1}%)", (Object)message, (Object)new Integer((int)(this.worked * 100.0 / (double)this.totalWork)));
        }
    }

    private class HistoryComparator
    implements Comparator {
        private CamelCaseComparator camelCaseComparator;

        public HistoryComparator() {
            this.camelCaseComparator = new CamelCaseComparator();
        }

        public int compare(Object o1, Object o2) {
            if (ContributorSelectionBlock.this.isHistoryElement(o1) && ContributorSelectionBlock.this.isHistoryElement(o2) || !ContributorSelectionBlock.this.isHistoryElement(o1) && !ContributorSelectionBlock.this.isHistoryElement(o2)) {
                return this.camelCaseComparator.compare(o1, o2);
            }
            if (ContributorSelectionBlock.this.isHistoryElement(o1)) {
                return -2;
            }
            if (ContributorSelectionBlock.this.isHistoryElement(o2)) {
                return 2;
            }
            return 0;
        }
    }

    public class ItemsFilter {
        protected SearchPattern patternMatcher = new CollationAwareSearchPattern();

        public ItemsFilter() {
            String stringPattern = ContributorSelectionBlock.EMPTY_STRING;
            if (ContributorSelectionBlock.this.pattern != null && !ContributorSelectionBlock.this.pattern.getText().equals("*")) {
                stringPattern = ContributorSelectionBlock.this.pattern.getText();
            }
            this.patternMatcher.setPattern(stringPattern);
        }

        public boolean isSubFilter(ItemsFilter filter) {
            String filterPattern;
            String lastFilterPattern = filter.getPattern();
            if (lastFilterPattern.equals(filterPattern = this.getPattern())) {
                return true;
            }
            if (lastFilterPattern.length() > 0 && filterPattern.length() > 0 && (ContributorSelectionBlock.this.fFetching || filterPattern.length() < lastFilterPattern.length())) {
                String lastSubstring = lastFilterPattern.substring(0, 1);
                String filterSubstring = filterPattern.substring(0, 1);
                if (lastSubstring.equals(" ") && filterSubstring.equals(" ")) {
                    return lastFilterPattern.length() > 1 && filterPattern.length() > 1 && lastFilterPattern.substring(1, 2).equalsIgnoreCase(filterPattern.substring(1, 2));
                }
                if (lastSubstring.equalsIgnoreCase(filterSubstring)) {
                    return true;
                }
            }
            return false;
        }

        public boolean equalsFilter(ItemsFilter filter) {
            if (ContributorSelectionBlock.this.fIsFilterBeingUpdated) {
                return false;
            }
            return filter != null && filter.patternMatcher.equalsPattern(this.patternMatcher);
        }

        public boolean isCamelCasePattern() {
            return this.patternMatcher.getMatchRule() == 128;
        }

        public String getPattern() {
            return this.patternMatcher.getPattern();
        }

        public int getMatchRule() {
            return this.patternMatcher.getMatchRule();
        }

        protected boolean matches(String text) {
            return this.patternMatcher.matches(text);
        }

        public boolean matchesRawNamePattern(Object item) {
            int prefixLength;
            String prefix = this.patternMatcher.getPattern();
            String text = ContributorSelectionBlock.this.getElementName(item);
            if (text == null) {
                return false;
            }
            int textLength = text.length();
            if (textLength < (prefixLength = prefix.length())) {
                return false;
            }
            int i = prefixLength - 1;
            while (i >= 0) {
                if (Character.toLowerCase(prefix.charAt(i)) != Character.toLowerCase(text.charAt(i))) {
                    return false;
                }
                --i;
            }
            return true;
        }

        public boolean matchItem(Object item) {
            String text = null;
            ContributorDialogItem cdi = (ContributorDialogItem)item;
            if (cdi.getRepositoryURL() != null) {
                String cdiRepo = cdi.getRepositoryURL().trim();
                String currentRepo = ContributorSelectionBlock.this.fTeamRepository.getRepositoryURI().trim();
                if (cdiRepo.endsWith("/") && cdiRepo.length() > 1) {
                    cdiRepo = cdiRepo.substring(0, cdiRepo.length() - 1);
                }
                if (currentRepo.endsWith("/") && currentRepo.length() > 1) {
                    currentRepo = currentRepo.substring(0, currentRepo.length() - 1);
                }
                if (!cdiRepo.equals(currentRepo)) {
                    return false;
                }
            }
            if (ContributorSelectionBlock.this.fFilteredContributors != null) {
                for (String filteredUUID : ContributorSelectionBlock.this.fFilteredContributors) {
                    if (!filteredUUID.equals(cdi.getContributorId())) continue;
                    return false;
                }
            }
            text = cdi.getLabel();
            int i = 0;
            boolean lastNameSearch = this.getPattern().startsWith(" ");
            while (i != -1) {
                if (this.matches(text = text.substring(i).trim())) {
                    if (lastNameSearch) {
                        if (i != 0) {
                            return true;
                        }
                    } else {
                        return i == 0;
                    }
                }
                i = text.indexOf(" ");
            }
            return false;
        }
    }

    private class ItemsListLabelProvider
    extends LabelProvider
    implements IColorProvider,
    IFontProvider,
    ILabelProviderListener {
        private ILabelProvider provider;
        private ILabelDecorator selectionDecorator;
        private ListenerList listeners = new ListenerList();

        public ItemsListLabelProvider(ILabelProvider provider, ILabelDecorator selectionDecorator) {
            Assert.isNotNull((Object)provider);
            this.provider = provider;
            this.selectionDecorator = selectionDecorator;
            provider.addListener((ILabelProviderListener)this);
            if (selectionDecorator != null) {
                selectionDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public void setSelectionDecorator(ILabelDecorator newSelectionDecorator) {
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            this.selectionDecorator = newSelectionDecorator;
            if (this.selectionDecorator != null) {
                this.selectionDecorator.addListener((ILabelProviderListener)this);
            }
        }

        public ILabelDecorator getSelectionDecorator() {
            return this.selectionDecorator;
        }

        public void setProvider(ILabelProvider newProvider) {
            Assert.isNotNull((Object)newProvider);
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            this.provider = newProvider;
            if (this.provider != null) {
                this.provider.addListener((ILabelProviderListener)this);
            }
        }

        public ILabelProvider getProvider() {
            return this.provider;
        }

        public Image getImage(Object element) {
            return this.provider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ItemsListSeparator) {
                return this.getSeparatorLabel(((ItemsListSeparator)element).getName());
            }
            String str = this.provider.getText(element);
            if (this.selectionDecorator != null && element != null) {
                int[] selectionIndices = ContributorSelectionBlock.this.list.getTable().getSelectionIndices();
                List<Object> elements = Arrays.asList(ContributorSelectionBlock.this.contentProvider.getElements(null));
                int i = 0;
                while (i < selectionIndices.length) {
                    if (elements.size() > selectionIndices[i] && element.equals(elements.get(selectionIndices[i]))) {
                        str = this.selectionDecorator.decorateText(str, element);
                        break;
                    }
                    ++i;
                }
            }
            return str;
        }

        private String getSeparatorLabel(String separatorLabel) {
            Rectangle rect = ContributorSelectionBlock.this.list.getTable().getBounds();
            int borderWidth = ((ContributorSelectionBlock)ContributorSelectionBlock.this).list.getTable().computeTrim((int)0, (int)0, (int)0, (int)0).width;
            int width = rect.width - borderWidth;
            GC gc = new GC((Drawable)ContributorSelectionBlock.this.list.getTable());
            gc.setFont(ContributorSelectionBlock.this.list.getTable().getFont());
            int separatorWidth = gc.getAdvanceWidth('-');
            int messageLength = gc.textExtent((String)separatorLabel).x;
            gc.dispose();
            StringBuffer dashes = new StringBuffer();
            int chars = (width - messageLength) / separatorWidth / 2;
            int i = 0;
            while (i < chars) {
                dashes.append('-');
                ++i;
            }
            StringBuffer result = new StringBuffer(dashes);
            result.append(String.valueOf(' ') + separatorLabel + ' ');
            result.append(dashes);
            return result.toString();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.provider.removeListener((ILabelProviderListener)this);
            this.provider.dispose();
            if (this.selectionDecorator != null) {
                this.selectionDecorator.removeListener((ILabelProviderListener)this);
                this.selectionDecorator.dispose();
            }
            super.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            if (this.provider.isLabelProperty(element, property)) {
                return true;
            }
            return this.selectionDecorator != null && this.selectionDecorator.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public Color getBackground(Object element) {
            if (element instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getBackground(element);
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof ItemsListSeparator) {
                return Display.getCurrent().getSystemColor(18);
            }
            if (this.provider instanceof IColorProvider) {
                return ((IColorProvider)this.provider).getForeground(element);
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof ItemsListSeparator) {
                return null;
            }
            if (this.provider instanceof IFontProvider) {
                return ((IFontProvider)this.provider).getFont(element);
            }
            return null;
        }

        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Object[] l = this.listeners.getListeners();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ILabelProviderListener)l[i]).labelProviderChanged(event);
                ++i;
            }
        }
    }

    private class ItemsListSeparator {
        private String fName;

        public ItemsListSeparator(String name) {
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }
    }

    private class RefreshCacheJob
    extends Job {
        private RefreshJob refreshJob;

        public RefreshCacheJob() {
            super(Messages.ContributorSelectionBlock_35);
            this.refreshJob = new RefreshJob();
            this.setSystem(true);
        }

        public void cancelAll() {
            this.cancel();
            this.refreshJob.cancel();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return new Status(8, "com.ibm.team.process.rcp.ui", 8, ContributorSelectionBlock.EMPTY_STRING, null);
            }
            if (ContributorSelectionBlock.this != null) {
                GranualProgressMonitor wrappedMonitor = new GranualProgressMonitor(monitor);
                ContributorSelectionBlock.this.reloadCache((IProgressMonitor)wrappedMonitor);
            }
            if (!monitor.isCanceled()) {
                this.refreshJob.schedule();
            }
            return new Status(0, "com.ibm.team.process.rcp.ui", 0, ContributorSelectionBlock.EMPTY_STRING, null);
        }

        protected void canceling() {
            super.canceling();
            ContributorSelectionBlock.this.contentProvider.stopReloadingCache();
        }
    }

    private class RefreshJob
    extends UIJob {
        public RefreshJob() {
            super(ContributorSelectionBlock.this.fShell.getDisplay(), Messages.ContributorSelectionBlock_33);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return new Status(0, "com.ibm.team.process.rcp.ui", 0, ContributorSelectionBlock.EMPTY_STRING, null);
            }
            if (ContributorSelectionBlock.this != null) {
                ContributorSelectionBlock.this.refresh();
            }
            return new Status(0, "com.ibm.team.process.rcp.ui", 0, ContributorSelectionBlock.EMPTY_STRING, null);
        }
    }

    private class RefreshProgressMessageJob
    extends UIJob {
        private GranualProgressMonitor progressMonitor;

        public RefreshProgressMessageJob() {
            super(ContributorSelectionBlock.this.fShell.getDisplay(), Messages.ContributorSelectionBlock_34);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!ContributorSelectionBlock.this.progressLabel.isDisposed()) {
                ContributorSelectionBlock.this.progressLabel.setText(this.progressMonitor != null ? this.progressMonitor.getMessage() : ContributorSelectionBlock.EMPTY_STRING);
                ContributorSelectionBlock.this.progressLabel.getParent().layout(true);
            }
            if (this.progressMonitor == null || this.progressMonitor.isDone()) {
                return new Status(8, "com.ibm.team.process.rcp.ui", 8, ContributorSelectionBlock.EMPTY_STRING, null);
            }
            this.schedule(500L);
            return new Status(0, "com.ibm.team.process.rcp.ui", 0, ContributorSelectionBlock.EMPTY_STRING, null);
        }

        public void scheduleProgressRefresh(GranualProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
            this.schedule(200L);
        }
    }

    private class RemoveHistoryItemAction
    extends Action {
        public RemoveHistoryItemAction() {
            super(Messages.ContributorSelectionBlock_36);
        }

        public void run() {
            List selectedElements = ((StructuredSelection)ContributorSelectionBlock.this.list.getSelection()).toList();
            ContributorSelectionBlock.this.removeSelectedItems(selectedElements);
        }
    }
}

