/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.repository.common.IExternalUser;
import com.ibm.team.repository.common.UUID;
import java.text.Collator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class ContributorDialogItem
implements Comparable {
    private UUID fContributorItemId;
    private String fLabel;
    private String fDetailLabel;
    private String fRepositoryURL;
    private IExternalUser fExternalUser;
    private boolean fHistoryItem = false;

    public ContributorDialogItem(UUID contributorItemId, String repositoryURL, String label, String detailLabel) {
        this.fContributorItemId = contributorItemId;
        this.fLabel = label;
        this.fDetailLabel = detailLabel;
        this.fRepositoryURL = repositoryURL;
    }

    public ContributorDialogItem(IExternalUser externalUser) {
        this.fExternalUser = externalUser;
    }

    public String getContributorId() {
        if (this.fExternalUser != null) {
            IStatus validUser = this.fExternalUser.isValidUser();
            if (validUser.isOK()) {
                return this.fExternalUser.getUserId();
            }
            return validUser.getMessage();
        }
        return this.fContributorItemId.getUuidValue();
    }

    public String getLabel() {
        if (this.fExternalUser != null) {
            IStatus validUser = this.fExternalUser.isValidUser();
            List fullNames = this.fExternalUser.getFullNames();
            if (validUser.isOK()) {
                if (fullNames != null && !fullNames.isEmpty()) {
                    return (String)fullNames.get(0);
                }
            } else {
                String fullName = "";
                if (fullNames != null && !fullNames.isEmpty()) {
                    fullName = (String)fullNames.get(0);
                }
                return NLS.bind((String)Messages.ContributorDialogItem_0, (Object)fullName, (Object)validUser.getMessage());
            }
        }
        return this.fLabel;
    }

    public String getDetailLabel() {
        if (this.fExternalUser != null) {
            IStatus validUser = this.fExternalUser.isValidUser();
            List emailAddresses = this.fExternalUser.getEmailAddresses();
            if (validUser.isOK()) {
                if (emailAddresses != null && !emailAddresses.isEmpty()) {
                    return (String)emailAddresses.get(0);
                }
            } else {
                String emailAddress = "";
                if (emailAddresses != null && !emailAddresses.isEmpty()) {
                    emailAddress = (String)emailAddresses.get(0);
                }
                return NLS.bind((String)Messages.ContributorDialogItem_1, (Object)emailAddress, (Object)validUser.getMessage());
            }
        }
        return this.fDetailLabel;
    }

    public String getRepositoryURL() {
        return this.fRepositoryURL;
    }

    public int compareTo(Object o) {
        if (o instanceof ContributorDialogItem) {
            Collator collator = Collator.getInstance();
            return collator.compare(this.getLabel(), ((ContributorDialogItem)o).getLabel());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ContributorDialogItem) {
            return this.getContributorId().equals(((ContributorDialogItem)obj).getContributorId());
        }
        return false;
    }

    public int hashCode() {
        return this.getContributorId().hashCode();
    }

    public boolean isValid() {
        if (this.fExternalUser != null) {
            return this.fExternalUser.isValidUser().isOK();
        }
        return true;
    }

    public boolean isHistoryItem() {
        return this.fHistoryItem;
    }

    public void setIsHistoryItem(boolean historyItem) {
        this.fHistoryItem = historyItem;
    }
}

