/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.internal.rcp.ui.Messages;
import com.ibm.team.process.rcp.ui.teamnavigator.ConnectedProjectAreaRegistry;
import com.ibm.team.process.rcp.ui.teamnavigator.IConnectedProjectAreaRegistryChangeEvent;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.rcp.ui.utils.ItemHandleComparer;
import java.util.ArrayList;
import java.util.List;

public class ConnectedProjectAreaRegistryChangeEvent
implements IConnectedProjectAreaRegistryChangeEvent {
    private ITeamAreaHandle fTeamArea;
    private IProjectAreaHandle fProjectArea;
    private int fType;
    private ITeamRepository fTeamRepository;
    private boolean fSharedItemChange = false;
    private List fHierarchyChanges;
    private boolean fResortRequired;

    public ITeamRepository getTeamRepository() {
        if (this.fTeamRepository != null) {
            return this.fTeamRepository;
        }
        return null;
    }

    public ITeamAreaHandle getAddedTeamArea() {
        if (this.fType == 5) {
            return this.fTeamArea;
        }
        return null;
    }

    public ITeamAreaHandle getRemovedTeamArea() {
        if (this.fType == 6) {
            return this.fTeamArea;
        }
        return null;
    }

    public IProjectAreaHandle getAddedProjectArea() {
        if (this.fType == 1 || this.fType == 8) {
            return this.fProjectArea;
        }
        return null;
    }

    public IProjectAreaHandle getRemovedProjectArea() {
        if (this.fType == 2 || this.fType == 9) {
            return this.fProjectArea;
        }
        return null;
    }

    public void setProjectArea(IProjectAreaHandle projectArea, boolean connected) {
        this.setProjectArea(projectArea);
        this.fType = connected ? 1 : 2;
    }

    public void setTeamArea(ITeamAreaHandle teamArea, boolean selected, boolean sharedItemChange) {
        this.updateToFullStateIfPossible((IItemHandle)teamArea, false);
        this.fType = selected ? 5 : 6;
        this.fSharedItemChange = sharedItemChange;
    }

    public void setTeamRepository(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
    }

    public int getType() {
        return this.fType;
    }

    public void setType(int type) {
        this.fType = type;
    }

    public IProjectAreaHandle getProjectAreaHandle() {
        return this.fProjectArea;
    }

    public void setProjectArea(IProjectAreaHandle handle) {
        this.fTeamRepository = (ITeamRepository)handle.getOrigin();
        this.fType = 3;
        this.updateToFullStateIfPossible((IItemHandle)handle, true);
    }

    private void updateToFullStateIfPossible(IItemHandle handle, boolean projectArea) {
        ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
        if (teamRepository.loggedIn() && teamRepository.getErrorState() == 0) {
            IItemManager itemManager = teamRepository.itemManager();
            IItem fullState = itemManager.getSharedItemIfKnown(handle);
            if (fullState != null) {
                if (projectArea) {
                    this.fProjectArea = (IProjectAreaHandle)fullState;
                } else {
                    this.fTeamArea = (ITeamAreaHandle)fullState;
                }
            } else if (projectArea) {
                this.fProjectArea = (IProjectAreaHandle)handle;
            } else {
                this.fTeamArea = (ITeamAreaHandle)handle;
            }
        } else if (handle.hasFullState()) {
            if (projectArea) {
                this.fProjectArea = (IProjectAreaHandle)handle.getFullState().getItemHandle();
            } else {
                this.fTeamArea = (ITeamAreaHandle)handle.getFullState().getItemHandle();
            }
        } else if (projectArea) {
            this.fProjectArea = (IProjectAreaHandle)handle;
        } else {
            this.fTeamArea = (ITeamAreaHandle)handle;
        }
    }

    public String toString() {
        int type = this.getType();
        switch (type) {
            case 3: {
                if (this.fProjectArea != null) {
                    return String.valueOf(Messages.ConnectedProjectAreaRegistryChangeEvent_0) + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_1;
            }
            case 0: {
                return Messages.ConnectedProjectAreaRegistryChangeEvent_2;
            }
            case 4: {
                if (this.fProjectArea != null) {
                    return String.valueOf(Messages.ConnectedProjectAreaRegistryChangeEvent_3) + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_4;
            }
            case 1: {
                if (this.fProjectArea != null) {
                    return String.valueOf(Messages.ConnectedProjectAreaRegistryChangeEvent_5) + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_6;
            }
            case 2: {
                if (this.fProjectArea != null) {
                    return String.valueOf(Messages.ConnectedProjectAreaRegistryChangeEvent_7) + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_8;
            }
            case 7: {
                if (this.fProjectArea != null) {
                    return String.valueOf(Messages.ConnectedProjectAreaRegistryChangeEvent_9) + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_10;
            }
            case 5: {
                String extra = "";
                if (this.isFromSharedItemChange()) {
                    extra = Messages.ConnectedProjectAreaRegistryChangeEvent_12;
                }
                if (this.fProjectArea != null) {
                    return String.valueOf(extra) + Messages.ConnectedProjectAreaRegistryChangeEvent_13 + ConnectedProjectAreaRegistry.getDefault().getProjectAreaName(this.fProjectArea);
                }
                return Messages.ConnectedProjectAreaRegistryChangeEvent_14;
            }
            case 6: {
                String extra = "";
                if (this.isFromSharedItemChange()) {
                    extra = Messages.ConnectedProjectAreaRegistryChangeEvent_16;
                }
                return String.valueOf(extra) + Messages.ConnectedProjectAreaRegistryChangeEvent_17;
            }
        }
        return super.toString();
    }

    public void setPreviouslySelected(List previouslySelected) {
        this.fType = 7;
    }

    public boolean isFromSharedItemChange() {
        return this.fSharedItemChange;
    }

    public void setHierarchyChanges(List hierarchyChanges) {
        this.fHierarchyChanges = new ArrayList();
        for (IProcessAreaHandle handle : hierarchyChanges) {
            IItemManager itemManager;
            IItem fullState;
            ITeamRepository teamRepository;
            if (this.alreadyKnownChange(handle) || !(teamRepository = (ITeamRepository)handle.getOrigin()).loggedIn() || teamRepository.getErrorState() != 0 || (fullState = (itemManager = teamRepository.itemManager()).getSharedItemIfKnown((IItemHandle)handle)) == null) continue;
            this.fHierarchyChanges.add(fullState);
        }
    }

    private boolean alreadyKnownChange(IProcessAreaHandle handle) {
        ItemHandleComparer comparer = new ItemHandleComparer();
        for (IItemHandle seen : this.fHierarchyChanges) {
            if (!comparer.equals((Object)seen, (Object)handle)) continue;
            return true;
        }
        return false;
    }

    public List getHierarchyChanges() {
        return this.fHierarchyChanges;
    }

    public void setResortRequired(boolean refreshRequired) {
        this.fResortRequired = true;
    }

    public boolean isResortRequired() {
        return this.fResortRequired;
    }
}

