/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.rcp.ui;

import com.ibm.team.process.internal.rcp.ui.DomainSelection;
import com.ibm.team.process.rcp.ui.IOpener;
import com.ibm.team.process.rcp.ui.IRefreshable;
import com.ibm.team.process.rcp.ui.teamnavigator.IMenuOperationTarget;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class AdapterAction
extends Action
implements ISelectionChangedListener {
    private IStructuredSelection fSelection;
    private IMenuOperationTarget fMenuTarget;
    private final String fType;
    private final IWorkbenchSite fSite;
    private String fDefaultText;

    public AdapterAction(String text, String type, IWorkbenchSite site) {
        super(text);
        this.fDefaultText = text;
        this.setId(type);
        this.fType = type;
        this.fSite = site;
        this.intialize();
        this.fSite.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.fSelection = (IStructuredSelection)this.fSite.getSelectionProvider().getSelection();
        if (this.fSelection == null) {
            this.fSelection = new StructuredSelection();
        }
    }

    public AdapterAction(String text, String type, IWorkbenchSite site, ISelectionProvider selectionProvider) {
        super(text);
        this.fDefaultText = text;
        this.setId(type);
        this.fType = type;
        this.fSite = site;
        this.intialize();
        ISelection selection = selectionProvider.getSelection();
        this.selectionChanged(selection);
    }

    private void intialize() {
        if (this.fType == IMenuOperationTarget.PROPERTIES) {
            this.setActionDefinitionId("org.eclipse.ui.file.properties");
        } else if (this.fType == IMenuOperationTarget.DELETE) {
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            ISharedImages sharedImages = this.fSite.getWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        } else if (this.fType == IMenuOperationTarget.REFRESH) {
            this.setActionDefinitionId("org.eclipse.ui.file.refresh");
            this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.team.process.rcp.ui", (String)"icons/copied/elcl16/refresh_co.gif"));
        }
    }

    public void run() {
        if (this.fMenuTarget != null && this.fMenuTarget.canDoOperation(this.fType, this.fSelection)) {
            this.fMenuTarget.doOperation(this.fType, this.fSite, this.fSelection);
        } else if (this.enabledForProperties(this.fSelection)) {
            PropertyDialogAction propertyAction = new PropertyDialogAction((IShellProvider)this.fSite, new ISelectionProvider(){

                public void setSelection(ISelection selection) {
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return AdapterAction.this.fSelection;
                }

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }
            });
            propertyAction.run();
        } else if (this.enabledForRefresh()) {
            IWorkbenchPart part = this.fSite.getPage().getActivePart();
            ((IRefreshable)part).refresh();
        } else if (this.enableForOpen()) {
            IWorkbenchPart part = this.fSite.getPage().getActivePart();
            ((IOpener)part).openSelection(this.fSelection);
        }
    }

    public void dispose() {
        this.fSite.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(event.getSelection());
    }

    private void selectionChanged(ISelection selection) {
        String targetText;
        if (selection == null) {
            selection = new StructuredSelection();
        }
        this.fSelection = (IStructuredSelection)selection;
        if (this.fSelection instanceof DomainSelection) {
            this.fSelection = ((DomainSelection)this.fSelection).getOriginal();
        }
        if (this.fSelection.size() == 1) {
            this.fMenuTarget = this.getMenuAdapter(this.fSelection.getFirstElement());
        }
        String text = this.fDefaultText;
        if (this.fMenuTarget != null && (targetText = this.fMenuTarget.getLabel(this.fType)) != null) {
            text = targetText;
        }
        this.setText(text);
        this.setEnabled(this.fMenuTarget != null && this.fMenuTarget.canDoOperation(this.fType, this.fSelection) || this.enabledForProperties(this.fSelection) || this.enabledForRefresh() || this.enableForOpen());
    }

    private boolean enableForOpen() {
        if (this.fType == "jazz.open") {
            IWorkbenchPart part = this.fSite.getPage().getActivePart();
            return part instanceof IOpener;
        }
        return false;
    }

    private boolean enabledForRefresh() {
        if (this.fType == IMenuOperationTarget.REFRESH) {
            IWorkbenchPart part = this.fSite.getPage().getActivePart();
            return part instanceof IRefreshable;
        }
        return false;
    }

    private boolean enabledForProperties(IStructuredSelection selection) {
        if (this.fType == IMenuOperationTarget.PROPERTIES && selection != null && selection.size() == 1) {
            return !PropertyPageContributorManager.getManager().getApplicableContributors(selection.getFirstElement()).isEmpty();
        }
        return false;
    }

    private IMenuOperationTarget getMenuAdapter(Object element) {
        IAdapterManager manager = Platform.getAdapterManager();
        return (IMenuOperationTarget)manager.getAdapter(element, IMenuOperationTarget.class);
    }

    public String getType() {
        return this.fType;
    }
}

