/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.icu.text.UTF16;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.internal.common.util.AbstractProcess;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.form.AbstractProcessAspect;
import com.ibm.team.process.internal.ide.ui.editors.form.util.Util;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.ui.operations.IStatusCollector;
import com.ibm.team.repository.rcp.ui.operations.JobRunner;
import com.ibm.team.repository.rcp.ui.operations.Operation;
import com.ibm.team.repository.rcp.ui.operations.RepositoryOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RequiredWorkItemApprovalAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TAG_REQUIRES = "requires";
    private static final String TAG_APPROVAL = "approval";
    private static final String ATTR_APPROVAL_TYPE = "type";
    private static final String VAL_APPROVAL_TYPE_APPROVAL = "Approval";
    private static final String VAL_APPROVAL_TYPE_REVIEW = "Review";
    private static final String VAL_APPROVAL_TYPE_VERIFICATION = "Verification";
    private static final String TAG_APPROVERS = "approvers";
    private static final String ATTR_APPROVER_ROLE = "role";
    private static final String ATTR_APPROVER_COUNT = "number-of-approvers";
    private static final int MAX_APPROVERS = 99;
    static final String[] DEFINED_APPROVAL_TYPES = new String[]{"Approval", "Review", "Verification"};
    static final String[] APPROVAL_TYPE_LABELS = new String[]{Messages.RequiredWorkItemApprovalAspectEditor_approval, Messages.RequiredWorkItemApprovalAspectEditor_review, Messages.RequiredWorkItemApprovalAspectEditor_verification};
    static final String[] APPROVAL_TYPE_INTRO_LABEL = new String[]{Messages.RequiredWorkItemApprovalAspectEditor_approval_intro, Messages.RequiredWorkItemApprovalAspectEditor_review_intro, Messages.RequiredWorkItemApprovalAspectEditor_verification_intro};
    private Model fModel;
    private TableViewer fTableViewer;
    private JobRunner fJobRunner = new JobRunner(false);
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;

    static int getApprovalTypeIndex(String approvalType) {
        int i = 0;
        while (i < DEFINED_APPROVAL_TYPES.length) {
            if (DEFINED_APPROVAL_TYPES[i].equals(approvalType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static String getApprovalTypeLabel(String approvalType) {
        int i = RequiredWorkItemApprovalAspectEditor.getApprovalTypeIndex(approvalType);
        if (i >= 0) {
            return APPROVAL_TYPE_LABELS[i];
        }
        return approvalType;
    }

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    private static String normalize(String string) {
        return string == null ? "" : string.trim();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequiredWorkItemApprovalAspectEditor_1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(2).applyTo(body);
        Table table = toolkit.createTable(body, 2818);
        GridDataFactory.fillDefaults().grab(true, true).hint(200, 100).applyTo((Control)table);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setContentProvider((IContentProvider)new ApprovalsContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ApprovalsLabelProvider());
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RequiredWorkItemApprovalAspectEditor.this.updateEnablement();
            }
        });
        this.fTableViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                RequiredWorkItemApprovalAspectEditor.this.doEditApproval(sel);
            }
        });
        Composite buttonBar = toolkit.createComposite(body);
        GridDataFactory.fillDefaults().applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fNewButton = toolkit.createButton(buttonBar, Messages.RequiredWorkItemApprovalAspectEditor_0, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fNewButton);
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredWorkItemApprovalAspectEditor.this.doNewApproval();
            }
        });
        this.fEditButton = toolkit.createButton(buttonBar, Messages.RequiredWorkItemApprovalAspectEditor_6, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEditButton);
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredWorkItemApprovalAspectEditor.this.doEditApproval();
            }
        });
        this.fRemoveButton = toolkit.createButton(buttonBar, Messages.RequiredWorkItemApprovalAspectEditor_7, 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveButton);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequiredWorkItemApprovalAspectEditor.this.doRemoveApproval();
            }
        });
        this.updateEnablement();
        final IProcessItem processItem = this.getAspect().getProcessContainerWorkingCopy().getUnderlyingProcessItem();
        final IRole[] explicitlyDefinedRoles = ((AbstractProcessAspect)this.getAspect()).getRootAspect().getDefinedRoles();
        final Display display = this.fTableViewer.getControl().getDisplay();
        this.fJobRunner.enqueue(Messages.RequiredWorkItemApprovalAspectEditor_5, (Operation)new RepositoryOperation(){

            public void repositoryRun(IProgressMonitor monitor, IStatusCollector problems) throws TeamRepositoryException {
                ITeamArea teamArea;
                IRole[] inheritedRoles;
                ArrayList<IRole> allRoles = new ArrayList<IRole>();
                if (processItem instanceof ITeamArea && (inheritedRoles = Util.getInheritedRoles((ITeamArea)(teamArea = (ITeamArea)processItem), (IProgressMonitor)monitor)) != null) {
                    allRoles.addAll((Collection)Arrays.asList(inheritedRoles));
                }
                if (explicitlyDefinedRoles != null) {
                    allRoles.addAll((Collection)Arrays.asList(explicitlyDefinedRoles));
                }
                if (!allRoles.contains(AbstractProcess.fgDefaultRole)) {
                    allRoles.add(AbstractProcess.fgDefaultRole);
                }
                RequiredWorkItemApprovalAspectEditor.this.fModel.setPredefinedRoles(allRoles);
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (!RequiredWorkItemApprovalAspectEditor.this.fTableViewer.getTable().isDisposed()) {
                            RequiredWorkItemApprovalAspectEditor.this.fTableViewer.setInput((Object)RequiredWorkItemApprovalAspectEditor.this.fModel);
                            RequiredWorkItemApprovalAspectEditor.this.updateEnablement();
                        }
                    }
                });
            }
        });
    }

    private void updateEnablement() {
        boolean loading = this.fTableViewer.getInput() == null;
        IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
        int n = sel.size();
        this.fNewButton.setEnabled(!loading);
        this.fEditButton.setEnabled(!loading && n == 1);
        this.fRemoveButton.setEnabled(!loading && n >= 1);
    }

    private Shell getShell() {
        return this.fTableViewer.getTable().getShell();
    }

    private void doNewApproval() {
        Approval approval = new Approval();
        EditApprovalDialog dialog = new EditApprovalDialog(this.getShell(), Messages.RequiredWorkItemApprovalAspectEditor_8, approval);
        if (dialog.open() == 0) {
            this.fModel.add(approval);
            this.fTableViewer.refresh();
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)approval));
            this.setDirty();
        }
    }

    private void doEditApproval() {
        IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
        this.doEditApproval(sel);
    }

    private void doEditApproval(IStructuredSelection sel) {
        if (sel.size() == 1 && sel.getFirstElement() instanceof Approval) {
            Approval toEdit = (Approval)sel.getFirstElement();
            Approval dup = new Approval();
            dup.copyFrom(toEdit);
            EditApprovalDialog dialog = new EditApprovalDialog(this.getShell(), Messages.RequiredWorkItemApprovalAspectEditor_9, dup);
            if (dialog.open() == 0) {
                toEdit.copyFrom(dup);
                this.fTableViewer.update((Object)toEdit, null);
                this.setDirty();
            }
        }
    }

    private void doRemoveApproval() {
        IStructuredSelection sel = (IStructuredSelection)this.fTableViewer.getSelection();
        if (!sel.isEmpty()) {
            this.fModel.removeAll(sel.toList());
            this.fTableViewer.refresh();
            this.setDirty();
        }
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
    }

    public void restoreState(IMemento memento) {
        this.fModel.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        return this.fModel.saveTo(memento);
    }

    static class Approval {
        public String type = "Approval";
        public Map approvers = new TreeMap(new RoleIdComparator());

        Approval() {
        }

        public int getCount(String roleId) {
            Integer count = (Integer)this.approvers.get(roleId);
            return count == null ? 0 : count;
        }

        public void setCount(String roleId, int count) {
            if (count == 0) {
                this.approvers.remove(roleId);
            } else {
                this.approvers.put(roleId, new Integer(count));
            }
        }

        public boolean isEmpty() {
            return this.approvers.isEmpty();
        }

        public String toString(IRole[] allRoles) {
            HashMap roleIdMap = this.makeRolesByIdMap(allRoles);
            String approversString = "";
            for (Map.Entry entry : this.approvers.entrySet()) {
                String roleId = (String)entry.getKey();
                IRole role = (IRole)roleIdMap.get(roleId);
                String roleLabel = role == null ? roleId : Util.getText((IRole)role);
                Integer count = (Integer)entry.getValue();
                String approverString = NLS.bind((String)Messages.RequiredWorkItemApprovalAspectEditor_approverFmt, (Object)count, (Object)roleLabel);
                approversString = approversString.length() == 0 ? approverString : NLS.bind((String)Messages.RequiredWorkItemApprovalAspectEditor_approversFmt, (Object)approversString, (Object)approverString);
            }
            return this.getApprovalString(this.type, approversString);
        }

        private String getApprovalString(String approvalType, String allApprovals) {
            int i = RequiredWorkItemApprovalAspectEditor.getApprovalTypeIndex(approvalType);
            if (i >= 0) {
                return NLS.bind((String)APPROVAL_TYPE_INTRO_LABEL[i], (Object)allApprovals);
            }
            return NLS.bind((String)Messages.RequiredWorkItemApprovalAspectEditor_approvalFmt, (Object)approvalType, (Object)allApprovals);
        }

        private HashMap makeRolesByIdMap(IRole[] allRoles) {
            HashMap<String, IRole> map = new HashMap<String, IRole>();
            int i = 0;
            while (i < allRoles.length) {
                IRole role = allRoles[i];
                map.put(role.getId(), role);
                ++i;
            }
            return map;
        }

        public boolean restoreState(IMemento memento) {
            String type = RequiredWorkItemApprovalAspectEditor.normalize(memento.getString(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVAL_TYPE));
            if (RequiredWorkItemApprovalAspectEditor.isNotNull(type) && RequiredWorkItemApprovalAspectEditor.getApprovalTypeIndex(type) >= 0) {
                this.type = type;
                IMemento[] approversMementos = memento.getChildren(RequiredWorkItemApprovalAspectEditor.TAG_APPROVERS);
                if (approversMementos != null) {
                    int i = 0;
                    while (i < approversMementos.length) {
                        IMemento approversMemento = approversMementos[i];
                        String role = RequiredWorkItemApprovalAspectEditor.normalize(approversMemento.getString(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVER_ROLE));
                        Integer requiredApprovers = approversMemento.getInteger(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVER_COUNT);
                        if (RequiredWorkItemApprovalAspectEditor.isNotNull(role) && requiredApprovers != null) {
                            this.setCount(role, requiredApprovers);
                        }
                        ++i;
                    }
                }
                return !this.isEmpty();
            }
            return false;
        }

        public void saveState(IMemento memento) {
            memento.putString(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVAL_TYPE, this.type);
            for (String roleId : this.approvers.keySet()) {
                int count = this.getCount(roleId);
                IMemento approversMemento = memento.createChild(RequiredWorkItemApprovalAspectEditor.TAG_APPROVERS);
                approversMemento.putString(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVER_ROLE, roleId);
                approversMemento.putInteger(RequiredWorkItemApprovalAspectEditor.ATTR_APPROVER_COUNT, count);
            }
        }

        public void copyFrom(Approval original) {
            this.type = original.type;
            this.approvers.clear();
            this.approvers.putAll(original.approvers);
        }
    }

    private class ApprovalsContentProvider
    implements IStructuredContentProvider {
        private ApprovalsContentProvider() {
        }

        public Object[] getElements(Object element) {
            return RequiredWorkItemApprovalAspectEditor.this.fModel.getApprovals().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ApprovalsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ApprovalsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Approval) {
                Approval approval = (Approval)element;
                return approval.toString(RequiredWorkItemApprovalAspectEditor.this.fModel.getRoles());
            }
            return null;
        }
    }

    class EditApprovalDialog
    extends TitleAreaDialog {
        private final String DIALOG_SETTINGS_SECTION;
        private String fTitle;
        private Approval fApproval;

        public EditApprovalDialog(Shell parentShell, String title, Approval approval) {
            super(parentShell);
            this.DIALOG_SETTINGS_SECTION = EditApprovalDialog.class.getName();
            this.fTitle = title;
            this.fApproval = approval;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            this.setHelpAvailable(false);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.fTitle);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            final FormToolkit toolkit = new FormToolkit(composite.getDisplay());
            toolkit.getColors().setBackground(parent.getBackground());
            composite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    toolkit.dispose();
                }
            });
            Composite top = toolkit.createComposite(composite, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)top);
            this.createDialogContents(top, toolkit);
            this.setTitle(this.fTitle);
            this.setMessage(Messages.RequiredWorkItemApprovalAspectEditor_10);
            EditApprovalDialog.applyDialogFont((Control)composite);
            return composite;
        }

        private void createDialogContents(Composite top, FormToolkit toolkit) {
            GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).applyTo(top);
            Composite typeComposite = toolkit.createComposite(top);
            GridDataFactory.fillDefaults().applyTo((Control)typeComposite);
            GridLayoutFactory.fillDefaults().numColumns(4).applyTo(typeComposite);
            toolkit.createLabel(typeComposite, Messages.RequiredWorkItemApprovalAspectEditor_11);
            String[] types = DEFINED_APPROVAL_TYPES;
            int i = 0;
            while (i < types.length) {
                final String type = types[i];
                String label = RequiredWorkItemApprovalAspectEditor.getApprovalTypeLabel(type);
                final Button button = toolkit.createButton(typeComposite, label, 16);
                button.setSelection(type.equals(this.fApproval.type));
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (button.getSelection()) {
                            ((EditApprovalDialog)EditApprovalDialog.this).fApproval.type = type;
                        }
                    }
                });
                ++i;
            }
            toolkit.createLabel(top, Messages.RequiredWorkItemApprovalAspectEditor_12);
            ScrolledForm scrolledForm = toolkit.createScrolledForm(top);
            GridDataFactory.fillDefaults().grab(true, true).indent(10, 0).hint(350, 200).applyTo((Control)scrolledForm);
            Composite approversComposite = scrolledForm.getBody();
            approversComposite.setBackground(top.getBackground());
            ColumnLayout layout = new ColumnLayout();
            layout.minNumColumns = 1;
            layout.maxNumColumns = 10;
            layout.leftMargin = 0;
            layout.topMargin = 0;
            layout.rightMargin = 0;
            layout.bottomMargin = 0;
            Point spacing = LayoutConstants.getSpacing();
            layout.horizontalSpacing = spacing.x;
            layout.verticalSpacing = spacing.y;
            approversComposite.setLayout((Layout)layout);
            this.createRoleItems(approversComposite, toolkit, RequiredWorkItemApprovalAspectEditor.this.fModel.getRoles());
        }

        public void create() {
            super.create();
            this.updateOK();
        }

        private void updateOK() {
            this.getButton(0).setEnabled(!this.fApproval.isEmpty());
        }

        private void createRoleItems(Composite parent, FormToolkit toolkit, IRole[] roles) {
            int i = 0;
            while (i < roles.length) {
                this.createRoleItem(parent, toolkit, roles[i]);
                ++i;
            }
        }

        private void createRoleItem(Composite parent, FormToolkit toolkit, final IRole role) {
            Composite composite = toolkit.createComposite(parent);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
            String roleId = role.getId();
            int count = this.fApproval.getCount(roleId);
            final Spinner spinner = new Spinner(composite, 8);
            toolkit.adapt((Control)spinner, true, false);
            GridDataFactory.fillDefaults().applyTo((Control)spinner);
            spinner.setValues(count, 0, 99, 0, 1, 10);
            Label roleLabel = toolkit.createLabel(composite, Util.getText((IRole)role));
            GridDataFactory.fillDefaults().align(16384, 128).applyTo((Control)roleLabel);
            spinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selection = spinner.getSelection();
                    EditApprovalDialog.this.fApproval.setCount(role.getId(), selection);
                    EditApprovalDialog.this.updateOK();
                }
            });
        }

        protected IDialogSettings getDialogBoundsSettings() {
            IDialogSettings settings = DefinitionsIdeUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(this.DIALOG_SETTINGS_SECTION);
            if (section == null) {
                section = settings.addNewSection(this.DIALOG_SETTINGS_SECTION);
            }
            return section;
        }
    }

    private static class Model {
        private IRole[] fRoles = new IRole[0];
        private List fApprovals = new ArrayList();

        public synchronized IRole[] getRoles() {
            return this.fRoles;
        }

        public List getApprovals() {
            return this.fApprovals;
        }

        public synchronized void setPredefinedRoles(List definedRoles) {
            this.fRoles = definedRoles.toArray(new IRole[definedRoles.size()]);
            this.sort();
        }

        private void sort() {
            Arrays.sort(this.fRoles, new Comparator(){
                Comparator roleIdComparator = new RoleIdComparator();

                public int compare(Object left, Object right) {
                    IRole rLeft = (IRole)left;
                    IRole rRight = (IRole)right;
                    return this.roleIdComparator.compare(rLeft.getId(), rRight.getId());
                }
            });
        }

        public synchronized void readFrom(IMemento memento) {
            IMemento[] approvalMementos;
            IMemento requiresMemento = memento.getChild(RequiredWorkItemApprovalAspectEditor.TAG_REQUIRES);
            if (requiresMemento != null && (approvalMementos = requiresMemento.getChildren(RequiredWorkItemApprovalAspectEditor.TAG_APPROVAL)) != null) {
                int i = 0;
                while (i < approvalMementos.length) {
                    Approval approval = new Approval();
                    if (approval.restoreState(approvalMementos[i])) {
                        this.add(approval);
                    }
                    ++i;
                }
            }
        }

        public synchronized boolean saveTo(IMemento memento) {
            if (this.fApprovals.isEmpty()) {
                return false;
            }
            IMemento requiresMemento = memento.createChild(RequiredWorkItemApprovalAspectEditor.TAG_REQUIRES);
            for (Approval approval : this.fApprovals) {
                approval.saveState(requiresMemento.createChild(RequiredWorkItemApprovalAspectEditor.TAG_APPROVAL));
            }
            return true;
        }

        public void add(Approval approval) {
            this.fApprovals.add(approval);
        }

        public void removeAll(List toRemove) {
            this.fApprovals.removeAll(toRemove);
        }
    }

    static class RoleIdComparator
    implements Comparator {
        final UTF16.StringComparator stringComparator = new UTF16.StringComparator(false, true, 0);

        RoleIdComparator() {
        }

        public int compare(Object left, Object right) {
            String rLeft = (String)left;
            String rRight = (String)right;
            if ("default".equals(rLeft)) {
                if ("default".equals(rRight)) {
                    return 0;
                }
                return 1;
            }
            if ("default".equals(rRight)) {
                return -1;
            }
            return this.stringComparator.compare((Object)rLeft, (Object)rRight);
        }
    }
}

