/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor2;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.ComponentScopeDefinitionBlock;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.form.util.MessageBox;
import com.ibm.team.process.internal.ide.ui.editors.util.DisplayHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequiredContentAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TAG_FILE_PATTERN = "filePattern";
    private static final String ATTR_PATTERN = "pattern";
    private static final String TAG_REQUIRED_TEXT = "requiredText";
    private static final String TAG_INSERT_TEXT = "insertText";
    private static final String ATTR_TEXT = "text";
    private Model fModel;
    private Text fRequiredTextField;
    private Text fFilePatternField;
    private Text fInsertTextField;
    private TableViewer fComponentList;
    private MessageBox fMessageBox;
    private ControlDecoration fFilePatternDecoration;
    private ControlDecoration fRequiredTextDecoration;
    private boolean fSettingInput;
    private ComponentScopeDefinitionBlock fComponentBlock = new ComponentScopeDefinitionBlock();

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    private static String normalize(String string) {
        return string == null ? "" : string.trim();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequiredContentAspectEditor_1);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(3).applyTo(body);
        Label label = toolkit.createLabel(body, Messages.RequiredContentAspectEditor_2);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fFilePatternField = toolkit.createText(body, "", 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fFilePatternField);
        this.fFilePatternDecoration = new ControlDecoration((Control)this.fFilePatternField, 16512);
        this.fFilePatternField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!RequiredContentAspectEditor.this.fSettingInput) {
                    ((RequiredContentAspectEditor)RequiredContentAspectEditor.this).fModel.filePattern = RequiredContentAspectEditor.this.fFilePatternField.getText();
                    RequiredContentAspectEditor.this.setDirty();
                    RequiredContentAspectEditor.this.validateData();
                }
            }
        });
        label = toolkit.createLabel(body, Messages.RequiredContentAspectEditor_4);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fRequiredTextField = toolkit.createText(body, "", 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fRequiredTextField);
        this.fRequiredTextDecoration = new ControlDecoration((Control)this.fRequiredTextField, 16512);
        this.fRequiredTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!RequiredContentAspectEditor.this.fSettingInput) {
                    ((RequiredContentAspectEditor)RequiredContentAspectEditor.this).fModel.requiredText = RequiredContentAspectEditor.this.fRequiredTextField.getText();
                    RequiredContentAspectEditor.this.setDirty();
                    RequiredContentAspectEditor.this.validateData();
                }
            }
        });
        label = toolkit.createLabel(body, Messages.RequiredContentAspectEditor_6);
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)label);
        this.fInsertTextField = toolkit.createText(body, "", 2626);
        int h = this.fInsertTextField.getLineHeight() * 4;
        h = this.fInsertTextField.computeTrim((int)0, (int)0, (int)100, (int)h).height;
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).hint(100, h).applyTo((Control)this.fInsertTextField);
        this.fInsertTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!RequiredContentAspectEditor.this.fSettingInput) {
                    ((RequiredContentAspectEditor)RequiredContentAspectEditor.this).fModel.insertText = RequiredContentAspectEditor.this.fInsertTextField.getText();
                    RequiredContentAspectEditor.this.setDirty();
                    RequiredContentAspectEditor.this.validateData();
                }
            }
        });
        this.fComponentList = this.fComponentBlock.createControl(body, toolkit, (ProcessAspectEditor2)this);
        this.fMessageBox = new MessageBox();
        Composite messageBoxControl = this.fMessageBox.createControl(parent, toolkit, (ProcessAspectEditor2)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageBoxControl);
        DisplayHelper.asyncExec((Control)messageBoxControl, (Runnable)new Runnable(){

            public void run() {
                RequiredContentAspectEditor.this.updateUI();
            }
        });
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public void updateUI() {
        this.fSettingInput = true;
        try {
            this.fFilePatternField.setText(this.fModel.filePattern);
            this.fRequiredTextField.setText(this.fModel.requiredText);
            this.fInsertTextField.setText(this.fModel.insertText);
            this.fComponentList.setInput((Object)this.fModel.componentNames);
            this.validateData();
        }
        finally {
            this.fSettingInput = false;
        }
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
    }

    public void restoreState(IMemento memento) {
        this.fModel.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        return this.fModel.saveTo(memento);
    }

    private void validateData() {
        boolean validFilePattern = this.validateFilePattern();
        boolean validRequiredText = this.validateRequiredText(validFilePattern);
        if (validFilePattern && validRequiredText) {
            this.fMessageBox.clearMessage();
        }
    }

    private boolean validateFilePattern() {
        String filePattern = this.fFilePatternField.getText();
        if (RequiredContentAspectEditor.isNull(filePattern)) {
            this.setValidationMessage(true, this.fFilePatternDecoration, true, Messages.RequiredContentAspectEditor_11);
            return false;
        }
        if (!this.isValidFilePattern(filePattern)) {
            this.setValidationMessage(true, this.fFilePatternDecoration, true, Messages.RequiredContentAspectEditor_12);
            return false;
        }
        this.setValidationMessage(true, this.fFilePatternDecoration, true, null);
        return true;
    }

    private static boolean isNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    private boolean isValidFilePattern(String filePattern) {
        if (RequiredContentAspectEditor.isNotNull(filePattern)) {
            try {
                Pattern.compile(filePattern);
                return true;
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return false;
    }

    private boolean validateRequiredText(boolean primaryError) {
        String requiredText = this.fRequiredTextField.getText();
        if (RequiredContentAspectEditor.isNull(requiredText)) {
            this.setValidationMessage(true, this.fRequiredTextDecoration, primaryError, Messages.RequiredContentAspectEditor_13);
            return false;
        }
        this.setValidationMessage(true, this.fRequiredTextDecoration, primaryError, null);
        return true;
    }

    private void setValidationMessage(boolean required, ControlDecoration decoration, boolean setErrorMessage, String msg) {
        if (msg != null) {
            if (setErrorMessage) {
                this.fMessageBox.setErrorMessage(msg);
            }
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        } else {
            this.clearDecoration(decoration, required);
        }
    }

    private void clearDecoration(ControlDecoration decoration, boolean required) {
        if (required) {
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        } else {
            decoration.hide();
            decoration.setImage(null);
            decoration.show();
        }
    }

    private static class Model {
        String filePattern = "";
        String requiredText = "";
        String insertText = "";
        List componentNames = new ArrayList();

        private Model() {
        }

        public void readFrom(IMemento memento) {
            IMemento insertTextMemento;
            IMemento requiredTextMemento;
            IMemento filePatternMemento = memento.getChild(RequiredContentAspectEditor.TAG_FILE_PATTERN);
            if (filePatternMemento != null) {
                this.filePattern = RequiredContentAspectEditor.normalize(filePatternMemento.getString(RequiredContentAspectEditor.ATTR_PATTERN));
            }
            if ((requiredTextMemento = memento.getChild(RequiredContentAspectEditor.TAG_REQUIRED_TEXT)) != null) {
                this.requiredText = RequiredContentAspectEditor.normalize(requiredTextMemento.getString(RequiredContentAspectEditor.ATTR_TEXT));
            }
            if ((insertTextMemento = memento.getChild(RequiredContentAspectEditor.TAG_INSERT_TEXT)) != null) {
                this.insertText = RequiredContentAspectEditor.normalize(insertTextMemento.getString(RequiredContentAspectEditor.ATTR_TEXT));
            }
            this.componentNames.clear();
            this.componentNames.addAll(ComponentScopeDefinitionBlock.readComponents(memento));
        }

        public boolean saveTo(IMemento memento) {
            IMemento child = memento.createChild(RequiredContentAspectEditor.TAG_FILE_PATTERN);
            child.putString(RequiredContentAspectEditor.ATTR_PATTERN, this.filePattern);
            child = memento.createChild(RequiredContentAspectEditor.TAG_REQUIRED_TEXT);
            child.putString(RequiredContentAspectEditor.ATTR_TEXT, this.requiredText);
            if (RequiredContentAspectEditor.isNotNull(this.insertText)) {
                child = memento.createChild(RequiredContentAspectEditor.TAG_INSERT_TEXT);
                child.putString(RequiredContentAspectEditor.ATTR_TEXT, this.insertText);
            }
            ComponentScopeDefinitionBlock.saveComponents(this.componentNames, memento);
            return true;
        }
    }
}

