/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver.editors;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.ide.ui.IProcessAspectEditorSite;
import com.ibm.team.process.ide.ui.OperationDetailsAspectEditor;
import com.ibm.team.process.ide.ui.ProcessAspect;
import com.ibm.team.process.ide.ui.ProcessAspectEditor2;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.editors.Messages;
import com.ibm.team.process.internal.ide.ui.editors.form.util.MessageBox;
import com.ibm.team.process.internal.ide.ui.editors.util.DisplayHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.TestKindRegistry;
import org.eclipse.jdt.internal.junit.launcher.TestSelectionDialog;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class RequireTestRunAspectEditor
extends OperationDetailsAspectEditor {
    private static final String TAG_SUITE = "suite";
    private static final String ATTR_CLASS = "class";
    private Model fModel;
    private ArrayList fTestSuiteKinds;
    private ITestKind fTestKind;
    private IJavaProject fJavaProject;
    private Text fJavaProjectField;
    private Text fTestSuiteField;
    private ControlDecoration fTestSuiteDecoration;
    private Button fSearchTestSuiteButton;
    private MessageBox fMessageBox;
    private boolean fSettingInput;

    private static boolean isNotNull(String string) {
        return string != null && string.trim().length() > 0;
    }

    private static String normalize(String string) {
        return string == null ? "" : string.trim();
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(1).applyTo(parent);
        Label heading = toolkit.createLabel(parent, Messages.RequireTestRunAspectEditor_0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)heading);
        heading.setFont(this.getBoldFont());
        Composite body = toolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)body);
        GridLayoutFactory.fillDefaults().spacing(10, 8).numColumns(3).applyTo(body);
        Label label = toolkit.createLabel(body, Messages.RequireTestRunAspectEditor_1);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        final Combo combo = new Combo(body, 4);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)combo);
        combo.setItems(this.getTestSuiteKindLabels());
        combo.select(0);
        this.fTestKind = (ITestKind)this.fTestSuiteKinds.get(0);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequireTestRunAspectEditor.this.fTestKind = (ITestKind)RequireTestRunAspectEditor.this.fTestSuiteKinds.get(combo.getSelectionIndex());
            }
        });
        label = toolkit.createLabel(body, Messages.RequireTestRunAspectEditor_2);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fJavaProjectField = toolkit.createText(body, "", 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fJavaProjectField);
        this.fJavaProjectField.setEditable(false);
        this.fJavaProjectField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RequireTestRunAspectEditor.this.fSearchTestSuiteButton.setEnabled(RequireTestRunAspectEditor.isNotNull(RequireTestRunAspectEditor.this.fJavaProjectField.getText()));
            }
        });
        Button selectProject = toolkit.createButton(body, Messages.RequireTestRunAspectEditor_3, 0x800000);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.fJavaProjectField);
        selectProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequireTestRunAspectEditor.this.handleSelectProject();
            }
        });
        label = toolkit.createLabel(body, Messages.RequireTestRunAspectEditor_4);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.fTestSuiteField = toolkit.createText(body, "", 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTestSuiteField);
        this.fTestSuiteField.setEditable(false);
        this.fTestSuiteDecoration = new ControlDecoration((Control)this.fTestSuiteField, 16512);
        this.fTestSuiteField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!RequireTestRunAspectEditor.this.fSettingInput) {
                    RequireTestRunAspectEditor.this.setDirty();
                    RequireTestRunAspectEditor.this.validateData();
                }
            }
        });
        this.fSearchTestSuiteButton = toolkit.createButton(body, Messages.RequireTestRunAspectEditor_5, 0x800000);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.fJavaProjectField);
        this.fSearchTestSuiteButton.setEnabled(false);
        this.fSearchTestSuiteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RequireTestRunAspectEditor.this.handleSearchTestSuite();
            }
        });
        this.fMessageBox = new MessageBox();
        Composite messageBoxControl = this.fMessageBox.createControl(parent, toolkit, (ProcessAspectEditor2)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageBoxControl);
        DisplayHelper.asyncExec((Control)messageBoxControl, (Runnable)new Runnable(){

            public void run() {
                RequireTestRunAspectEditor.this.updateUI();
            }
        });
    }

    private Font getBoldFont() {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    private String[] getTestSuiteKindLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (ITestKind kind : this.fTestSuiteKinds) {
            labels.add(kind.getDisplayName());
        }
        return labels.toArray(new String[labels.size()]);
    }

    public void updateUI() {
        this.fSettingInput = true;
        try {
            this.fTestSuiteField.setText(this.fModel.className);
            this.validateData();
        }
        finally {
            this.fSettingInput = false;
        }
    }

    private void handleSelectProject() {
        this.fJavaProject = this.selectJavaProject();
        this.fJavaProjectField.setText(this.fJavaProject == null ? "" : this.fJavaProject.getElementName());
    }

    private IJavaProject selectJavaProject() {
        Object[] projects;
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            projects = new IJavaProject[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.fJavaProjectField.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(Messages.RequireTestRunAspectEditor_6);
        dialog.setMessage(Messages.RequireTestRunAspectEditor_7);
        dialog.setElements(projects);
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private void handleSearchTestSuite() {
        IType testSuite = this.selectTestSuite();
        if (testSuite != null) {
            this.fJavaProjectField.setText(testSuite.getJavaProject().getElementName());
            this.fModel.className = testSuite.getFullyQualifiedName();
            this.fTestSuiteField.setText(this.fModel.className);
        } else {
            this.fTestSuiteField.setText("");
        }
    }

    private IType selectTestSuite() {
        Object[] results;
        IType[] testSuites = this.getAllTestSuites();
        TestSelectionDialog dialog = new TestSelectionDialog(this.fTestSuiteField.getShell(), testSuites);
        dialog.setTitle(Messages.RequireTestRunAspectEditor_9);
        dialog.setMessage(Messages.RequireTestRunAspectEditor_10);
        if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length >= 1) {
            return (IType)results[0];
        }
        return null;
    }

    private IType[] getAllTestSuites() {
        ArrayList testSuites = new ArrayList();
        IWorkbenchWindow workbenchWindow = this.findWorkbenchWindow();
        try {
            IType[] types = TestSearchEngine.findTests((IRunnableContext)workbenchWindow, (IJavaElement)this.fJavaProject, (ITestKind)this.fTestKind);
            if (types != null && types.length > 0) {
                testSuites.addAll(Arrays.asList(types));
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return testSuites.toArray(new IType[testSuites.size()]);
    }

    private IWorkbenchWindow findWorkbenchWindow() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = workbenchWindows[0];
        }
        return window;
    }

    public void dispose() {
    }

    public void init(IProcessAspectEditorSite site, ProcessAspect inputAspect) {
        super.init(site, inputAspect);
        this.fModel = new Model();
        this.fTestSuiteKinds = TestKindRegistry.getDefault().getAllKinds();
    }

    public void restoreState(IMemento memento) {
        this.fModel.readFrom(memento);
    }

    public boolean saveState(IMemento memento) {
        return this.fModel.saveTo(memento);
    }

    private void validateData() {
        if (this.validateTestSuite()) {
            this.fMessageBox.clearMessage();
        }
    }

    private boolean validateTestSuite() {
        String testSuiteName = this.fTestSuiteField.getText();
        if (RequireTestRunAspectEditor.isNull(testSuiteName)) {
            this.setValidationMessage(true, this.fTestSuiteDecoration, true, Messages.RequireTestRunAspectEditor_11);
            return false;
        }
        this.setValidationMessage(true, this.fTestSuiteDecoration, true, null);
        return true;
    }

    private static boolean isNull(String string) {
        return string == null || string.trim().length() == 0;
    }

    private void setValidationMessage(boolean required, ControlDecoration decoration, boolean setErrorMessage, String msg) {
        if (msg != null) {
            if (setErrorMessage) {
                this.fMessageBox.setErrorMessage(msg);
            }
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        } else {
            this.clearDecoration(decoration, required);
        }
    }

    private void clearDecoration(ControlDecoration decoration, boolean required) {
        if (required) {
            decoration.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_REQUIRED").getImage());
        } else {
            decoration.hide();
            decoration.setImage(null);
            decoration.show();
        }
    }

    private static class Model {
        String className = "";

        private Model() {
        }

        public void readFrom(IMemento memento) {
            IMemento suiteMemento = memento.getChild(RequireTestRunAspectEditor.TAG_SUITE);
            if (suiteMemento != null) {
                this.className = RequireTestRunAspectEditor.normalize(suiteMemento.getString(RequireTestRunAspectEditor.ATTR_CLASS));
            }
        }

        public boolean saveTo(IMemento memento) {
            if (RequireTestRunAspectEditor.isNotNull(this.className)) {
                IMemento suiteMemento = memento.createChild(RequireTestRunAspectEditor.TAG_SUITE);
                suiteMemento.putString(RequireTestRunAspectEditor.ATTR_CLASS, this.className);
                return true;
            }
            return false;
        }
    }
}

