/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisorDetailProvider;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RequiredContentDetailProvider
extends AbstractFileAdvisorDetailProvider {
    public static final String DATA_TAG_FILE = "file";
    public static final String DATA_ATTR_FILE_ITEMID = "fileItemId";
    public static final String DATA_ATTR_FILE_NAME = "fileName";
    public static final String DATA_ATTR_COMPONENT_ITEMID = "componentItemId";
    public static final String DATA_ATTR_WORKSPACE_ITEMID = "workspaceItemId";

    public RequiredContentDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer) {
        final List filesMissingContent = RequiredContentDetailProvider.getFiles(info);
        Collections.sort(filesMissingContent, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof IFile && arg1 instanceof IFile) {
                    Collator collator = Collator.getInstance();
                    return collator.compare(((IFile)arg0).getName(), ((IFile)arg1).getName());
                }
                return 0;
            }
        });
        int numFiles = filesMissingContent.size();
        if (numFiles > 0) {
            int maxFilesToShow = 10;
            if (numFiles == 1) {
                buffer.append(Messages.RequiredContentDetailProvider_0);
            } else {
                buffer.append(NLS.bind((String)Messages.RequiredContentDetailProvider_1, (Object)numFiles));
            }
            int i = 0;
            while (i < filesMissingContent.size() && i < maxFilesToShow) {
                IFile file = (IFile)filesMissingContent.get(i);
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendFileLink(buffer, file);
                ++i;
            }
            if (numFiles > maxFilesToShow) {
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendHyperlink(NLS.bind((String)Messages.RequiredContentDetailProvider_2, (Object)(numFiles - maxFilesToShow)), Messages.RequiredContentDetailProvider_3, buffer, new Runnable(){

                    public void run() {
                        RequiredContentDetailProvider.this.showAllFiles(filesMissingContent);
                    }
                });
            }
        }
    }

    public static List getFiles(IAdvisorInfo info) {
        List<IFile> files = new ArrayList();
        Object problemObject = info.getProblemObject();
        if (problemObject instanceof List) {
            files = (List)problemObject;
        } else {
            Element dataElement = AbstractFileAdvisorDetailProvider.getDataElement(info.getData());
            if (dataElement != null) {
                NodeList fileElements = dataElement.getElementsByTagName(DATA_TAG_FILE);
                int i = 0;
                while (i < fileElements.getLength()) {
                    Element fileElement = (Element)fileElements.item(i);
                    UUID workspaceItemId = UUID.valueOf((String)fileElement.getAttribute(DATA_ATTR_WORKSPACE_ITEMID));
                    IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceItemId, null);
                    UUID componentItemId = UUID.valueOf((String)fileElement.getAttribute(DATA_ATTR_WORKSPACE_ITEMID));
                    IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(componentItemId, null);
                    UUID fileItemId = UUID.valueOf((String)fileElement.getAttribute(DATA_ATTR_FILE_ITEMID));
                    IFileItemHandle fileItemHandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle(fileItemId, null);
                    ISharingManager sharingManager = FileSystemCore.getSharingManager();
                    try {
                        IFile file;
                        IShareable shareable = sharingManager.findShareable(sharingManager.getDefaultCFARoot(), (IVersionableHandle)fileItemHandle, componentHandle, (IContextHandle)workspaceHandle, null);
                        if (shareable != null && (file = (IFile)shareable.getAdapter(IFile.class)) != null) {
                            files.add(file);
                        }
                    }
                    catch (FileSystemClientException fileSystemClientException) {}
                    ++i;
                }
            }
        }
        return files;
    }
}

