/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessClientService;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemApprovalProblemObject;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RequireWorkItemApprovalAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ELEMENT_APPROVAL = "approval";
    private static String ELEMENT_APPROVERS = "approvers";
    private static String ATTR_TYPE = "type";
    private static String ATTR_ROLE = "role";
    private static String ATTR_NUMBER_OF_APPROVERS = "number-of-approvers";
    public static String VAL_REVIEW = "Review";
    public static String VAL_APPROVAL = "Approval";
    public static String VAL_VERIFICATION = "Verification";
    public static String VAL_DEFAULT_ROLE = "default";
    public static final String ID_APPROVAL_ADVISOR = "com.ibm.team.process.deliver.requireWorkItemApproval";
    public static final String ID_APPROVAL_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApprovalProblem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApproval.configurationProblem";
    private List fRequirements = new ArrayList();

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_0, 1000);
        try {
            try {
                this.initialize(advisorConfiguration);
                IProcessArea handle = operation.getProcessArea();
                ITeamRepository repo = (ITeamRepository)handle.getOrigin();
                IProcessArea processArea = (IProcessArea)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (data.getChangeSetHandles().size() > 0) {
                    this.addProblems(data, processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.RequireWorkItemApprovalAdvisor_1, (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                IProcessConfigurationElement[] children2 = child.getChildren();
                int j = 0;
                while (j < children2.length) {
                    IProcessConfigurationElement child2 = children2[j];
                    String child2Name = child2.getName();
                    if (ELEMENT_APPROVAL.equals(child2Name)) {
                        String approvalType = child2.getAttribute(ATTR_TYPE);
                        ArrayList<Approvers> allApprovers = new ArrayList<Approvers>();
                        IProcessConfigurationElement[] children3 = child2.getChildren();
                        int k = 0;
                        while (k < children3.length) {
                            IProcessConfigurationElement child3 = children3[k];
                            String child3Name = child3.getName();
                            if (ELEMENT_APPROVERS.equals(child3Name)) {
                                Approvers approvers = new Approvers();
                                approvers.role = child3.getAttribute(ATTR_ROLE);
                                String numberString = child3.getAttribute(ATTR_NUMBER_OF_APPROVERS);
                                try {
                                    approvers.numberOfApprovers = Integer.parseInt(numberString);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    approvers.numberOfApprovers = 1;
                                }
                                allApprovers.add(approvers);
                            }
                            ++k;
                        }
                        Requirement requirement = new Requirement();
                        requirement.type = approvalType;
                        requirement.approvers = allApprovers.toArray(new Approvers[allApprovers.size()]);
                        this.fRequirements.add(requirement);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addProblems(DeliverOperationData data, IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000 * (data.getChangeSetHandles().size() + 3));
        try {
            ITeamRepository repository = (ITeamRepository)processArea.getOrigin();
            IProcessClientService clientService = (IProcessClientService)repository.getClientLibrary(IProcessClientService.class);
            IClientProcess clientProcess = clientService.getClientProcess(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (!this.checkRequirementsSpecification(clientProcess, processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                return;
            }
            ITeamRepository repo = (ITeamRepository)processArea.getOrigin();
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)new ClientProviderFactory(repo), (List)data.getChangeSetHandles(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                if (changeSet != null) {
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, workItemHandles, changeSet, collector, clientProcess, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkRequirementsSpecification(IClientProcess clientProcess, IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_2, 500);
        try {
            IRole[] roles = clientProcess.getRoles(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            boolean succeeded = true;
            for (Requirement requirement : this.fRequirements) {
                if (!this.isValidTypeValue(requirement.type)) {
                    collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.RequireWorkItemApprovalAdvisor_3, NLS.bind((String)Messages.RequireWorkItemApprovalAdvisor_4, (Object[])new Object[]{VAL_APPROVAL, VAL_REVIEW, VAL_VERIFICATION}), ID_CONFIGURATION_PROBLEM));
                    succeeded = false;
                }
                int i = 0;
                while (i < requirement.approvers.length) {
                    Approvers approvers = requirement.approvers[i];
                    if (!this.isValidRoleValue(approvers.role, roles)) {
                        collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.RequireWorkItemApprovalAdvisor_5, Messages.RequireWorkItemApprovalAdvisor_6, ID_CONFIGURATION_PROBLEM));
                        succeeded = false;
                    }
                    ++i;
                }
            }
            boolean bl = succeeded;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isValidTypeValue(String typeValue) {
        return VAL_APPROVAL.equals(typeValue) || VAL_REVIEW.equals(typeValue) || VAL_VERIFICATION.equals(typeValue);
    }

    private boolean isValidRoleValue(String roleValue, IRole[] definedRoles) {
        return VAL_DEFAULT_ROLE.equals(roleValue) || this.isDefinedRole(roleValue, definedRoles);
    }

    private boolean isDefinedRole(String roleValue, IRole[] definedRoles) {
        int i = 0;
        while (i < definedRoles.length) {
            if (definedRoles[i].getId().equals(roleValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addProblem(DeliverOperationData data, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IClientProcess clientProcess, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_7, 1000);
        try {
            if (workItems == null || workItems.isEmpty()) {
                collector.addInfo((IReportInfo)this.createProblem(Messages.RequireWorkItemApprovalAdvisor_8, Messages.RequireWorkItemApprovalAdvisor_9, collector, data, changeSet, workItems, processArea));
                return;
            }
            ITeamRepository teamRepository = (ITeamRepository)processArea.getOrigin();
            workItems = teamRepository.itemManager().fetchCompleteItems(workItems, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            ListIterator iterator = workItems.listIterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.RequireWorkItemApprovalAdvisor_10, (Throwable)new TeamRepositoryException(Messages.RequireWorkItemApprovalAdvisor_11)));
                iterator.remove();
            }
            String approvalProblem = this.checkApprovals(workItems, clientProcess, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            if (approvalProblem != null && approvalProblem.trim().length() > 0) {
                IAdvisorInfo info = this.createProblem(Messages.RequireWorkItemApprovalAdvisor_12, approvalProblem, collector, data, changeSet, workItems, processArea);
                collector.addInfo((IReportInfo)info);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorInfo createProblem(String summary, String description, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProcessArea processArea) {
        RequireWorkItemApprovalProblemObject object = new RequireWorkItemApprovalProblemObject(data, changeSet, workItems, processArea);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, ID_APPROVAL_PROBLEM);
        problem.setProblemObject((Object)object);
        return problem;
    }

    private String checkApprovals(List workItems, IClientProcess clientProcess, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_13, numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredApprovals(workItem, clientProcess, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (numWorkItems == 1) {
            return Messages.RequireWorkItemApprovalAdvisor_14;
        }
        return Messages.RequireWorkItemApprovalAdvisor_15;
    }

    private boolean hasRequiredApprovals(IWorkItem workItem, IClientProcess clientProcess, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_16, this.fRequirements.size() * 1000);
        try {
            for (Requirement requirement : this.fRequirements) {
                if (this.meetsRequirement(requirement, workItem, clientProcess, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return false;
            }
            return true;
        }
        finally {
            monitor.done();
        }
    }

    private boolean meetsRequirement(Requirement requirement, IWorkItem workItem, IClientProcess clientProcess, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        IApprovalType requiredType = this.getApprovalType(requirement);
        if (requiredType != null) {
            IApprovals approvals = workItem.getApprovals();
            List descriptors = approvals.getDescriptors();
            Approvers[] approvers = requirement.approvers;
            monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_17, 1000 * descriptors.size() * approvers.length);
            try {
                block4: for (IApprovalDescriptor descriptor : descriptors) {
                    IApprovalType actualType = WorkItemApprovals.getType((String)descriptor.getTypeIdentifier());
                    if (requiredType == actualType) {
                        int i = 0;
                        while (i < approvers.length) {
                            if (!this.checkRequiredApprovers(approvers[i], approvals, descriptor, clientProcess, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue block4;
                            ++i;
                        }
                        return true;
                    }
                    monitor.worked(1000 * approvers.length);
                }
            }
            finally {
                monitor.done();
            }
        }
        return false;
    }

    private boolean checkRequiredApprovers(Approvers approvers, IApprovals approvals, IApprovalDescriptor descriptor, IClientProcess clientProcess, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        List contents = approvals.getContents(descriptor);
        monitor.beginTask(Messages.RequireWorkItemApprovalAdvisor_18, contents.size() * 1000);
        try {
            int missingApprovers = approvers.numberOfApprovers;
            for (IApproval approval : contents) {
                IApprovalState state = WorkItemApprovals.getState((String)approval.getStateIdentifier());
                if (WorkItemApprovals.APPROVED_STATE != state) continue;
                IContributorHandle handle = approval.getApprover();
                IRole[] contributorRoles = clientProcess.getContributorRoles(handle, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                int i = 0;
                while (i < contributorRoles.length) {
                    IRole role = contributorRoles[i];
                    if (approvers.role.equals(role.getId()) && --missingApprovers == 0) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private IApprovalType getApprovalType(Requirement requirement) {
        if (VAL_APPROVAL.equals(requirement.type)) {
            return WorkItemApprovals.APPROVAL_TYPE;
        }
        if (VAL_REVIEW.equals(requirement.type)) {
            return WorkItemApprovals.REVIEW_TYPE;
        }
        if (VAL_VERIFICATION.equals(requirement.type)) {
            return WorkItemApprovals.VERIFICATION_TYPE;
        }
        return null;
    }

    private static class Approvers {
        public String role;
        public int numberOfApprovers;

        private Approvers() {
        }
    }

    private static class Requirement {
        public String type;
        public Approvers[] approvers;

        private Requirement() {
        }
    }
}

