/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemProblemObject;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.internal.ClientProviderFactory;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class RequireWorkItemAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ATTR_VALUE = "value";
    public static String VAL_WORKITEM = "workitem";
    public static String VAL_COMMENT = "comment";
    public static String VAL_WORKITEM_OR_COMMENT = "workitem-or-comment";
    public static String VAL_WORKITEM_AND_COMMENT = "workitem-and-comment";
    private static String ELEMENT_WORKITEM = "workitem";
    private static String ATTR_TARGET = "target";
    private static String ATTR_OWNER = "owner";
    private static String VAL_REQUIRED = "required";
    private static String VAL_OPTIONAL = "optional";
    private static String VAL_CURRENT_ITERATION = "current-iteration";
    private static String VAL_CURRENT_CONTRIBUTOR = "current-contributor";
    public static final String ID_REQUIRE_WORK_ITEM = "com.ibm.team.process.deliver.requireWorkItem";
    public static final String ID_REQUIRE_WORK_ITEM_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemProblem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItem.configurationProblem";
    private String fRequires = VAL_WORKITEM;
    private String fTarget = VAL_OPTIONAL;
    private String fOwner = VAL_OPTIONAL;

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                this.fRequires = child.getAttribute(ATTR_VALUE);
                IProcessConfigurationElement[] grandChildren = child.getChildren();
                int j = 0;
                while (j < grandChildren.length) {
                    IProcessConfigurationElement grandChild = grandChildren[j];
                    String grandChildName = grandChild.getName();
                    if (ELEMENT_WORKITEM.equals(grandChildName)) {
                        this.fTarget = grandChild.getAttribute(ATTR_TARGET);
                        this.fOwner = grandChild.getAttribute(ATTR_OWNER);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = operation.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.RequireWorkItemAdvisor_0, 1000);
        try {
            try {
                this.initialize(advisorConfiguration);
                ITeamArea teamArea = (ITeamArea)operation.getProcessArea();
                IProjectAreaHandle handle = teamArea.getProjectArea();
                ITeamRepository repo = (ITeamRepository)handle.getOrigin();
                IProjectArea projectArea = (IProjectArea)repo.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
                if (data.getChangeSetHandles().size() > 0) {
                    this.addProblems(data, teamArea, projectArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.RequireWorkItemAdvisor_1, (Throwable)e));
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addProblems(DeliverOperationData data, ITeamArea teamArea, IProjectArea projectArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000 * data.getChangeSetHandles().size() + 1);
        try {
            if (!this.isValidRequiresValue(this.fRequires)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.RequireWorkItemAdvisor_3, NLS.bind((String)Messages.RequireWorkItemAdvisor_4, (Object[])new Object[]{VAL_WORKITEM, VAL_COMMENT, VAL_WORKITEM_OR_COMMENT, VAL_WORKITEM_AND_COMMENT}), ID_CONFIGURATION_PROBLEM));
                monitor.done();
                return;
            }
            if (!this.isValidTargetValue(this.fTarget)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.RequireWorkItemAdvisor_3, NLS.bind((String)Messages.RequireWorkItemAdvisor_6, (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_ITERATION}), ID_CONFIGURATION_PROBLEM));
            }
            if (!this.isValidOwnerValue(this.fOwner)) {
                collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.RequireWorkItemAdvisor_3, NLS.bind((String)Messages.RequireWorkItemAdvisor_8, (Object[])new Object[]{VAL_OPTIONAL, VAL_REQUIRED, VAL_CURRENT_CONTRIBUTOR}), ID_CONFIGURATION_PROBLEM));
            }
            ITeamRepository repo = (ITeamRepository)projectArea.getOrigin();
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)new ClientProviderFactory(repo), (List)data.getChangeSetHandles(), (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                String comment = null;
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                if (changeSet != null) {
                    comment = changeSet.getComment();
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, comment, workItemHandles, changeSet, collector, projectArea, teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private IAdvisorInfo createProblem(String summary, String description, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProjectArea projectArea, boolean isNeedTarget, boolean isNeedOwner) {
        RequireWorkItemProblemObject object = new RequireWorkItemProblemObject(data, changeSet, workItems, projectArea, this.fRequires, isNeedTarget, isNeedOwner);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, ID_REQUIRE_WORK_ITEM_PROBLEM);
        problem.setProblemObject((Object)object);
        return problem;
    }

    private boolean isValidRequiresValue(String requiresValue) {
        return VAL_WORKITEM.equals(requiresValue) || VAL_COMMENT.equals(requiresValue) || VAL_WORKITEM_OR_COMMENT.equals(requiresValue) || VAL_WORKITEM_AND_COMMENT.equals(requiresValue);
    }

    private boolean isValidTargetValue(String targetValue) {
        return VAL_OPTIONAL.equals(targetValue) || VAL_REQUIRED.equals(targetValue) || VAL_CURRENT_ITERATION.equals(targetValue);
    }

    private boolean isValidOwnerValue(String ownerValue) {
        return VAL_OPTIONAL.equals(ownerValue) || VAL_REQUIRED.equals(ownerValue) || VAL_CURRENT_CONTRIBUTOR.equals(ownerValue);
    }

    private void addProblem(DeliverOperationData data, String comment, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IProjectArea projectArea, ITeamArea teamArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.RequireWorkItemAdvisor_9, 1000);
        try {
            boolean hasWorkitems = workItems != null && !workItems.isEmpty();
            boolean hasComment = comment != null && comment.trim().length() > 0;
            String problemSummary = null;
            String problemDetail = null;
            if (VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) && !hasWorkitems && !hasComment) {
                problemSummary = Messages.RequireWorkItemAdvisor_10;
                problemDetail = Messages.RequireWorkItemAdvisor_11;
            } else if ((VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) || VAL_WORKITEM.equals(this.fRequires)) && !hasWorkitems) {
                problemSummary = Messages.RequireWorkItemAdvisor_12;
                problemDetail = Messages.RequireWorkItemAdvisor_13;
            } else if ((VAL_WORKITEM_AND_COMMENT.equals(this.fRequires) || VAL_COMMENT.equals(this.fRequires)) && !hasComment) {
                problemSummary = Messages.RequireWorkItemAdvisor_14;
                problemDetail = Messages.RequireWorkItemAdvisor_15;
            } else if (VAL_WORKITEM_OR_COMMENT.equals(this.fRequires) && !hasWorkitems && !hasComment) {
                problemSummary = Messages.RequireWorkItemAdvisor_16;
                problemDetail = Messages.RequireWorkItemAdvisor_17;
            }
            if (problemSummary != null) {
                collector.addInfo((IReportInfo)this.createProblem(problemSummary, problemDetail, collector, data, changeSet, workItems, projectArea, false, false));
                return;
            }
            IAdvisorInfo info = null;
            if (hasWorkitems) {
                String ownerProblem;
                ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
                workItems = teamRepository.itemManager().fetchCompleteItems(workItems, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                ListIterator iterator = workItems.listIterator();
                while (iterator.hasNext()) {
                    if (iterator.next() != null) continue;
                    collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.RequireWorkItemAdvisor_18, (Throwable)new TeamRepositoryException(Messages.RequireWorkItemAdvisor_19)));
                    iterator.remove();
                }
                StringBuffer buffer = new StringBuffer();
                String targetProblem = this.checkTarget(workItems, teamArea, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
                if (targetProblem != null) {
                    buffer.append(targetProblem);
                }
                if ((ownerProblem = this.checkOwner(workItems, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 300))) != null) {
                    buffer.append(ownerProblem);
                }
                if (buffer.length() > 0) {
                    String summary = Messages.RequireWorkItemAdvisor_20;
                    if (workItems.size() == 1) {
                        summary = Messages.RequireWorkItemAdvisor_21;
                    }
                    info = this.createProblem(summary, buffer.toString(), collector, data, changeSet, workItems, projectArea, targetProblem != null, ownerProblem != null);
                }
            }
            if (info != null) {
                collector.addInfo(info);
            }
        }
        finally {
            monitor.done();
        }
    }

    private String checkTarget(List workItems, ITeamArea teamArea, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fTarget) || numWorkItems == 0) {
            return null;
        }
        monitor.beginTask(Messages.RequireWorkItemAdvisor_22, numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredTarget(workItem, teamArea, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (VAL_REQUIRED.equals(this.fTarget)) {
            if (numWorkItems == 1) {
                return Messages.RequireWorkItemAdvisor_23;
            }
            return Messages.RequireWorkItemAdvisor_24;
        }
        if (numWorkItems == 1) {
            return Messages.RequireWorkItemAdvisor_25;
        }
        return Messages.RequireWorkItemAdvisor_26;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasRequiredTarget(IWorkItem workItem, ITeamArea teamArea, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.RequireWorkItemAdvisor_27, 1000);
        try {
            IIterationHandle handle = workItem.getTarget();
            if (VAL_REQUIRED.equals(this.fTarget)) {
                boolean bl = handle != null;
                return bl;
            }
            if (handle == null) {
                return false;
            }
            IProcessItemService processService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
            IDevelopmentLine line = processService.getDevelopmentLine(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IIteration target = (IIteration)teamRepository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            IIteration[] currentIterations = processService.getCurrentIterations((IDevelopmentLineHandle)line, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            int i = currentIterations.length - 1;
            while (i >= 0) {
                IIteration iteration = currentIterations[i];
                if (target.sameItemId((IItemHandle)iteration)) {
                    return true;
                }
                if (iteration.hasDeliverable()) {
                    return false;
                }
                --i;
            }
            return false;
        }
        finally {
            monitor.done();
        }
    }

    private String checkOwner(List workItems, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        if (VAL_OPTIONAL.equals(this.fOwner) || numWorkItems == 0) {
            return null;
        }
        monitor.beginTask(Messages.RequireWorkItemAdvisor_29, numWorkItems * 1000);
        try {
            for (IWorkItem workItem : workItems) {
                if (!this.hasRequiredOwner(workItem, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) continue;
                return null;
            }
        }
        finally {
            monitor.done();
        }
        if (VAL_REQUIRED.equals(this.fOwner)) {
            if (numWorkItems == 1) {
                return Messages.RequireWorkItemAdvisor_30;
            }
            return Messages.RequireWorkItemAdvisor_31;
        }
        if (numWorkItems == 1) {
            return Messages.RequireWorkItemAdvisor_32;
        }
        return Messages.RequireWorkItemAdvisor_33;
    }

    private boolean hasRequiredOwner(IWorkItem workItem, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        IContributorHandle handle = workItem.getOwner();
        if (handle == null) {
            return false;
        }
        IContributor owner = (IContributor)teamRepository.itemManager().fetchCompleteItem((IItemHandle)handle, 0, monitor);
        if (VAL_REQUIRED.equals(this.fOwner)) {
            return this.isValidOwner(owner);
        }
        return teamRepository.loggedInContributor().sameItemId((IItemHandle)owner);
    }

    private boolean isValidOwner(IContributor owner) {
        if (owner == null) {
            return false;
        }
        String userId = owner.getUserId();
        return userId != null && userId.trim().length() > 0 && !Messages.RequireWorkItemAdvisor_34.equalsIgnoreCase(userId);
    }

    public String getRequires() {
        return this.fRequires;
    }

    public String getTarget() {
        return this.fTarget;
    }
}

