/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.TestRunManager;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequireTestRunAdvisor
implements IOperationAdvisor {
    private static final String TAG_SUITE = "suite";
    private static final String ATTR_CLASS = "class";
    public static final String ID_PROBLEM_TESTS_UNDEFINED = "com.ibm.team.process.definitions.testsUndefined";
    public static final String ID_PROBLEM_TESTS_NOT_RUN = "com.ibm.team.process.definitions.testsNotRunProblem";
    public static final String ID_PROBLEM_FAILED_TESTS = "com.ibm.team.process.definitions.failedTestsProblem";
    public static final String ID_REQUIRE_TEST_RUN = "com.ibm.team.process.deliver.requireTestRun";
    private String fTestSuite;

    private void initialize(IProcessConfigurationElement element) {
        IProcessConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String elementName = child.getName();
            if (elementName.equals(TAG_SUITE)) {
                this.fTestSuite = child.getAttribute(ATTR_CLASS);
            }
            ++i;
        }
    }

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.initialize(advisorConfiguration);
        if (this.fTestSuite == null || this.fTestSuite.trim().length() == 0) {
            String description = "Tests should be run locally before delivering the change set. Please define a test that should succeed before delivering changes.";
            IAdvisorInfo problem = collector.createProblemInfo(Messages.RequireTestRunAdvisor_0, description, ID_PROBLEM_TESTS_UNDEFINED);
            problem.setSeverity(2);
            collector.addInfo((IReportInfo)problem);
            return;
        }
        TestRunManager testRunManager = DefinitionsIdeUIPlugin.getDefault().getTestRunManager();
        if (!testRunManager.wereTestsRun(this.fTestSuite)) {
            String description = Messages.RequireTestRunAdvisor_1;
            IAdvisorInfo problem = collector.createProblemInfo(Messages.RequireTestRunAdvisor_2, description, ID_PROBLEM_TESTS_NOT_RUN);
            problem.setData(this.fTestSuite);
            collector.addInfo((IReportInfo)problem);
        } else {
            Map failedTests = testRunManager.getFailedTests(this.fTestSuite);
            if (failedTests != null && !failedTests.isEmpty()) {
                StringBuffer buffer = new StringBuffer(Messages.RequireTestRunAdvisor_3);
                buffer.append(Messages.RequireTestRunAdvisor_4);
                Iterator e = failedTests.values().iterator();
                while (e.hasNext()) {
                    buffer.append(e.next());
                    buffer.append("\n");
                }
                IAdvisorInfo problem = collector.createProblemInfo(Messages.RequireTestRunAdvisor_5, buffer.toString(), ID_PROBLEM_FAILED_TESTS);
                problem.setData(this.fTestSuite);
                collector.addInfo((IReportInfo)problem);
            }
        }
    }
}

