/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisorDetailProvider;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;

public class ProhibitUnusedImportsDetailProvider
extends AbstractFileAdvisorDetailProvider {
    public ProhibitUnusedImportsDetailProvider(IAdvisorInfo info) {
        super(info);
    }

    protected void appendProblem(IAdvisorInfo info, StringBuffer buffer) {
        final List filesWithUnusedImports = (List)info.getProblemObject();
        Collections.sort(filesWithUnusedImports, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof IFile && arg1 instanceof IFile) {
                    RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance();
                    return collator.compare(((IFile)arg0).getName(), ((IFile)arg1).getName());
                }
                return 0;
            }
        });
        int numFiles = filesWithUnusedImports.size();
        if (numFiles > 0) {
            int maxFilesToShow = 10;
            if (numFiles == 1) {
                buffer.append(Messages.ProhibitUnusedImportsDetailProvider_0);
            } else {
                buffer.append(NLS.bind((String)Messages.ProhibitUnusedImportsDetailProvider_1, (Object)numFiles));
            }
            int i = 0;
            while (i < filesWithUnusedImports.size() && i < maxFilesToShow) {
                IFile file = (IFile)filesWithUnusedImports.get(i);
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendFileLink(buffer, file);
                ++i;
            }
            if (numFiles > maxFilesToShow) {
                buffer.append("<br>&nbsp;&nbsp;");
                this.appendHyperlink(NLS.bind((String)Messages.ProhibitUnusedImportsDetailProvider_2, (Object)(numFiles - maxFilesToShow)), Messages.ProhibitUnusedImportsDetailProvider_3, buffer, new Runnable(){

                    public void run() {
                        ProhibitUnusedImportsDetailProvider.this.showAllFiles(filesWithUnusedImports);
                    }
                });
            }
        }
    }
}

