/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProhibitCompilationErrorsAdvisor
extends AbstractFileAdvisor {
    public static final String DATA_TAG_PROJECT = "project";
    public static final String DATA_ATTR_PROJECT_NAME = "name";
    public static final String ID_PROHIBIT_COMPILATION_ERRORS_PROBLEM = "com.ibm.team.process.deliver.prohibitCompilationErrorsProblem";
    public static final String ID_PROHIBIT_COMPILATION_ERRORS = "com.ibm.team.process.deliver.prohibitCompilationErrors";
    private List fCheckedProjects;
    private List fErrorProjects;

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fCheckedProjects = new ArrayList();
        this.fErrorProjects = new ArrayList();
        super.run(operation, advisorConfiguration, collector, monitor);
        if (this.fErrorProjects.size() > 0) {
            IAdvisorInfo problem = collector.createProblemInfo(Messages.ProhibitCompilationErrorsAdvisor_0, Messages.ProhibitCompilationErrorsAdvisor_1, ID_PROHIBIT_COMPILATION_ERRORS_PROBLEM);
            problem.setProblemObject((Object)this.fErrorProjects);
            collector.addInfo((IReportInfo)problem);
        }
    }

    protected IReportInfo getProblem(IFile file, IAdvisorInfoCollector collector, IProgressMonitor monitor) {
        IProject project = file.getProject();
        if (!this.fCheckedProjects.contains(project)) {
            this.fCheckedProjects.add(project);
            try {
                IMarker[] markers = project.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                int i = 0;
                while (i < markers.length) {
                    if (markers[i].getAttribute("severity", 0) == 2) {
                        this.fErrorProjects.add(project);
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                return collector.createExceptionInfo(Messages.ProhibitCompilationErrorsAdvisor_2, (Throwable)e);
            }
        }
        return null;
    }

    protected void appendToProblemData(Element dataElement, Object custom, Document doc) {
    }
}

