/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemProblemObject;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewWorkItemResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    public boolean run(IAdvisorInfo info, IProgressMonitor monitor) {
        IParticipantReport advisorReport;
        AdvisableOperation operation;
        monitor.beginTask(Messages.NewWorkItemResolutionDelegate_0, 1000);
        WorkItemWorkingCopy workingCopy = null;
        boolean[] result = new boolean[1];
        Object problemObject = info.getProblemObject();
        if (problemObject instanceof RequireWorkItemProblemObject && (operation = (advisorReport = (IParticipantReport)info.getProcessReport()).getOperationReport().getOperation()) != null) {
            IProcessArea area = operation.getProcessArea();
            IProjectAreaHandle projectArea = area.getProjectArea();
            final RequireWorkItemProblemObject data = (RequireWorkItemProblemObject)problemObject;
            ITeamRepository teamRepository = (ITeamRepository)data.getProjectArea().getOrigin();
            IWorkItemClient client = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            try {
                final IWorkItemWorkingCopyManager workingCopyManager = client.getWorkItemWorkingCopyManager();
                IWorkItemType workItemType = client.findWorkItemType(projectArea, "task", (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                IWorkItemHandle handle = workingCopyManager.connectNew(workItemType, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                workingCopy = workingCopyManager.getWorkingCopy(handle);
                IWorkItem item = workingCopy.getWorkItem();
                item.setOwner((IContributorHandle)teamRepository.loggedInContributor());
                final IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)teamRepository.getClientLibrary(IFileSystemWorkItemManager.class);
                final WorkItemWorkingCopy finalWorkingCopy = workingCopy;
                result[0] = true;
                workingCopy.addWorkingCopyListener(new IWorkingCopyListener(){

                    public void workingCopyEvent(WorkingCopyEvent event) {
                        if (event.getType().equals("saved")) {
                            final IChangeSet changeSet = data.getChangeSet();
                            final ArrayList<IWorkItem> workItems = new ArrayList<IWorkItem>();
                            workItems.add(finalWorkingCopy.getWorkItem());
                            new Job(Messages.NewWorkItemResolutionDelegate_1){

                                protected IStatus run(IProgressMonitor monitor) {
                                    try {
                                        workItemManager.createLink(data.getOperationData().getSourceWorkspace(), (IChangeSetHandle)changeSet, workItems.toArray(new IWorkItemHandle[workItems.size()]), monitor);
                                    }
                                    catch (TeamRepositoryException e) {
                                        DefinitionsIdeUIPlugin.getDefault().log(e);
                                    }
                                    return Status.OK_STATUS;
                                }
                            }.schedule();
                            finalWorkingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
                            workingCopyManager.disconnect((IWorkItemHandle)finalWorkingCopy.getWorkItem());
                        } else if (event.getType().equals("aboutToBeDisposed")) {
                            finalWorkingCopy.removeWorkingCopyListener((IWorkingCopyListener)this);
                            workingCopyManager.disconnect((IWorkItemHandle)finalWorkingCopy.getWorkItem());
                        }
                    }
                });
            }
            catch (TeamRepositoryException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
            }
        }
        final WorkItemWorkingCopy finalWorkingCopy = workingCopy;
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                if (finalWorkingCopy != null) {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        WorkItemUI.openEditor((IWorkbenchPage)page, (Object)finalWorkingCopy.getWorkItem());
                    }
                } else {
                    Shell shell = display.getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)Messages.NewWorkItemResolutionDelegate_2, (String)Messages.NewWorkItemResolutionDelegate_3);
                }
            }
        });
        monitor.done();
        return result[0];
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        Object object = info.getProblemObject();
        if (object instanceof RequireWorkItemProblemObject) {
            RequireWorkItemProblemObject problemObject = (RequireWorkItemProblemObject)object;
            return problemObject.getWorkItems().isEmpty() && !problemObject.getRequires().equals(RequireWorkItemAdvisor.VAL_COMMENT);
        }
        return false;
    }
}

