/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.AbstractFileAdvisorDetailProvider;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequiredContentDetailProvider;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.w3c.dom.Element;

public class InsertRequiredTextResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    private static final String TAG_INSERT_TEXT = "insertText";

    public boolean run(IAdvisorInfo info, IProgressMonitor monitor) {
        String insertText = this.getInsertText(info);
        boolean result = false;
        if (insertText.length() > 0) {
            List files = RequiredContentDetailProvider.getFiles(info);
            if (files.size() > 0) {
                result = this.insertText(files, insertText, monitor);
            }
        } else {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null) {
                        MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.InsertRequiredTextResolutionDelegate_0, (String)NLS.bind((String)Messages.InsertRequiredTextResolutionDelegate_1, (Object)InsertRequiredTextResolutionDelegate.TAG_INSERT_TEXT));
                    }
                }
            });
        }
        return result;
    }

    protected boolean insertText(final List files, final String insertText, final IProgressMonitor monitor) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                for (IFile file : files) {
                    IDocument document;
                    IEditorPart part = InsertRequiredTextResolutionDelegate.this.openEditor(file);
                    if (!(part instanceof ITextEditor)) continue;
                    boolean wasDirty = part.isDirty();
                    IDocumentProvider documentProvider = ((ITextEditor)part).getDocumentProvider();
                    if (documentProvider == null || (document = documentProvider.getDocument((Object)part.getEditorInput())) == null) continue;
                    String text = document.get();
                    StringBuffer buffer = new StringBuffer(InsertRequiredTextResolutionDelegate.this.convertLineDelimiters(insertText, text));
                    buffer.append(text);
                    document.set(buffer.toString());
                    if (!wasDirty) {
                        part.doSave(monitor);
                    }
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    protected String convertLineDelimiters(String text, String baseText) {
        String targetDelimiter = this.getDelimiter(baseText);
        if (targetDelimiter != null) {
            StringBuffer buffer = new StringBuffer();
            if (targetDelimiter == "\r\n") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '\n') {
                        if (i <= 0 || text.charAt(i - 1) != '\r') {
                            buffer.append(targetDelimiter);
                        }
                    } else if (ch == '\r') {
                        buffer.append(targetDelimiter);
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                text = buffer.toString();
            } else if (targetDelimiter == "\n") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch != '\n' || i <= 0 || text.charAt(i - 1) != '\r') {
                        if (ch == '\r') {
                            buffer.append(targetDelimiter);
                        } else {
                            buffer.append(ch);
                        }
                    }
                    ++i;
                }
                text = buffer.toString();
            } else if (targetDelimiter == "\r") {
                int i = 0;
                while (i < text.length()) {
                    char ch = text.charAt(i);
                    if (ch == '\n') {
                        if (i <= 0 || text.charAt(i - 1) != '\r') {
                            buffer.append(targetDelimiter);
                        }
                    } else {
                        buffer.append(ch);
                    }
                    ++i;
                }
                text = buffer.toString();
            }
        }
        return text;
    }

    private String getDelimiter(String baseText) {
        int i = 0;
        while (i < baseText.length()) {
            char ch = baseText.charAt(i);
            if (ch == '\n') {
                return "\n";
            }
            if (ch == '\r') {
                if (baseText.length() >= i && baseText.charAt(i + 1) == '\n') {
                    return "\r\n";
                }
                return "\r";
            }
            ++i;
        }
        return null;
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        return this.getInsertText(info).length() > 0;
    }

    private String getInsertText(IAdvisorInfo info) {
        Element dataElement = AbstractFileAdvisorDetailProvider.getDataElement(info.getData());
        return dataElement.getAttribute(TAG_INSERT_TEXT);
    }

    public IEditorPart openEditor(IFile file) {
        IWorkbenchPage page;
        IEditorPart part = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            try {
                part = IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
            catch (PartInitException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
            }
        }
        return part;
    }
}

