/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemAdvisor;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemProblemObject;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AssociateWorkItemResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    public boolean run(IAdvisorInfo problem, IProgressMonitor monitor) {
        Object object = problem.getProblemObject();
        final boolean[] result = new boolean[1];
        if (object instanceof RequireWorkItemProblemObject) {
            final RequireWorkItemProblemObject problemObject = (RequireWorkItemProblemObject)object;
            final Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    final IWorkItemHandle[] workItems = AssociateWorkItemResolutionDelegate.openWorkItemPicker(display.getActiveShell(), problemObject.getProjectArea());
                    if (workItems.length > 0) {
                        result[0] = true;
                        Job job = new Job(Messages.AssociateWorkItemResolutionDelegate_0){

                            protected IStatus run(IProgressMonitor monitor) {
                                monitor.beginTask(Messages.AssociateWorkItemResolutionDelegate_1, 1000);
                                try {
                                    ITeamRepository repo = (ITeamRepository)problemObject.getProjectArea().getOrigin();
                                    IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)repo.getClientLibrary(IFileSystemWorkItemManager.class);
                                    workItemManager.createLink(problemObject.getOperationData().getSourceWorkspace(), (IChangeSetHandle)problemObject.getChangeSet(), workItems, monitor);
                                    IStatus iStatus = Status.OK_STATUS;
                                    return iStatus;
                                }
                                catch (TeamRepositoryException e) {
                                    Status status = new Status(4, "com.ibm.team.process.definitions.ide.ui", 4, Messages.AssociateWorkItemResolutionDelegate_2, (Throwable)e);
                                    return status;
                                }
                                finally {
                                    monitor.done();
                                }
                            }
                        };
                        job.setUser(true);
                        job.schedule();
                    }
                }
            });
        }
        return result[0];
    }

    public boolean mayBeApplicable(IAdvisorInfo info) {
        Object object = info.getProblemObject();
        if (object instanceof RequireWorkItemProblemObject) {
            RequireWorkItemProblemObject problemObject = (RequireWorkItemProblemObject)object;
            return problemObject.getWorkItems().isEmpty() && !problemObject.getRequires().equals(RequireWorkItemAdvisor.VAL_COMMENT);
        }
        return false;
    }

    public static IWorkItemHandle[] openWorkItemPicker(Shell parent, IProjectArea projectArea) {
        WorkItemSelectionDialog dialog = new WorkItemSelectionDialog(parent, (IProjectAreaHandle)projectArea, true);
        dialog.setTitle(Messages.AssociateWorkItemResolutionDelegate_3);
        if (dialog.open() == 0) {
            return (IWorkItemHandle[])dialog.getResult();
        }
        return new IWorkItemHandle[0];
    }
}

