/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.client.IAdvisorProblemResolutionDelegate;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.RequireWorkItemProblemObject;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWorkItemResolutionDelegate
implements IAdvisorProblemResolutionDelegate {
    public abstract boolean mayBeApplicable(RequireWorkItemProblemObject var1);

    public abstract void modifyWorkItem(IWorkItem var1, IDevelopmentLine var2, ITeamRepository var3, IProgressMonitor var4) throws TeamRepositoryException;

    public boolean mayBeApplicable(IAdvisorInfo info) {
        Object problemObject = info.getProblemObject();
        if (problemObject instanceof RequireWorkItemProblemObject) {
            return this.mayBeApplicable((RequireWorkItemProblemObject)problemObject);
        }
        return false;
    }

    public boolean run(IAdvisorInfo info, IProgressMonitor monitor) {
        IParticipantReport advisorReport;
        AdvisableOperation operation;
        monitor.beginTask(Messages.AbstractWorkItemResolutionDelegate_0, 1000);
        WorkItemWorkingCopy workingCopy = null;
        Object problemObject = info.getProblemObject();
        if (problemObject instanceof RequireWorkItemProblemObject && (operation = (advisorReport = (IParticipantReport)info.getProcessReport()).getOperationReport().getOperation()) != null) {
            RequireWorkItemProblemObject data = (RequireWorkItemProblemObject)problemObject;
            ITeamRepository teamRepository = (ITeamRepository)data.getProjectArea().getOrigin();
            List workItems = ((RequireWorkItemProblemObject)problemObject).getWorkItems();
            if (workItems.size() > 0) {
                IWorkItemHandle handle = (IWorkItemHandle)workItems.get(0);
                try {
                    IWorkItemClient client = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    IWorkItemWorkingCopyManager workingCopyManager = client.getWorkItemWorkingCopyManager();
                    workingCopyManager.connectCurrent(handle, ItemProfile.createFullProfile((IItemType)IWorkItem.ITEM_TYPE), (IProgressMonitor)new SubProgressMonitor(monitor, 125));
                    workingCopy = workingCopyManager.getWorkingCopy(handle);
                    boolean wasDirty = workingCopy.isDirty();
                    IWorkItem item = workingCopy.getWorkItem();
                    ITeamArea teamArea = (ITeamArea)operation.getProcessArea();
                    IProcessItemService processService = (IProcessItemService)teamRepository.getClientLibrary(IProcessItemService.class);
                    IDevelopmentLine developmentLine = processService.getDevelopmentLine(teamArea, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                    this.modifyWorkItem(item, developmentLine, teamRepository, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                    if (!wasDirty) {
                        workingCopy.save((IProgressMonitor)new SubProgressMonitor(monitor, 500));
                    } else {
                        final WorkItemWorkingCopy finalWorkingCopy = workingCopy;
                        final Display display = Display.getDefault();
                        display.asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchPage page;
                                IWorkbenchWindow window;
                                if (!display.isDisposed() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                                    WorkItemUI.openEditor((IWorkbenchPage)page, (Object)finalWorkingCopy.getWorkItem());
                                }
                            }
                        });
                    }
                    return true;
                }
                catch (TeamRepositoryException e) {
                    this.reportException(e);
                }
            }
        }
        return false;
    }

    private void reportException(final TeamRepositoryException e) {
        DefinitionsIdeUIPlugin.getDefault().log(e);
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    Shell[] shells;
                    Shell shell = display.getActiveShell();
                    if (shell == null && (shells = display.getShells()).length > 0) {
                        shell = shells[0];
                    }
                    if (shell != null) {
                        ErrorDialog.openError((Shell)shell, (String)Messages.AbstractWorkItemResolutionDelegate_1, null, (IStatus)new Status(4, "com.ibm.team.process.definitions.ide.ui", Messages.AbstractWorkItemResolutionDelegate_2, (Throwable)e));
                    }
                }
            }
        });
    }
}

