/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.definitions.ide.ui.deliver;

import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IParticipantReport;
import com.ibm.team.process.common.advice.IProcessReport;
import com.ibm.team.process.ide.ui.advice.AdviceElementDetailProvider;
import com.ibm.team.process.internal.definitions.ide.ui.DefinitionsIdeUIPlugin;
import com.ibm.team.process.internal.definitions.ide.ui.deliver.Messages;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbstractFileAdvisorDetailProvider
extends AdviceElementDetailProvider {
    public AbstractFileAdvisorDetailProvider(IAdvisorInfo info) {
        super((Object)info);
    }

    protected String createDetailText() {
        String parentDescription;
        IAdvisorInfo info = (IAdvisorInfo)this.fElement;
        StringBuffer buffer = new StringBuffer();
        this.appendBodyAndTableStart(buffer, info.getSeverity());
        String problemTitle = Messages.AbstractFileAdvisorDetailProvider_1;
        buffer.append("<b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)problemTitle));
        this.appendProblem(info, buffer);
        IProcessReport parentReport = info.getProcessReport();
        if (parentReport instanceof IParticipantReport && (parentDescription = parentReport.getDescription()) != null && parentDescription.length() > 0) {
            String reasonTitle = Messages.AbstractFileAdvisorDetailProvider_2;
            buffer.append("<br><br><b><font color=\"").append(this.getTitleFontColor()).append(NLS.bind((String)"\">{0}</font></b><br>", (Object)reasonTitle));
            buffer.append(this.convertToHtml(parentDescription));
        }
        this.appendQuickFixes(info, buffer);
        this.appendExplainOperationLink(info, buffer);
        buffer.append("</td></tr></table></body>");
        return buffer.toString();
    }

    protected abstract void appendProblem(IAdvisorInfo var1, StringBuffer var2);

    public static Element getDataElement(String data) {
        if (data != null) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(data.getBytes()));
                return doc.getDocumentElement();
            }
            catch (SAXException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
            }
            catch (IOException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
            }
            catch (ParserConfigurationException e) {
                DefinitionsIdeUIPlugin.getDefault().log(e);
            }
        }
        return null;
    }

    protected void appendFileLink(StringBuffer buffer, final IFile file) {
        this.appendHyperlink(file.getName(), file.getFullPath().toString(), buffer, new Runnable(){

            public void run() {
                AbstractFileAdvisorDetailProvider.this.openFile(file);
            }
        });
    }

    protected void showAllFiles(List files) {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            FileSelectionDialog dialog = new FileSelectionDialog(window.getShell(), files);
            dialog.setTitle(Messages.AbstractFileAdvisorDetailProvider_3);
            if (dialog.open() == 0) {
                Object[] selectedFiles = dialog.getResult();
                int i = 0;
                while (i < selectedFiles.length) {
                    this.openFile((IFile)selectedFiles[i]);
                    ++i;
                }
            }
        }
    }

    public void openFile(String filePath) {
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(filePath));
        if (resource != null && resource instanceof IFile) {
            this.openFile((IFile)resource);
        }
    }

    public void openFile(final IFile file) {
        IWorkbenchPage page;
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows()).length > 0) {
            window = workbenchWindows[0];
        }
        if (window != null && (page = window.getActivePage()) != null) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file);
                    }
                    catch (PartInitException e) {
                        DefinitionsIdeUIPlugin.getDefault().log(e);
                    }
                }
            });
        }
    }

    private class FileSelectionDialog
    extends ListSelectionDialog {
        public FileSelectionDialog(Shell shell, List files) {
            super(shell, (Object)files, new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof List) {
                        return ((List)inputElement).toArray();
                    }
                    return new Object[0];
                }
            }, (ILabelProvider)new WorkbenchLabelProvider(), Messages.AbstractFileAdvisorDetailProvider_0);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }
}

